import logging.config
import os
from dotenv import load_dotenv

load_dotenv()  # Load environment variables from .env file if it exists

# Determine log level from environment variable or default to INFO
LOG_LEVEL = os.environ.get("LOG_LEVEL", "INFO").upper()
LOG_FORMAT = os.environ.get(
    "LOG_FORMAT", "%(asctime)s - %(name)s - %(levelname)s - %(message)s"
)

LOGGING_CONFIG = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        "standard": {
            "format": LOG_FORMAT,
            "datefmt": "%Y-%m-%d %H:%M:%S",
        },
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "level": LOG_LEVEL,
            "formatter": "standard",
            "stream": "ext://sys.stdout",
        },
    },
    "loggers": {
        # Root logger: catches everything not caught by specific loggers
        "": {
            "handlers": ["console"],
            "level": LOG_LEVEL,
            "propagate": False,
        },
        "kyd_dataspec_gen": {
            "handlers": ["console"],
            "level": LOG_LEVEL,
            "propagate": False,
        },
    },
}


def setup_logging():
    """Applies the logging configuration."""
    try:
        logging.config.dictConfig(LOGGING_CONFIG)
        logging.getLogger().setLevel(LOG_LEVEL)
    except Exception as e:
        # Fallback to basic config if dictConfig fails
        print(  # noqa: T201 - for debugging
            f"Error setting up logging from dictConfig: {e}. Falling back to basicConfig."
        )
        logging.basicConfig(
            level=LOG_LEVEL, format="%(asctime)s - %(levelname)s - %(message)s"
        )
        print("Using basic logging configuration due to setup error.")  # noqa: T201 - for debugging
