# adventureWorks Full Data Specification Report

This data source provides a comprehensive view of sales operations, encompassing details about salespersons, their assigned territories and targets, product information, reseller data, and individual sales transactions. It allows for analysis of sales performance across different products, resellers, and geographical regions.

<table>
    <tr>
        <th>Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Licensing</td>
        <td>Open Data Commons</td>
    </tr>
    <tr>
        <td>Location Coverage</td>
        <td>Australia, Canada, France, Germany, United Kingdom, United States</td>
    </tr>
    <tr>
        <td>Format</td>
        <td>csv</td>
    </tr>
    <tr>
        <td>Encoding</td>
        <td>utf-8</td>
    </tr>
</table>

## Overview

```mermaid
erDiagram
    Product {
        int ProductKey PK
        string Product
        string Standard_Cost
        string Color
        string Subcategory
        string Category
        string Background_Color_Format
        string Font_Color_Format
        }
    Region {
        int SalesTerritoryKey PK
        string Region "AK"
        string Country
        string Group
        }
    Reseller {
        int ResellerKey PK
        string Business_Type
        string Reseller
        string City
        string State-Province
        string Country-Region
        }
    Sales {
        string SalesOrderNumber PK
        date OrderDate PK
        int ProductKey PK, FK
        int ResellerKey FK
        int EmployeeKey FK
        int SalesTerritoryKey FK
        int Quantity
        string Unit_Price
        string Sales
        string Cost
        }
    Salesperson {
        int EmployeeKey "AK"
        int EmployeeID PK
        string Salesperson "AK"
        string Title
        string UPN "AK"
        }
    SalespersonRegion {
        int EmployeeKey PK, FK
        int SalesTerritoryKey PK, FK
        }
    Targets {
        int EmployeeID PK, FK
        string Target
        string TargetMonth
        }
    Product ||--|{ Sales : "sold in"
    Region ||--|{ SalespersonRegion : "has"
    Region ||--|{ Sales : "occurs in"
    Reseller ||--|{ Sales : "generates"
    Salesperson ||--|{ Targets : "records"
    Salesperson ||--|{ SalespersonRegion : "assigned to"
    Salesperson ||--|{ Sales : "makes"
```

## <a id="table-of-contents"></a>Table of Contents

<table>
    <tr>
        <th>Datasets</th>
        <th>Column</th>
        <th>Type</th>
        <th>Description</th>
        <th>Reference Data</th>
    </tr>
    <tr>
        <td rowspan="9"><a href="#dataset-Product">Product</a></td>
        <tr>
                <td><a href="#column-Product-ProductKey">ProductKey[PK]</a></td>
                <td>int</td>
                <td>A unique numerical identifier for each product.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Product-Product">Product</a></td>
                <td>string</td>
                <td>The full name and specific description of the product.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Product-Standard Cost">Standard Cost</a></td>
                <td>string</td>
                <td>The standard manufacturing or acquisition cost of the product.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Product-Color">Color</a></td>
                <td>string</td>
                <td>The primary color of the product.</td>
                <td><a href="#ref-dataset-REF-Color">REF-Color</a></td>
            </tr>
        <tr>
                <td><a href="#column-Product-Subcategory">Subcategory</a></td>
                <td>string</td>
                <td>The specific subcategory to which the product belongs.</td>
                <td><a href="#ref-dataset-REF-Subcategory">REF-Subcategory</a></td>
            </tr>
        <tr>
                <td><a href="#column-Product-Category">Category</a></td>
                <td>string</td>
                <td>The main category to which the product belongs.</td>
                <td><a href="#ref-dataset-REF-Category">REF-Category</a></td>
            </tr>
        <tr>
                <td><a href="#column-Product-Background Color Format">Background Color Format</a></td>
                <td>string</td>
                <td>The hexadecimal color code used for the background in product display.</td>
                <td><a href="#ref-dataset-REF-Background Color Format">REF-Background Color Format</a></td>
            </tr>
        <tr>
                <td><a href="#column-Product-Font Color Format">Font Color Format</a></td>
                <td>string</td>
                <td>The hexadecimal color code used for the font in product display.</td>
                <td><a href="#ref-dataset-REF-Font Color Format">REF-Font Color Format</a></td>
            </tr>
        </tr>
    <tr>
        <td rowspan="5"><a href="#dataset-Region">Region</a></td>
        <tr>
                <td><a href="#column-Region-SalesTerritoryKey">SalesTerritoryKey[PK]</a></td>
                <td>int</td>
                <td>A unique numerical identifier for each sales territory.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Region-Region">Region[AK]</a></td>
                <td>string</td>
                <td>The name of the sales region.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Region-Country">Country</a></td>
                <td>string</td>
                <td>The country where the sales territory is located.</td>
                <td><a href="#ref-dataset-REF-Country">REF-Country</a></td>
            </tr>
        <tr>
                <td><a href="#column-Region-Group">Group</a></td>
                <td>string</td>
                <td>The broader geographical group to which the sales territory belongs.</td>
                <td><a href="#ref-dataset-REF-Group">REF-Group</a></td>
            </tr>
        </tr>
    <tr>
        <td rowspan="7"><a href="#dataset-Reseller">Reseller</a></td>
        <tr>
                <td><a href="#column-Reseller-ResellerKey">ResellerKey[PK]</a></td>
                <td>int</td>
                <td>A unique numerical identifier for each reseller.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Reseller-Business Type">Business Type</a></td>
                <td>string</td>
                <td>The classification of the reseller's business model.</td>
                <td><a href="#ref-dataset-REF-Business Type">REF-Business Type</a></td>
            </tr>
        <tr>
                <td><a href="#column-Reseller-Reseller">Reseller</a></td>
                <td>string</td>
                <td>The official name of the reseller.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Reseller-City">City</a></td>
                <td>string</td>
                <td>The city where the reseller is located.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Reseller-State-Province">State-Province</a></td>
                <td>string</td>
                <td>The state or province where the reseller is located.</td>
                <td><a href="#ref-dataset-REF-State-Province">REF-State-Province</a></td>
            </tr>
        <tr>
                <td><a href="#column-Reseller-Country-Region">Country-Region</a></td>
                <td>string</td>
                <td>The country or broader region where the reseller is located.</td>
                <td><a href="#ref-dataset-REF-Country-Region">REF-Country-Region</a></td>
            </tr>
        </tr>
    <tr>
        <td rowspan="11"><a href="#dataset-Sales">Sales</a></td>
        <tr>
                <td><a href="#column-Sales-SalesOrderNumber">SalesOrderNumber[PK]</a></td>
                <td>string</td>
                <td>A unique identifier for each sales order.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-OrderDate">OrderDate[PK]</a></td>
                <td>date</td>
                <td>The date on which the sales order was placed.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-ProductKey">ProductKey[PK,FK]</a></td>
                <td>int</td>
                <td>An identifier for the product included in the sales order.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-ResellerKey">ResellerKey[FK]</a></td>
                <td>int</td>
                <td>The identifier of the reseller associated with the sales order.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-EmployeeKey">EmployeeKey[FK]</a></td>
                <td>int</td>
                <td>An identifier for the employee who processed the sales order.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-SalesTerritoryKey">SalesTerritoryKey[FK]</a></td>
                <td>int</td>
                <td>An identifier for the sales territory where the transaction occurred.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-Quantity">Quantity</a></td>
                <td>int</td>
                <td>The number of units of the product sold in this order line item.</td>
                <td><a href="#ref-dataset-REF-Quantity">REF-Quantity</a></td>
            </tr>
        <tr>
                <td><a href="#column-Sales-Unit Price">Unit Price</a></td>
                <td>string</td>
                <td>The price per single unit of the product at the time of sale.</td>
                <td><a href="#ref-dataset-REF-Unit Price">REF-Unit Price</a></td>
            </tr>
        <tr>
                <td><a href="#column-Sales-Sales">Sales</a></td>
                <td>string</td>
                <td>The total revenue generated from the sales transaction.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Sales-Cost">Cost</a></td>
                <td>string</td>
                <td>The total cost of goods sold for the transaction.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="6"><a href="#dataset-Salesperson">Salesperson</a></td>
        <tr>
                <td><a href="#column-Salesperson-EmployeeKey">EmployeeKey[AK]</a></td>
                <td>int</td>
                <td>A unique numerical identifier assigned to each employee.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Salesperson-EmployeeID">EmployeeID[PK]</a></td>
                <td>int</td>
                <td>A unique identification number for the employee.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Salesperson-Salesperson">Salesperson[AK]</a></td>
                <td>string</td>
                <td>The full name of the salesperson.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Salesperson-Title">Title</a></td>
                <td>string</td>
                <td>The official job title held by the salesperson.</td>
                <td><a href="#ref-dataset-REF-Title">REF-Title</a></td>
            </tr>
        <tr>
                <td><a href="#column-Salesperson-UPN">UPN[AK]</a></td>
                <td>string</td>
                <td>The User Principal Name, typically an email address, for the salesperson.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="3"><a href="#dataset-SalespersonRegion">SalespersonRegion</a></td>
        <tr>
                <td><a href="#column-SalespersonRegion-EmployeeKey">EmployeeKey[PK,FK]</a></td>
                <td>int</td>
                <td>An identifier for the employee assigned to a sales territory.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-SalespersonRegion-SalesTerritoryKey">SalesTerritoryKey[PK,FK]</a></td>
                <td>int</td>
                <td>An identifier for the sales territory covered by an employee.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="4"><a href="#dataset-Targets">Targets</a></td>
        <tr>
                <td><a href="#column-Targets-EmployeeID">EmployeeID[PK,FK]</a></td>
                <td>int</td>
                <td>An identification number for the employee to whom the sales target is assigned.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-Targets-Target">Target</a></td>
                <td>string</td>
                <td>The monetary sales target amount for a given month.</td>
                <td><a href="#ref-dataset-REF-Target">REF-Target</a></td>
            </tr>
        <tr>
                <td><a href="#column-Targets-TargetMonth">TargetMonth[PK]</a></td>
                <td>string</td>
                <td>The specific month for which the sales target is applicable.</td>
                <td><a href="#ref-dataset-REF-TargetMonth">REF-TargetMonth</a></td>
            </tr>
        </tr>
    
</table>

## Datasets

### <a id="dataset-Product"></a>Dataset: Product

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Product</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset provides detailed information about various products, including their unique keys, names, standard costs, colors, and categorization.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Product</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>8</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>397</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>397</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Product-ProductKey"></a>**ProductKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>ProductKey [PK][<a href="#profile-Product-ProductKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique numerical identifier for each product.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 210 to 606. All 397 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>449</li><li>522</li><li>519</li><li>440</li><li>276</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>210.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>606.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Product"></a>**Product**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Product [<a href="#profile-Product-Product">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The full name and specific description of the product.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains text values representing product names. There are 295 unique product names out of 397 entries (74.31%). The top 3 most frequent products are 'Long-Sleeve Logo Jersey, L' (17.38%), 'ML Road Frame-W - Yellow, 42' (12.09%), and 'HL Mountain Frame - Silver, 46' (11.08%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>LL Touring Frame - Blue, 58</li><li>LL Road Frame - Red, 52</li><li>Rear Brakes</li><li>Mountain-400-W Silver, 46</li><li>Long-Sleeve Logo Jersey, S</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>32.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Standard Cost"></a>**Standard Cost**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Standard Cost [<a href="#profile-Product-Standard Cost">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The standard cost of manufacturing or acquiring the product.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 131 unique standard costs out of 397 entries (33% unique).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>$53.93</li><li>$199.85</li><li>$413.15</li><li>$1,481.94</li><li>$461.44</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>9.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Color"></a>**Color**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Color [<a href="#profile-Product-Color">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The primary color of the product.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 10 unique colors out of 397 entries (2.52% unique). The most frequent values are 'Black' (129 entries, 32.49%), 'Red' (63 entries, 15.87%), and 'NA' (56 entries, 14.11%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Black</li><li>Silver</li><li>Blue</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Color">REF-Color</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>12.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX</td>
        <td>151</td>
        <td>38.04%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>91</td>
        <td>22.92%</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>63</td>
        <td>15.87%</td>
    </tr>
    <tr>
        <td>XX</td>
        <td>56</td>
        <td>14.11%</td>
    </tr>
    <tr>
        <td>XXXX</td>
        <td>29</td>
        <td>7.30%</td>
    </tr>
    <tr>
        <td>XXXXXX/XXXXX</td>
        <td>7</td>
        <td>1.76%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Subcategory"></a>**Subcategory**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Subcategory [<a href="#profile-Product-Subcategory">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The specific subcategory to which the product belongs.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 37 unique subcategories out of 397 entries (9.32% unique). The most frequent values are 'Road Frames' (70 entries, 17.63%), 'Road Bikes' (65 entries, 16.37%), and 'Mountain Frames' (40 entries, 10.08%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Touring Frames</li><li>Vests</li><li>Handlebars</li><li>Cranksets</li><li>Road Frames</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Subcategory">REF-Subcategory</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>17.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXX XXXXXX</td>
        <td>71</td>
        <td>17.88%</td>
    </tr>
    <tr>
        <td>XXXX XXXXX</td>
        <td>66</td>
        <td>16.62%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>46</td>
        <td>11.59%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX</td>
        <td>40</td>
        <td>10.08%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>38</td>
        <td>9.57%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>35</td>
        <td>8.82%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>22</td>
        <td>5.54%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX</td>
        <td>18</td>
        <td>4.53%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXX</td>
        <td>14</td>
        <td>3.53%</td>
    </tr>
    <tr>
        <td>XXXXX</td>
        <td>13</td>
        <td>3.27%</td>
    </tr>
    <tr>
        <td>XXXXX XXX XXXXX</td>
        <td>11</td>
        <td>2.77%</td>
    </tr>
    <tr>
        <td>XXXXXXXX</td>
        <td>5</td>
        <td>1.26%</td>
    </tr>
    <tr>
        <td>XXX-XXXXXX</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXX XXXXX</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXXX</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>XXXX</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXXX</td>
        <td>2</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX XXXXX</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Category"></a>**Category**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Category [<a href="#profile-Product-Category">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The main category to which the product belongs.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 4 unique categories out of 397 entries (1.01% unique). The most frequent values are 'Components' (189 entries, 47.61%), 'Bikes' (125 entries, 31.49%), and 'Clothing' (48 entries, 12.09%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Bikes</li><li>Components</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Category">REF-Category</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>11.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXXXX</td>
        <td>189</td>
        <td>47.61%</td>
    </tr>
    <tr>
        <td>XXXXX</td>
        <td>125</td>
        <td>31.49%</td>
    </tr>
    <tr>
        <td>XXXXXXXX</td>
        <td>48</td>
        <td>12.09%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXXX</td>
        <td>35</td>
        <td>8.82%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Background Color Format"></a>**Background Color Format**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Background Color Format [<a href="#profile-Product-Background Color Format">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The hexadecimal color code used for the background color of the product's display.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>All values are 7 characters long. There are 10 unique formats out of 397 entries (2.52% unique). The most frequent values are '#000000' (129 entries, 32.49%), '#FF0000' (63 entries, 15.87%), and '#DCDCDC' (56 entries, 14.11%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>#808080</li><li>#000000</li><li>#FFFF00</li><li>#BC8F8F</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Background Color Format">REF-Background Color Format</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>7.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>#999999</td>
        <td>137</td>
        <td>34.51%</td>
    </tr>
    <tr>
        <td>#XX9999</td>
        <td>63</td>
        <td>15.87%</td>
    </tr>
    <tr>
        <td>#XXXXXX</td>
        <td>60</td>
        <td>15.11%</td>
    </tr>
    <tr>
        <td>#XXXX99</td>
        <td>46</td>
        <td>11.59%</td>
    </tr>
    <tr>
        <td>#X9X9X9</td>
        <td>45</td>
        <td>11.34%</td>
    </tr>
    <tr>
        <td>#9999XX</td>
        <td>28</td>
        <td>7.05%</td>
    </tr>
    <tr>
        <td>#XX9X9X</td>
        <td>18</td>
        <td>4.53%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Product-Font Color Format"></a>**Font Color Format**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Font Color Format [<a href="#profile-Product-Font Color Format">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The hexadecimal color code used for the font in product display.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>All values are 7 characters long. There are 2 unique formats out of 397 entries (0.5% unique). The most frequent values are '#FFFFFF' (228 entries, 57.43%) and '#000000' (169 entries, 42.57%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>#000000</li><li>#FFFFFF</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Font Color Format">REF-Font Color Format</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>7.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>#XXXXXX</td>
        <td>228</td>
        <td>57.43%</td>
    </tr>
    <tr>
        <td>#999999</td>
        <td>169</td>
        <td>42.57%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-Region"></a>Dataset: Region

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Region</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset defines sales territories, including their unique keys, regional names, associated countries, and broader geographical groups.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Region</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>4</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>10</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>10</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Region-SalesTerritoryKey"></a>**SalesTerritoryKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>SalesTerritoryKey [PK][<a href="#profile-Region-SalesTerritoryKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique numerical identifier for each sales territory.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 1 to 10. All 10 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>3</li><li>9</li><li>6</li><li>1</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>ascending</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>10.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>9</td>
        <td>9</td>
        <td>90.00%</td>
    </tr>
    <tr>
        <td>99</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Region-Region"></a>**Region**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Region [<a href="#profile-Region-Region">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The name of the sales region.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>All 10 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Australia</li><li>Central</li><li>United Kingdom</li><li>Canada</li><li>Southwest</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>6.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>14.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>5</td>
        <td>50.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>2</td>
        <td>20.00%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>2</td>
        <td>20.00%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXX</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Region-Country"></a>**Country**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Country [<a href="#profile-Region-Country">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Addresses</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The country where the sales territory is located.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 6 unique countries out of 10 entries (60% unique). The most frequent value is 'United States', appearing 5 times (50%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>France</li><li>Canada</li><li>Australia</li><li>United States</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Country">REF-Country</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>6.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>14.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>5</td>
        <td>50.00%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>2</td>
        <td>20.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXX</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Region-Group"></a>**Group**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Group [<a href="#profile-Region-Group">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The broader geographical group to which the sales territory belongs.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 3 unique groups out of 10 entries (30% unique). The most frequent value is 'North America', appearing 6 times (60%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Europe</li><li>North America</li><li>Pacific</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Group">REF-Group</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>6.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>13.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX XXXXXXX</td>
        <td>6</td>
        <td>60.00%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>3</td>
        <td>30.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-Reseller"></a>Dataset: Reseller

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Reseller</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about various resellers, including their unique keys, business types, names, and geographical locations.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Reseller</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>6</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>701</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>701</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Reseller-ResellerKey"></a>**ResellerKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>ResellerKey [PK][<a href="#profile-Reseller-ResellerKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique numerical identifier for each reseller.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 1 to 701. All 701 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>110</li><li>542</li><li>358</li><li>580</li><li>28</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>701.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Reseller-Business Type"></a>**Business Type**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Business Type [<a href="#profile-Reseller-Business Type">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The classification of the reseller's business model.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 3 unique business types out of 701 entries (0.43% unique). The most frequent values are 'Value Added Reseller' (238 entries, 33.95%), 'Warehouse' (232 entries, 33.1%), and 'Specialty Bike Shop' (231 entries, 32.95%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Warehouse</li><li>Value Added Reseller</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Business Type">REF-Business Type</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>9.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>20.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX XXXXX XXXXXXXX</td>
        <td>238</td>
        <td>33.95%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>232</td>
        <td>33.10%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX XXXX XXXX</td>
        <td>231</td>
        <td>32.95%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Reseller-Reseller"></a>**Reseller**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Reseller [<a href="#profile-Reseller-Reseller">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Names</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The official name of the reseller.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 699 unique reseller names out of 701 entries (99.71% unique).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Only Bikes and Accessories</li><li>Finer Sales and Service</li><li>Responsible Bike Dealers</li><li>Sundry Sporting Goods</li><li>Economy Center</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>9.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>41.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Reseller-City"></a>**City**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>City [<a href="#profile-Reseller-City">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Addresses</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The city where the reseller is located.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 451 unique cities out of 701 entries (64.34% unique).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Woonsocket</li><li>Logansport</li><li>Berlin</li><li>Portland</li><li>Memphis</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>20.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Reseller-State-Province"></a>**State-Province**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>State-Province [<a href="#profile-Reseller-State-Province">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Addresses</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The state or province where the reseller is located.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 65 unique states/provinces out of 701 entries (9.27% unique). The most frequent values are 'California' (78 entries, 11.13%), 'Ontario' (55 entries, 7.85%), and 'Washington' (47 entries, 6.7%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Ontario</li><li>California</li><li>Virginia</li><li>Texas</li><li>Seine Saint Denis</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-State-Province">REF-State-Province</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>19.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Reseller-Country-Region"></a>**Country-Region**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Country-Region [<a href="#profile-Reseller-Country-Region">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Addresses</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The country or broader region where the reseller is located.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 6 unique countries/regions out of 701 entries (0.86% unique). The most frequent values are 'United States' (427 entries, 60.91%), 'Canada' (114 entries, 16.26%), and 'Australia' (40 entries, 5.71%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Germany</li><li>United States</li><li>Canada</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Country-Region">REF-Country-Region</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>6.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>14.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>427</td>
        <td>60.91%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>154</td>
        <td>21.97%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXX</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-Sales"></a>Dataset: Sales

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Sales</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains detailed records of individual sales transactions, including order numbers, dates, product details, reseller information, and associated employee and territory data.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Sales</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>10</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>57851</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>57851</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Sales-SalesOrderNumber"></a>**SalesOrderNumber**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>SalesOrderNumber [PK][<a href="#profile-Sales-SalesOrderNumber">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each sales order.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains text values. There are 3,622 unique sales order numbers out of 57,851 entries (6.26%). All values have a length of 7. The top 3 most frequent values are 'SO51721' (0.003%), 'SO51739' (0.003%), and 'SO51722' (0.003%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>SO47973</li><li>SO53483</li><li>SO49052</li><li>SO49865</li><li>SO65221</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>7.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-OrderDate"></a>**OrderDate**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>OrderDate [PK][<a href="#profile-Sales-OrderDate">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date on which the sales order was placed.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains date values. There are 995 unique order dates out of 57,851 entries (1.72%). The most frequent date is 'Monday, September 2, 2019' (15.36%). Date format: 'DayOfWeek, Month Day, Year'.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Thursday, August 3, 2017</li><li>Thursday, December 21, 2017</li><li>Thursday, September 13, 2018</li><li>Wednesday, November 22, 2017</li><li>Tuesday, October 22, 2019</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td></td>
    </tr>
    </table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-ProductKey"></a>**ProductKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>ProductKey [PK,FK][<a href="#profile-Sales-ProductKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the product included in the sales order.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Product">Product</a>: <a href="#column-Product-ProductKey">ProductKey</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains integer values. There are 334 unique product keys out of 57,851 entries (0.58%). The top 3 most frequent keys are '471' (14.48%), '491' (14.17%), and '224' (12.14%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>232</li><li>483</li><li>577</li><li>544</li><li>214</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>212.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>606.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>999</td>
        <td>57851</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-ResellerKey"></a>**ResellerKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>ResellerKey [FK][<a href="#profile-Sales-ResellerKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the reseller involved in the sales transaction.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Reseller">Reseller</a>: <a href="#column-Reseller-ResellerKey">ResellerKey</a></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains integer values. There are 632 unique reseller keys out of 57,851 entries (1.09%). The top 3 most frequent keys are '678' (11.8%), '514' (10.95%), and '54' (10.88%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>594</li><li>170</li><li>683</li><li>475</li><li>230</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>701.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>999</td>
        <td>48661</td>
        <td>84.11%</td>
    </tr>
    <tr>
        <td>99</td>
        <td>8300</td>
        <td>14.35%</td>
    </tr>
    <tr>
        <td>9</td>
        <td>890</td>
        <td>1.54%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-EmployeeKey"></a>**EmployeeKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>EmployeeKey [FK][<a href="#profile-Sales-EmployeeKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the employee who processed the sales order.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Salesperson">Salesperson</a>: <a href="#column-Salesperson-EmployeeKey">EmployeeKey</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains integer values. There are 17 unique employee keys out of 57,851 entries (0.03%). The top 3 most frequent keys are '283' (30.27%), '282' (15.74%), and '281' (14.72%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>295</li><li>291</li><li>288</li><li>281</li><li>282</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>272.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>296.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>999</td>
        <td>57851</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-SalesTerritoryKey"></a>**SalesTerritoryKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>SalesTerritoryKey [FK][<a href="#profile-Sales-SalesTerritoryKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the sales territory where the transaction occurred.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Region">Region</a>: <a href="#column-Region-SalesTerritoryKey">SalesTerritoryKey</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains integer values. There are 10 unique sales territory keys out of 57,851 entries (0.02%). The top 3 most frequent keys are '4' (22.17%), '6' (18.9%), and '1' (12.87%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>1</li><li>10</li><li>4</li><li>6</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>10.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>9</td>
        <td>54609</td>
        <td>94.40%</td>
    </tr>
    <tr>
        <td>99</td>
        <td>3242</td>
        <td>5.60%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-Quantity"></a>**Quantity**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Quantity [<a href="#profile-Sales-Quantity">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The number of units of the product sold in this order line item.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains integer values. There are 41 unique quantities out of 57,851 entries (0.07%). The top 3 most frequent quantities are '1' (83.2%), '2' (12.16%), and '5' (3.02%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>1</li><li>2</li><li>5</li><li>3</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Quantity">REF-Quantity</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>44.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>9</td>
        <td>55170</td>
        <td>95.37%</td>
    </tr>
    <tr>
        <td>99</td>
        <td>2681</td>
        <td>4.63%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-Unit Price"></a>**Unit Price**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Unit Price [<a href="#profile-Sales-Unit Price">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The price per single unit of the product at the time of sale.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains text values representing currency amounts. There are 228 unique unit prices out of 57,851 entries (0.39%). The top 3 most frequent prices are '$469.79' (42.21%), '$419.46' (33.19%), and '$28.84' (15.88%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>$600.26</li><li>$2,024.99</li><li>$419.46</li><li>$323.99</li><li>$113</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Unit Price">REF-Unit Price</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>9.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$999.99</td>
        <td>24416</td>
        <td>42.20%</td>
    </tr>
    <tr>
        <td>$99.99</td>
        <td>17514</td>
        <td>30.27%</td>
    </tr>
    <tr>
        <td>$9,999.99</td>
        <td>9188</td>
        <td>15.88%</td>
    </tr>
    <tr>
        <td>$9.99</td>
        <td>2674</td>
        <td>4.62%</td>
    </tr>
    <tr>
        <td>$999.9</td>
        <td>1691</td>
        <td>2.92%</td>
    </tr>
    <tr>
        <td>$99.9</td>
        <td>1303</td>
        <td>2.25%</td>
    </tr>
    <tr>
        <td>$99</td>
        <td>692</td>
        <td>1.20%</td>
    </tr>
    <tr>
        <td>$9.9</td>
        <td>214</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>$999</td>
        <td>158</td>
        <td>0.27%</td>
    </tr>
    <tr>
        <td>$9,999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-Sales"></a>**Sales**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Sales [<a href="#profile-Sales-Sales">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The total sales amount for this specific line item in the order.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains text values representing currency amounts. There are 1,413 unique sales amounts out of 57,851 entries (2.44%). The top 3 most frequent sales amounts are '$419.46' (37.46%), '$939.58' (28.71%), and '$838.92' (24.31%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>$5,864.04</li><li>$3,061.77</li><li>$242.99</li><li>$338.99</li><li>$4,079.98</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>10.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$999.99</td>
        <td>21668</td>
        <td>37.45%</td>
    </tr>
    <tr>
        <td>$9,999.99</td>
        <td>16508</td>
        <td>28.54%</td>
    </tr>
    <tr>
        <td>$99.99</td>
        <td>10639</td>
        <td>18.39%</td>
    </tr>
    <tr>
        <td>$999.9</td>
        <td>3316</td>
        <td>5.73%</td>
    </tr>
    <tr>
        <td>$9,999.9</td>
        <td>2569</td>
        <td>4.44%</td>
    </tr>
    <tr>
        <td>$99.9</td>
        <td>845</td>
        <td>1.46%</td>
    </tr>
    <tr>
        <td>$99,999.99</td>
        <td>644</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$999</td>
        <td>639</td>
        <td>1.10%</td>
    </tr>
    <tr>
        <td>$9.99</td>
        <td>525</td>
        <td>0.91%</td>
    </tr>
    <tr>
        <td>$99</td>
        <td>265</td>
        <td>0.46%</td>
    </tr>
    <tr>
        <td>$9,999</td>
        <td>111</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>$99,999.9</td>
        <td>99</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>$9.9</td>
        <td>21</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$99,999</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Sales-Cost"></a>**Cost**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Cost [<a href="#profile-Sales-Cost">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The cost associated with the product sold in this order line item.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column contains text values representing currency amounts. There are 1,438 unique cost amounts out of 57,851 entries (2.49%). The top 3 most frequent costs are '$413.15' (36.83%), '$973.41' (30.53%), and '$826.29' (25.57%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>$4,445.81</li><li>$176.2</li><li>$408.75</li><li>$31.72</li><li>$41.63</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>10.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$999.99</td>
        <td>21308</td>
        <td>36.83%</td>
    </tr>
    <tr>
        <td>$9,999.99</td>
        <td>17560</td>
        <td>30.35%</td>
    </tr>
    <tr>
        <td>$99.99</td>
        <td>12770</td>
        <td>22.07%</td>
    </tr>
    <tr>
        <td>$999.9</td>
        <td>1971</td>
        <td>3.41%</td>
    </tr>
    <tr>
        <td>$9,999.9</td>
        <td>1548</td>
        <td>2.68%</td>
    </tr>
    <tr>
        <td>$9.99</td>
        <td>969</td>
        <td>1.67%</td>
    </tr>
    <tr>
        <td>$99.9</td>
        <td>749</td>
        <td>1.29%</td>
    </tr>
    <tr>
        <td>$99,999.99</td>
        <td>561</td>
        <td>0.97%</td>
    </tr>
    <tr>
        <td>$99</td>
        <td>131</td>
        <td>0.23%</td>
    </tr>
    <tr>
        <td>$99,999.9</td>
        <td>103</td>
        <td>0.18%</td>
    </tr>
    <tr>
        <td>$9.9</td>
        <td>78</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>$9,999</td>
        <td>50</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>$999</td>
        <td>40</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>$9</td>
        <td>13</td>
        <td>0.02%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-Salesperson"></a>Dataset: Salesperson

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Salesperson</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about individual sales employees, including their unique identifiers, names, job titles, and user principal names.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Salesperson</td>
        </tr>
   <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>5</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>18</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>18</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Salesperson-EmployeeKey"></a>**EmployeeKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>EmployeeKey [AK][<a href="#profile-Salesperson-EmployeeKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique numerical identifier for each employee.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 272 to 296. All 18 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>289</li><li>285</li><li>294</li><li>281</li><li>296</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>ascending</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>272.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>296.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Salesperson-EmployeeID"></a>**EmployeeID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>EmployeeID [PK][<a href="#profile-Salesperson-EmployeeID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identification number for the employee.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 61,161,660 to 987,554,265. All 18 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>987554265</li><li>716374314</li><li>982310417</li><li>90836195</li><li>481044938</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>61161660.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>987554265.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Salesperson-Salesperson"></a>**Salesperson**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Salesperson [AK][<a href="#profile-Salesperson-Salesperson">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Names</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The full name of the salesperson.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>All 18 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>JosÃ© Saraiva</li><li>Syed Abbas</li><li>Tete Mensa-Annan</li><li>Shu Ito</li><li>Stephen Jiang</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>24.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Salesperson-Title"></a>**Title**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Title [<a href="#profile-Salesperson-Title">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The official job title held by the salesperson.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 5 unique titles out of 18 entries (27.78% unique). The most frequent value is 'Sales Representative', appearing 14 times (77.78%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Sales Representative</li><li>European Sales Manager</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Title">REF-Title</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>17.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>28.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXXXXXXX</td>
        <td>14</td>
        <td>77.78%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXX XXXXX XXXXXXX</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XX XXXXX</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX XXXXXXX</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX XXXXXXX</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Salesperson-UPN"></a>**UPN**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>UPN [AK][<a href="#profile-Salesperson-UPN">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The User Principal Name, typically an email address, for the salesperson.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>All 18 entries are unique, representing 100% of the data.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>jae-pak@adventureworks.com</li><li>tete-mensa-annan@adventureworks.com</li><li>amy-alberts@adventureworks.com</li><li>linda-mitchell@adventureworks.com</li><li>david-campbell@adventureworks.com</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>26.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>43.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-SalespersonRegion"></a>Dataset: SalespersonRegion

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>SalespersonRegion</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset links salespersons to the specific sales territories they are responsible for.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>SalespersonRegion</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>2</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>39</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>39</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-SalespersonRegion-EmployeeKey"></a>**EmployeeKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>EmployeeKey [PK,FK][<a href="#profile-SalespersonRegion-EmployeeKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the employee assigned to a sales territory.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Salesperson">Salesperson</a>: <a href="#column-Salesperson-EmployeeKey">EmployeeKey</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 272 to 296. There are 18 unique keys out of 39 entries (46.15% unique).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>290</li><li>285</li><li>286</li><li>291</li><li>272</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>ascending</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>272.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>296.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-SalespersonRegion-SalesTerritoryKey"></a>**SalesTerritoryKey**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>SalesTerritoryKey [PK,FK][<a href="#profile-SalespersonRegion-SalesTerritoryKey">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier for the sales territory covered by an employee.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Region">Region</a>: <a href="#column-Region-SalesTerritoryKey">SalesTerritoryKey</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 1 to 10. There are 10 unique keys out of 39 entries (25.64% unique). The most frequent values are '1', '3', and '4', each appearing 5 times (12.82%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>6</li><li>1</li><li>8</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>10.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>9</td>
        <td>36</td>
        <td>92.31%</td>
    </tr>
    <tr>
        <td>99</td>
        <td>3</td>
        <td>7.69%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-Targets"></a>Dataset: Targets

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Targets</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset records the sales targets assigned to employees for specific months.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>Targets</td>
        </tr>
    <tr>
        <td>Statistics</td>
        <td>
            <table>
                <tr>
                    <td>Column Count</td>
                    <td>3</td>
                </tr>
                <tr>
                    <td>Row Count</td>
                    <td>809</td>
                </tr>
                <tr>
                    <td>Samples Used</td>
                    <td>809</td>
                </tr>
                <tr>
                    <td>Unique Row Ratio</td>
                    <td>1.0</td>
                </tr>
                <tr>
                    <td>Row Has Null Ratio</td>
                    <td>0.0</td>
                </tr>
                <tr>
                    <td>Duplicate Row Count</td>
                    <td>0</td>
                </tr>
                <tr>
                    <td>Row Is Null Ratio</td>
                    <td>0.0</td>
                </tr>
                </table>
        </td>
        </tr>
    <tr>
        <td>Complete Data Spec</td>
        <td>True</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-Targets-EmployeeID"></a>**EmployeeID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>EmployeeID [PK,FK][<a href="#profile-Targets-EmployeeID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Individual Identifier Data</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identification number for the employee to whom the sales target is assigned.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-Salesperson">Salesperson</a>: <a href="#column-Salesperson-EmployeeID">EmployeeID</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Values range from 61,161,660 to 987,554,265. There are 18 unique IDs out of 809 entries (2.22% unique). The most frequent values are '234474252', '139397894', and '191644724', each appearing 54 times (6.67%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>61161660</li><li>841560125</li><li>139397894</li><li>234474252</li><li>982310417</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>61161660.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>987554265.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>999999999</td>
        <td>707</td>
        <td>87.39%</td>
    </tr>
    <tr>
        <td>99999999</td>
        <td>102</td>
        <td>12.61%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Targets-Target"></a>**Target**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>Target [<a href="#profile-Targets-Target">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The monetary sales target set for the employee.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>There are 57 unique target amounts out of 809 entries (7.05% unique). The most frequent values are '$500,000' (169 entries, 20.89%), '$200,000' (73 entries, 9.02%), and '$1,000,000' (71 entries, 8.78%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>$1,000,000</li><li>$400,000</li><li>$250,000</li><li>$500,000</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-Target">REF-Target</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>11.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$999,999</td>
        <td>586</td>
        <td>72.44%</td>
    </tr>
    <tr>
        <td>$9,999,999</td>
        <td>184</td>
        <td>22.74%</td>
    </tr>
    <tr>
        <td>$99,999</td>
        <td>34</td>
        <td>4.20%</td>
    </tr>
    <tr>
        <td>$99,999,999</td>
        <td>5</td>
        <td>0.62%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-Targets-TargetMonth"></a>**TargetMonth**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>TargetMonth [<a href="#profile-Targets-TargetMonth">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>Non Classified</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The specific month for which the sales target is applicable.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Date format is 'Day, Month Day, Year' (e.g., 'Wednesday, January 1, 2020'). There are 54 unique months out of 809 entries (6.67% unique). The most frequent values are 'Saturday, August 1, 2020', 'Monday, June 1, 2020', and 'Wednesday, April 1, 2020', each appearing 18 times (2.22%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Wednesday, January 1, 2020</li><li>Friday, February 1, 2019</li><li>Monday, November 1, 2021</li><li>Sunday, March 1, 2020</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Data Dictionary Matching</td>
        <td>Not Matched</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-TargetMonth">REF-TargetMonth</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>19.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>28.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### Data Profile:

### <a href="#dataset-Product">Dataset: Product</a>

<a id="profile-Product-ProductKey"></a><a href="#column-Product-ProductKey">**ProductKey**</a>[PK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>210.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>606.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>210.198</li><li>210.99</li><li>212.178</li><li>212.97</li><li>214.158</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>408.198</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>161976.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>408.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>13167.1667</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>114.7483</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>210.0</li><li>249.6</li><li>289.2</li><li>328.8</li><li>487.2</li><li>526.8</li><li>566.4</li><li>606.0</li></ul>bin_counts: <ul><li>40.0</li><li>40.0</li><li>39.0</li><li>40.0</li><li>39.0</li><li>40.0</li><li>40.0</li><li>39.0</li><li>40.0</li><li>40.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 309.0991: 408.1982: 507.297
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0001</li><li>0.0007</li><li>0.0001</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Product"></a><a href="#column-Product-Product">**Product**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>32.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>22.9955</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>22.0037</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8670.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>21.8388</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>25.8931</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.0885</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.3866</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.0795</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>6.8</li><li>8.6</li><li>10.4</li><li>26.6</li><li>28.4</li><li>30.2</li><li>32.0</li></ul>bin_counts: <ul><li>1.0</li><li>4.0</li><li>4.0</li><li>12.0</li><li>5.0</li><li>69.0</li><li>44.0</li><li>23.0</li><li>48.0</li><li>5.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 18.00571: 22.00372: 24.9975
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>1</li><li>'</li><li>G</li><li>Y</li><li>h</li><li>y</li><li>2</li><li>D</li><li>v</li><li>/</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>295</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.7431</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Standard Cost"></a><a href="#column-Product-Standard Cost">**Standard Cost**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>9.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.0025</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0013</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2699.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>6.7985</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.0957</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.0467</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.5832</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.4969</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.26315789</li><li>8.73684211</li><li>9.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>0.0</li><li>29.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>50.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.00291: 7.00132: 7.0038
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>9</li><li>1</li><li>7</li><li>3</li><li>,</li><li>.</li><li>0</li><li>6</li><li>2</li><li>$</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>131</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.33</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Color"></a><a href="#column-Product-Color">**Color**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>12.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>5.0033</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8156</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8177</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1802.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>4.539</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>2.8653</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.6927</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0754</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>4.7205</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>2.52631579</li><li>11.47368421</li><li>12.0</li></ul>bin_counts: <ul><li>56.0</li><li>63.0</li><li>0.0</li><li>29.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>7.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00691: 5.00332: 5.0099
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>w</li><li>G</li><li>Y</li><li>h</li><li>W</li><li>R</li><li>y</li><li>o</li><li>i</li><li>/</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Black</li><li>Red</li><li>NA</li><li>Silver/Black</li><li>White</li><li>Grey</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0252</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Black</td>
        <td>129</td>
    </tr>
    <tr>
        <td>Red</td>
        <td>63</td>
    </tr>
    <tr>
        <td>NA</td>
        <td>56</td>
    </tr>
    <tr>
        <td>Yellow</td>
        <td>46</td>
    </tr>
    <tr>
        <td>Silver</td>
        <td>45</td>
    </tr>
    <tr>
        <td>Blue</td>
        <td>28</td>
    </tr>
    <tr>
        <td>Multi</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Silver/Black</td>
        <td>7</td>
    </tr>
    <tr>
        <td>White</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Grey</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Subcategory"></a><a href="#column-Product-Subcategory">**Subcategory**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>17.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>9.9995</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>10.9959</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9098</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9121</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>4244.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.6902</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>10.1184</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.1809</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.1953</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.0253</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>5.3</li><li>6.6</li><li>7.9</li><li>9.2</li><li>11.8</li><li>13.1</li><li>14.4</li><li>15.7</li><li>17.0</li></ul>bin_counts: <ul><li>16.0</li><li>46.0</li><li>35.0</li><li>8.0</li><li>83.0</li><li>73.0</li><li>22.0</li><li>56.0</li><li>55.0</li><li>3.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.99681: 10.99592: 14.0004
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>G</li><li>h</li><li>p</li><li>W</li><li>M</li><li>R</li><li>y</li><li>C</li><li>D</li><li>v</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Road Frames</li><li>Road Bikes</li><li>Panniers</li><li>Hydration Packs</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>37</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0932</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Road Frames</td>
        <td>70</td>
    </tr>
    <tr>
        <td>Road Bikes</td>
        <td>65</td>
    </tr>
    <tr>
        <td>Mountain Frames</td>
        <td>40</td>
    </tr>
    <tr>
        <td>Mountain Bikes</td>
        <td>38</td>
    </tr>
    <tr>
        <td>Touring Bikes</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Touring Frames</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Jerseys</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Wheels</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Handlebars</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Tires and Tubes</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Saddles</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Helmets</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Gloves</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Shorts</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Pedals</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Socks</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Bib-Shorts</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Bottles and Cages</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Vests</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Bottom Brackets</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Lights</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Forks</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Tights</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Headsets</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Cranksets</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Caps</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Brakes</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Derailleurs</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Pumps</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Locks</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bike Stands</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Fenders</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Cleaners</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bike Racks</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Chains</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Panniers</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Hydration Packs</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Category"></a><a href="#column-Product-Category">**Category**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10.001</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>9.9988</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.6518</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.6535</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>3284.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.272</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>5.4713</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.3391</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.5343</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.4854</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>5.6</li><li>6.2</li><li>6.8</li><li>7.4</li><li>8.6</li><li>9.2</li><li>9.8</li><li>10.4</li><li>11.0</li></ul>bin_counts: <ul><li>125.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>189.0</li><li>35.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 5.00481: 9.99882: 10.002
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>h</li><li>p</li><li>k</li><li>A</li><li>l</li><li>e</li><li>c</li><li>C</li><li>o</li><li>i</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Components</li><li>Bikes</li><li>Clothing</li><li>Accessories</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0101</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Components</td>
        <td>189</td>
    </tr>
    <tr>
        <td>Bikes</td>
        <td>125</td>
    </tr>
    <tr>
        <td>Clothing</td>
        <td>48</td>
    </tr>
    <tr>
        <td>Accessories</td>
        <td>35</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Background Color Format"></a><a href="#column-Product-Background Color Format">**Background Color Format**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8156</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8177</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2779.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0229</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>397</li></ul>bin_edges: <ul><li>7.0</li><li>7.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.01: 7.02: 7.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>9</li><li>B</li><li>F</li><li>#</li><li>8</li><li>0</li><li>6</li><li>C</li><li>D</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>#000000</li><li>#FF0000</li><li>#DCDCDC</li><li>#696969</li><li>#FFFFFF</li><li>#808080</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0252</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>#000000</td>
        <td>129</td>
    </tr>
    <tr>
        <td>#FF0000</td>
        <td>63</td>
    </tr>
    <tr>
        <td>#DCDCDC</td>
        <td>56</td>
    </tr>
    <tr>
        <td>#FFFF00</td>
        <td>46</td>
    </tr>
    <tr>
        <td>#C0C0C0</td>
        <td>45</td>
    </tr>
    <tr>
        <td>#0000FF</td>
        <td>28</td>
    </tr>
    <tr>
        <td>#BC8F8F</td>
        <td>18</td>
    </tr>
    <tr>
        <td>#696969</td>
        <td>7</td>
    </tr>
    <tr>
        <td>#FFFFFF</td>
        <td>4</td>
    </tr>
    <tr>
        <td>#808080</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Product-Font Color Format"></a><a href="#column-Product-Font Color Format">**Font Color Format**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.489</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.4902</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2779.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0229</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>397</li></ul>bin_edges: <ul><li>7.0</li><li>7.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.01: 7.02: 7.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>#</li><li>0</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>#FFFFFF</li><li>#000000</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.005</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>397</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>#FFFFFF</td>
        <td>228</td>
    </tr>
    <tr>
        <td>#000000</td>
        <td>169</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-Region">Dataset: Region</a>

<a id="profile-Region-SalesTerritoryKey"></a><a href="#column-Region-SalesTerritoryKey">**SalesTerritoryKey**</a>[PK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>1.0045</li><li>2.0035</li><li>3.0025</li><li>4.0015</li><li>5.0005</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>5.5</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>55.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>5.5</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>9.1667</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.0277</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>2.8</li><li>4.6</li><li>6.4</li><li>8.2</li><li>10.0</li></ul>bin_counts: <ul><li>2.0</li><li>2.0</li><li>2.0</li><li>2.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00251: 5.52: 7.9975
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0006</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Region-Region"></a><a href="#column-Region-Region">**Region**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>14.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>9.004</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>9.0016</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>85.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.5</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>5.3889</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.3214</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.4322</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>3.2036</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>6.0</li><li>7.6</li><li>9.2</li><li>10.8</li><li>12.4</li><li>14.0</li></ul>bin_counts: <ul><li>4.0</li><li>5.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.0021: 9.00162: 9.0056
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>K</li><li>a</li><li>N</li><li>y</li><li>d</li><li>o</li><li>u</li><li>h</li><li>G</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Region-Country"></a><a href="#column-Region-Country">**Country**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>14.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.004</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>13.0016</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.7</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.7778</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>107.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.7</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>10.9</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.3015</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.6424</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.712</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>6.0</li><li>7.6</li><li>9.2</li><li>10.8</li><li>12.4</li><li>14.0</li></ul>bin_counts: <ul><li>3.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>6.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.0041: 13.00162: 13.0056
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>K</li><li>a</li><li>U</li><li>y</li><li>n</li><li>d</li><li>o</li><li>u</li><li>G</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.6</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0003</li><li>0.0006</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Region-Group"></a><a href="#column-Region-Group">**Group**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>12.9965</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>12.9942</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.54</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.6</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>103.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.3</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>12.2333</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.4976</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.5075</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-2.2055</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>6.0</li><li>7.4</li><li>8.8</li><li>10.2</li><li>11.6</li><li>13.0</li></ul>bin_counts: <ul><li>4.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>6.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.00581: 12.99422: 12.9971
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>P</li><li>a</li><li>N</li><li>r</li><li>p</li><li>o</li><li>u</li><li>f</li><li>h</li><li>E</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>North America</li><li>Europe</li><li>Pacific</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.3</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>North America</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Europe</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Pacific</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-Reseller">Dataset: Reseller</a>

<a id="profile-Reseller-ResellerKey"></a><a href="#column-Reseller-ResellerKey">**ResellerKey**</a>[PK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>701.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>1.35</li><li>2.05</li><li>2.75</li><li>4.15</li><li>4.85</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>351.35</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>246051.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>351.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>41008.5</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>202.5056</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>64.63636364</li><li>637.36363636</li><li>701.0</li></ul>bin_counts: <ul><li>64.0</li><li>64.0</li><li>64.0</li><li>63.0</li><li>63.0</li><li>63.0</li><li>63.0</li><li>64.0</li><li>64.0</li><li>64.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 176.1751: 351.352: 526.525
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0002</li><li>0.0007</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Reseller-Business Type"></a><a href="#column-Reseller-Business Type">**Business Type**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>9.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>20.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>19.9945</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>19.0046</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.6666</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.6676</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>11237.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>16.03</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>24.6491</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.9648</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.6984</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.4863</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>9.0</li><li>10.0</li><li>11.0</li><li>12.0</li><li>13.0</li><li>16.0</li><li>17.0</li><li>18.0</li><li>19.0</li><li>20.0</li></ul>bin_counts: <ul><li>232.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>469.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 9.00831: 19.00462: 19.9919
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>h</li><li>p</li><li>W</li><li>k</li><li>A</li><li>c</li><li>R</li><li>y</li><li>o</li><li>i</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Value Added Reseller</li><li>Warehouse</li><li>Specialty Bike Shop</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0043</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0002</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Value Added Reseller</td>
        <td>238</td>
    </tr>
    <tr>
        <td>Warehouse</td>
        <td>232</td>
    </tr>
    <tr>
        <td>Specialty Bike Shop</td>
        <td>231</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Reseller-Reseller"></a><a href="#column-Reseller-Reseller">**Reseller**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>9.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>41.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>21.016</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>19.9811</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>14103.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>20.1184</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>29.6131</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.4418</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.4586</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.0304</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>9.0</li><li>10.77777778</li><li>39.22222222</li><li>41.0</li></ul>bin_counts: <ul><li>9.0</li><li>45.0</li><li>55.0</li><li>76.0</li><li>52.0</li><li>4.0</li><li>11.0</li><li>1.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 16.00111: 19.98112: 23.9816
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>q</li><li>P</li><li>F</li><li>K</li><li>R</li><li>Y</li><li>u</li><li>M</li><li>h</li><li>G</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>699</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9971</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0002</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Reseller-City"></a><a href="#column-Reseller-City">**City**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>20.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.0056</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>5834.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.3224</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>6.2845</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.5069</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0206</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>1.3402</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.66666667</li><li>19.33333333</li><li>20.0</li></ul>bin_counts: <ul><li>14.0</li><li>44.0</li><li>0.0</li><li>107.0</li><li>147.0</li><li>5.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.99311: 8.00562: 10.0025
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>P</li><li>q</li><li>F</li><li>K</li><li>Z</li><li>.</li><li>u</li><li>M</li><li>h</li><li>G</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>451</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.6434</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Reseller-State-Province"></a><a href="#column-Reseller-State-Province">**State-Province**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>19.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.0075</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.9939</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9591</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9604</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>6132.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.7475</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>9.5947</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.0975</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0471</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.6622</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.65217391</li><li>18.34782609</li><li>19.0</li></ul>bin_counts: <ul><li>24.0</li><li>43.0</li><li>0.0</li><li>61.0</li><li>199.0</li><li>20.0</li><li>3.0</li><li>0.0</li><li>0.0</li><li>6.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.00361: 7.99392: 10.0092
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>'</li><li>U</li><li>G</li><li>Y</li><li>h</li><li>y</li><li>C</li><li>D</li><li>v</li><li>E</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>California</li><li>Ontario</li><li>Val de Marne</li><li>Val d'Oise</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>65</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0927</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0005</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>California</td>
        <td>78</td>
    </tr>
    <tr>
        <td>Ontario</td>
        <td>55</td>
    </tr>
    <tr>
        <td>Washington</td>
        <td>47</td>
    </tr>
    <tr>
        <td>England</td>
        <td>40</td>
    </tr>
    <tr>
        <td>Texas</td>
        <td>38</td>
    </tr>
    <tr>
        <td>New South Wales</td>
        <td>29</td>
    </tr>
    <tr>
        <td>Florida</td>
        <td>27</td>
    </tr>
    <tr>
        <td>Quebec</td>
        <td>23</td>
    </tr>
    <tr>
        <td>British Columbia</td>
        <td>20</td>
    </tr>
    <tr>
        <td>Oregon</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Tennessee</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Michigan</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Illinois</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Alberta</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Georgia</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Arizona</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Seine (Paris)</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Ohio</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Saarland</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Missouri</td>
        <td>11</td>
    </tr>
    <tr>
        <td>New York</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Hamburg</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Connecticut</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Utah</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Colorado</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Indiana</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Hessen</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Nevada</td>
        <td>7</td>
    </tr>
    <tr>
        <td>North Carolina</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Essonne</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Hauts de Seine</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Minnesota</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Alabama</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Nordrhein-Westfalen</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Victoria</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Kentucky</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Wyoming</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Virginia</td>
        <td>5</td>
    </tr>
    <tr>
        <td>New Hampshire</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Massachusetts</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Wisconsin</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Idaho</td>
        <td>3</td>
    </tr>
    <tr>
        <td>South Carolina</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Seine Saint Denis</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Bayern</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Rhode Island</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Mississippi</td>
        <td>3</td>
    </tr>
    <tr>
        <td>South Australia</td>
        <td>3</td>
    </tr>
    <tr>
        <td>New Mexico</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Montana</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Maine</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Queensland</td>
        <td>2</td>
    </tr>
    <tr>
        <td>South Dakota</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Seine et Marne</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Nord</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Loiret</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Loir et Cher</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Manitoba</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Brandenburg</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Brunswick</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pas de Calais</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Gers</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Garonne (Haute)</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Val de Marne</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Val d'Oise</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Reseller-Country-Region"></a><a href="#column-Reseller-Country-Region">**Country-Region**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>14.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.004</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>13.0022</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.5895</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.5903</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>7675.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.9486</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>9.5945</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.0975</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.8002</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2334</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>6.0</li><li>6.72727273</li><li>13.27272727</li><li>14.0</li></ul>bin_counts: <ul><li>154.0</li><li>40.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>427.0</li><li>40.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.00421: 13.00222: 13.0055
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>K</li><li>a</li><li>U</li><li>y</li><li>n</li><li>d</li><li>o</li><li>u</li><li>G</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>United States</li><li>Canada</li><li>France</li><li>United Kingdom</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0086</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0005</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>United States</td>
        <td>427</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>114</td>
    </tr>
    <tr>
        <td>Australia</td>
        <td>40</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>40</td>
    </tr>
    <tr>
        <td>France</td>
        <td>40</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>40</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-Sales">Dataset: Sales</a>

<a id="profile-Sales-SalesOrderNumber"></a><a href="#column-Sales-SalesOrderNumber">**SalesOrderNumber**</a>[PK]

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>SO51721</li><li>SO51739</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>404957</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>0</li><li>0</li><li>0</li><li>0</li><li>57851</li><li>0</li><li>0</li><li>0</li><li>0</li><li>0</li></ul>bin_edges: <ul><li>6.6</li><li>6.7</li><li>6.8</li><li>6.9</li><li>7.0</li><li>7.1</li><li>7.2</li><li>7.3</li><li>7.4</li><li>7.5</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.01: 7.02: 7.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>6</li><li>0</li><li>8</li><li>3</li><li>9</li><li>7</li><li>2</li><li>5</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>3622</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0626</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-OrderDate"></a><a href="#column-Sales-OrderDate">**OrderDate**</a>[PK]

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>19.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>29.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>Monday, September 2, 2019</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>24.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9982</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9982</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1398735</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.1782</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>5.0441</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.2459</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.1388</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.6983</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>20.0</li><li>21.0</li><li>22.0</li><li>23.0</li><li>24.0</li><li>25.0</li><li>26.0</li><li>27.0</li><li>28.0</li><li>29.0</li></ul>bin_counts: <ul><li>3445</li><li>4673</li><li>6436</li><li>6898</li><li>8888</li><li>10581</li><li>7423</li><li>5503</li><li>3487</li><li>517</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 22.01: 24.02: 26.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>4</li><li>0</li><li>y</li><li>N</li><li>8</li><li>d</li><li>u</li><li>M</li><li>h</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>995</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0172</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-ProductKey"></a><a href="#column-Sales-ProductKey">**ProductKey**</a>[PK,FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>212.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>606.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>471</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>401.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.996</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.996</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>23640042</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>408.6367</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>12919.8788</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>113.6656</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.0123</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.0587</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>251.4</li><li>290.8</li><li>330.2</li><li>369.6</li><li>409.0</li><li>448.4</li><li>487.8</li><li>527.2</li><li>566.5999999999999</li><li>606.0</li></ul>bin_counts: <ul><li>7026</li><li>2832</li><li>5824</li><li>8379</li><li>5574</li><li>4545</li><li>8197</li><li>4385</li><li>4562</li><li>6527</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 326.01: 401.02: 491.0
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>237</li><li>531</li><li>359</li><li>442</li><li>462</li><li>504</li><li>440</li><li>403</li><li>338</li><li>585</li><li>383</li><li>322</li><li>379</li><li>527</li><li>236</li><li>215</li><li>312</li><li>334</li><li>386</li><li>230</li><li>464</li><li>498</li><li>492</li><li>572</li><li>288</li><li>476</li><li>460</li><li>551</li><li>367</li><li>603</li><li>389</li><li>521</li><li>494</li><li>376</li><li>424</li><li>335</li><li>317</li><li>258</li><li>299</li><li>364</li><li>309</li><li>246</li><li>414</li><li>554</li><li>470</li><li>586</li><li>433</li><li>565</li><li>516</li><li>378</li><li>523</li><li>439</li><li>316</li><li>488</li><li>290</li><li>499</li><li>240</li><li>356</li><li>496</li><li>520</li><li>474</li><li>579</li><li>427</li><li>353</li><li>229</li><li>568</li><li>219</li><li>289</li><li>605</li><li>365</li><li>368</li><li>457</li><li>329</li><li>426</li><li>253</li><li>419</li><li>447</li><li>503</li><li>400</li><li>342</li><li>234</li><li>417</li><li>387</li><li>591</li><li>445</li><li>326</li><li>481</li><li>583</li><li>375</li><li>491</li><li>441</li><li>593</li><li>295</li><li>272</li><li>458</li><li>574</li><li>245</li><li>352</li><li>567</li><li>232</li><li>456</li><li>448</li><li>506</li><li>296</li><li>472</li><li>501</li><li>377</li><li>354</li><li>337</li><li>235</li><li>218</li><li>543</li><li>534</li><li>393</li><li>397</li><li>212</li><li>373</li><li>279</li><li>243</li><li>566</li><li>233</li><li>576</li><li>436</li><li>271</li><li>415</li><li>294</li><li>435</li><li>355</li><li>454</li><li>325</li><li>285</li><li>307</li><li>408</li><li>469</li><li>276</li><li>318</li><li>343</li><li>569</li><li>310</li><li>411</li><li>423</li><li>429</li><li>533</li><li>597</li><li>407</li><li>321</li><li>300</li><li>465</li><li>263</li><li>563</li><li>467</li><li>361</li><li>502</li><li>410</li><li>402</li><li>584</li><li>306</li><li>404</li><li>273</li><li>374</li><li>514</li><li>575</li><li>324</li><li>434</li><li>344</li><li>601</li><li>265</li><li>495</li><li>604</li><li>281</li><li>286</li><li>578</li><li>390</li><li>333</li><li>313</li><li>330</li><li>360</li><li>264</li><li>398</li><li>391</li><li>262</li><li>532</li><li>213</li><li>484</li><li>256</li><li>223</li><li>345</li><li>418</li><li>384</li><li>287</li><li>394</li><li>341</li><li>573</li><li>562</li><li>385</li><li>304</li><li>463</li><li>598</li><li>323</li><li>471</li><li>409</li><li>380</li><li>348</li><li>255</li><li>582</li><li>500</li><li>587</li><li>239</li><li>557</li><li>549</li><li>493</li><li>477</li><li>231</li><li>553</li><li>266</li><li>526</li><li>351</li><li>547</li><li>242</li><li>224</li><li>363</li><li>305</li><li>420</li><li>524</li><li>280</li><li>482</li><li>399</li><li>327</li><li>222</li><li>362</li><li>517</li><li>336</li><li>556</li><li>564</li><li>314</li><li>297</li><li>511</li><li>275</li><li>552</li><li>600</li><li>267</li><li>320</li><li>483</li><li>421</li><li>507</li><li>473</li><li>487</li><li>580</li><li>217</li><li>214</li><li>311</li><li>369</li><li>382</li><li>428</li><li>401</li><li>559</li><li>328</li><li>241</li><li>430</li><li>315</li><li>509</li><li>510</li><li>331</li><li>590</li><li>542</li><li>293</li><li>257</li><li>589</li><li>560</li><li>388</li><li>466</li><li>254</li><li>238</li><li>581</li><li>349</li><li>571</li><li>594</li><li>505</li><li>358</li><li>340</li><li>513</li><li>515</li><li>357</li><li>372</li><li>550</li><li>525</li><li>544</li><li>298</li><li>459</li><li>319</li><li>468</li><li>596</li><li>512</li><li>592</li><li>606</li><li>346</li><li>546</li><li>480</li><li>595</li><li>497</li><li>490</li><li>381</li><li>545</li><li>422</li><li>561</li><li>339</li><li>453</li><li>347</li><li>270</li><li>518</li><li>221</li><li>588</li><li>220</li><li>558</li><li>555</li><li>370</li><li>350</li><li>461</li><li>292</li><li>332</li><li>225</li><li>522</li><li>366</li><li>599</li><li>371</li><li>577</li><li>395</li><li>475</li><li>548</li><li>570</li><li>396</li><li>216</li><li>412</li><li>308</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>334</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0058</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>471</td>
        <td>466</td>
    </tr>
    <tr>
        <td>491</td>
        <td>447</td>
    </tr>
    <tr>
        <td>224</td>
        <td>442</td>
    </tr>
    <tr>
        <td>458</td>
        <td>437</td>
    </tr>
    <tr>
        <td>233</td>
        <td>436</td>
    </tr>
    <tr>
        <td>456</td>
        <td>418</td>
    </tr>
    <tr>
        <td>483</td>
        <td>418</td>
    </tr>
    <tr>
        <td>225</td>
        <td>417</td>
    </tr>
    <tr>
        <td>234</td>
        <td>410</td>
    </tr>
    <tr>
        <td>477</td>
        <td>402</td>
    </tr>
    <tr>
        <td>490</td>
        <td>393</td>
    </tr>
    <tr>
        <td>484</td>
        <td>378</td>
    </tr>
    <tr>
        <td>221</td>
        <td>372</td>
    </tr>
    <tr>
        <td>470</td>
        <td>361</td>
    </tr>
    <tr>
        <td>323</td>
        <td>358</td>
    </tr>
    <tr>
        <td>469</td>
        <td>355</td>
    </tr>
    <tr>
        <td>460</td>
        <td>349</td>
    </tr>
    <tr>
        <td>343</td>
        <td>348</td>
    </tr>
    <tr>
        <td>217</td>
        <td>348</td>
    </tr>
    <tr>
        <td>327</td>
        <td>347</td>
    </tr>
    <tr>
        <td>299</td>
        <td>13</td>
    </tr>
    <tr>
        <td>534</td>
        <td>9</td>
    </tr>
    <tr>
        <td>505</td>
        <td>9</td>
    </tr>
    <tr>
        <td>266</td>
        <td>6</td>
    </tr>
    <tr>
        <td>473</td>
        <td>6</td>
    </tr>
    <tr>
        <td>550</td>
        <td>6</td>
    </tr>
    <tr>
        <td>518</td>
        <td>6</td>
    </tr>
    <tr>
        <td>549</td>
        <td>5</td>
    </tr>
    <tr>
        <td>504</td>
        <td>2</td>
    </tr>
    <tr>
        <td>256</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-ResellerKey"></a><a href="#column-Sales-ResellerKey">**ResellerKey**</a>[FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>701.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>678</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>327.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9962</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9962</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>19712322</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>340.743</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>42227.7453</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>205.4939</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0842</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2241</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>71.0</li><li>141.0</li><li>211.0</li><li>281.0</li><li>351.0</li><li>421.0</li><li>491.0</li><li>561.0</li><li>631.0</li><li>701.0</li></ul>bin_counts: <ul><li>5650</li><li>6827</li><li>6422</li><li>6294</li><li>5524</li><li>4111</li><li>6176</li><li>6336</li><li>4276</li><li>6235</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 166.01: 327.02: 514.0
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>462</li><li>599</li><li>552</li><li>139</li><li>108</li><li>684</li><li>522</li><li>239</li><li>430</li><li>131</li><li>680</li><li>472</li><li>635</li><li>257</li><li>626</li><li>426</li><li>346</li><li>647</li><li>460</li><li>696</li><li>180</li><li>659</li><li>185</li><li>444</li><li>155</li><li>602</li><li>255</li><li>102</li><li>378</li><li>660</li><li>467</li><li>556</li><li>318</li><li>528</li><li>368</li><li>129</li><li>438</li><li>601</li><li>36</li><li>550</li><li>248</li><li>534</li><li>410</li><li>125</li><li>530</li><li>456</li><li>562</li><li>208</li><li>691</li><li>363</li><li>512</li><li>634</li><li>306</li><li>442</li><li>677</li><li>231</li><li>575</li><li>55</li><li>449</li><li>436</li><li>628</li><li>560</li><li>701</li><li>287</li><li>127</li><li>340</li><li>266</li><li>157</li><li>359</li><li>458</li><li>99</li><li>214</li><li>201</li><li>8</li><li>309</li><li>330</li><li>141</li><li>41</li><li>668</li><li>120</li><li>301</li><li>232</li><li>212</li><li>616</li><li>122</li><li>58</li><li>499</li><li>342</li><li>304</li><li>478</li><li>78</li><li>229</li><li>260</li><li>77</li><li>165</li><li>511</li><li>1</li><li>697</li><li>686</li><li>193</li><li>33</li><li>19</li><li>172</li><li>351</li><li>621</li><li>596</li><li>302</li><li>370</li><li>525</li><li>666</li><li>46</li><li>395</li><li>627</li><li>7</li><li>173</li><li>311</li><li>254</li><li>640</li><li>203</li><li>163</li><li>183</li><li>25</li><li>243</li><li>563</li><li>389</li><li>121</li><li>579</li><li>576</li><li>175</li><li>61</li><li>45</li><li>168</li><li>184</li><li>328</li><li>326</li><li>523</li><li>598</li><li>258</li><li>97</li><li>364</li><li>513</li><li>490</li><li>570</li><li>653</li><li>166</li><li>398</li><li>9</li><li>611</li><li>242</li><li>300</li><li>592</li><li>331</li><li>357</li><li>187</li><li>473</li><li>316</li><li>488</li><li>223</li><li>482</li><li>365</li><li>320</li><li>292</li><li>698</li><li>648</li><li>580</li><li>581</li><li>448</li><li>3</li><li>107</li><li>14</li><li>624</li><li>215</li><li>549</li><li>135</li><li>84</li><li>299</li><li>79</li><li>700</li><li>584</li><li>466</li><li>568</li><li>615</li><li>236</li><li>577</li><li>443</li><li>495</li><li>676</li><li>418</li><li>502</li><li>284</li><li>503</li><li>675</li><li>609</li><li>641</li><li>390</li><li>317</li><li>263</li><li>520</li><li>377</li><li>156</li><li>597</li><li>31</li><li>383</li><li>272</li><li>295</li><li>15</li><li>392</li><li>288</li><li>270</li><li>296</li><li>471</li><li>96</li><li>566</li><li>213</li><li>504</li><li>20</li><li>190</li><li>164</li><li>56</li><li>16</li><li>380</li><li>663</li><li>545</li><li>334</li><li>117</li><li>667</li><li>343</li><li>150</li><li>70</li><li>91</li><li>264</li><li>393</li><li>536</li><li>322</li><li>594</li><li>366</li><li>481</li><li>636</li><li>47</li><li>48</li><li>81</li><li>427</li><li>459</li><li>388</li><li>265</li><li>167</li><li>147</li><li>109</li><li>662</li><li>661</li><li>247</li><li>496</li><li>335</li><li>23</li><li>29</li><li>408</li><li>146</li><li>692</li><li>337</li><li>585</li><li>630</li><li>289</li><li>2</li><li>211</li><li>533</li><li>527</li><li>431</li><li>593</li><li>118</li><li>182</li><li>606</li><li>252</li><li>221</li><li>303</li><li>200</li><li>169</li><li>477</li><li>38</li><li>308</li><li>339</li><li>345</li><li>110</li><li>268</li><li>535</li><li>277</li><li>30</li><li>486</li><li>148</li><li>494</li><li>664</li><li>451</li><li>251</li><li>310</li><li>113</li><li>65</li><li>195</li><li>323</li><li>206</li><li>411</li><li>177</li><li>160</li><li>516</li><li>524</li><li>159</li><li>491</li><li>171</li><li>583</li><li>665</li><li>492</li><li>54</li><li>608</li><li>683</li><li>644</li><li>162</li><li>276</li><li>6</li><li>227</li><li>355</li><li>237</li><li>181</li><li>483</li><li>216</li><li>400</li><li>170</li><li>574</li><li>217</li><li>396</li><li>440</li><li>461</li><li>259</li><li>40</li><li>487</li><li>424</li><li>286</li><li>437</li><li>678</li><li>441</li><li>321</li><li>352</li><li>10</li><li>136</li><li>281</li><li>219</li><li>314</li><li>493</li><li>269</li><li>540</li><li>685</li><li>51</li><li>319</li><li>572</li><li>344</li><li>89</li><li>154</li><li>586</li><li>564</li><li>591</li><li>610</li><li>112</li><li>559</li><li>361</li><li>199</li><li>428</li><li>454</li><li>360</li><li>604</li><li>672</li><li>649</li><li>435</li><li>198</li><li>690</li><li>315</li><li>369</li><li>312</li><li>582</li><li>475</li><li>622</li><li>115</li><li>401</li><li>484</li><li>544</li><li>422</li><li>282</li><li>230</li><li>106</li><li>279</li><li>391</li><li>90</li><li>98</li><li>633</li><li>226</li><li>241</li><li>50</li><li>103</li><li>100</li><li>429</li><li>607</li><li>256</li><li>95</li><li>137</li><li>52</li><li>693</li><li>313</li><li>603</li><li>417</li><li>39</li><li>74</li><li>555</li><li>646</li><li>305</li><li>325</li><li>642</li><li>5</li><li>66</li><li>142</li><li>474</li><li>480</li><li>176</li><li>381</li><li>228</li><li>69</li><li>588</li><li>614</li><li>445</li><li>143</li><li>57</li><li>652</li><li>62</li><li>376</li><li>529</li><li>111</li><li>73</li><li>414</li><li>152</li><li>546</li><li>128</li><li>145</li><li>234</li><li>293</li><li>587</li><li>578</li><li>220</li><li>674</li><li>26</li><li>561</li><li>651</li><li>275</li><li>87</li><li>590</li><li>283</li><li>94</li><li>126</li><li>469</li><li>571</li><li>222</li><li>11</li><li>372</li><li>694</li><li>468</li><li>386</li><li>553</li><li>350</li><li>420</li><li>446</li><li>539</li><li>114</li><li>645</li><li>548</li><li>138</li><li>682</li><li>191</li><li>196</li><li>18</li><li>72</li><li>280</li><li>207</li><li>617</li><li>130</li><li>403</li><li>595</li><li>425</li><li>43</li><li>573</li><li>379</li><li>605</li><li>149</li><li>262</li><li>623</li><li>397</li><li>433</li><li>202</li><li>336</li><li>673</li><li>650</li><li>679</li><li>338</li><li>654</li><li>151</li><li>267</li><li>498</li><li>53</li><li>423</li><li>618</li><li>439</li><li>514</li><li>291</li><li>387</li><li>44</li><li>453</li><li>186</li><li>210</li><li>205</li><li>412</li><li>271</li><li>687</li><li>532</li><li>670</li><li>218</li><li>656</li><li>569</li><li>179</li><li>434</li><li>17</li><li>557</li><li>399</li><li>83</li><li>479</li><li>59</li><li>353</li><li>123</li><li>518</li><li>86</li><li>34</li><li>384</li><li>637</li><li>245</li><li>358</li><li>632</li><li>432</li><li>67</li><li>681</li><li>153</li><li>27</li><li>543</li><li>625</li><li>93</li><li>85</li><li>4</li><li>541</li><li>470</li><li>274</li><li>134</li><li>178</li><li>80</li><li>92</li><li>285</li><li>629</li><li>688</li><li>348</li><li>612</li><li>12</li><li>327</li><li>235</li><li>161</li><li>144</li><li>519</li><li>542</li><li>476</li><li>28</li><li>506</li><li>510</li><li>554</li><li>509</li><li>639</li><li>290</li><li>464</li><li>307</li><li>567</li><li>531</li><li>224</li><li>246</li><li>695</li><li>225</li><li>643</li><li>385</li><li>119</li><li>485</li><li>101</li><li>354</li><li>558</li><li>497</li><li>457</li><li>37</li><li>249</li><li>68</li><li>238</li><li>63</li><li>49</li><li>421</li><li>382</li><li>253</li><li>538</li><li>22</li><li>489</li><li>75</li><li>233</li><li>116</li><li>24</li><li>297</li><li>521</li><li>250</li><li>349</li><li>613</li><li>505</li><li>273</li><li>551</li><li>669</li><li>699</li><li>197</li><li>240</li><li>631</li><li>404</li><li>64</li><li>407</li><li>124</li><li>638</li><li>278</li><li>104</li><li>406</li><li>21</li><li>88</li><li>133</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>632</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0109</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>678</td>
        <td>469</td>
    </tr>
    <tr>
        <td>514</td>
        <td>451</td>
    </tr>
    <tr>
        <td>54</td>
        <td>443</td>
    </tr>
    <tr>
        <td>496</td>
        <td>441</td>
    </tr>
    <tr>
        <td>175</td>
        <td>440</td>
    </tr>
    <tr>
        <td>328</td>
        <td>436</td>
    </tr>
    <tr>
        <td>84</td>
        <td>436</td>
    </tr>
    <tr>
        <td>221</td>
        <td>432</td>
    </tr>
    <tr>
        <td>167</td>
        <td>422</td>
    </tr>
    <tr>
        <td>475</td>
        <td>418</td>
    </tr>
    <tr>
        <td>638</td>
        <td>405</td>
    </tr>
    <tr>
        <td>155</td>
        <td>401</td>
    </tr>
    <tr>
        <td>233</td>
        <td>401</td>
    </tr>
    <tr>
        <td>118</td>
        <td>394</td>
    </tr>
    <tr>
        <td>309</td>
        <td>393</td>
    </tr>
    <tr>
        <td>650</td>
        <td>391</td>
    </tr>
    <tr>
        <td>442</td>
        <td>387</td>
    </tr>
    <tr>
        <td>618</td>
        <td>380</td>
    </tr>
    <tr>
        <td>236</td>
        <td>375</td>
    </tr>
    <tr>
        <td>312</td>
        <td>374</td>
    </tr>
    <tr>
        <td>50</td>
        <td>1</td>
    </tr>
    <tr>
        <td>74</td>
        <td>1</td>
    </tr>
    <tr>
        <td>474</td>
        <td>1</td>
    </tr>
    <tr>
        <td>590</td>
        <td>1</td>
    </tr>
    <tr>
        <td>350</td>
        <td>1</td>
    </tr>
    <tr>
        <td>617</td>
        <td>1</td>
    </tr>
    <tr>
        <td>434</td>
        <td>1</td>
    </tr>
    <tr>
        <td>153</td>
        <td>1</td>
    </tr>
    <tr>
        <td>521</td>
        <td>1</td>
    </tr>
    <tr>
        <td>699</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-EmployeeKey"></a><a href="#column-Sales-EmployeeKey">**EmployeeKey**</a>[FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>272.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>296.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>283</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>285.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9132</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9132</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>16553007</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>286.1317</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>20.447</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.5218</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.1231</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.0735</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>274.4</li><li>276.8</li><li>279.2</li><li>281.6</li><li>284.0</li><li>286.4</li><li>288.8</li><li>291.2</li><li>293.6</li><li>296.0</li></ul>bin_counts: <ul><li>747</li><li>0</li><li>0</li><li>6734</li><li>17510</li><li>7195</li><li>8516</li><li>9104</li><li>5061</li><li>2984</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 283.01: 285.02: 290.0
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>291</li><li>283</li><li>295</li><li>272</li><li>289</li><li>293</li><li>288</li><li>285</li><li>287</li><li>296</li><li>284</li><li>281</li><li>286</li><li>282</li><li>292</li><li>294</li><li>290</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>17</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0003</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>283</td>
        <td>7529</td>
    </tr>
    <tr>
        <td>282</td>
        <td>6843</td>
    </tr>
    <tr>
        <td>281</td>
        <td>6734</td>
    </tr>
    <tr>
        <td>291</td>
        <td>6374</td>
    </tr>
    <tr>
        <td>285</td>
        <td>5250</td>
    </tr>
    <tr>
        <td>287</td>
        <td>4357</td>
    </tr>
    <tr>
        <td>288</td>
        <td>4159</td>
    </tr>
    <tr>
        <td>292</td>
        <td>3311</td>
    </tr>
    <tr>
        <td>284</td>
        <td>3138</td>
    </tr>
    <tr>
        <td>289</td>
        <td>2146</td>
    </tr>
    <tr>
        <td>286</td>
        <td>1945</td>
    </tr>
    <tr>
        <td>293</td>
        <td>1750</td>
    </tr>
    <tr>
        <td>295</td>
        <td>1561</td>
    </tr>
    <tr>
        <td>296</td>
        <td>1183</td>
    </tr>
    <tr>
        <td>272</td>
        <td>747</td>
    </tr>
    <tr>
        <td>290</td>
        <td>584</td>
    </tr>
    <tr>
        <td>294</td>
        <td>240</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-SalesTerritoryKey"></a><a href="#column-Sales-SalesTerritoryKey">**SalesTerritoryKey**</a>[FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8621</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8621</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>263478</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>4.5544</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>5.8189</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.4122</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.431</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.3072</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.9</li><li>2.8</li><li>3.7</li><li>4.6</li><li>5.5</li><li>6.4</li><li>7.3</li><li>8.2</li><li>9.1</li><li>10.0</li></ul>bin_counts: <ul><li>7446</li><li>5610</li><li>5527</li><li>12826</li><li>5742</li><li>10934</li><li>3422</li><li>1679</li><li>1423</li><li>3242</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.01: 4.02: 6.0
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>2</li><li>10</li><li>5</li><li>6</li><li>3</li><li>8</li><li>4</li><li>9</li><li>1</li><li>7</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0002</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>4</td>
        <td>12826</td>
    </tr>
    <tr>
        <td>6</td>
        <td>10934</td>
    </tr>
    <tr>
        <td>1</td>
        <td>7446</td>
    </tr>
    <tr>
        <td>5</td>
        <td>5742</td>
    </tr>
    <tr>
        <td>2</td>
        <td>5610</td>
    </tr>
    <tr>
        <td>3</td>
        <td>5527</td>
    </tr>
    <tr>
        <td>7</td>
        <td>3422</td>
    </tr>
    <tr>
        <td>10</td>
        <td>3242</td>
    </tr>
    <tr>
        <td>8</td>
        <td>1679</td>
    </tr>
    <tr>
        <td>9</td>
        <td>1423</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-Quantity"></a><a href="#column-Sales-Quantity">**Quantity**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>44.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8366</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8366</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>204114</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.5283</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>9.2159</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.0358</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.8354</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>14.0564</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.3</li><li>9.6</li><li>13.899999999999999</li><li>18.2</li><li>22.5</li><li>26.799999999999997</li><li>31.099999999999998</li><li>35.4</li><li>39.699999999999996</li><li>44.0</li></ul>bin_counts: <ul><li>48134</li><li>7036</li><li>1749</li><li>675</li><li>138</li><li>70</li><li>23</li><li>18</li><li>4</li><li>4</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 2.01: 3.02: 4.0
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>32</li><li>34</li><li>9</li><li>24</li><li>40</li><li>23</li><li>14</li><li>5</li><li>4</li><li>10</li><li>28</li><li>6</li><li>16</li><li>17</li><li>18</li><li>22</li><li>8</li><li>35</li><li>15</li><li>13</li><li>27</li><li>7</li><li>2</li><li>19</li><li>38</li><li>31</li><li>39</li><li>33</li><li>29</li><li>20</li><li>12</li><li>44</li><li>1</li><li>21</li><li>3</li><li>36</li><li>30</li><li>26</li><li>41</li><li>11</li><li>25</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>41</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0007</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>1</td>
        <td>13713</td>
    </tr>
    <tr>
        <td>2</td>
        <td>13476</td>
    </tr>
    <tr>
        <td>3</td>
        <td>9593</td>
    </tr>
    <tr>
        <td>4</td>
        <td>7150</td>
    </tr>
    <tr>
        <td>5</td>
        <td>4202</td>
    </tr>
    <tr>
        <td>6</td>
        <td>3134</td>
    </tr>
    <tr>
        <td>7</td>
        <td>1649</td>
    </tr>
    <tr>
        <td>8</td>
        <td>1455</td>
    </tr>
    <tr>
        <td>9</td>
        <td>798</td>
    </tr>
    <tr>
        <td>10</td>
        <td>727</td>
    </tr>
    <tr>
        <td>12</td>
        <td>439</td>
    </tr>
    <tr>
        <td>11</td>
        <td>365</td>
    </tr>
    <tr>
        <td>14</td>
        <td>247</td>
    </tr>
    <tr>
        <td>13</td>
        <td>218</td>
    </tr>
    <tr>
        <td>16</td>
        <td>129</td>
    </tr>
    <tr>
        <td>15</td>
        <td>113</td>
    </tr>
    <tr>
        <td>18</td>
        <td>98</td>
    </tr>
    <tr>
        <td>17</td>
        <td>88</td>
    </tr>
    <tr>
        <td>19</td>
        <td>52</td>
    </tr>
    <tr>
        <td>20</td>
        <td>44</td>
    </tr>
    <tr>
        <td>21</td>
        <td>30</td>
    </tr>
    <tr>
        <td>23</td>
        <td>21</td>
    </tr>
    <tr>
        <td>24</td>
        <td>18</td>
    </tr>
    <tr>
        <td>25</td>
        <td>16</td>
    </tr>
    <tr>
        <td>26</td>
        <td>15</td>
    </tr>
    <tr>
        <td>22</td>
        <td>12</td>
    </tr>
    <tr>
        <td>27</td>
        <td>9</td>
    </tr>
    <tr>
        <td>32</td>
        <td>7</td>
    </tr>
    <tr>
        <td>28</td>
        <td>6</td>
    </tr>
    <tr>
        <td>33</td>
        <td>6</td>
    </tr>
    <tr>
        <td>31</td>
        <td>4</td>
    </tr>
    <tr>
        <td>34</td>
        <td>3</td>
    </tr>
    <tr>
        <td>29</td>
        <td>3</td>
    </tr>
    <tr>
        <td>40</td>
        <td>2</td>
    </tr>
    <tr>
        <td>35</td>
        <td>2</td>
    </tr>
    <tr>
        <td>36</td>
        <td>2</td>
    </tr>
    <tr>
        <td>38</td>
        <td>1</td>
    </tr>
    <tr>
        <td>39</td>
        <td>1</td>
    </tr>
    <tr>
        <td>44</td>
        <td>1</td>
    </tr>
    <tr>
        <td>30</td>
        <td>1</td>
    </tr>
    <tr>
        <td>41</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-Unit Price"></a><a href="#column-Sales-Unit Price">**Unit Price**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>9.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>$469.79</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9845</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9845</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>392289</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>6.781</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.4436</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.2015</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.2354</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.5972</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.6</li><li>4.2</li><li>4.8</li><li>5.4</li><li>6.0</li><li>6.6</li><li>7.2</li><li>7.8</li><li>8.399999999999999</li><li>9.0</li></ul>bin_counts: <ul><li>692</li><li>372</li><li>0</li><li>3977</li><li>19206</li><li>0</li><li>24416</li><li>0</li><li>0</li><li>9188</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.01: 7.02: 7.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>6</li><li>0</li><li>,</li><li>8</li><li>$</li><li>9</li><li>7</li><li>2</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>$242.99</li><li>$850</li><li>$211.17</li><li>$209.26</li><li>$38.1</li><li>$22.79</li><li>$1,417.14</li><li>$1.33</li><li>$20.52</li><li>$56.26</li><li>$2.89</li><li>$214.24</li><li>$218.45</li><li>$31.58</li><li>$582.27</li><li>$1,265.31</li><li>$1,229.46</li><li>$338.99</li><li>$28.99</li><li>$153.89</li><li>$430.64</li><li>$178.58</li><li>$26.44</li><li>$647.99</li><li>$649.88</li><li>$54.94</li><li>$24.29</li><li>$27.65</li><li>$46.97</li><li>$461.69</li><li>$37.5</li><li>$60</li><li>$445.41</li><li>$28.84</li><li>$32.39</li><li>$54.89</li><li>$953.63</li><li>$133.1</li><li>$234.9</li><li>$5.21</li><li>$66</li><li>$53.06</li><li>$59.33</li><li>$196.33</li><li>$672.29</li><li>$13.66</li><li>$324.45</li><li>$72.89</li><li>$1.37</li><li>$850.5</li><li>$5.01</li><li>$53.99</li><li>$4.77</li><li>$48.59</li><li>$74.84</li><li>$809.76</li><li>$2.99</li><li>$1,308.94</li><li>$65.6</li><li>$35</li><li>$14.13</li><li>$14.5</li><li>$1,242.85</li><li>$72</li><li>$165.23</li><li>$49.49</li><li>$183.94</li><li>$4.32</li><li>$67.54</li><li>$469.79</li><li>$15</li><li>$144.88</li><li>$113</li><li>$25.83</li><li>$27.88</li><li>$1,192.04</li><li>$874.79</li><li>$19.51</li><li>$327.16</li><li>$935.54</li><li>$736.15</li><li>$2,039.99</li><li>$31.89</li><li>$16.27</li><li>$16.82</li><li>$69.6</li><li>$1,376.99</li><li>$35.23</li><li>$1,971.99</li><li>$323.99</li><li>$179.97</li><li>$5.23</li><li>$2.74</li><li>$19.24</li><li>$41.99</li><li>$4.75</li><li>$15.73</li><li>$4.61</li><li>$1,311.24</li><li>$580.25</li><li>$791.41</li><li>$193.38</li><li>$14.2</li><li>$2,024.99</li><li>$1,331.09</li><li>$454.13</li><li>$2.5</li><li>$1,343.84</li><li>$5.39</li><li>$33.77</li><li>$13.47</li><li>$1,201.42</li><li>$2,146.96</li><li>$177.81</li><li>$408.29</li><li>$602.35</li><li>$600.26</li><li>$125.42</li><li>$189.78</li><li>$704.61</li><li>$40.59</li><li>$153.15</li><li>$626.39</li><li>$1,391.99</li><li>$12.95</li><li>$34.79</li><li>$20.29</li><li>$11.59</li><li>$20.19</li><li>$20.89</li><li>$149.03</li><li>$313.64</li><li>$36.83</li><li>$15.75</li><li>$722.59</li><li>$61.77</li><li>$334.06</li><li>$758.08</li><li>$19</li><li>$22.03</li><li>$356.9</li><li>$446.3</li><li>$34.93</li><li>$29.99</li><li>$137.69</li><li>$17.1</li><li>$1,957.49</li><li>$72.16</li><li>$44.99</li><li>$36.45</li><li>$26.72</li><li>$18.5</li><li>$202.28</li><li>$728.91</li><li>$11.99</li><li>$27</li><li>$780.82</li><li>$14.69</li><li>$43.49</li><li>$23.48</li><li>$668.17</li><li>$858.9</li><li>$35.99</li><li>$29.69</li><li>$41.24</li><li>$20.99</li><li>$200.05</li><li>$4.5</li><li>$4.37</li><li>$136.89</li><li>$430.56</li><li>$5.7</li><li>$234.89</li><li>$61.37</li><li>$22.7</li><li>$1,188.48</li><li>$714.7</li><li>$1,430.44</li><li>$52.19</li><li>$5.19</li><li>$31.75</li><li>$419.46</li><li>$845.63</li><li>$31.31</li><li>$313.19</li><li>$24.03</li><li>$1,020.59</li><li>$1,262.24</li><li>$1,275.99</li><li>$5.51</li><li>$405.48</li><li>$12.14</li><li>$105.29</li><li>$149.87</li><li>$27.49</li><li>$141.62</li><li>$158.43</li><li>$88.93</li><li>$129.81</li><li>$3.98</li><li>$52.65</li><li>$37.25</li><li>$72.88</li><li>$744.27</li><li>$202.33</li><li>$843.75</li><li>$550.24</li><li>$11.74</li><li>$198.04</li><li>$986.57</li><li>$31.5</li><li>$63.9</li><li>$1,345.59</li><li>$180.13</li><li>$4.94</li><li>$30.24</li><li>$35.91</li><li>$37.15</li><li>$552.15</li><li>$818.7</li><li>$195.59</li><li>$24.5</li><li>$183.38</li><li>$296.99</li><li>$1,382.76</li><li>$32.99</li><li>$1,127</li><li>$38.49</li><li>$1,466.01</li><li>$32.65</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>228</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0039</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>$469.79</td>
        <td>2969</td>
    </tr>
    <tr>
        <td>$419.46</td>
        <td>2198</td>
    </tr>
    <tr>
        <td>$28.84</td>
        <td>1593</td>
    </tr>
    <tr>
        <td>$20.19</td>
        <td>1493</td>
    </tr>
    <tr>
        <td>$323.99</td>
        <td>1463</td>
    </tr>
    <tr>
        <td>$1,466.01</td>
        <td>1353</td>
    </tr>
    <tr>
        <td>$1,430.44</td>
        <td>1251</td>
    </tr>
    <tr>
        <td>$202.33</td>
        <td>1203</td>
    </tr>
    <tr>
        <td>$445.41</td>
        <td>1165</td>
    </tr>
    <tr>
        <td>$32.39</td>
        <td>1095</td>
    </tr>
    <tr>
        <td>$183.94</td>
        <td>1015</td>
    </tr>
    <tr>
        <td>$600.26</td>
        <td>934</td>
    </tr>
    <tr>
        <td>$874.79</td>
        <td>903</td>
    </tr>
    <tr>
        <td>$44.99</td>
        <td>903</td>
    </tr>
    <tr>
        <td>$647.99</td>
        <td>888</td>
    </tr>
    <tr>
        <td>$1,020.59</td>
        <td>885</td>
    </tr>
    <tr>
        <td>$1,229.46</td>
        <td>880</td>
    </tr>
    <tr>
        <td>$5.39</td>
        <td>866</td>
    </tr>
    <tr>
        <td>$672.29</td>
        <td>863</td>
    </tr>
    <tr>
        <td>$1,308.94</td>
        <td>819</td>
    </tr>
    <tr>
        <td>$1,242.85</td>
        <td>819</td>
    </tr>
    <tr>
        <td>$20.99</td>
        <td>816</td>
    </tr>
    <tr>
        <td>$29.99</td>
        <td>803</td>
    </tr>
    <tr>
        <td>$22.79</td>
        <td>789</td>
    </tr>
    <tr>
        <td>$41.99</td>
        <td>750</td>
    </tr>
    <tr>
        <td>$53.99</td>
        <td>735</td>
    </tr>
    <tr>
        <td>$728.91</td>
        <td>728</td>
    </tr>
    <tr>
        <td>$356.9</td>
        <td>718</td>
    </tr>
    <tr>
        <td>$209.26</td>
        <td>709</td>
    </tr>
    <tr>
        <td>$338.99</td>
        <td>705</td>
    </tr>
    <tr>
        <td>$1,376.99</td>
        <td>691</td>
    </tr>
    <tr>
        <td>$5.19</td>
        <td>690</td>
    </tr>
    <tr>
        <td>$324.45</td>
        <td>688</td>
    </tr>
    <tr>
        <td>$602.35</td>
        <td>682</td>
    </tr>
    <tr>
        <td>$2,024.99</td>
        <td>661</td>
    </tr>
    <tr>
        <td>$2,039.99</td>
        <td>643</td>
    </tr>
    <tr>
        <td>$158.43</td>
        <td>643</td>
    </tr>
    <tr>
        <td>$24.29</td>
        <td>642</td>
    </tr>
    <tr>
        <td>$38.1</td>
        <td>634</td>
    </tr>
    <tr>
        <td>$14.69</td>
        <td>602</td>
    </tr>
    <tr>
        <td>$200.05</td>
        <td>565</td>
    </tr>
    <tr>
        <td>$35.99</td>
        <td>561</td>
    </tr>
    <tr>
        <td>$1,391.99</td>
        <td>549</td>
    </tr>
    <tr>
        <td>$2,146.96</td>
        <td>539</td>
    </tr>
    <tr>
        <td>$48.59</td>
        <td>534</td>
    </tr>
    <tr>
        <td>$218.45</td>
        <td>523</td>
    </tr>
    <tr>
        <td>$149.87</td>
        <td>512</td>
    </tr>
    <tr>
        <td>$334.06</td>
        <td>504</td>
    </tr>
    <tr>
        <td>$14.13</td>
        <td>496</td>
    </tr>
    <tr>
        <td>$461.69</td>
        <td>433</td>
    </tr>
    <tr>
        <td>$818.7</td>
        <td>424</td>
    </tr>
    <tr>
        <td>$31.58</td>
        <td>407</td>
    </tr>
    <tr>
        <td>$744.27</td>
        <td>386</td>
    </tr>
    <tr>
        <td>$37.25</td>
        <td>385</td>
    </tr>
    <tr>
        <td>$72</td>
        <td>361</td>
    </tr>
    <tr>
        <td>$780.82</td>
        <td>354</td>
    </tr>
    <tr>
        <td>$2.99</td>
        <td>351</td>
    </tr>
    <tr>
        <td>$809.76</td>
        <td>344</td>
    </tr>
    <tr>
        <td>$63.9</td>
        <td>330</td>
    </tr>
    <tr>
        <td>$4.77</td>
        <td>329</td>
    </tr>
    <tr>
        <td>$858.9</td>
        <td>314</td>
    </tr>
    <tr>
        <td>$736.15</td>
        <td>311</td>
    </tr>
    <tr>
        <td>$67.54</td>
        <td>303</td>
    </tr>
    <tr>
        <td>$178.58</td>
        <td>272</td>
    </tr>
    <tr>
        <td>$32.99</td>
        <td>272</td>
    </tr>
    <tr>
        <td>$11.99</td>
        <td>262</td>
    </tr>
    <tr>
        <td>$141.62</td>
        <td>258</td>
    </tr>
    <tr>
        <td>$196.33</td>
        <td>253</td>
    </tr>
    <tr>
        <td>$33.77</td>
        <td>253</td>
    </tr>
    <tr>
        <td>$15</td>
        <td>252</td>
    </tr>
    <tr>
        <td>$65.6</td>
        <td>242</td>
    </tr>
    <tr>
        <td>$953.63</td>
        <td>231</td>
    </tr>
    <tr>
        <td>$36.45</td>
        <td>231</td>
    </tr>
    <tr>
        <td>$54.89</td>
        <td>224</td>
    </tr>
    <tr>
        <td>$37.15</td>
        <td>224</td>
    </tr>
    <tr>
        <td>$72.16</td>
        <td>218</td>
    </tr>
    <tr>
        <td>$12.14</td>
        <td>218</td>
    </tr>
    <tr>
        <td>$5.7</td>
        <td>210</td>
    </tr>
    <tr>
        <td>$198.04</td>
        <td>206</td>
    </tr>
    <tr>
        <td>$26.72</td>
        <td>195</td>
    </tr>
    <tr>
        <td>$149.03</td>
        <td>194</td>
    </tr>
    <tr>
        <td>$242.99</td>
        <td>190</td>
    </tr>
    <tr>
        <td>$72.89</td>
        <td>188</td>
    </tr>
    <tr>
        <td>$722.59</td>
        <td>188</td>
    </tr>
    <tr>
        <td>$16.27</td>
        <td>179</td>
    </tr>
    <tr>
        <td>$714.7</td>
        <td>169</td>
    </tr>
    <tr>
        <td>$23.48</td>
        <td>164</td>
    </tr>
    <tr>
        <td>$1.37</td>
        <td>150</td>
    </tr>
    <tr>
        <td>$105.29</td>
        <td>148</td>
    </tr>
    <tr>
        <td>$52.65</td>
        <td>148</td>
    </tr>
    <tr>
        <td>$72.88</td>
        <td>123</td>
    </tr>
    <tr>
        <td>$137.69</td>
        <td>116</td>
    </tr>
    <tr>
        <td>$125.42</td>
        <td>114</td>
    </tr>
    <tr>
        <td>$74.84</td>
        <td>110</td>
    </tr>
    <tr>
        <td>$180.13</td>
        <td>104</td>
    </tr>
    <tr>
        <td>$61.37</td>
        <td>101</td>
    </tr>
    <tr>
        <td>$16.82</td>
        <td>98</td>
    </tr>
    <tr>
        <td>$31.31</td>
        <td>92</td>
    </tr>
    <tr>
        <td>$36.83</td>
        <td>91</td>
    </tr>
    <tr>
        <td>$54.94</td>
        <td>90</td>
    </tr>
    <tr>
        <td>$113</td>
        <td>90</td>
    </tr>
    <tr>
        <td>$15.75</td>
        <td>84</td>
    </tr>
    <tr>
        <td>$88.93</td>
        <td>83</td>
    </tr>
    <tr>
        <td>$20.29</td>
        <td>77</td>
    </tr>
    <tr>
        <td>$5.21</td>
        <td>75</td>
    </tr>
    <tr>
        <td>$454.13</td>
        <td>75</td>
    </tr>
    <tr>
        <td>$38.49</td>
        <td>74</td>
    </tr>
    <tr>
        <td>$22.03</td>
        <td>71</td>
    </tr>
    <tr>
        <td>$843.75</td>
        <td>69</td>
    </tr>
    <tr>
        <td>$850</td>
        <td>68</td>
    </tr>
    <tr>
        <td>$20.89</td>
        <td>67</td>
    </tr>
    <tr>
        <td>$40.59</td>
        <td>66</td>
    </tr>
    <tr>
        <td>$34.93</td>
        <td>63</td>
    </tr>
    <tr>
        <td>$29.69</td>
        <td>62</td>
    </tr>
    <tr>
        <td>$234.9</td>
        <td>61</td>
    </tr>
    <tr>
        <td>$28.99</td>
        <td>57</td>
    </tr>
    <tr>
        <td>$27.88</td>
        <td>49</td>
    </tr>
    <tr>
        <td>$4.94</td>
        <td>49</td>
    </tr>
    <tr>
        <td>$43.49</td>
        <td>47</td>
    </tr>
    <tr>
        <td>$20.52</td>
        <td>46</td>
    </tr>
    <tr>
        <td>$214.24</td>
        <td>45</td>
    </tr>
    <tr>
        <td>$19.51</td>
        <td>42</td>
    </tr>
    <tr>
        <td>$14.2</td>
        <td>39</td>
    </tr>
    <tr>
        <td>$758.08</td>
        <td>35</td>
    </tr>
    <tr>
        <td>$4.61</td>
        <td>34</td>
    </tr>
    <tr>
        <td>$31.89</td>
        <td>33</td>
    </tr>
    <tr>
        <td>$69.6</td>
        <td>32</td>
    </tr>
    <tr>
        <td>$2.89</td>
        <td>31</td>
    </tr>
    <tr>
        <td>$165.23</td>
        <td>31</td>
    </tr>
    <tr>
        <td>$27.65</td>
        <td>30</td>
    </tr>
    <tr>
        <td>$35</td>
        <td>29</td>
    </tr>
    <tr>
        <td>$153.89</td>
        <td>28</td>
    </tr>
    <tr>
        <td>$5.01</td>
        <td>27</td>
    </tr>
    <tr>
        <td>$27.49</td>
        <td>25</td>
    </tr>
    <tr>
        <td>$986.57</td>
        <td>25</td>
    </tr>
    <tr>
        <td>$430.64</td>
        <td>24</td>
    </tr>
    <tr>
        <td>$19</td>
        <td>24</td>
    </tr>
    <tr>
        <td>$66</td>
        <td>23</td>
    </tr>
    <tr>
        <td>$1,382.76</td>
        <td>22</td>
    </tr>
    <tr>
        <td>$2.74</td>
        <td>19</td>
    </tr>
    <tr>
        <td>$19.24</td>
        <td>18</td>
    </tr>
    <tr>
        <td>$41.24</td>
        <td>18</td>
    </tr>
    <tr>
        <td>$4.75</td>
        <td>16</td>
    </tr>
    <tr>
        <td>$52.19</td>
        <td>15</td>
    </tr>
    <tr>
        <td>$26.44</td>
        <td>14</td>
    </tr>
    <tr>
        <td>$4.37</td>
        <td>14</td>
    </tr>
    <tr>
        <td>$1,331.09</td>
        <td>13</td>
    </tr>
    <tr>
        <td>$935.54</td>
        <td>12</td>
    </tr>
    <tr>
        <td>$704.61</td>
        <td>12</td>
    </tr>
    <tr>
        <td>$18.5</td>
        <td>12</td>
    </tr>
    <tr>
        <td>$1,345.59</td>
        <td>12</td>
    </tr>
    <tr>
        <td>$5.51</td>
        <td>11</td>
    </tr>
    <tr>
        <td>$13.47</td>
        <td>10</td>
    </tr>
    <tr>
        <td>$34.79</td>
        <td>10</td>
    </tr>
    <tr>
        <td>$31.75</td>
        <td>10</td>
    </tr>
    <tr>
        <td>$582.27</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$5.23</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$1,311.24</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$1,201.42</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$313.19</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$30.24</td>
        <td>8</td>
    </tr>
    <tr>
        <td>$59.33</td>
        <td>7</td>
    </tr>
    <tr>
        <td>$14.5</td>
        <td>7</td>
    </tr>
    <tr>
        <td>$1,265.31</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$49.49</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$153.15</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$626.39</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$1,957.49</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$430.56</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$1,188.48</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$405.48</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$195.59</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$649.88</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$580.25</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$11.59</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$136.89</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$1,262.24</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$211.17</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$1,417.14</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$13.66</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$189.78</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$296.99</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$46.97</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$53.06</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$1,971.99</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$61.77</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$446.3</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$202.28</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$4.5</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$22.7</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$11.74</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$56.26</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$60</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$25.83</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$408.29</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$12.95</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$668.17</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$234.89</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$845.63</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$35.91</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$552.15</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$32.65</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$1.33</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$37.5</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$133.1</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$850.5</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$4.32</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$144.88</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,192.04</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$327.16</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$35.23</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$179.97</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$15.73</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$791.41</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$193.38</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$2.5</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,343.84</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$177.81</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$313.64</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$17.1</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$27</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$24.03</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,275.99</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$129.81</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$3.98</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$550.24</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$31.5</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$24.5</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$183.38</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,127</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-Sales"></a><a href="#column-Sales-Sales">**Sales**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>$419.46</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9971</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9971</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>422826</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.3089</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.7113</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.3082</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.0034</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.5146</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.7</li><li>4.4</li><li>5.1</li><li>5.8</li><li>6.5</li><li>7.199999999999999</li><li>7.8999999999999995</li><li>8.6</li><li>9.3</li><li>10.0</li></ul>bin_counts: <ul><li>265</li><li>660</li><li>1370</li><li>0</li><li>14066</li><li>21670</li><li>0</li><li>2569</li><li>16607</li><li>644</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.01: 7.02: 9.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>6</li><li>0</li><li>,</li><li>8</li><li>$</li><li>9</li><li>7</li><li>2</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>$5,183.92</li><li>$652.63</li><li>$51.3</li><li>$589</li><li>$682.87</li><li>$384.8</li><li>$4,008.72</li><li>$88.93</li><li>$9,904.72</li><li>$218.45</li><li>$2,783.98</li><li>$11.4</li><li>$3,926.82</li><li>$818.7</li><li>$3,050.91</li><li>$607.86</li><li>$1,427.6</li><li>$97.18</li><li>$708.1</li><li>$1,593.68</li><li>$356.9</li><li>$475.29</li><li>$303.93</li><li>$563.64</li><li>$219.56</li><li>$3,239.95</li><li>$97.12</li><li>$355.13</li><li>$728.91</li><li>$923.76</li><li>$1,260</li><li>$9,942.8</li><li>$86.52</li><li>$4,175.97</li><li>$1,505.79</li><li>$7,148.68</li><li>$334.24</li><li>$188.91</li><li>$752.52</li><li>$5,831.28</li><li>$388.72</li><li>$1,747.6</li><li>$216.48</li><li>$340.13</li><li>$495.69</li><li>$119.96</li><li>$189.48</li><li>$588.99</li><li>$4,194.6</li><li>$714.32</li><li>$7,368.3</li><li>$593.82</li><li>$165.23</li><li>$1,687.5</li><li>$164.95</li><li>$566.48</li><li>$21,532.39</li><li>$14,801.49</li><li>$74.3</li><li>$6,963</li><li>$3,445.09</li><li>$461.69</li><li>$1,781.64</li><li>$210.6</li><li>$296</li><li>$19,668.6</li><li>$1,457.94</li><li>$10,471.52</li><li>$953.63</li><li>$5,010.9</li><li>$70.44</li><li>$22,291.08</li><li>$93.86</li><li>$1,684.65</li><li>$299.9</li><li>$20.19</li><li>$2,456.1</li><li>$4,077.32</li><li>$359.9</li><li>$393.6</li><li>$32.34</li><li>$18,838.26</li><li>$20.52</li><li>$185.75</li><li>$197.94</li><li>$17,492.67</li><li>$319.5</li><li>$377.91</li><li>$179.95</li><li>$526.45</li><li>$31.14</li><li>$3,212.1</li><li>$835.2</li><li>$20.93</li><li>$14,641.99</li><li>$33.77</li><li>$1,101.52</li><li>$6,675.41</li><li>$720.52</li><li>$49.32</li><li>$6,722.9</li><li>$419.46</li><li>$527.67</li><li>$791</li><li>$6,560.19</li><li>$2,534.04</li><li>$447.3</li><li>$47.25</li><li>$180.13</li><li>$47.96</li><li>$5,209.89</li><li>$80.76</li><li>$84.1</li><li>$12,527.91</li><li>$146.93</li><li>$337.7</li><li>$1,642.68</li><li>$8,143.07</li><li>$758.08</li><li>$596.12</li><li>$377.93</li><li>$1,839.4</li><li>$396.08</li><li>$3,355.68</li><li>$259.56</li><li>$6,890.29</li><li>$405.86</li><li>$6,404.97</li><li>$34.68</li><li>$8,705.51</li><li>$80.75</li><li>$260.05</li><li>$856.96</li><li>$4,706.03</li><li>$1,308.94</li><li>$780.82</li><li>$23.48</li><li>$8.22</li><li>$324.45</li><li>$17,005.68</li><li>$551.82</li><li>$16.17</li><li>$266.7</li><li>$446.46</li><li>$20,195.84</li><li>$990</li><li>$1,310.7</li><li>$2,087.58</li><li>$30,993.04</li><li>$3,361.45</li><li>$37.15</li><li>$242.9</li><li>$323.91</li><li>$392</li><li>$108</li><li>$890.82</li><li>$99.5</li><li>$83.98</li><li>$164.82</li><li>$533.58</li><li>$1,457.82</li><li>$120</li><li>$307.84</li><li>$1,409.37</li><li>$618.6</li><li>$60.61</li><li>$5,102.37</li><li>$2,498.3</li><li>$2,023.3</li><li>$204.75</li><li>$1,820.97</li><li>$59.95</li><li>$940.31</li><li>$48.81</li><li>$1,291.5</li><li>$44.07</li><li>$152.4</li><li>$9,162.58</li><li>$576</li><li>$2,915.91</li><li>$5,166.72</li><li>$3,435.6</li><li>$5,355.6</li><li>$360.8</li><li>$633.72</li><li>$170.03</li><li>$291.54</li><li>$6,959.95</li><li>$72.9</li><li>$461.67</li><li>$1,071.48</li><li>$243.48</li><li>$94.5</li><li>$467.33</li><li>$94.14</li><li>$1,400</li><li>$1,837.8</li><li>$314.5</li><li>$83.03</li><li>$7,650</li><li>$4,373.46</li><li>$3,904.1</li><li>$46.96</li><li>$129.56</li><li>$145.78</li><li>$10.96</li><li>$20,249.9</li><li>$803.01</li><li>$59.93</li><li>$11,780.46</li><li>$298.06</li><li>$2,274.24</li><li>$2,753.98</li><li>$328.05</li><li>$45.6</li><li>$202.33</li><li>$87.4</li><li>$288</li><li>$198.8</li><li>$3,123.28</li><li>$82.08</li><li>$430.92</li><li>$2,033.94</li><li>$196.8</li><li>$981.65</li><li>$209.9</li><li>$99.37</li><li>$513</li><li>$2,576.7</li><li>$4.11</li><li>$505.12</li><li>$971.97</li><li>$939.6</li><li>$100.95</li><li>$41.52</li><li>$316.86</li><li>$4,293.92</li><li>$392.66</li><li>$436.9</li><li>$1,529.15</li><li>$1,618.64</li><li>$218.61</li><li>$2,860.89</li><li>$3,887.94</li><li>$350.79</li><li>$118.56</li><li>$421.16</li><li>$107.97</li><li>$339</li><li>$13,350.82</li><li>$11,728.08</li><li>$910</li><li>$218.7</li><li>$65.98</li><li>$264.36</li><li>$475.04</li><li>$6,440.88</li><li>$330.46</li><li>$227.9</li><li>$6,698.43</li><li>$452</li><li>$32.54</li><li>$2,770.14</li><li>$501.36</li><li>$1,267.44</li><li>$368.22</li><li>$447.09</li><li>$72.16</li><li>$9,835.68</li><li>$6,549.6</li><li>$17.1</li><li>$156.2</li><li>$551</li><li>$540.32</li><li>$698.6</li><li>$84.98</li><li>$178.58</li><li>$1,955.91</li><li>$490.96</li><li>$255.6</li><li>$50.71</li><li>$1,386</li><li>$3,688.38</li><li>$80.16</li><li>$2,818.74</li><li>$405.13</li><li>$15.75</li><li>$11.99</li><li>$889</li><li>$252.64</li><li>$2,583.9</li><li>$263.92</li><li>$974.4</li><li>$329.34</li><li>$1,600.4</li><li>$71.25</li><li>$144</li><li>$210.58</li><li>$71.98</li><li>$478.39</li><li>$608.86</li><li>$1,200.52</li><li>$16,147.08</li><li>$4.77</li><li>$9.59</li><li>$765.6</li><li>$4,697.9</li><li>$3,563.28</li><li>$1,130</li><li>$9,281.25</li><li>$67.54</li><li>$113.04</li><li>$449.61</li><li>$4,818.8</li><li>$469.79</li><li>$8,455.32</li><li>$4,416.9</li><li>$4,228.11</li><li>$1,085</li><li>$6,478.08</li><li>$40.38</li><li>$82.95</li><li>$1,258.38</li><li>$3,231.83</li><li>$991.34</li><li>$657.58</li><li>$24.28</li><li>$548.9</li><li>$41.98</li><li>$2,977.08</li><li>$1,341.27</li><li>$445.35</li><li>$919.7</li><li>$267.75</li><li>$74.5</li><li>$29.9</li><li>$628.74</li><li>$713.8</li><li>$2,458.92</li><li>$494</li><li>$8,182.16</li><li>$37.73</li><li>$364.5</li><li>$437.34</li><li>$6,246.56</li><li>$749.35</li><li>$1,471.52</li><li>$485.91</li><li>$121.4</li><li>$376.26</li><li>$15,973.08</li><li>$333</li><li>$23.98</li><li>$1,800.78</li><li>$4,048.8</li><li>$577.35</li><li>$1,122</li><li>$722.59</li><li>$3,644.55</li><li>$3,006.54</li><li>$1,740</li><li>$6,124.35</li><li>$593.8</li><li>$438.69</li><li>$23.85</li><li>$48.59</li><li>$7,873.11</li><li>$134.97</li><li>$1,946.7</li><li>$894.18</li><li>$53.99</li><li>$552.33</li><li>$2,818.8</li><li>$659.84</li><li>$3,758.28</li><li>$274.45</li><li>$412.35</li><li>$1,749.58</li><li>$32.39</li><li>$202.62</li><li>$18,933.6</li><li>$59.98</li><li>$161.95</li><li>$170.4</li><li>$1,192.24</li><li>$2,485.7</li><li>$98.91</li><li>$2,186.73</li><li>$149.68</li><li>$31.5</li><li>$1,846.76</li><li>$245.48</li><li>$1,409.4</li><li>$3,117.87</li><li>$3,728.55</li><li>$224.95</li><li>$8,351.94</li><li>$390.32</li><li>$315.9</li><li>$65.13</li><li>$1,400.35</li><li>$3,288.46</li><li>$665</li><li>$367.88</li><li>$43.84</li><li>$10,852.27</li><li>$8,151.78</li><li>$12,825.41</li><li>$150.26</li><li>$3,032.32</li><li>$283.24</li><li>$94.74</li><li>$877.94</li><li>$315.87</li><li>$10.78</li><li>$2,944.6</li><li>$126</li><li>$141.3</li><li>$11,838.84</li><li>$2,818.68</li><li>$16,905</li><li>$24.29</li><li>$4,865.76</li><li>$242.46</li><li>$222.9</li><li>$843.9</li><li>$1,344.58</li><li>$7,289.1</li><li>$266.79</li><li>$364.45</li><li>$288.6</li><li>$4,398.03</li><li>$2,427.36</li><li>$74.29</li><li>$90.25</li><li>$5,062.5</li><li>$534.42</li><li>$744.27</li><li>$971.96</li><li>$251.93</li><li>$1,943.92</li><li>$5.48</li><li>$189</li><li>$939.58</li><li>$106.88</li><li>$115.36</li><li>$107.91</li><li>$23,489.88</li><li>$653.18</li><li>$60.28</li><li>$72</li><li>$7,457.1</li><li>$9,638.93</li><li>$114.3</li><li>$2,936.22</li><li>$167.92</li><li>$1,700</li><li>$2,016.87</li><li>$950.58</li><li>$71.94</li><li>$849.72</li><li>$565</li><li>$439.52</li><li>$1,274.58</li><li>$3,614.1</li><li>$1,943.97</li><li>$1,320</li><li>$480.47</li><li>$153.89</li><li>$253.63</li><li>$216</li><li>$12,699.45</li><li>$60.7</li><li>$2,271.15</li><li>$4,535.93</li><li>$76</li><li>$119.9</li><li>$269.12</li><li>$3,680.75</li><li>$235.48</li><li>$485.98</li><li>$15,904.18</li><li>$904.8</li><li>$920.75</li><li>$164.67</li><li>$14,174.93</li><li>$209.95</li><li>$5,954.16</li><li>$274.7</li><li>$2,186.91</li><li>$10,489.93</li><li>$1,694.95</li><li>$35.97</li><li>$251.94</li><li>$3,758.32</li><li>$632.27</li><li>$10,262.07</li><li>$48.58</li><li>$53.9</li><li>$5,676.72</li><li>$66.12</li><li>$431.92</li><li>$6,987.24</li><li>$218.67</li><li>$501.68</li><li>$57.68</li><li>$1,297.8</li><li>$34.2</li><li>$89.98</li><li>$72.87</li><li>$4,250</li><li>$250.84</li><li>$14,261.76</li><li>$3,274.8</li><li>$5.19</li><li>$240.48</li><li>$5,465.74</li><li>$539.9</li><li>$62.97</li><li>$14,304.4</li><li>$20,581.88</li><li>$2,855.2</li><li>$141.62</li><li>$209.93</li><li>$31.58</li><li>$414.57</li><li>$1,155</li><li>$149.95</li><li>$186.25</li><li>$655.92</li><li>$654.33</li><li>$5,567.96</li><li>$14.69</li><li>$98.97</li><li>$574.09</li><li>$109.78</li><li>$900.65</li><li>$11,443.52</li><li>$33.64</li><li>$17,175.68</li><li>$1,644.3</li><li>$1,011.65</li><li>$2,277.36</li><li>$791.84</li><li>$135.08</li><li>$148.6</li><li>$407.03</li><li>$69.92</li><li>$194.32</li><li>$2,039.99</li><li>$306.68</li><li>$2,097.3</li><li>$3,375</li><li>$437.28</li><li>$17,775.26</li><li>$26.72</li><li>$145.76</li><li>$144.32</li><li>$242.99</li><li>$704.7</li><li>$21.56</li><li>$164.36</li><li>$5,402.34</li><li>$1,198.96</li><li>$284.22</li><li>$5.39</li><li>$194.34</li><li>$1,043.21</li><li>$1,260.91</li><li>$291.6</li><li>$7,144.13</li><li>$10,205.9</li><li>$9,536.3</li><li>$27,536.04</li><li>$1,229.46</li><li>$6,884.95</li><li>$803.39</li><li>$1,254</li><li>$2,208.45</li><li>$2,342.46</li><li>$423.04</li><li>$239.92</li><li>$613.7</li><li>$14,660.1</li><li>$15,183.72</li><li>$4,465.62</li><li>$475.92</li><li>$8,261.94</li><li>$191.7</li><li>$25,515</li><li>$27.65</li><li>$23,663.88</li><li>$424.86</li><li>$360.26</li><li>$14,279.93</li><li>$60.57</li><li>$2,336.58</li><li>$20.76</li><li>$38.16</li><li>$196.33</li><li>$11.96</li><li>$598.72</li><li>$1,807.05</li><li>$157.5</li><li>$1,336.24</li><li>$2,114.1</li><li>$20,979.84</li><li>$20,026.23</li><li>$647.98</li><li>$10,734.8</li><li>$6,890.24</li><li>$288.64</li><li>$113</li><li>$3,288.6</li><li>$1,863.4</li><li>$211.32</li><li>$288.4</li><li>$4,971.4</li><li>$105</li><li>$396.91</li><li>$168.2</li><li>$10.38</li><li>$688.45</li><li>$4,218.75</li><li>$381</li><li>$1,012.68</li><li>$1,680</li><li>$26.91</li><li>$51.9</li><li>$8,123.5</li><li>$102.6</li><li>$7,320.88</li><li>$269.95</li><li>$1,250.06</li><li>$207.2</li><li>$771.29</li><li>$291.56</li><li>$1,385.07</li><li>$4,342.78</li><li>$24,913.56</li><li>$623.49</li><li>$298</li><li>$39.9</li><li>$291.51</li><li>$1,214.95</li><li>$1,429.4</li><li>$335.92</li><li>$131.2</li><li>$4,071.47</li><li>$161.97</li><li>$2,024.99</li><li>$792.16</li><li>$1,637.4</li><li>$8.97</li><li>$599.48</li><li>$110.6</li><li>$511.2</li><li>$12,873.96</li><li>$514.08</li><li>$22.8</li><li>$678</li><li>$792.15</li><li>$14,417.04</li><li>$678.47</li><li>$404.04</li><li>$2,347.08</li><li>$627</li><li>$1,143</li><li>$2.74</li><li>$3,499.16</li><li>$47.7</li><li>$152</li><li>$160.32</li><li>$13,918.41</li><li>$150.67</li><li>$127.8</li><li>$52.65</li><li>$161.52</li><li>$11,015.92</li><li>$2,372.93</li><li>$1,883.34</li><li>$2,595.6</li><li>$6,119.97</li><li>$1,177.98</li><li>$72.88</li><li>$42.39</li><li>$10,124.95</li><li>$77.14</li><li>$510.23</li><li>$1,092.25</li><li>$6,800</li><li>$8,164.72</li><li>$2,004.36</li><li>$286.39</li><li>$565.37</li><li>$846.78</li><li>$418.52</li><li>$140.88</li><li>$1,109.01</li><li>$646</li><li>$2,338.42</li><li>$309.96</li><li>$745.15</li><li>$733.53</li><li>$1,391.99</li><li>$752.4</li><li>$15,210.36</li><li>$76.2</li><li>$809.32</li><li>$150</li><li>$209.26</li><li>$1,132.96</li><li>$65</li><li>$181.71</li><li>$110.25</li><li>$1,204.7</li><li>$117.4</li><li>$48.56</li><li>$4,294.5</li><li>$8,448.44</li><li>$1,717.8</li><li>$1,386.28</li><li>$689.78</li><li>$125.42</li><li>$504</li><li>$2,745.21</li><li>$4,460.28</li><li>$1,295.98</li><li>$28.26</li><li>$850</li><li>$16.27</li><li>$242.95</li><li>$7,593.75</li><li>$374.2</li><li>$105.3</li><li>$3,569</li><li>$41.99</li><li>$4,335.54</li><li>$731.31</li><li>$46.58</li><li>$735.76</li><li>$5,235.76</li><li>$391.8</li><li>$8,612.8</li><li>$177.86</li><li>$35.99</li><li>$1,374.31</li><li>$459.2</li><li>$6,750</li><li>$4,155.21</li><li>$13,215.62</li><li>$223.19</li><li>$438.34</li><li>$444</li><li>$120.29</li><li>$351.5</li><li>$1,445.18</li><li>$8,437.5</li><li>$362.25</li><li>$564.11</li><li>$825.5</li><li>$113.62</li><li>$1,990.95</li><li>$9,043.44</li><li>$6,479.9</li><li>$730.66</li><li>$83.96</li><li>$1,416.31</li><li>$43.12</li><li>$400.1</li><li>$121.45</li><li>$2,516.76</li><li>$93.92</li><li>$5.7</li><li>$1,655.46</li><li>$18,224.91</li><li>$277.5</li><li>$3,993.3</li><li>$115.06</li><li>$583.66</li><li>$269.91</li><li>$1,784.5</li><li>$4,907.4</li><li>$36.45</li><li>$89.97</li><li>$215.96</li><li>$8,699.95</li><li>$2,141.4</li><li>$15,258.08</li><li>$1,963.3</li><li>$3,484.22</li><li>$378</li><li>$40.46</li><li>$521.88</li><li>$121.14</li><li>$272.4</li><li>$7,349.22</li><li>$2,550</li><li>$9.54</li><li>$405.24</li><li>$215.52</li><li>$109.26</li><li>$668.12</li><li>$125.97</li><li>$111.45</li><li>$2,689.16</li><li>$4,008.69</li><li>$793.75</li><li>$11,185.65</li><li>$6,544.7</li><li>$122.74</li><li>$179.94</li><li>$1,287.58</li><li>$2,624.37</li><li>$1,619.95</li><li>$1,330</li><li>$30</li><li>$1,242.85</li><li>$1,348.83</li><li>$78.75</li><li>$1,488.54</li><li>$2,617.88</li><li>$8,099.96</li><li>$141.75</li><li>$648</li><li>$25.95</li><li>$234.12</li><li>$1,188</li><li>$127.17</li><li>$338.99</li><li>$213.76</li><li>$149.03</li><li>$1,416.2</li><li>$191.24</li><li>$14,033.1</li><li>$4,858.56</li><li>$1,700.93</li><li>$14.13</li><li>$4,684.92</li><li>$37.25</li><li>$768.96</li><li>$64.54</li><li>$615.56</li><li>$100.92</li><li>$12.14</li><li>$287.92</li><li>$60.12</li><li>$449.48</li><li>$858.9</li><li>$29.38</li><li>$4,373.95</li><li>$502.74</li><li>$626.28</li><li>$182.25</li><li>$2.99</li><li>$523.95</li><li>$179.96</li><li>$190.5</li><li>$187.04</li><li>$194.36</li><li>$720</li><li>$57.31</li><li>$606.99</li><li>$375.72</li><li>$41.1</li><li>$2,151.49</li><li>$359.92</li><li>$26.95</li><li>$133.6</li><li>$1,355.96</li><li>$360</li><li>$183.94</li><li>$198.04</li><li>$16,319.92</li><li>$3,061.77</li><li>$234.8</li><li>$1,016.97</li><li>$923.34</li><li>$78.45</li><li>$63</li><li>$67.73</li><li>$158.43</li><li>$672.29</li><li>$323.99</li><li>$16,638.72</li><li>$22.79</li><li>$550.76</li><li>$364.4</li><li>$5,721.78</li><li>$6,123.53</li><li>$327.08</li><li>$53.44</li><li>$873.8</li><li>$1,907.26</li><li>$2,860.88</li><li>$88.92</li><li>$6,459.6</li><li>$532</li><li>$14.95</li><li>$275.38</li><li>$3,612.95</li><li>$135</li><li>$260.75</li><li>$88.14</li><li>$1,570.64</li><li>$8,803.84</li><li>$255.15</li><li>$37.57</li><li>$214.61</li><li>$19.08</li><li>$549.8</li><li>$945</li><li>$263.77</li><li>$323.94</li><li>$13.7</li><li>$8,796.06</li><li>$79.04</li><li>$95.92</li><li>$299.36</li><li>$12,881.76</li><li>$226.73</li><li>$384.23</li><li>$675</li><li>$494.82</li><li>$1,425.87</li><li>$29.99</li><li>$1,002.18</li><li>$4,995.43</li><li>$4,201.82</li><li>$12,294.6</li><li>$54.89</li><li>$808.29</li><li>$800.2</li><li>$31.79</li><li>$159.53</li><li>$432.96</li><li>$230.93</li><li>$145.74</li><li>$9,864.54</li><li>$5,271.24</li><li>$4,079.98</li><li>$328</li><li>$7,798.56</li><li>$843.75</li><li>$6,625.35</li><li>$824.8</li><li>$136.74</li><li>$6,998.32</li><li>$13,769.9</li><li>$429.59</li><li>$97.16</li><li>$4,909.3</li><li>$445.41</li><li>$838.32</li><li>$7,750.71</li><li>$5,668.32</li><li>$2,227.05</li><li>$376.02</li><li>$291.52</li><li>$5,102.95</li><li>$2,092.6</li><li>$7,376.76</li><li>$83.93</li><li>$48.51</li><li>$13,089.4</li><li>$3,758.4</li><li>$108.68</li><li>$1,295.96</li><li>$1,255.56</li><li>$262.4</li><li>$21,691.83</li><li>$61.37</li><li>$504.73</li><li>$1,584</li><li>$768.46</li><li>$2,127.18</li><li>$297.2</li><li>$2,184.5</li><li>$6,382.75</li><li>$63.16</li><li>$5,378.32</li><li>$15,588.54</li><li>$220.5</li><li>$56.52</li><li>$1,103.64</li><li>$2,167.77</li><li>$8,159.96</li><li>$5,449.56</li><li>$892.9</li><li>$346.32</li><li>$404.66</li><li>$36.42</li><li>$3,239.04</li><li>$4,093.5</li><li>$28.62</li><li>$109.25</li><li>$1,879.2</li><li>$259.12</li><li>$90</li><li>$7,629.04</li><li>$1,677.84</li><li>$600.26</li><li>$6.85</li><li>$329.9</li><li>$701.08</li><li>$4,463.1</li><li>$555.24</li><li>$62.52</li><li>$307.78</li><li>$417.48</li><li>$203</li><li>$16.82</li><li>$1.37</li><li>$70.65</li><li>$728.97</li><li>$3,400</li><li>$215.94</li><li>$5,864.04</li><li>$413.07</li><li>$5,248.74</li><li>$3,340.6</li><li>$143.96</li><li>$16,593.12</li><li>$163.92</li><li>$97.17</li><li>$15.96</li><li>$173.04</li><li>$12,149.94</li><li>$1,056</li><li>$396.6</li><li>$741</li><li>$1,016</li><li>$6,147.3</li><li>$610.61</li><li>$6,002.6</li><li>$2,429.9</li><li>$4,736.16</li><li>$4,454.85</li><li>$4,130.97</li><li>$103.74</li><li>$182.32</li><li>$4,802.08</li><li>$4,676.84</li><li>$5,950</li><li>$4,751.84</li><li>$677.98</li><li>$98.8</li><li>$382.68</li><li>$515.62</li><li>$228.6</li><li>$1,120</li><li>$1,464.82</li><li>$73.45</li><li>$330.75</li><li>$146.9</li><li>$74.1</li><li>$50.46</li><li>$315</li><li>$809.76</li><li>$218.64</li><li>$3,288.53</li><li>$269.94</li><li>$55.3</li><li>$200.05</li><li>$4,049.98</li><li>$226</li><li>$2,144.1</li><li>$2,672.46</li><li>$6,050.61</li><li>$728.9</li><li>$187.84</li><li>$1,080.78</li><li>$102.83</li><li>$5,730.9</li><li>$1,466.01</li><li>$2,890.36</li><li>$318.89</li><li>$17,975.88</li><li>$478.79</li><li>$593.81</li><li>$13,811.98</li><li>$159.5</li><li>$6,074.97</li><li>$7,152.2</li><li>$1,376.9</li><li>$299.74</li><li>$692.82</li><li>$313.35</li><li>$221.06</li><li>$527.84</li><li>$711.96</li><li>$830.62</li><li>$558.88</li><li>$648.9</li><li>$368.55</li><li>$185.02</li><li>$65.76</li><li>$306.85</li><li>$604.78</li><li>$568.26</li><li>$2,401.04</li><li>$42.93</li><li>$2,429.28</li><li>$2,858.8</li><li>$201.88</li><li>$224.52</li><li>$382.69</li><li>$6,357.82</li><li>$3,239.9</li><li>$439.84</li><li>$2,531.25</li><li>$1,619.52</li><li>$1,561.64</li><li>$1,020.59</li><li>$7,569.51</li><li>$9,938.7</li><li>$5,721.76</li><li>$184.11</li><li>$2,915.64</li><li>$75</li><li>$4,917.84</li><li>$81.35</li><li>$3,573.5</li><li>$84.78</li><li>$8,582.67</li><li>$376.87</li><li>$7,751.52</li><li>$125.94</li><li>$101.31</li><li>$714.7</li><li>$602.35</li><li>$449.9</li><li>$68.37</li><li>$12,239.94</li><li>$236.39</li><li>$963.83</li><li>$357.16</li><li>$783.56</li><li>$72.84</li><li>$12,392.91</li><li>$769.8</li><li>$4,291.32</li><li>$2,920.05</li><li>$2,932.02</li><li>$3,601.56</li><li>$16,199.92</li><li>$472.78</li><li>$284.06</li><li>$33.39</li><li>$151.38</li><li>$457.99</li><li>$104.95</li><li>$109.83</li><li>$4,216.45</li><li>$184.6</li><li>$113.95</li><li>$21,458.08</li><li>$459.58</li><li>$126.32</li><li>$1,584.3</li><li>$65.08</li><li>$129.14</li><li>$10,690.72</li><li>$3,001.3</li><li>$1,049.09</li><li>$615.84</li><li>$3,523.5</li><li>$10,013.08</li><li>$269.4</li><li>$973.35</li><li>$8,587.84</li><li>$437.31</li><li>$1,516.16</li><li>$296.91</li><li>$44.99</li><li>$441.96</li><li>$284.13</li><li>$36.33</li><li>$293.93</li><li>$5,153.05</li><li>$28.84</li><li>$105.29</li><li>$4,912.2</li><li>$4,616.9</li><li>$72.94</li><li>$1,966.05</li><li>$201.9</li><li>$5,507.96</li><li>$2,308.45</li><li>$145.8</li><li>$3,814.52</li><li>$1,174.5</li><li>$769.45</li><li>$1,213.98</li><li>$5,153.4</li><li>$1,000.25</li><li>$679.47</li><li>$604.8</li><li>$308.42</li><li>$5,100</li><li>$242.33</li><li>$107.98</li><li>$1,070.7</li><li>$61.56</li><li>$46.71</li><li>$600.15</li><li>$334.06</li><li>$899.22</li><li>$371.5</li><li>$2,409.4</li><li>$439.12</li><li>$132.21</li><li>$12,428.5</li><li>$485.9</li><li>$642.72</li><li>$362.44</li><li>$5,903.69</li><li>$10,147.56</li><li>$2,699.55</li><li>$11,443.56</li><li>$885.27</li><li>$304.8</li><li>$1,336.23</li><li>$27,607.86</li><li>$583.12</li><li>$246.05</li><li>$17.94</li><li>$123.5</li><li>$4,454.1</li><li>$647.99</li><li>$627.1</li><li>$157.9</li><li>$12,397.19</li><li>$236.25</li><li>$1,376.99</li><li>$137.69</li><li>$404.91</li><li>$6,214.25</li><li>$1,046.3</li><li>$234.9</li><li>$131.96</li><li>$419.9</li><li>$446.49</li><li>$452.27</li><li>$17,304.17</li><li>$111.75</li><li>$54.8</li><li>$55.11</li><li>$109.88</li><li>$785.32</li><li>$10,993.19</li><li>$127.49</li><li>$72.89</li><li>$1,879.16</li><li>$1,584.32</li><li>$627.78</li><li>$14.31</li><li>$4,082.36</li><li>$149</li><li>$5,906.25</li><li>$510.16</li><li>$639</li><li>$13,073.28</li><li>$273.14</li><li>$8,747.9</li><li>$355.72</li><li>$2,041.18</li><li>$314.93</li><li>$2,232.81</li><li>$594.12</li><li>$8,582.64</li><li>$608</li><li>$121.5</li><li>$875</li><li>$167.96</li><li>$65.6</li><li>$97.62</li><li>$3,053.7</li><li>$145.77</li><li>$388.5</li><li>$5,421.15</li><li>$6,012.3</li><li>$41.04</li><li>$109.35</li><li>$923.38</li><li>$58.76</li><li>$57</li><li>$223.5</li><li>$1,472.3</li><li>$1,188.24</li><li>$230.72</li><li>$11,135.92</li><li>$3,721.35</li><li>$838.92</li><li>$6,023.5</li><li>$91.16</li><li>$874.79</li><li>$631.74</li><li>$1,766.97</li><li>$45</li><li>$23.92</li><li>$1,670.3</li><li>$1,800.45</li><li>$6,123.54</li><li>$1,943.94</li><li>$149.87</li><li>$383.4</li><li>$334.56</li><li>$14,304.45</li><li>$5.98</li><li>$453.6</li><li>$742.32</li><li>$13,194.09</li><li>$590.4</li><li>$28.5</li><li>$228.99</li><li>$3,775.14</li><li>$469.8</li><li>$23,602.32</li><li>$7,853.64</li><li>$70.14</li><li>$63.9</li><li>$219.76</li><li>$144.2</li><li>$38.1</li><li>$2,348.95</li><li>$444.65</li><li>$1,622.25</li><li>$4,033.74</li><li>$1,200.3</li><li>$826.14</li><li>$4,288.2</li><li>$18,359.91</li><li>$15,618.46</li><li>$417.8</li><li>$428.48</li><li>$45.58</li><li>$487.06</li><li>$535.74</li><li>$8,606.22</li><li>$20,399.9</li><li>$13,919.9</li><li>$214.24</li><li>$522.31</li><li>$347.88</li><li>$323.9</li><li>$263.25</li><li>$205.11</li><li>$252</li><li>$141.33</li><li>$32.99</li><li>$157.95</li><li>$134.56</li><li>$1,050</li><li>$8,187</li><li>$9,743.93</li><li>$11,065.14</li><li>$54.94</li><li>$540.39</li><li>$432</li><li>$1,782.36</li><li>$334.35</li><li>$3,674.66</li><li>$249.7</li><li>$329.64</li><li>$2,831.92</li><li>$736.15</li><li>$117.52</li><li>$663.67</li><li>$2,267.93</li><li>$20,157.6</li><li>$14,968.64</li><li>$4,768.15</li><li>$1,430.44</li><li>$837.04</li><li>$2,591.92</li><li>$15</li><li>$344.41</li><li>$5,831.91</li><li>$2,146.96</li><li>$67.28</li><li>$168.85</li><li>$342.9</li><li>$20.99</li><li>$990.2</li><li>$3,244.5</li><li>$2,591.96</li><li>$270.16</li><li>$7,330.05</li><li>$10,199.95</li><li>$1,674.08</li><li>$174</li><li>$55.32</li><li>$173.03</li><li>$660.92</li><li>$100.51</li><li>$64.78</li><li>$655.35</li><li>$636.72</li><li>$475</li><li>$25,447.37</li><li>$3,011.75</li><li>$74.84</li><li>$2,672.48</li><li>$3,693.52</li><li>$6,236.79</li><li>$15.57</li><li>$9,185.31</li><li>$60</li><li>$202.05</li><li>$487.08</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>1413</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0244</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>$419.46</td>
        <td>789</td>
    </tr>
    <tr>
        <td>$939.58</td>
        <td>665</td>
    </tr>
    <tr>
        <td>$838.92</td>
        <td>657</td>
    </tr>
    <tr>
        <td>$469.79</td>
        <td>639</td>
    </tr>
    <tr>
        <td>$1,409.37</td>
        <td>596</td>
    </tr>
    <tr>
        <td>$323.99</td>
        <td>462</td>
    </tr>
    <tr>
        <td>$445.41</td>
        <td>431</td>
    </tr>
    <tr>
        <td>$1,430.44</td>
        <td>411</td>
    </tr>
    <tr>
        <td>$183.94</td>
        <td>401</td>
    </tr>
    <tr>
        <td>$647.98</td>
        <td>374</td>
    </tr>
    <tr>
        <td>$1,879.16</td>
        <td>369</td>
    </tr>
    <tr>
        <td>$1,466.01</td>
        <td>355</td>
    </tr>
    <tr>
        <td>$202.33</td>
        <td>349</td>
    </tr>
    <tr>
        <td>$1,258.38</td>
        <td>345</td>
    </tr>
    <tr>
        <td>$2,932.02</td>
        <td>344</td>
    </tr>
    <tr>
        <td>$2,860.88</td>
        <td>342</td>
    </tr>
    <tr>
        <td>$57.68</td>
        <td>329</td>
    </tr>
    <tr>
        <td>$874.79</td>
        <td>328</td>
    </tr>
    <tr>
        <td>$40.38</td>
        <td>321</td>
    </tr>
    <tr>
        <td>$890.82</td>
        <td>312</td>
    </tr>
    <tr>
        <td>$1,050</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,782.36</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$249.7</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$20,157.6</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$173.03</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$100.51</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$636.72</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$475</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$25,447.37</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$6,236.79</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Sales-Cost"></a><a href="#column-Sales-Cost">**Cost**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>57851</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>$413.15</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9972</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9972</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>424344</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.3351</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.6577</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.2875</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.1432</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.8986</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.8</li><li>3.6</li><li>4.4</li><li>5.2</li><li>6.0</li><li>6.800000000000001</li><li>7.6000000000000005</li><li>8.4</li><li>9.2</li><li>10.0</li></ul>bin_counts: <ul><li>13</li><li>131</li><li>118</li><li>1718</li><li>14791</li><li>0</li><li>21308</li><li>1548</li><li>17663</li><li>561</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.01: 7.02: 9.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>6</li><li>0</li><li>,</li><li>8</li><li>$</li><li>9</li><li>7</li><li>2</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>$497.35</li><li>$35.96</li><li>$399.7</li><li>$154.67</li><li>$2,245.89</li><li>$49.49</li><li>$106.8</li><li>$179.82</li><li>$826.3</li><li>$544.47</li><li>$7,648.62</li><li>$6,707.14</li><li>$5,173.29</li><li>$155.42</li><li>$83.27</li><li>$53.94</li><li>$61.87</li><li>$942.48</li><li>$1,178.32</li><li>$186.98</li><li>$83.07</li><li>$133.3</li><li>$15,023.78</li><li>$2,393.74</li><li>$290.57</li><li>$289.19</li><li>$713.26</li><li>$7.47</li><li>$6,017.44</li><li>$299.87</li><li>$431.52</li><li>$52.35</li><li>$1,162.27</li><li>$6.79</li><li>$110.28</li><li>$692.86</li><li>$885.32</li><li>$247.43</li><li>$161.82</li><li>$623.84</li><li>$547.14</li><li>$54.96</li><li>$3,248.49</li><li>$363.33</li><li>$261.76</li><li>$28,156.82</li><li>$7,779.66</li><li>$205.66</li><li>$1,047.95</li><li>$54.99</li><li>$134.64</li><li>$956.16</li><li>$590.42</li><li>$5,287.31</li><li>$399.89</li><li>$235.55</li><li>$313.42</li><li>$467.51</li><li>$181.67</li><li>$4,471.42</li><li>$4.28</li><li>$20.38</li><li>$13,206.84</li><li>$8.57</li><li>$13,921.81</li><li>$2,120.43</li><li>$362.97</li><li>$528.6</li><li>$377.59</li><li>$10,616.5</li><li>$29.86</li><li>$8,846.48</li><li>$9,112.72</li><li>$209.41</li><li>$371.21</li><li>$7,472</li><li>$47.57</li><li>$1,618.34</li><li>$3,691.56</li><li>$654.37</li><li>$668.18</li><li>$17.97</li><li>$204.63</li><li>$104.8</li><li>$81.86</li><li>$1,554.95</li><li>$8,891.63</li><li>$706.81</li><li>$324.97</li><li>$499.58</li><li>$64.12</li><li>$433.07</li><li>$20.57</li><li>$5,694.27</li><li>$26.15</li><li>$65.97</li><li>$2,517.42</li><li>$155.84</li><li>$11,886.15</li><li>$317.92</li><li>$72.17</li><li>$1,408.56</li><li>$907.43</li><li>$2,112.84</li><li>$157.04</li><li>$1,077.12</li><li>$1,073.23</li><li>$538.56</li><li>$665.16</li><li>$311.67</li><li>$3,028.25</li><li>$111.36</li><li>$146.55</li><li>$10,631.5</li><li>$5,948.23</li><li>$1,701.43</li><li>$854.96</li><li>$5,736.46</li><li>$1,310.1</li><li>$16,706.65</li><li>$3,037.57</li><li>$156.71</li><li>$331</li><li>$145.28</li><li>$190.35</li><li>$263.24</li><li>$7,551.51</li><li>$2,024.31</li><li>$2,518.67</li><li>$3,901.54</li><li>$2,495.36</li><li>$7,843.88</li><li>$1,816.95</li><li>$509.47</li><li>$11,390.58</li><li>$109.7</li><li>$8.99</li><li>$1,497.26</li><li>$142.49</li><li>$661.7</li><li>$837.64</li><li>$371.64</li><li>$81.24</li><li>$27.69</li><li>$1,023.13</li><li>$124.9</li><li>$143.95</li><li>$4,467.44</li><li>$569.98</li><li>$3,962.05</li><li>$611.36</li><li>$125.85</li><li>$1,307.55</li><li>$4,957.76</li><li>$13.09</li><li>$247.46</li><li>$95.16</li><li>$5,883.27</li><li>$334.09</li><li>$30.94</li><li>$14,532.13</li><li>$1,232.87</li><li>$4,434.25</li><li>$71.91</li><li>$6,603.42</li><li>$2,887.54</li><li>$8,479.09</li><li>$1,016.98</li><li>$34.76</li><li>$427.48</li><li>$72.25</li><li>$799.41</li><li>$40.93</li><li>$53.92</li><li>$143.82</li><li>$73.27</li><li>$47.29</li><li>$371.23</li><li>$23,711.01</li><li>$98.85</li><li>$23.37</li><li>$183.21</li><li>$26,674.88</li><li>$517.14</li><li>$438.79</li><li>$1,531.29</li><li>$5,450.84</li><li>$17,320.16</li><li>$267</li><li>$107.86</li><li>$419.78</li><li>$10.31</li><li>$1,541.09</li><li>$5.71</li><li>$78.11</li><li>$26.97</li><li>$157.06</li><li>$11.2</li><li>$12,439.58</li><li>$4,278.48</li><li>$192.98</li><li>$237.49</li><li>$13,414.27</li><li>$20.53</li><li>$628.23</li><li>$185.1</li><li>$1,637</li><li>$2,641.37</li><li>$187.16</li><li>$7,924.1</li><li>$2,773.96</li><li>$9,270.04</li><li>$89.87</li><li>$179.78</li><li>$587.73</li><li>$27.48</li><li>$20.77</li><li>$17.98</li><li>$65.43</li><li>$3,610.46</li><li>$216.53</li><li>$329.91</li><li>$208.17</li><li>$618.67</li><li>$1,082.83</li><li>$654.41</li><li>$2,265.45</li><li>$15.67</li><li>$1,798.67</li><li>$1,760.7</li><li>$263.69</li><li>$38.96</li><li>$1,478.08</li><li>$97.15</li><li>$215.71</li><li>$1,737.27</li><li>$1,307.39</li><li>$900.36</li><li>$48.11</li><li>$10,884.64</li><li>$4,575.88</li><li>$13,286.66</li><li>$108.68</li><li>$3,797.19</li><li>$13.84</li><li>$116.32</li><li>$31.72</li><li>$80.88</li><li>$1,718.25</li><li>$13.06</li><li>$130.86</li><li>$13.45</li><li>$378.05</li><li>$5.23</li><li>$222.73</li><li>$2,422.6</li><li>$166.29</li><li>$418.82</li><li>$831.45</li><li>$1,300.74</li><li>$996.88</li><li>$8,763.87</li><li>$487.46</li><li>$4,626.4</li><li>$130.88</li><li>$3,358.23</li><li>$48.46</li><li>$546.23</li><li>$593.73</li><li>$4,189.05</li><li>$863.82</li><li>$100.75</li><li>$153.97</li><li>$40.66</li><li>$5,415.69</li><li>$116.88</li><li>$4,813.95</li><li>$36.08</li><li>$3,304.57</li><li>$343.65</li><li>$2.57</li><li>$144.59</li><li>$340.27</li><li>$6,460.23</li><li>$5,370.9</li><li>$69.39</li><li>$2,992.18</li><li>$494.93</li><li>$92.8</li><li>$172.38</li><li>$266.59</li><li>$1,472.9</li><li>$19.78</li><li>$162.63</li><li>$5,529.05</li><li>$20,031.7</li><li>$179.52</li><li>$569.41</li><li>$131.62</li><li>$485.35</li><li>$15,187.43</li><li>$174.95</li><li>$73.22</li><li>$51.35</li><li>$507.59</li><li>$197.43</li><li>$97.09</li><li>$6,328.1</li><li>$6.72</li><li>$378.29</li><li>$852.72</li><li>$45.64</li><li>$8.25</li><li>$48.12</li><li>$340.29</li><li>$40.35</li><li>$467.47</li><li>$3,538.83</li><li>$273.57</li><li>$74.98</li><li>$634.14</li><li>$18.32</li><li>$29.14</li><li>$4,445.81</li><li>$9.33</li><li>$8,859.34</li><li>$50.43</li><li>$94.03</li><li>$164.87</li><li>$291.01</li><li>$5,498.39</li><li>$138.45</li><li>$407.57</li><li>$593.93</li><li>$61.88</li><li>$747.97</li><li>$139.03</li><li>$219.94</li><li>$294.58</li><li>$149.94</li><li>$23.54</li><li>$69.22</li><li>$3,565.4</li><li>$123.4</li><li>$600.24</li><li>$2,605.9</li><li>$1,481.94</li><li>$24.26</li><li>$789.87</li><li>$719.26</li><li>$2,062.06</li><li>$706.73</li><li>$413.15</li><li>$215.76</li><li>$818.5</li><li>$174.48</li><li>$2,198.37</li><li>$78.45</li><li>$538.89</li><li>$16.98</li><li>$5,282.74</li><li>$3,775.75</li><li>$86.89</li><li>$145.37</li><li>$1,679.11</li><li>$3,590.61</li><li>$107.84</li><li>$5,998.78</li><li>$10.19</li><li>$551.41</li><li>$15,187.86</li><li>$55.14</li><li>$494.37</li><li>$48.57</li><li>$1,426.16</li><li>$58.28</li><li>$11,388.57</li><li>$17,718.67</li><li>$2,991.87</li><li>$4,423.24</li><li>$98.88</li><li>$5,230.4</li><li>$431.53</li><li>$9,952.29</li><li>$26.76</li><li>$11,058.1</li><li>$2,889.03</li><li>$199.38</li><li>$123.73</li><li>$1,898.09</li><li>$45.42</li><li>$1,395.63</li><li>$12,150.29</li><li>$14,527.52</li><li>$272.2</li><li>$165.41</li><li>$384.9</li><li>$43.71</li><li>$589.16</li><li>$611.17</li><li>$498.73</li><li>$6,582.79</li><li>$284.99</li><li>$16,453.05</li><li>$866.14</li><li>$1,510.3</li><li>$2,405.55</li><li>$203.56</li><li>$1,486.55</li><li>$13,994.53</li><li>$6,192.96</li><li>$408.75</li><li>$30.26</li><li>$101.89</li><li>$3.36</li><li>$2,097.28</li><li>$99.36</li><li>$7,511.89</li><li>$1,258.71</li><li>$1,239.45</li><li>$124.6</li><li>$45.55</li><li>$464.04</li><li>$88.9</li><li>$410.36</li><li>$614.72</li><li>$389.59</li><li>$17,082.85</li><li>$2,229.83</li><li>$9,690.39</li><li>$360.94</li><li>$31.73</li><li>$87.24</li><li>$1,088.91</li><li>$79.1</li><li>$60.74</li><li>$194.29</li><li>$246.8</li><li>$26.18</li><li>$203.72</li><li>$3,824.31</li><li>$144.38</li><li>$3,778.01</li><li>$59.33</li><li>$53.4</li><li>$4,343.17</li><li>$360.43</li><li>$323.65</li><li>$19.43</li><li>$82.5</li><li>$27.17</li><li>$113.44</li><li>$601.74</li><li>$317.07</li><li>$316.41</li><li>$581.13</li><li>$7,216.64</li><li>$323.64</li><li>$74.33</li><li>$97.14</li><li>$166.24</li><li>$39.26</li><li>$18,779.72</li><li>$10,373.57</li><li>$95.17</li><li>$9,244.79</li><li>$419.18</li><li>$820.71</li><li>$628.32</li><li>$3,796.86</li><li>$957.5</li><li>$176.2</li><li>$660.91</li><li>$5,984.35</li><li>$149.96</li><li>$116.56</li><li>$14,072.63</li><li>$615.88</li><li>$94.14</li><li>$733.57</li><li>$2,478.88</li><li>$131.52</li><li>$71.89</li><li>$16,301.32</li><li>$525.87</li><li>$1,239.44</li><li>$329.05</li><li>$935.79</li><li>$69.51</li><li>$399.83</li><li>$20,879.04</li><li>$1,595.01</li><li>$158.21</li><li>$673.2</li><li>$3,436.5</li><li>$3,736</li><li>$1,743.4</li><li>$305.68</li><li>$259.85</li><li>$143.96</li><li>$1,257.54</li><li>$22,229.07</li><li>$10,831.39</li><li>$23,815.22</li><li>$2,235.71</li><li>$16,587.15</li><li>$138.43</li><li>$457.3</li><li>$445</li><li>$41.06</li><li>$192.45</li><li>$12,082.41</li><li>$143.83</li><li>$188.05</li><li>$21,515.53</li><li>$423.42</li><li>$41.57</li><li>$1,871.52</li><li>$373.8</li><li>$123.75</li><li>$217.53</li><li>$556.84</li><li>$15.69</li><li>$1,057.2</li><li>$6.85</li><li>$166.54</li><li>$540.44</li><li>$465.29</li><li>$89.76</li><li>$1,398.96</li><li>$111.03</li><li>$26.17</li><li>$31.38</li><li>$32.98</li><li>$126.9</li><li>$243.73</li><li>$933.07</li><li>$203.29</li><li>$6,259.91</li><li>$261.73</li><li>$3.73</li><li>$199.85</li><li>$199.95</li><li>$71.25</li><li>$732.73</li><li>$253.8</li><li>$28.53</li><li>$74.21</li><li>$47.07</li><li>$8,306.66</li><li>$582.01</li><li>$395.93</li><li>$471.17</li><li>$523.98</li><li>$50.55</li><li>$13.88</li><li>$25,192.94</li><li>$20,747.13</li><li>$22.4</li><li>$272.71</li><li>$8,219.2</li><li>$46.74</li><li>$1,500.59</li><li>$726.42</li><li>$267.36</li><li>$22,781.8</li><li>$4,212.21</li><li>$17.84</li><li>$71.92</li><li>$3,796.18</li><li>$2,827.24</li><li>$811.47</li><li>$5.95</li><li>$1,231.07</li><li>$155.71</li><li>$3,082.18</li><li>$62.91</li><li>$117.78</li><li>$3,538.84</li><li>$439.64</li><li>$78.53</li><li>$91.59</li><li>$37.12</li><li>$9,490.47</li><li>$2,165.02</li><li>$9,734.13</li><li>$207.86</li><li>$366.81</li><li>$68.39</li><li>$510.43</li><li>$1,361.14</li><li>$63.45</li><li>$6,513.88</li><li>$20.17</li><li>$243.94</li><li>$87.42</li><li>$59.47</li><li>$122.27</li><li>$549.7</li><li>$35.68</li><li>$41.23</li><li>$230.95</li><li>$374.31</li><li>$384.92</li><li>$47.01</li><li>$1,199.11</li><li>$3,406.95</li><li>$132.31</li><li>$3,008.72</li><li>$352.4</li><li>$4,330.04</li><li>$108.25</li><li>$21,283.68</li><li>$11.42</li><li>$924.65</li><li>$11,178.56</li><li>$755.15</li><li>$7,787.31</li><li>$359.63</li><li>$5,589.28</li><li>$6,075.15</li><li>$4,867.07</li><li>$10,220.84</li><li>$1,301.52</li><li>$943.16</li><li>$152.66</li><li>$166.14</li><li>$748.63</li><li>$44.93</li><li>$300.98</li><li>$1,105.81</li><li>$1,265.62</li><li>$222.07</li><li>$163.61</li><li>$8,274.01</li><li>$33.59</li><li>$117.68</li><li>$2,065.73</li><li>$284.35</li><li>$7,077.67</li><li>$297.75</li><li>$2,892.02</li><li>$7,409.69</li><li>$688.72</li><li>$56.49</li><li>$92.81</li><li>$136.25</li><li>$308.22</li><li>$23.77</li><li>$617.03</li><li>$489.08</li><li>$868.63</li><li>$102.83</li><li>$5,385.92</li><li>$121.97</li><li>$89.99</li><li>$1,047.05</li><li>$2,701.07</li><li>$296.95</li><li>$1,794.38</li><li>$341.64</li><li>$352.14</li><li>$5,736.45</li><li>$128.23</li><li>$839.56</li><li>$2,217.12</li><li>$121.65</li><li>$14,819.38</li><li>$221.52</li><li>$15,481.34</li><li>$242.73</li><li>$314.16</li><li>$883.74</li><li>$6,634.86</li><li>$2,614.79</li><li>$189.14</li><li>$137.39</li><li>$74.72</li><li>$23.75</li><li>$398.75</li><li>$95.89</li><li>$15,297.24</li><li>$3,305.17</li><li>$4,380.36</li><li>$47.55</li><li>$17,104.43</li><li>$1,030.95</li><li>$23.79</li><li>$930.58</li><li>$249.89</li><li>$731.35</li><li>$850.71</li><li>$30.37</li><li>$222.71</li><li>$3,796.19</li><li>$110.76</li><li>$158.53</li><li>$6,724.8</li><li>$617.47</li><li>$1,247.68</li><li>$0.86</li><li>$441.13</li><li>$575.88</li><li>$130.74</li><li>$68.46</li><li>$7,592.36</li><li>$771.98</li><li>$3,893.65</li><li>$67.25</li><li>$1,652.59</li><li>$314.07</li><li>$598.13</li><li>$74.17</li><li>$561.47</li><li>$879.28</li><li>$807.84</li><li>$10,060.7</li><li>$533.18</li><li>$7,267.79</li><li>$3,824.3</li><li>$1,117.86</li><li>$3,755.94</li><li>$134.85</li><li>$7,300.6</li><li>$88.3</li><li>$1,518.79</li><li>$308.49</li><li>$474.98</li><li>$161.8</li><li>$2,211.62</li><li>$317.24</li><li>$16.49</li><li>$12,163.91</li><li>$20.63</li><li>$2,157.79</li><li>$11.41</li><li>$48.55</li><li>$11,194.25</li><li>$164.53</li><li>$1,795.31</li><li>$13,771.79</li><li>$107.88</li><li>$247.47</li><li>$2,171.29</li><li>$38.85</li><li>$992.55</li><li>$170.14</li><li>$1,234.06</li><li>$747.2</li><li>$167.8</li><li>$26.9</li><li>$3,092.85</li><li>$15.18</li><li>$320.4</li><li>$4,131.46</li><li>$5,840.48</li><li>$7,593.93</li><li>$11,907.61</li><li>$250.73</li><li>$8,760.72</li><li>$215.77</li><li>$39.94</li><li>$699.09</li><li>$1,886.31</li><li>$183.23</li><li>$36.64</li><li>$545</li><li>$1,152.75</li><li>$236.43</li><li>$23.97</li><li>$75.92</li><li>$2,651.22</li><li>$29.08</li><li>$391.77</li><li>$13,669.08</li><li>$528.08</li><li>$300.12</li><li>$1,056.42</li><li>$6,219.79</li><li>$2,654.12</li><li>$95</li><li>$93.49</li><li>$11.89</li><li>$41.53</li><li>$1,879.72</li><li>$523.53</li><li>$135.99</li><li>$12.03</li><li>$177.98</li><li>$299.92</li><li>$1,200.48</li><li>$9,247.43</li><li>$449.81</li><li>$6,921.67</li><li>$5,412.55</li><li>$49.48</li><li>$15,848.21</li><li>$6,813.89</li><li>$82.48</li><li>$18.66</li><li>$973.41</li><li>$882.26</li><li>$759.97</li><li>$5,704.64</li><li>$2,061.9</li><li>$219.39</li><li>$12,656.2</li><li>$445.45</li><li>$287.93</li><li>$20.46</li><li>$45.8</li><li>$867.56</li><li>$18,980.94</li><li>$113.88</li><li>$445.43</li><li>$24.08</li><li>$8,847.08</li><li>$1,025.83</li><li>$156.4</li><li>$63.88</li><li>$96.22</li><li>$5,927.75</li><li>$3,020.6</li><li>$60.14</li><li>$5,062.48</li><li>$1,374.6</li><li>$22,945.85</li><li>$38.49</li><li>$11,472.93</li><li>$523.45</li><li>$2.97</li><li>$7,962.37</li><li>$1,211.3</li><li>$209.59</li><li>$49.99</li><li>$5,286.06</li><li>$706.76</li><li>$118.65</li><li>$120.28</li><li>$583.44</li><li>$220.54</li><li>$3,317.43</li><li>$929.1</li><li>$307.94</li><li>$40.62</li><li>$9,061.81</li><li>$91.6</li><li>$227.08</li><li>$598.44</li><li>$107.2</li><li>$748.3</li><li>$53.93</li><li>$235.06</li><li>$7,774.74</li><li>$3,611.28</li><li>$136.79</li><li>$26.13</li><li>$704.28</li><li>$362.98</li><li>$65.81</li><li>$164.96</li><li>$232.65</li><li>$285.52</li><li>$47.5</li><li>$24.75</li><li>$704.8</li><li>$199.92</li><li>$81.31</li><li>$185.61</li><li>$4,991.56</li><li>$332.49</li><li>$62.68</li><li>$4,239.54</li><li>$278.4</li><li>$185.6</li><li>$2,749.2</li><li>$4,614.45</li><li>$237.31</li><li>$1,094.28</li><li>$4,423.54</li><li>$325.26</li><li>$1,598.82</li><li>$486.71</li><li>$379.98</li><li>$3.43</li><li>$63.44</li><li>$162.49</li><li>$871.7</li><li>$41.84</li><li>$3,780.15</li><li>$13,027.77</li><li>$10,572.11</li><li>$3,718.32</li><li>$118.75</li><li>$38.65</li><li>$1,445.94</li><li>$3,695.21</li><li>$3,230.11</li><li>$119.07</li><li>$179.8</li><li>$3,474.54</li><li>$461.91</li><li>$394.86</li><li>$110.27</li><li>$3,495.46</li><li>$5,912.33</li><li>$482.57</li><li>$349.85</li><li>$713.08</li><li>$346.44</li><li>$309.33</li><li>$30.93</li><li>$242.74</li><li>$27.76</li><li>$2,166.77</li><li>$210.35</li><li>$1,452.84</li><li>$548.48</li><li>$7,592.38</li><li>$376.1</li><li>$3,743.04</li><li>$60.15</li><li>$16.81</li><li>$13,269.72</li><li>$472.86</li><li>$282.08</li><li>$32,475.3</li><li>$104.71</li><li>$17.12</li><li>$222.05</li><li>$403.73</li><li>$227.76</li><li>$67.99</li><li>$34.23</li><li>$213.6</li><li>$2,165.66</li><li>$1,256.64</li><li>$73.97</li><li>$409.25</li><li>$233.75</li><li>$349.63</li><li>$60.52</li><li>$35.95</li><li>$116.86</li><li>$61.7</li><li>$436.91</li><li>$7,130.8</li><li>$4,845.19</li><li>$269.28</li><li>$70.12</li><li>$48.17</li><li>$1,196.25</li><li>$74.24</li><li>$9.71</li><li>$36.99</li><li>$4,617.56</li><li>$817.5</li><li>$186.9</li><li>$6,041.21</li><li>$106.85</li><li>$145.64</li><li>$80.7</li><li>$115.48</li><li>$94.57</li><li>$2,433.53</li><li>$27.49</li><li>$68</li><li>$12,296.41</li><li>$226.23</li><li>$577.38</li><li>$192.46</li><li>$8,556.96</li><li>$475.6</li><li>$82.46</li><li>$6,080.44</li><li>$52.3</li><li>$725.94</li><li>$124.97</li><li>$13,840.11</li><li>$12.04</li><li>$17.38</li><li>$330.85</li><li>$329.09</li><li>$170.12</li><li>$2,503.96</li><li>$189.99</li><li>$371.2</li><li>$8,660.08</li><li>$5.14</li><li>$2,920.24</li><li>$436.21</li><li>$5,154.74</li><li>$3,965.49</li><li>$680.58</li><li>$1,494.4</li><li>$415.72</li><li>$380.69</li><li>$5,784.05</li><li>$37.33</li><li>$51.56</li><li>$38,530.39</li><li>$3,609.43</li><li>$41.25</li><li>$4,483.2</li><li>$628.77</li><li>$599.56</li><li>$20.81</li><li>$49.98</li><li>$2,400.95</li><li>$1,495.94</li><li>$922.89</li><li>$433.78</li><li>$17,370.35</li><li>$141.04</li><li>$1,504.64</li><li>$41.63</li><li>$873.02</li><li>$664.97</li><li>$1,320.68</li><li>$1,993.76</li><li>$249.43</li><li>$6,796.36</li><li>$287.68</li><li>$2,643.66</li><li>$519.69</li><li>$4,556.36</li><li>$578.38</li><li>$451.23</li><li>$2,938.45</li><li>$107.87</li><li>$141.86</li><li>$125.37</li><li>$1,858.19</li><li>$196.29</li><li>$96.91</li><li>$5,537.34</li><li>$55.38</li><li>$721.89</li><li>$2,768.67</li><li>$57.53</li><li>$374.15</li><li>$5,211.81</li><li>$485.8</li><li>$77.71</li><li>$19,121.54</li><li>$5,075.89</li><li>$623.58</li><li>$539.42</li><li>$406.22</li><li>$10,565.47</li><li>$5,308.25</li><li>$1,020.86</li><li>$269.45</li><li>$8,685.18</li><li>$2,356.64</li><li>$17,209.39</li><li>$16.8</li><li>$37.36</li><li>$222.47</li><li>$71.32</li><li>$10,124.96</li><li>$109.91</li><li>$76.98</li><li>$722.26</li><li>$1,946.83</li><li>$605.65</li><li>$1.87</li><li>$11,267.83</li><li>$6,495.06</li><li>$3,001.19</li><li>$1,018.94</li><li>$407.13</li><li>$27.99</li><li>$2,817.12</li><li>$266.41</li><li>$47.94</li><li>$27.57</li><li>$119.86</li><li>$251.72</li><li>$403.92</li><li>$33.62</li><li>$999.26</li><li>$1,156.75</li><li>$104.69</li><li>$213.74</li><li>$98.98</li><li>$30.57</li><li>$29.73</li><li>$1,259.34</li><li>$224.94</li><li>$314.39</li><li>$7,220.92</li><li>$1,804.71</li><li>$287.94</li><li>$80.91</li><li>$1,961.09</li><li>$291.27</li><li>$448.8</li><li>$314.12</li><li>$83.68</li><li>$16,237.65</li><li>$4,153</li><li>$571.04</li><li>$423.11</li><li>$184.56</li><li>$5.6</li><li>$90.78</li><li>$2,601.47</li><li>$17,783.25</li><li>$8,306.01</li><li>$2,406.97</li><li>$435.85</li><li>$500.4</li><li>$2,139.24</li><li>$2,157.53</li><li>$1,078.89</li><li>$235.59</li><li>$10.46</li><li>$39.55</li><li>$31.34</li><li>$203.79</li><li>$683.93</li><li>$274.93</li><li>$15,549.48</li><li>$602.05</li><li>$616.44</li><li>$653.7</li><li>$52.13</li><li>$8.92</li><li>$666.48</li><li>$13,385.08</li><li>$1,851.08</li><li>$359.04</li><li>$1,769.42</li><li>$454.17</li><li>$272.5</li><li>$1,398.19</li><li>$14.87</li><li>$1,590.53</li><li>$15,155.14</li><li>$5,414.14</li><li>$41.13</li><li>$283.72</li><li>$6</li><li>$2,956.16</li><li>$5,977.6</li><li>$220.57</li><li>$4,787.48</li><li>$402.13</li><li>$124.72</li><li>$1,196.87</li><li>$109.97</li><li>$3,109.9</li><li>$10,856.47</li><li>$1,444.51</li><li>$84.19</li><li>$9,742.59</li><li>$308.74</li><li>$346.43</li><li>$91.28</li><li>$269.64</li><li>$1,849.31</li><li>$799.77</li><li>$7,824.99</li><li>$203.11</li><li>$1,735.13</li><li>$291.44</li><li>$503.43</li><li>$26.96</li><li>$14.93</li><li>$897.6</li><li>$156.36</li><li>$2,852.32</li><li>$366.47</li><li>$64.53</li><li>$344.76</li><li>$148.48</li><li>$348.97</li><li>$2,526.6</li><li>$532.81</li><li>$188.8</li><li>$244.54</li><li>$9,329.69</li><li>$1,318.92</li><li>$323.57</li><li>$705.3</li><li>$769.85</li><li>$6.92</li><li>$181.49</li><li>$1,233.4</li><li>$8,424.41</li><li>$942.35</li><li>$58.16</li><li>$356.24</li><li>$1,082.51</li><li>$57.05</li><li>$689.52</li><li>$290.81</li><li>$332.58</li><li>$10,825.1</li><li>$20,567.69</li><li>$132.45</li><li>$1,251.98</li><li>$12,519.81</li><li>$208.54</li><li>$125.84</li><li>$1,426.51</li><li>$321.7</li><li>$1,227.75</li><li>$914.59</li><li>$359.6</li><li>$61.39</li><li>$7,577.57</li><li>$5,778.05</li><li>$9,560.77</li><li>$7,822.67</li><li>$4,123.8</li><li>$36.61</li><li>$50.94</li><li>$173.78</li><li>$680.57</li><li>$8,942.85</li><li>$1,767.48</li><li>$22,777.13</li><li>$455.53</li><li>$3,633.9</li><li>$4,544.61</li><li>$1,039.31</li><li>$224.4</li><li>$16,275.76</li><li>$32.71</li><li>$62.3</li><li>$2,065.75</li><li>$2,179.25</li><li>$815.15</li><li>$293.09</li><li>$61.13</li><li>$461.44</li><li>$520.15</li><li>$2,307.22</li><li>$276.9</li><li>$235.93</li><li>$269.71</li><li>$2,468.11</li><li>$1,012.16</li><li>$412.42</li><li>$161.78</li><li>$392.64</li><li>$9.16</li><li>$278.42</li><li>$2,591.88</li><li>$1,805.23</li><li>$104.27</li><li>$18,402.67</li><li>$501.47</li><li>$722.97</li><li>$11,855.5</li><li>$493.68</li><li>$31,120.7</li><li>$19,265.19</li><li>$557.46</li><li>$194.79</li><li>$2,531.24</li><li>$1,443.77</li><li>$881</li><li>$140.23</li><li>$1,172.37</li><li>$1,321.83</li><li>$884.71</li><li>$1,460.12</li><li>$197.97</li><li>$48.52</li><li>$22.84</li><li>$36.12</li><li>$180.42</li><li>$743.28</li><li>$44.88</li><li>$5,353.77</li><li>$1,301.34</li><li>$339.82</li><li>$3,922.18</li><li>$1,432.38</li><li>$34.61</li><li>$454.46</li><li>$4,530.9</li><li>$10,015.85</li><li>$77.33</li><li>$5,308.26</li><li>$613.88</li><li>$20.4</li><li>$40.76</li><li>$55.51</li><li>$3,702.17</li><li>$2,250.88</li><li>$194.18</li><li>$683.29</li><li>$60.21</li><li>$78.35</li><li>$33.96</li><li>$83.14</li><li>$24.74</li><li>$994.7</li><li>$3,119.2</li><li>$2,963.88</li><li>$296.97</li><li>$13.59</li><li>$10.28</li><li>$443.04</li><li>$319.89</li><li>$3,085.14</li><li>$2,243.9</li><li>$24.99</li><li>$586.19</li><li>$1,982.74</li><li>$3,268.49</li><li>$76.15</li><li>$4,664.84</li><li>$333.08</li><li>$2,988.8</li><li>$1,413.62</li><li>$70.61</li><li>$522.48</li><li>$739.04</li><li>$2,100.83</li><li>$1,438.52</li><li>$1.71</li><li>$3.4</li><li>$1,384.33</li><li>$173.22</li><li>$10.09</li><li>$1,800.71</li><li>$5,694.28</li><li>$126.88</li><li>$1,871.57</li><li>$137.84</li><li>$11,501.21</li><li>$138.78</li><li>$183.19</li><li>$377.5</li><li>$145.4</li><li>$1,684.41</li><li>$446.84</li><li>$407.44</li><li>$6,417.72</li><li>$350.62</li><li>$90.83</li><li>$3,353.57</li><li>$544.46</li><li>$539.45</li><li>$5,055.8</li><li>$103.13</li><li>$20.92</li><li>$2,058.73</li><li>$718.08</li><li>$2,241.6</li><li>$7,740.67</li><li>$1,191</li><li>$408.33</li><li>$1,203.49</li><li>$62.76</li><li>$249.93</li><li>$838.36</li><li>$26,770.16</li><li>$82.27</li><li>$7,593.72</li><li>$6,056.49</li><li>$89.89</li><li>$556.8</li><li>$797.5</li><li>$158.62</li><li>$261.24</li><li>$6,327.19</li><li>$1,912.15</li><li>$72.19</li><li>$762.96</li><li>$498.87</li><li>$99.96</li><li>$12,990.12</li><li>$185.82</li><li>$82.7</li><li>$681.25</li><li>$635.84</li><li>$1,845.78</li><li>$1,598.12</li><li>$191.16</li><li>$1,122.94</li><li>$687.3</li><li>$4,197.78</li><li>$826.29</li><li>$22.82</li><li>$610.69</li><li>$143.84</li><li>$6,662.14</li><li>$24,675.23</li><li>$57.72</li><li>$1,672.37</li><li>$411.33</li><li>$2,098.89</li><li>$2,796.37</li><li>$137.46</li><li>$899.08</li><li>$13,337.44</li><li>$649.65</li><li>$79.87</li><li>$99.97</li><li>$209.38</li><li>$44.79</li><li>$3,247.53</li><li>$57.16</li><li>$6,619.18</li><li>$249.81</li><li>$24.06</li><li>$18,225.44</li><li>$82.43</li><li>$121.86</li><li>$274.81</li><li>$15,184.76</li><li>$1,114.92</li><li>$1,798.16</li><li>$78.52</li><li>$4,342.59</li><li>$5,007.93</li><li>$4,333.54</li><li>$5,037.34</li><li>$90.7</li><li>$464</li><li>$77.92</li><li>$160.2</li><li>$2,392.51</li><li>$846.83</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>1438</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0249</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>57851</td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>$413.15</td>
        <td>789</td>
    </tr>
    <tr>
        <td>$973.41</td>
        <td>675</td>
    </tr>
    <tr>
        <td>$826.29</td>
        <td>655</td>
    </tr>
    <tr>
        <td>$486.71</td>
        <td>650</td>
    </tr>
    <tr>
        <td>$1,460.12</td>
        <td>610</td>
    </tr>
    <tr>
        <td>$461.44</td>
        <td>597</td>
    </tr>
    <tr>
        <td>$1,481.94</td>
        <td>481</td>
    </tr>
    <tr>
        <td>$922.89</td>
        <td>433</td>
    </tr>
    <tr>
        <td>$2,963.88</td>
        <td>404</td>
    </tr>
    <tr>
        <td>$1,946.83</td>
        <td>378</td>
    </tr>
    <tr>
        <td>$1,239.44</td>
        <td>340</td>
    </tr>
    <tr>
        <td>$52.35</td>
        <td>338</td>
    </tr>
    <tr>
        <td>$35.96</td>
        <td>332</td>
    </tr>
    <tr>
        <td>$884.71</td>
        <td>328</td>
    </tr>
    <tr>
        <td>$308.22</td>
        <td>277</td>
    </tr>
    <tr>
        <td>$1,769.42</td>
        <td>271</td>
    </tr>
    <tr>
        <td>$1,384.33</td>
        <td>258</td>
    </tr>
    <tr>
        <td>$3,796.19</td>
        <td>255</td>
    </tr>
    <tr>
        <td>$4,445.81</td>
        <td>252</td>
    </tr>
    <tr>
        <td>$181.49</td>
        <td>248</td>
    </tr>
    <tr>
        <td>$191.16</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$4,197.78</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$610.69</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$6,662.14</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$24,675.23</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$79.87</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$44.79</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$249.81</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$5,037.34</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$846.83</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-Salesperson">Dataset: Salesperson</a>

<a id="profile-Salesperson-EmployeeKey"></a><a href="#column-Salesperson-EmployeeKey">**EmployeeKey**</a>[PK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>272.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>296.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>272.012</li><li>277.004</li><li>281.012</li><li>281.996</li><li>283.004</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>287.504</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>5165.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>286.9444</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>41.232</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>6.4212</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.6684</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.2149</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>272.0</li><li>276.0</li><li>280.0</li><li>284.0</li><li>288.0</li><li>292.0</li><li>296.0</li></ul>bin_counts: <ul><li>1.0</li><li>1.0</li><li>3.0</li><li>4.0</li><li>4.0</li><li>5.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 283.0041: 287.5042: 292.004
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0003</li><li>0.0001</li><li>0.0021</li><li>0.0002</li><li>0.0001</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Salesperson-EmployeeID"></a><a href="#column-Salesperson-EmployeeID">**EmployeeID**</a>[PK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>61161660.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>987554265.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>61624856.3</li><li>91269419.7</li><li>112576450.0</li><li>133883479.0</li><li>139441835.0</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>491471025.0225</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8872134039.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>492896335.5</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.1164975783165298e+17</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>334140326.5571</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.1416</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.5093</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>61161660.0</li><li>215560428.0</li><li>833155498.0</li><li>987554265.0</li></ul>bin_counts: <ul><li>6.0</li><li>1.0</li><li>3.0</li><li>2.0</li><li>2.0</li><li>4.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 139441835.12251: 491471025.02252: 758272095.2625
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0005</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Salesperson-Salesperson"></a><a href="#column-Salesperson-Salesperson">**Salesperson**</a>[AK]

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>24.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>12.9925</li><li>13.9955</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>12.9976</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>240.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>13.3333</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>15.1765</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.8957</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.9462</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.7304</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>7.0</li><li>8.88888889</li><li>22.11111111</li><li>24.0</li></ul>bin_counts: <ul><li>2.0</li><li>1.0</li><li>2.0</li><li>10.0</li><li>1.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.00771: 12.99762: 13.9989
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>G</li><li>Ã</li><li>h</li><li>p</li><li>W</li><li>c</li><li>y</li><li>C</li><li>D</li><li>v</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Salesperson-Title"></a><a href="#column-Salesperson-Title">**Title**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>17.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>28.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>19.9975</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>19.9983</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.3827</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.4052</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>368.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>20.4444</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>4.3791</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.0926</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.8392</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>11.2763</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>17.0</li><li>18.83333333</li><li>26.16666667</li><li>28.0</li></ul>bin_counts: <ul><li>1.0</li><li>14.0</li><li>2.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 19.99471: 19.99832: 20.0018
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>P</li><li>a</li><li>R</li><li>N</li><li>r</li><li>u</li><li>f</li><li>M</li><li>h</li><li>E</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Sales Representative</li><li>North American Sales Manager</li><li>Director of Sales</li><li>European Sales Manager</li><li>Pacific Sales Manager</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.2778</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Sales Representative</td>
        <td>14</td>
    </tr>
    <tr>
        <td>North American Sales Manager</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Director of Sales</td>
        <td>1</td>
    </tr>
    <tr>
        <td>European Sales Manager</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pacific Sales Manager</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Salesperson-UPN"></a><a href="#column-Salesperson-UPN">**UPN**</a>[AK]

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>26.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>43.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>32.9955</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>31.9967</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>581.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>32.2778</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>15.2712</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.9078</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.9828</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.7221</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>26.0</li><li>27.88888889</li><li>41.11111111</li><li>43.0</li></ul>bin_counts: <ul><li>2.0</li><li>1.0</li><li>3.0</li><li>9.0</li><li>1.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 30.00781: 31.99672: 32.9989
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>a</li><li>y</li><li>b</li><li>w</li><li>r</li><li>u</li><li>@</li><li>f</li><li>h</li><li>z</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-SalespersonRegion">Dataset: SalespersonRegion</a>

<a id="profile-SalespersonRegion-EmployeeKey"></a><a href="#column-SalespersonRegion-EmployeeKey">**EmployeeKey**</a>[PK,FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>272.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>296.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>277.004</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>281.99</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>11019.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>282.5385</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>54.7814</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>7.4014</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.1519</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.1927</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>272.0</li><li>275.42857143</li><li>292.57142857</li><li>296.0</li></ul>bin_counts: <ul><li>6.0</li><li>10.0</li><li>5.0</li><li>3.0</li><li>5.0</li><li>6.0</li><li>4.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 277.0011: 281.992: 290.002
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.4615</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0006</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-SalespersonRegion-SalesTerritoryKey"></a><a href="#column-SalespersonRegion-SalesTerritoryKey">**SalesTerritoryKey**</a>[PK,FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>1.0045</li><li>3.0025</li><li>4.0015</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>4.9994</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8955</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.919</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>199.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>5.1026</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>7.9366</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.8172</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.1801</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.0585</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>2.28571429</li><li>8.71428571</li><li>10.0</li></ul>bin_counts: <ul><li>8.0</li><li>5.0</li><li>5.0</li><li>8.0</li><li>4.0</li><li>3.0</li><li>6.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00111: 4.99942: 7.0013
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>1</li><li>3</li><li>4</li><li>5</li><li>6</li><li>7</li><li>2</li><li>8</li><li>9</li><li>10</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.2564</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0006</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>1</td>
        <td>5</td>
    </tr>
    <tr>
        <td>3</td>
        <td>5</td>
    </tr>
    <tr>
        <td>4</td>
        <td>5</td>
    </tr>
    <tr>
        <td>5</td>
        <td>4</td>
    </tr>
    <tr>
        <td>6</td>
        <td>4</td>
    </tr>
    <tr>
        <td>7</td>
        <td>4</td>
    </tr>
    <tr>
        <td>2</td>
        <td>3</td>
    </tr>
    <tr>
        <td>8</td>
        <td>3</td>
    </tr>
    <tr>
        <td>9</td>
        <td>3</td>
    </tr>
    <tr>
        <td>10</td>
        <td>3</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-Targets">Dataset: Targets</a>

<a id="profile-Targets-EmployeeID"></a><a href="#column-Targets-EmployeeID">**EmployeeID**</a>[PK,FK]

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>61161660.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>987554265.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td><ul><li>61624856.3</li><li>112576450.0</li><li>139441835.0</li><li>191319821.0</li><li>234860273.0</li></ul></td>
    </tr>
    <tr>
        <td>Median</td>
        <td>480914009.2947</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9409</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9421</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>371653951256.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>459399198.0915</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.032030712808933e+17</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>321252348.2885</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.2807</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.3771</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>61161660.0</li><li>145379170.0</li><li>903336755.0</li><li>987554265.0</li></ul>bin_counts: <ul><li>246.0</li><li>54.0</li><li>54.0</li><li>0.0</li><li>90.0</li><li>24.0</li><li>54.0</li><li>108.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 139154481.86081: 480914009.29472: 716768848.7876
        </td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>234474252</li><li>139397894</li><li>954276278</li><li>758596752</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0222</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0003</li><li>0.0002</li><li>0.0007</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>234474252</td>
        <td>54</td>
    </tr>
    <tr>
        <td>139397894</td>
        <td>54</td>
    </tr>
    <tr>
        <td>191644724</td>
        <td>54</td>
    </tr>
    <tr>
        <td>502097814</td>
        <td>54</td>
    </tr>
    <tr>
        <td>716374314</td>
        <td>54</td>
    </tr>
    <tr>
        <td>841560125</td>
        <td>54</td>
    </tr>
    <tr>
        <td>61161660</td>
        <td>54</td>
    </tr>
    <tr>
        <td>112432117</td>
        <td>54</td>
    </tr>
    <tr>
        <td>615389812</td>
        <td>53</td>
    </tr>
    <tr>
        <td>399771412</td>
        <td>48</td>
    </tr>
    <tr>
        <td>90836195</td>
        <td>48</td>
    </tr>
    <tr>
        <td>987554265</td>
        <td>48</td>
    </tr>
    <tr>
        <td>134219713</td>
        <td>36</td>
    </tr>
    <tr>
        <td>668991357</td>
        <td>36</td>
    </tr>
    <tr>
        <td>982310417</td>
        <td>36</td>
    </tr>
    <tr>
        <td>481044938</td>
        <td>24</td>
    </tr>
    <tr>
        <td>954276278</td>
        <td>24</td>
    </tr>
    <tr>
        <td>758596752</td>
        <td>24</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Targets-Target"></a><a href="#column-Targets-Target">**Target**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>8.002</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.0025</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9178</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9189</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>6821.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.4314</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.8223</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.9068</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0784</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.2553</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>7.0</li><li>7.36363636</li><li>10.63636364</li><li>11.0</li></ul>bin_counts: <ul><li>34.0</li><li>0.0</li><li>586.0</li><li>0.0</li><li>0.0</li><li>184.0</li><li>0.0</li><li>5.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 8.00111: 8.00252: 8.0039
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>9</li><li>1</li><li>7</li><li>3</li><li>,</li><li>8</li><li>0</li><li>6</li><li>2</li><li>$</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>$500,000</li><li>$200,000</li><li>$1,850,000</li><li>$1,700,000</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>57</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0705</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0002</li><li>0.0002</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>$500,000</td>
        <td>169</td>
    </tr>
    <tr>
        <td>$200,000</td>
        <td>73</td>
    </tr>
    <tr>
        <td>$1,000,000</td>
        <td>71</td>
    </tr>
    <tr>
        <td>$250,000</td>
        <td>66</td>
    </tr>
    <tr>
        <td>$100,000</td>
        <td>52</td>
    </tr>
    <tr>
        <td>$300,000</td>
        <td>51</td>
    </tr>
    <tr>
        <td>$150,000</td>
        <td>32</td>
    </tr>
    <tr>
        <td>$400,000</td>
        <td>30</td>
    </tr>
    <tr>
        <td>$750,000</td>
        <td>27</td>
    </tr>
    <tr>
        <td>$50,000</td>
        <td>22</td>
    </tr>
    <tr>
        <td>$1,500,000</td>
        <td>19</td>
    </tr>
    <tr>
        <td>$2,000,000</td>
        <td>17</td>
    </tr>
    <tr>
        <td>$800,000</td>
        <td>17</td>
    </tr>
    <tr>
        <td>$1,750,000</td>
        <td>14</td>
    </tr>
    <tr>
        <td>$600,000</td>
        <td>13</td>
    </tr>
    <tr>
        <td>$2,500,000</td>
        <td>11</td>
    </tr>
    <tr>
        <td>$3,000,000</td>
        <td>10</td>
    </tr>
    <tr>
        <td>$700,000</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$450,000</td>
        <td>9</td>
    </tr>
    <tr>
        <td>$350,000</td>
        <td>8</td>
    </tr>
    <tr>
        <td>$75,000</td>
        <td>7</td>
    </tr>
    <tr>
        <td>$1,250,000</td>
        <td>6</td>
    </tr>
    <tr>
        <td>$850,000</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$3,500,000</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$175,000</td>
        <td>5</td>
    </tr>
    <tr>
        <td>$900,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$650,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$1,200,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$225,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$2,750,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$25,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$4,000,000</td>
        <td>4</td>
    </tr>
    <tr>
        <td>$2,250,000</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$125,000</td>
        <td>3</td>
    </tr>
    <tr>
        <td>$550,000</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$2,200,000</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$950,000</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$3,750,000</td>
        <td>2</td>
    </tr>
    <tr>
        <td>$33,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$11,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$36,500,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$5,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$10,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$3,250,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$10,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$3,200,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$2,950,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$4,500,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,400,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,050,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$325,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$2,850,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$9,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$2,650,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$30,000,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,850,000</td>
        <td>1</td>
    </tr>
    <tr>
        <td>$1,700,000</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-Targets-TargetMonth"></a><a href="#column-Targets-TargetMonth">**TargetMonth**</a>[PK]

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>19.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>28.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>23.9995</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>23.9956</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9806</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9819</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>18857.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>23.309</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>4.4366</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.1063</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.0838</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.7692</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>19.0</li><li>19.81818182</li><li>27.18181818</li><li>28.0</li></ul>bin_counts: <ul><li>18.0</li><li>75.0</li><li>114.0</li><li>59.0</li><li>126.0</li><li>195.0</li><li>81.0</li><li>96.0</li><li>36.0</li><li>9.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 21.00661: 23.99562: 24.9962
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>0</li><li>y</li><li>N</li><li>e</li><li>8</li><li>d</li><li>u</li><li>M</li><li>h</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Saturday, August 1, 2020</li><li>Wednesday, December 1, 2021</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>54</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0667</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>809</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0002</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Saturday, August 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Monday, June 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Wednesday, April 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Tuesday, September 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Thursday, August 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Tuesday, October 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Monday, July 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Sunday, November 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Friday, November 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Sunday, December 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Sunday, September 1, 2019</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Tuesday, December 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Saturday, February 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Wednesday, January 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Wednesday, July 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Thursday, October 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Sunday, March 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Friday, January 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Monday, February 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Monday, March 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Thursday, April 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Saturday, May 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Tuesday, June 1, 2021</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Friday, May 1, 2020</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Monday, April 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Tuesday, January 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Saturday, June 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Friday, February 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Friday, March 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Saturday, December 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Thursday, November 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Monday, October 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Saturday, September 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Wednesday, August 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Sunday, July 1, 2018</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Wednesday, May 1, 2019</td>
        <td>15</td>
    </tr>
    <tr>
        <td>Tuesday, May 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Sunday, October 1, 2017</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Friday, September 1, 2017</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Tuesday, August 1, 2017</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Monday, January 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Wednesday, November 1, 2017</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Friday, December 1, 2017</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Thursday, February 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Friday, June 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Thursday, March 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Sunday, April 1, 2018</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Saturday, July 1, 2017</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Thursday, July 1, 2021</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Sunday, August 1, 2021</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Friday, October 1, 2021</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Monday, November 1, 2021</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Wednesday, September 1, 2021</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Wednesday, December 1, 2021</td>
        <td>9</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


## <a id="reference"></a>Reference Datasets



### <a id="ref-dataset-REF-Title"></a>Reference Data Code: REF-Title

Description: The official job title held by the salesperson.

Values Count: 5

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Director of Sales</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>European Sales Manager</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>North American Sales Manager</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>Pacific Sales Manager</td>
        <td>1</td>
        <td>5.56%</td>
    </tr>
    <tr>
        <td>Sales Representative</td>
        <td>14</td>
        <td>77.78%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Target"></a>Reference Data Code: REF-Target

Description: The monetary sales target set for the employee.

Values Count: 57

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$1,000,000</td>
        <td>71</td>
        <td>8.78%</td>
    </tr>
    <tr>
        <td>$1,050,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$1,200,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$1,250,000</td>
        <td>6</td>
        <td>0.74%</td>
    </tr>
    <tr>
        <td>$1,400,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$1,500,000</td>
        <td>19</td>
        <td>2.35%</td>
    </tr>
    <tr>
        <td>$1,700,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$1,750,000</td>
        <td>14</td>
        <td>1.73%</td>
    </tr>
    <tr>
        <td>$1,850,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$10,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$10,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$100,000</td>
        <td>52</td>
        <td>6.43%</td>
    </tr>
    <tr>
        <td>$11,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$125,000</td>
        <td>3</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>$150,000</td>
        <td>32</td>
        <td>3.96%</td>
    </tr>
    <tr>
        <td>$175,000</td>
        <td>5</td>
        <td>0.62%</td>
    </tr>
    <tr>
        <td>$2,000,000</td>
        <td>17</td>
        <td>2.10%</td>
    </tr>
    <tr>
        <td>$2,200,000</td>
        <td>2</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>$2,250,000</td>
        <td>3</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>$2,500,000</td>
        <td>11</td>
        <td>1.36%</td>
    </tr>
    <tr>
        <td>$2,650,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$2,750,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$2,850,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$2,950,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$200,000</td>
        <td>73</td>
        <td>9.02%</td>
    </tr>
    <tr>
        <td>$225,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$25,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$250,000</td>
        <td>66</td>
        <td>8.16%</td>
    </tr>
    <tr>
        <td>$3,000,000</td>
        <td>10</td>
        <td>1.24%</td>
    </tr>
    <tr>
        <td>$3,200,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$3,250,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$3,500,000</td>
        <td>5</td>
        <td>0.62%</td>
    </tr>
    <tr>
        <td>$3,750,000</td>
        <td>2</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>$30,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$300,000</td>
        <td>51</td>
        <td>6.30%</td>
    </tr>
    <tr>
        <td>$325,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$33,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$350,000</td>
        <td>8</td>
        <td>0.99%</td>
    </tr>
    <tr>
        <td>$36,500,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$4,000,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$4,500,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$400,000</td>
        <td>30</td>
        <td>3.71%</td>
    </tr>
    <tr>
        <td>$450,000</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$5,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$50,000</td>
        <td>22</td>
        <td>2.72%</td>
    </tr>
    <tr>
        <td>$500,000</td>
        <td>169</td>
        <td>20.89%</td>
    </tr>
    <tr>
        <td>$550,000</td>
        <td>2</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>$600,000</td>
        <td>13</td>
        <td>1.61%</td>
    </tr>
    <tr>
        <td>$650,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$700,000</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$75,000</td>
        <td>7</td>
        <td>0.87%</td>
    </tr>
    <tr>
        <td>$750,000</td>
        <td>27</td>
        <td>3.34%</td>
    </tr>
    <tr>
        <td>$800,000</td>
        <td>17</td>
        <td>2.10%</td>
    </tr>
    <tr>
        <td>$850,000</td>
        <td>5</td>
        <td>0.62%</td>
    </tr>
    <tr>
        <td>$9,000,000</td>
        <td>1</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$900,000</td>
        <td>4</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>$950,000</td>
        <td>2</td>
        <td>0.25%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-TargetMonth"></a>Reference Data Code: REF-TargetMonth

Description: The specific month for which the sales target is applicable.

Values Count: 54

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Friday, December 1, 2017</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Friday, February 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Friday, January 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Friday, June 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Friday, March 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Friday, May 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Friday, November 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Friday, October 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>Friday, September 1, 2017</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Monday, April 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Monday, February 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Monday, January 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Monday, July 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Monday, June 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Monday, March 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Monday, November 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>Monday, October 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Saturday, August 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Saturday, December 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Saturday, February 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Saturday, July 1, 2017</td>
        <td>11</td>
        <td>1.36%</td>
    </tr>
    <tr>
        <td>Saturday, June 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Saturday, May 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Saturday, September 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Sunday, April 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Sunday, August 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>Sunday, December 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Sunday, July 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Sunday, March 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Sunday, November 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Sunday, October 1, 2017</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Sunday, September 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Thursday, April 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Thursday, August 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Thursday, February 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Thursday, July 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>Thursday, March 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Thursday, November 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Thursday, October 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Tuesday, August 1, 2017</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Tuesday, December 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Tuesday, January 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Tuesday, June 1, 2021</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Tuesday, May 1, 2018</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Tuesday, October 1, 2019</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Tuesday, September 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Wednesday, April 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Wednesday, August 1, 2018</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Wednesday, December 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>Wednesday, January 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Wednesday, July 1, 2020</td>
        <td>18</td>
        <td>2.22%</td>
    </tr>
    <tr>
        <td>Wednesday, May 1, 2019</td>
        <td>15</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Wednesday, November 1, 2017</td>
        <td>12</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>Wednesday, September 1, 2021</td>
        <td>9</td>
        <td>1.11%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Country"></a>Reference Data Code: REF-Country

Description: The country where the sales territory is located.

Values Count: 6

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Australia</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>France</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>5</td>
        <td>50.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Group"></a>Reference Data Code: REF-Group

Description: The broader geographical group the sales territory belongs to (e.g., North America, Europe).

Values Count: 3

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Europe</td>
        <td>3</td>
        <td>30.00%</td>
    </tr>
    <tr>
        <td>North America</td>
        <td>6</td>
        <td>60.00%</td>
    </tr>
    <tr>
        <td>Pacific</td>
        <td>1</td>
        <td>10.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Quantity"></a>Reference Data Code: REF-Quantity

Description: The number of units of the product sold in this order line item.

Values Count: 41

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>1</td>
        <td>13713</td>
        <td>23.70%</td>
    </tr>
    <tr>
        <td>2</td>
        <td>13476</td>
        <td>23.29%</td>
    </tr>
    <tr>
        <td>3</td>
        <td>9593</td>
        <td>16.58%</td>
    </tr>
    <tr>
        <td>4</td>
        <td>7150</td>
        <td>12.36%</td>
    </tr>
    <tr>
        <td>5</td>
        <td>4202</td>
        <td>7.26%</td>
    </tr>
    <tr>
        <td>6</td>
        <td>3134</td>
        <td>5.42%</td>
    </tr>
    <tr>
        <td>7</td>
        <td>1649</td>
        <td>2.85%</td>
    </tr>
    <tr>
        <td>8</td>
        <td>1455</td>
        <td>2.52%</td>
    </tr>
    <tr>
        <td>9</td>
        <td>798</td>
        <td>1.38%</td>
    </tr>
    <tr>
        <td>10</td>
        <td>727</td>
        <td>1.26%</td>
    </tr>
    <tr>
        <td>11</td>
        <td>365</td>
        <td>0.63%</td>
    </tr>
    <tr>
        <td>12</td>
        <td>439</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>13</td>
        <td>218</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>14</td>
        <td>247</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>15</td>
        <td>113</td>
        <td>0.20%</td>
    </tr>
    <tr>
        <td>16</td>
        <td>129</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>17</td>
        <td>88</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>18</td>
        <td>98</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>19</td>
        <td>52</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>20</td>
        <td>44</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>21</td>
        <td>30</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>22</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>23</td>
        <td>21</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>24</td>
        <td>18</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>25</td>
        <td>16</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>26</td>
        <td>15</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>27</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>28</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>29</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>30</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>31</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>32</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>33</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>34</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>35</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>36</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>38</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>39</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>40</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>41</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>44</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Unit Price"></a>Reference Data Code: REF-Unit Price

Description: The price per single unit of the product at the time of sale.

Values Count: 230

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>$1,020.59</td>
        <td>885</td>
        <td>1.53%</td>
    </tr>
    <tr>
        <td>$1,127</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$1,188.48</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1,192.04</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$1,201.42</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$1,229.46</td>
        <td>880</td>
        <td>1.52%</td>
    </tr>
    <tr>
        <td>$1,242.85</td>
        <td>819</td>
        <td>1.42%</td>
    </tr>
    <tr>
        <td>$1,262.24</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1,265.31</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1,275.99</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$1,308.94</td>
        <td>819</td>
        <td>1.42%</td>
    </tr>
    <tr>
        <td>$1,311.24</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$1,331.09</td>
        <td>13</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$1,343.84</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$1,345.59</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$1,376.99</td>
        <td>691</td>
        <td>1.19%</td>
    </tr>
    <tr>
        <td>$1,382.76</td>
        <td>22</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$1,391.99</td>
        <td>549</td>
        <td>0.95%</td>
    </tr>
    <tr>
        <td>$1,417.14</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1,430.44</td>
        <td>1251</td>
        <td>2.16%</td>
    </tr>
    <tr>
        <td>$1,466.01</td>
        <td>1353</td>
        <td>2.34%</td>
    </tr>
    <tr>
        <td>$1,957.49</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1,971.99</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$1.33</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$1.37</td>
        <td>150</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>$105.29</td>
        <td>148</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>$11.59</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$11.74</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$11.99</td>
        <td>262</td>
        <td>0.45%</td>
    </tr>
    <tr>
        <td>$113</td>
        <td>90</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>$12.14</td>
        <td>218</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>$12.95</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$125.42</td>
        <td>114</td>
        <td>0.20%</td>
    </tr>
    <tr>
        <td>$129.81</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$13.47</td>
        <td>10</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$13.66</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$133.1</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$136.89</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$137.69</td>
        <td>116</td>
        <td>0.20%</td>
    </tr>
    <tr>
        <td>$14.13</td>
        <td>496</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>$14.2</td>
        <td>39</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>$14.5</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$14.69</td>
        <td>602</td>
        <td>1.04%</td>
    </tr>
    <tr>
        <td>$141.62</td>
        <td>258</td>
        <td>0.45%</td>
    </tr>
    <tr>
        <td>$144.88</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$149.03</td>
        <td>194</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>$149.87</td>
        <td>512</td>
        <td>0.89%</td>
    </tr>
    <tr>
        <td>$15</td>
        <td>252</td>
        <td>0.44%</td>
    </tr>
    <tr>
        <td>$15.73</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$15.75</td>
        <td>84</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>$153.15</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$153.89</td>
        <td>28</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$158.43</td>
        <td>643</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$16.27</td>
        <td>179</td>
        <td>0.31%</td>
    </tr>
    <tr>
        <td>$16.82</td>
        <td>98</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>$165.23</td>
        <td>31</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$17.1</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$177.81</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$178.58</td>
        <td>272</td>
        <td>0.47%</td>
    </tr>
    <tr>
        <td>$179.97</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$18.5</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$180.13</td>
        <td>104</td>
        <td>0.18%</td>
    </tr>
    <tr>
        <td>$183.38</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$183.94</td>
        <td>1015</td>
        <td>1.75%</td>
    </tr>
    <tr>
        <td>$189.78</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$19</td>
        <td>24</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$19.24</td>
        <td>18</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>$19.51</td>
        <td>42</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>$193.38</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$195.59</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$196.33</td>
        <td>253</td>
        <td>0.44%</td>
    </tr>
    <tr>
        <td>$198.04</td>
        <td>206</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>$2,024.99</td>
        <td>661</td>
        <td>1.14%</td>
    </tr>
    <tr>
        <td>$2,039.99</td>
        <td>643</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$2,146.96</td>
        <td>539</td>
        <td>0.93%</td>
    </tr>
    <tr>
        <td>$2.5</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$2.74</td>
        <td>19</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>$2.89</td>
        <td>31</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$2.99</td>
        <td>351</td>
        <td>0.61%</td>
    </tr>
    <tr>
        <td>$20.19</td>
        <td>1493</td>
        <td>2.58%</td>
    </tr>
    <tr>
        <td>$20.29</td>
        <td>77</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>$20.52</td>
        <td>46</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>$20.89</td>
        <td>67</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$20.99</td>
        <td>816</td>
        <td>1.41%</td>
    </tr>
    <tr>
        <td>$200.05</td>
        <td>565</td>
        <td>0.98%</td>
    </tr>
    <tr>
        <td>$202.28</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$202.33</td>
        <td>1203</td>
        <td>2.08%</td>
    </tr>
    <tr>
        <td>$209.26</td>
        <td>709</td>
        <td>1.23%</td>
    </tr>
    <tr>
        <td>$211.17</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$214.24</td>
        <td>45</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>$218.45</td>
        <td>523</td>
        <td>0.90%</td>
    </tr>
    <tr>
        <td>$22.03</td>
        <td>71</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$22.7</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$22.79</td>
        <td>789</td>
        <td>1.36%</td>
    </tr>
    <tr>
        <td>$23.48</td>
        <td>164</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>$234.89</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$234.9</td>
        <td>61</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>$24.03</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$24.29</td>
        <td>642</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>$24.5</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$242.99</td>
        <td>190</td>
        <td>0.33%</td>
    </tr>
    <tr>
        <td>$25.83</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$26.44</td>
        <td>14</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$26.72</td>
        <td>195</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>$27</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$27.49</td>
        <td>25</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$27.65</td>
        <td>30</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$27.88</td>
        <td>49</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>$28.84</td>
        <td>1593</td>
        <td>2.75%</td>
    </tr>
    <tr>
        <td>$28.99</td>
        <td>57</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>$29.69</td>
        <td>62</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>$29.99</td>
        <td>803</td>
        <td>1.39%</td>
    </tr>
    <tr>
        <td>$296.99</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$3.98</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$30.24</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$31.31</td>
        <td>92</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>$31.5</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$31.58</td>
        <td>407</td>
        <td>0.70%</td>
    </tr>
    <tr>
        <td>$31.75</td>
        <td>10</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$31.89</td>
        <td>33</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>$313.19</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$313.64</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$32.39</td>
        <td>1095</td>
        <td>1.89%</td>
    </tr>
    <tr>
        <td>$32.65</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$32.99</td>
        <td>272</td>
        <td>0.47%</td>
    </tr>
    <tr>
        <td>$323.99</td>
        <td>1463</td>
        <td>2.53%</td>
    </tr>
    <tr>
        <td>$324.45</td>
        <td>688</td>
        <td>1.19%</td>
    </tr>
    <tr>
        <td>$327.16</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$33.77</td>
        <td>253</td>
        <td>0.44%</td>
    </tr>
    <tr>
        <td>$334.06</td>
        <td>504</td>
        <td>0.87%</td>
    </tr>
    <tr>
        <td>$338.99</td>
        <td>705</td>
        <td>1.22%</td>
    </tr>
    <tr>
        <td>$34.79</td>
        <td>10</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$34.93</td>
        <td>63</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>$35</td>
        <td>29</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$35.23</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$35.91</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$35.99</td>
        <td>561</td>
        <td>0.97%</td>
    </tr>
    <tr>
        <td>$356.9</td>
        <td>718</td>
        <td>1.24%</td>
    </tr>
    <tr>
        <td>$36.45</td>
        <td>231</td>
        <td>0.40%</td>
    </tr>
    <tr>
        <td>$36.83</td>
        <td>91</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>$37.15</td>
        <td>224</td>
        <td>0.39%</td>
    </tr>
    <tr>
        <td>$37.25</td>
        <td>385</td>
        <td>0.67%</td>
    </tr>
    <tr>
        <td>$37.5</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$38.1</td>
        <td>634</td>
        <td>1.10%</td>
    </tr>
    <tr>
        <td>$38.49</td>
        <td>74</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>$4.32</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$4.37</td>
        <td>14</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$4.5</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$4.61</td>
        <td>34</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>$4.75</td>
        <td>16</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>$4.77</td>
        <td>329</td>
        <td>0.57%</td>
    </tr>
    <tr>
        <td>$4.94</td>
        <td>49</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>$40.59</td>
        <td>66</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>$405.48</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$408.29</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$41.24</td>
        <td>18</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>$41.99</td>
        <td>750</td>
        <td>1.30%</td>
    </tr>
    <tr>
        <td>$419.46</td>
        <td>2198</td>
        <td>3.80%</td>
    </tr>
    <tr>
        <td>$43.49</td>
        <td>47</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>$430.56</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$430.64</td>
        <td>24</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$44.99</td>
        <td>903</td>
        <td>1.56%</td>
    </tr>
    <tr>
        <td>$445.41</td>
        <td>1165</td>
        <td>2.01%</td>
    </tr>
    <tr>
        <td>$446.3</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$454.13</td>
        <td>75</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>$46.97</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$461.69</td>
        <td>433</td>
        <td>0.75%</td>
    </tr>
    <tr>
        <td>$469.79</td>
        <td>2969</td>
        <td>5.13%</td>
    </tr>
    <tr>
        <td>$48.59</td>
        <td>534</td>
        <td>0.92%</td>
    </tr>
    <tr>
        <td>$49.49</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$5.01</td>
        <td>27</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>$5.19</td>
        <td>690</td>
        <td>1.19%</td>
    </tr>
    <tr>
        <td>$5.21</td>
        <td>75</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>$5.23</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$5.39</td>
        <td>866</td>
        <td>1.50%</td>
    </tr>
    <tr>
        <td>$5.51</td>
        <td>11</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$5.7</td>
        <td>210</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>$52.19</td>
        <td>15</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>$52.65</td>
        <td>148</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>$53.06</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$53.99</td>
        <td>735</td>
        <td>1.27%</td>
    </tr>
    <tr>
        <td>$54.89</td>
        <td>224</td>
        <td>0.39%</td>
    </tr>
    <tr>
        <td>$54.94</td>
        <td>90</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>$550.24</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$552.15</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$56.26</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$580.25</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$582.27</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$59.33</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$60</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$600.26</td>
        <td>934</td>
        <td>1.61%</td>
    </tr>
    <tr>
        <td>$602.35</td>
        <td>682</td>
        <td>1.18%</td>
    </tr>
    <tr>
        <td>$61.37</td>
        <td>101</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>$61.77</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$626.39</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$63.9</td>
        <td>330</td>
        <td>0.57%</td>
    </tr>
    <tr>
        <td>$647.99</td>
        <td>888</td>
        <td>1.53%</td>
    </tr>
    <tr>
        <td>$649.88</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>$65.6</td>
        <td>242</td>
        <td>0.42%</td>
    </tr>
    <tr>
        <td>$66</td>
        <td>23</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>$668.17</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$67.54</td>
        <td>303</td>
        <td>0.52%</td>
    </tr>
    <tr>
        <td>$672.29</td>
        <td>863</td>
        <td>1.49%</td>
    </tr>
    <tr>
        <td>$69.6</td>
        <td>32</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>$704.61</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$714.7</td>
        <td>169</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>$72</td>
        <td>361</td>
        <td>0.62%</td>
    </tr>
    <tr>
        <td>$72.16</td>
        <td>218</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>$72.88</td>
        <td>123</td>
        <td>0.21%</td>
    </tr>
    <tr>
        <td>$72.89</td>
        <td>188</td>
        <td>0.32%</td>
    </tr>
    <tr>
        <td>$722.59</td>
        <td>188</td>
        <td>0.32%</td>
    </tr>
    <tr>
        <td>$728.91</td>
        <td>728</td>
        <td>1.26%</td>
    </tr>
    <tr>
        <td>$736.15</td>
        <td>311</td>
        <td>0.54%</td>
    </tr>
    <tr>
        <td>$74.84</td>
        <td>110</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>$744.27</td>
        <td>386</td>
        <td>0.67%</td>
    </tr>
    <tr>
        <td>$758.08</td>
        <td>35</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>$780.82</td>
        <td>354</td>
        <td>0.61%</td>
    </tr>
    <tr>
        <td>$791.41</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$809.76</td>
        <td>344</td>
        <td>0.59%</td>
    </tr>
    <tr>
        <td>$818.7</td>
        <td>424</td>
        <td>0.73%</td>
    </tr>
    <tr>
        <td>$843.75</td>
        <td>69</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$845.63</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$850</td>
        <td>68</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>$850.5</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>$858.9</td>
        <td>314</td>
        <td>0.54%</td>
    </tr>
    <tr>
        <td>$874.79</td>
        <td>903</td>
        <td>1.56%</td>
    </tr>
    <tr>
        <td>$88.93</td>
        <td>83</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>$935.54</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>$953.63</td>
        <td>231</td>
        <td>0.40%</td>
    </tr>
    <tr>
        <td>$986.57</td>
        <td>25</td>
        <td>0.04%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Color"></a>Reference Data Code: REF-Color

Description: The primary color of the product.

Values Count: 10

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Black</td>
        <td>129</td>
        <td>32.49%</td>
    </tr>
    <tr>
        <td>Blue</td>
        <td>28</td>
        <td>7.05%</td>
    </tr>
    <tr>
        <td>Grey</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Multi</td>
        <td>18</td>
        <td>4.53%</td>
    </tr>
    <tr>
        <td>NA</td>
        <td>56</td>
        <td>14.11%</td>
    </tr>
    <tr>
        <td>Red</td>
        <td>63</td>
        <td>15.87%</td>
    </tr>
    <tr>
        <td>Silver</td>
        <td>45</td>
        <td>11.34%</td>
    </tr>
    <tr>
        <td>Silver/Black</td>
        <td>7</td>
        <td>1.76%</td>
    </tr>
    <tr>
        <td>White</td>
        <td>4</td>
        <td>1.01%</td>
    </tr>
    <tr>
        <td>Yellow</td>
        <td>46</td>
        <td>11.59%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Subcategory"></a>Reference Data Code: REF-Subcategory

Description: The specific subcategory to which the product belongs.

Values Count: 37

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Bib-Shorts</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Bike Racks</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Bike Stands</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Bottles and Cages</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Bottom Brackets</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Brakes</td>
        <td>2</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>Caps</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Chains</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Cleaners</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Cranksets</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Derailleurs</td>
        <td>2</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>Fenders</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Forks</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Gloves</td>
        <td>9</td>
        <td>2.27%</td>
    </tr>
    <tr>
        <td>Handlebars</td>
        <td>14</td>
        <td>3.53%</td>
    </tr>
    <tr>
        <td>Headsets</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Helmets</td>
        <td>9</td>
        <td>2.27%</td>
    </tr>
    <tr>
        <td>Hydration Packs</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Jerseys</td>
        <td>16</td>
        <td>4.03%</td>
    </tr>
    <tr>
        <td>Lights</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Locks</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Mountain Bikes</td>
        <td>38</td>
        <td>9.57%</td>
    </tr>
    <tr>
        <td>Mountain Frames</td>
        <td>40</td>
        <td>10.08%</td>
    </tr>
    <tr>
        <td>Panniers</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Pedals</td>
        <td>7</td>
        <td>1.76%</td>
    </tr>
    <tr>
        <td>Pumps</td>
        <td>2</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>Road Bikes</td>
        <td>65</td>
        <td>16.37%</td>
    </tr>
    <tr>
        <td>Road Frames</td>
        <td>70</td>
        <td>17.63%</td>
    </tr>
    <tr>
        <td>Saddles</td>
        <td>9</td>
        <td>2.27%</td>
    </tr>
    <tr>
        <td>Shorts</td>
        <td>7</td>
        <td>1.76%</td>
    </tr>
    <tr>
        <td>Socks</td>
        <td>4</td>
        <td>1.01%</td>
    </tr>
    <tr>
        <td>Tights</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Tires and Tubes</td>
        <td>11</td>
        <td>2.77%</td>
    </tr>
    <tr>
        <td>Touring Bikes</td>
        <td>22</td>
        <td>5.54%</td>
    </tr>
    <tr>
        <td>Touring Frames</td>
        <td>18</td>
        <td>4.53%</td>
    </tr>
    <tr>
        <td>Vests</td>
        <td>3</td>
        <td>0.76%</td>
    </tr>
    <tr>
        <td>Wheels</td>
        <td>14</td>
        <td>3.53%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Category"></a>Reference Data Code: REF-Category

Description: The main category to which the product belongs.

Values Count: 4

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Accessories</td>
        <td>35</td>
        <td>8.82%</td>
    </tr>
    <tr>
        <td>Bikes</td>
        <td>125</td>
        <td>31.49%</td>
    </tr>
    <tr>
        <td>Clothing</td>
        <td>48</td>
        <td>12.09%</td>
    </tr>
    <tr>
        <td>Components</td>
        <td>189</td>
        <td>47.61%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Background Color Format"></a>Reference Data Code: REF-Background Color Format

Description: The hexadecimal color code used for the background color of the product's display.

Values Count: 10

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>#000000</td>
        <td>129</td>
        <td>32.49%</td>
    </tr>
    <tr>
        <td>#0000FF</td>
        <td>28</td>
        <td>7.05%</td>
    </tr>
    <tr>
        <td>#696969</td>
        <td>7</td>
        <td>1.76%</td>
    </tr>
    <tr>
        <td>#808080</td>
        <td>1</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>#BC8F8F</td>
        <td>18</td>
        <td>4.53%</td>
    </tr>
    <tr>
        <td>#C0C0C0</td>
        <td>45</td>
        <td>11.34%</td>
    </tr>
    <tr>
        <td>#DCDCDC</td>
        <td>56</td>
        <td>14.11%</td>
    </tr>
    <tr>
        <td>#FF0000</td>
        <td>63</td>
        <td>15.87%</td>
    </tr>
    <tr>
        <td>#FFFF00</td>
        <td>46</td>
        <td>11.59%</td>
    </tr>
    <tr>
        <td>#FFFFFF</td>
        <td>4</td>
        <td>1.01%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Font Color Format"></a>Reference Data Code: REF-Font Color Format

Description: The hexadecimal color code used for the font color of the product's display.

Values Count: 2

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>#000000</td>
        <td>169</td>
        <td>42.57%</td>
    </tr>
    <tr>
        <td>#FFFFFF</td>
        <td>228</td>
        <td>57.43%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Business Type"></a>Reference Data Code: REF-Business Type

Description: The classification of the reseller's business model.

Values Count: 3

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Specialty Bike Shop</td>
        <td>231</td>
        <td>32.95%</td>
    </tr>
    <tr>
        <td>Value Added Reseller</td>
        <td>238</td>
        <td>33.95%</td>
    </tr>
    <tr>
        <td>Warehouse</td>
        <td>232</td>
        <td>33.10%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-State-Province"></a>Reference Data Code: REF-State-Province

Description: The state or province where the reseller is located.

Values Count: 65

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Alabama</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Alberta</td>
        <td>13</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Arizona</td>
        <td>12</td>
        <td>1.71%</td>
    </tr>
    <tr>
        <td>Bayern</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Brandenburg</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>British Columbia</td>
        <td>20</td>
        <td>2.85%</td>
    </tr>
    <tr>
        <td>Brunswick</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>California</td>
        <td>78</td>
        <td>11.13%</td>
    </tr>
    <tr>
        <td>Colorado</td>
        <td>9</td>
        <td>1.28%</td>
    </tr>
    <tr>
        <td>Connecticut</td>
        <td>9</td>
        <td>1.28%</td>
    </tr>
    <tr>
        <td>England</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>Essonne</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Florida</td>
        <td>27</td>
        <td>3.85%</td>
    </tr>
    <tr>
        <td>Garonne (Haute)</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>Georgia</td>
        <td>13</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Gers</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>Hamburg</td>
        <td>10</td>
        <td>1.43%</td>
    </tr>
    <tr>
        <td>Hauts de Seine</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Hessen</td>
        <td>8</td>
        <td>1.14%</td>
    </tr>
    <tr>
        <td>Idaho</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Illinois</td>
        <td>15</td>
        <td>2.14%</td>
    </tr>
    <tr>
        <td>Indiana</td>
        <td>9</td>
        <td>1.28%</td>
    </tr>
    <tr>
        <td>Kentucky</td>
        <td>5</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>Loir et Cher</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Loiret</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Maine</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Manitoba</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Massachusetts</td>
        <td>5</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>Michigan</td>
        <td>16</td>
        <td>2.28%</td>
    </tr>
    <tr>
        <td>Minnesota</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Mississippi</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Missouri</td>
        <td>11</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>Montana</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Nevada</td>
        <td>7</td>
        <td>1.00%</td>
    </tr>
    <tr>
        <td>New Hampshire</td>
        <td>5</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>New Mexico</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>New South Wales</td>
        <td>29</td>
        <td>4.14%</td>
    </tr>
    <tr>
        <td>New York</td>
        <td>11</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>Nord</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Nordrhein-Westfalen</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>North Carolina</td>
        <td>7</td>
        <td>1.00%</td>
    </tr>
    <tr>
        <td>Ohio</td>
        <td>12</td>
        <td>1.71%</td>
    </tr>
    <tr>
        <td>Ontario</td>
        <td>55</td>
        <td>7.85%</td>
    </tr>
    <tr>
        <td>Oregon</td>
        <td>18</td>
        <td>2.57%</td>
    </tr>
    <tr>
        <td>Pas de Calais</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>Quebec</td>
        <td>23</td>
        <td>3.28%</td>
    </tr>
    <tr>
        <td>Queensland</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Rhode Island</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Saarland</td>
        <td>11</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>Seine (Paris)</td>
        <td>12</td>
        <td>1.71%</td>
    </tr>
    <tr>
        <td>Seine et Marne</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Seine Saint Denis</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>South Australia</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>South Carolina</td>
        <td>3</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>South Dakota</td>
        <td>2</td>
        <td>0.29%</td>
    </tr>
    <tr>
        <td>Tennessee</td>
        <td>16</td>
        <td>2.28%</td>
    </tr>
    <tr>
        <td>Texas</td>
        <td>38</td>
        <td>5.42%</td>
    </tr>
    <tr>
        <td>Utah</td>
        <td>9</td>
        <td>1.28%</td>
    </tr>
    <tr>
        <td>Val d'Oise</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>Val de Marne</td>
        <td>1</td>
        <td>0.14%</td>
    </tr>
    <tr>
        <td>Victoria</td>
        <td>6</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Virginia</td>
        <td>5</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>Washington</td>
        <td>47</td>
        <td>6.70%</td>
    </tr>
    <tr>
        <td>Wisconsin</td>
        <td>4</td>
        <td>0.57%</td>
    </tr>
    <tr>
        <td>Wyoming</td>
        <td>5</td>
        <td>0.71%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-Country-Region"></a>Reference Data Code: REF-Country-Region

Description: The country or broader region where the reseller is located.

Values Count: 6

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Australia</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>114</td>
        <td>16.26%</td>
    </tr>
    <tr>
        <td>France</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>40</td>
        <td>5.71%</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>427</td>
        <td>60.91%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>
