# icij Data Specification Report

This data source contains information about offshore entities, the individuals and companies involved as officers and intermediaries, their associated addresses, and the relationships between these different types of nodes. The data is compiled from various leaks investigated by the International Consortium of Investigative Journalists (ICIJ), including the Panama Papers, Paradise Papers, Offshore Leaks, and Pandora Papers.

<table>
    <tr>
        <th>Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Licensing</td>
        <td>Open Data Commons</td>
    </tr>
    <tr>
        <td>Location Coverage</td>
        <td>Afghanistan, Albania, Algeria, American Samoa, Andorra, Angola, Anguilla, Antigua and Barbuda, Argentina, Aruba, Australia, Austria, Azerbaijan, Bahamas, Bahrain, Bangladesh, Barbados, Belarus, Belgium, Belize, Benin, Bermuda, Bhutan, Bolivia, Bosnia and Herzegovina, Botswana, Brazil, British Indian Ocean Territory, British Virgin Islands, Brunei Darussalam, Bulgaria, Cabo Verde, Cambodia, Cameroon, Canada, Cayman Islands, Central African Republic, Chad, Chile, China, Colombia, Congo, Cook Islands, Costa Rica, Côte d'Ivoire, Croatia, Cuba, Curaçao, Cyprus, Czech Republic, Denmark, Djibouti, Dominica, Dominican Republic, Ecuador, Egypt, El Salvador, Equatorial Guinea, Estonia, Eswatini, Ethiopia, Fiji, Finland, France, French Guiana, French Polynesia, Gabon, Gambia, Georgia, Germany, Ghana, Gibraltar, Greece, Grenada, Guatemala, Guernsey, Guinea, Guam, Guyana, Haiti, Honduras, Hong Kong, Hungary, Iceland, India, Indonesia, Iran, Iraq, Ireland, Isle of Man, Israel, Italy, Jamaica, Japan, Jersey, Jordan, Kazakhstan, Kenya, Kuwait, Kyrgyzstan, Laos, Latvia, Lebanon, Lesotho, Liberia, Libya, Liechtenstein, Lithuania, Luxembourg, Macao, Madagascar, Malawi, Malaysia, Maldives, Mali, Malta, Marshall Islands, Martinique, Mauritius, Mexico, Moldova, Monaco, Mongolia, Montenegro, Morocco, Mozambique, Myanmar, Namibia, Nauru, Nepal, Netherlands, New Zealand, Nicaragua, Niger, Nigeria, Niue, Norfolk Island, North Korea, North Macedonia, Norway, Oman, Pakistan, Palestine, State of, Panama, Papua New Guinea, Paraguay, Peru, Philippines, Poland, Portugal, Puerto Rico, Qatar, Réunion, Romania, Russia, Saint Kitts and Nevis, Saint Lucia, Saint Martin (French part), Saint Vincent and the Grenadines, Samoa, San Marino, Saudi Arabia, Senegal, Serbia, Seychelles, Singapore, Sint Maarten (Dutch part), Slovakia, Slovenia, Solomon Islands, Somalia, South Africa, South Korea, Spain, Sri Lanka, Sudan, Suriname, Sweden, Switzerland, Syrian Arab Republic, Taiwan, Tanzania, Thailand, Togo, Tonga, Trinidad and Tobago, Tunisia, Turkey, Turkmenistan, Turks and Caicos Islands, Ukraine, United Arab Emirates, United Kingdom, United States, Uruguay, U.S. Virgin Islands, Uzbekistan, Vanuatu, Venezuela, Viet Nam, Yemen, Zambia, Zimbabwe</td>
    </tr>
    <tr>
        <td>Format</td>
        <td>csv</td>
    </tr>
    <tr>
        <td>Encoding</td>
        <td>utf-8</td>
    </tr>
</table>

## Overview

```mermaid
erDiagram
    nodes-addresses {
        int node_id PK
        text address
        string name
        string countries
        string country_codes
        string sourceID
        string valid_until
        text note
        }
    nodes-entities {
        int node_id PK
        string name
        string original_name
        string former_name
        string jurisdiction
        string jurisdiction_description
        string company_type
        string address
        int internal_id
        date incorporation_date
        date inactivation_date
        date struck_off_date
        date dorm_date
        string status
        string service_provider
        string ibcRUC
        string country_codes
        string countries
        string sourceID
        string valid_until
        text note
        }
    nodes-intermediaries {
        int node_id PK
        string name
        string status
        string internal_id
        string address
        string countries
        string country_codes
        string sourceID
        string valid_until
        text note
        }
    nodes-officers {
        int node_id PK
        string name
        string countries
        string country_codes
        string sourceID
        string valid_until
        text note
        }
    nodes-others {
        int node_id PK
        string name
        string type
        date incorporation_date
        date struck_off_date
        date closed_date
        string jurisdiction
        string jurisdiction_description
        string countries
        string country_codes
        string sourceID
        string valid_until
        string note
        }
    relationships {
        int node_id_start PK, FK
        int node_id_end PK, FK
        string rel_type
        text link
        string status
        date start_date
        date end_date
        string sourceID
        }
    nodes-addresses ||--|{ relationships : "has_outgoing_relationship"
    nodes-addresses ||--|{ relationships : "has_incoming_relationship"
    nodes-entities ||--|{ relationships : "has_outgoing_relationship"
    nodes-entities ||--|{ relationships : "has_incoming_relationship"
    nodes-intermediaries ||--|{ relationships : "has_outgoing_relationship"
    nodes-intermediaries ||--|{ relationships : "has_incoming_relationship"
    nodes-officers ||--|{ relationships : "has_outgoing_relationship"
    nodes-officers ||--|{ relationships : "has_incoming_relationship"
    nodes-others ||--|{ relationships : "has_outgoing_relationship"
    nodes-others ||--|{ relationships : "has_incoming_relationship"
```

## <a id="table-of-contents"></a>Table of Contents

<table>
    <tr>
        <th>Datasets</th>
        <th>Column</th>
        <th>Type</th>
        <th>Description</th>
        <th>Reference Data</th>
    </tr>
    <tr>
        <td rowspan="9"><a href="#dataset-nodes-addresses">nodes-addresses</a></td>
        <tr>
                <td><a href="#column-nodes-addresses-node_id">node_id</a></td>
                <td>int</td>
                <td>A unique identifier for each address node.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-address">address</a></td>
                <td>text</td>
                <td>The full physical address.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-name">name</a></td>
                <td>string</td>
                <td>A name associated with the address, if applicable (e.g., building name, company name at address).</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-countries">countries</a></td>
                <td>string</td>
                <td>Full country names associated with the address.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-country_codes">country_codes</a></td>
                <td>string</td>
                <td>Abbreviated country codes associated with the address.</td>
                <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the address record.</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-valid_until">valid_until</a></td>
                <td>string</td>
                <td>Indicates the period until which the data from the source is considered current.</td>
                <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-addresses-note">note</a></td>
                <td>text</td>
                <td>Additional notes or comments regarding the address record.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="22"><a href="#dataset-nodes-entities">nodes-entities</a></td>
        <tr>
                <td><a href="#column-nodes-entities-node_id">node_id</a></td>
                <td>int</td>
                <td>A unique identifier for each entity node.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-name">name</a></td>
                <td>string</td>
                <td>The current name of the offshore entity.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-original_name">original_name</a></td>
                <td>string</td>
                <td>The original name of the offshore entity, if different from the current name.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-former_name">former_name</a></td>
                <td>string</td>
                <td>Any previous names used by the offshore entity.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-jurisdiction">jurisdiction</a></td>
                <td>string</td>
                <td>The abbreviated code for the jurisdiction where the entity is registered.</td>
                <td><a href="#ref-dataset-REF-jurisdiction">REF-jurisdiction</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-jurisdiction_description">jurisdiction_description</a></td>
                <td>string</td>
                <td>The full name of the jurisdiction where the entity is registered.</td>
                <td><a href="#ref-dataset-REF-jurisdiction_description">REF-jurisdiction_description</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-company_type">company_type</a></td>
                <td>string</td>
                <td>The type of company or legal structure of the entity.</td>
                <td><a href="#ref-dataset-REF-company_type">REF-company_type</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-address">address</a></td>
                <td>string</td>
                <td>The registered address of the offshore entity.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-internal_id">internal_id</a></td>
                <td>int</td>
                <td>An internal identifier used by the service provider for the entity.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-incorporation_date">incorporation_date</a></td>
                <td>date</td>
                <td>The date when the entity was incorporated.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-inactivation_date">inactivation_date</a></td>
                <td>date</td>
                <td>The date when the entity became inactive.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-struck_off_date">struck_off_date</a></td>
                <td>date</td>
                <td>The date when the entity was officially struck off the registry.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-dorm_date">dorm_date</a></td>
                <td>date</td>
                <td>The date when the entity became dormant.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-status">status</a></td>
                <td>string</td>
                <td>The current operational status of the entity.</td>
                <td><a href="#ref-dataset-REF-status">REF-status</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-service_provider">service_provider</a></td>
                <td>string</td>
                <td>The name of the service provider associated with the entity.</td>
                <td><a href="#ref-dataset-REF-service_provider">REF-service_provider</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-ibcRUC">ibcRUC</a></td>
                <td>string</td>
                <td>An identifier related to International Business Companies (IBC) or other registration numbers.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-country_codes">country_codes</a></td>
                <td>string</td>
                <td>Abbreviated country codes associated with the entity's address or operations.</td>
                <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-countries">countries</a></td>
                <td>string</td>
                <td>Full country names associated with the entity's address or operations.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the entity record (e.g., Panama Papers, Paradise Papers).</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-valid_until">valid_until</a></td>
                <td>string</td>
                <td>Indicates the period until which the data from the source is considered current.</td>
                <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-entities-note">note</a></td>
                <td>text</td>
                <td>Additional notes or comments regarding the entity record.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="11"><a href="#dataset-nodes-intermediaries">nodes-intermediaries</a></td>
        <tr>
                <td><a href="#column-nodes-intermediaries-node_id">node_id</a></td>
                <td>int</td>
                <td>A unique identifier for each intermediary node.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-name">name</a></td>
                <td>string</td>
                <td>The name of the intermediary.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-status">status</a></td>
                <td>string</td>
                <td>The operational status of the intermediary.</td>
                <td><a href="#ref-dataset-REF-status">REF-status</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-internal_id">internal_id</a></td>
                <td>string</td>
                <td>An internal identifier used by the service provider for the intermediary.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-address">address</a></td>
                <td>string</td>
                <td>The registered address of the intermediary.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-countries">countries</a></td>
                <td>string</td>
                <td>Full country names associated with the intermediary's address or operations.</td>
                <td><a href="#ref-dataset-REF-countries">REF-countries</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-country_codes">country_codes</a></td>
                <td>string</td>
                <td>Abbreviated country codes associated with the intermediary's address or operations.</td>
                <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the intermediary record.</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-valid_until">valid_until</a></td>
                <td>string</td>
                <td>Indicates the period until which the data from the source is considered current.</td>
                <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-intermediaries-note">note</a></td>
                <td>text</td>
                <td>Additional notes or comments regarding the intermediary record.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="8"><a href="#dataset-nodes-officers">nodes-officers</a></td>
        <tr>
                <td><a href="#column-nodes-officers-node_id">node_id</a></td>
                <td>int</td>
                <td>A unique identifier for each officer node.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-name">name</a></td>
                <td>string</td>
                <td>The name of the officer.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-countries">countries</a></td>
                <td>string</td>
                <td>Full country names associated with the officer's address or nationality.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-country_codes">country_codes</a></td>
                <td>string</td>
                <td>Abbreviated country codes associated with the officer's address or nationality.</td>
                <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the officer record.</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-valid_until">valid_until</a></td>
                <td>string</td>
                <td>Indicates the period until which the data from the source is considered current.</td>
                <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-officers-note">note</a></td>
                <td>text</td>
                <td>Additional notes or comments regarding the officer record.</td>
                <td>None</td>
            </tr>
        </tr>
    <tr>
        <td rowspan="14"><a href="#dataset-nodes-others">nodes-others</a></td>
        <tr>
                <td><a href="#column-nodes-others-node_id">node_id</a></td>
                <td>int</td>
                <td>A unique identifier for each 'other' node.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-name">name</a></td>
                <td>string</td>
                <td>The name of the 'other' entity or organization.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-type">type</a></td>
                <td>string</td>
                <td>The type or category of the 'other' entity.</td>
                <td><a href="#ref-dataset-REF-type">REF-type</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-incorporation_date">incorporation_date</a></td>
                <td>date</td>
                <td>The date when the 'other' entity was incorporated.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-struck_off_date">struck_off_date</a></td>
                <td>date</td>
                <td>The date when the 'other' entity was officially struck off the registry.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-closed_date">closed_date</a></td>
                <td>date</td>
                <td>The date when the 'other' entity was closed.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-jurisdiction">jurisdiction</a></td>
                <td>string</td>
                <td>The abbreviated code for the jurisdiction where the 'other' entity is registered.</td>
                <td><a href="#ref-dataset-REF-jurisdiction">REF-jurisdiction</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-jurisdiction_description">jurisdiction_description</a></td>
                <td>string</td>
                <td>The full name of the jurisdiction where the 'other' entity is registered.</td>
                <td><a href="#ref-dataset-REF-jurisdiction_description">REF-jurisdiction_description</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-countries">countries</a></td>
                <td>string</td>
                <td>Full country names associated with the 'other' entity's address or operations.</td>
                <td><a href="#ref-dataset-REF-countries">REF-countries</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-country_codes">country_codes</a></td>
                <td>string</td>
                <td>Abbreviated country codes associated with the 'other' entity's address or operations.</td>
                <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the 'other' entity record.</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-valid_until">valid_until</a></td>
                <td>string</td>
                <td>Indicates the period until which the data from the source is considered current.</td>
                <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
            </tr>
        <tr>
                <td><a href="#column-nodes-others-note">note</a></td>
                <td>string</td>
                <td>Additional notes or comments regarding the 'other' entity record.</td>
                <td><a href="#ref-dataset-REF-note">REF-note</a></td>
            </tr>
        </tr>
    <tr>
        <td rowspan="9"><a href="#dataset-relationships">relationships</a></td>
        <tr>
                <td><a href="#column-relationships-node_id_start">node_id_start</a></td>
                <td>int</td>
                <td>The unique identifier of the starting node in a relationship.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-relationships-node_id_end">node_id_end</a></td>
                <td>int</td>
                <td>The unique identifier of the ending node in a relationship.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-relationships-rel_type">rel_type</a></td>
                <td>string</td>
                <td>The general type of relationship between the two nodes.</td>
                <td><a href="#ref-dataset-REF-rel_type">REF-rel_type</a></td>
            </tr>
        <tr>
                <td><a href="#column-relationships-link">link</a></td>
                <td>text</td>
                <td>A more specific description of the relationship, detailing the role or connection.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-relationships-status">status</a></td>
                <td>string</td>
                <td>The status of the relationship (e.g., appointed, resigned).</td>
                <td><a href="#ref-dataset-REF-status">REF-status</a></td>
            </tr>
        <tr>
                <td><a href="#column-relationships-start_date">start_date</a></td>
                <td>date</td>
                <td>The date when the relationship began.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-relationships-end_date">end_date</a></td>
                <td>date</td>
                <td>The date when the relationship ended.</td>
                <td>None</td>
            </tr>
        <tr>
                <td><a href="#column-relationships-sourceID">sourceID</a></td>
                <td>string</td>
                <td>The source of the data for the relationship record.</td>
                <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
            </tr>
        </tr>
    
</table>

## Datasets

### <a id="dataset-nodes-addresses"></a>Dataset: nodes-addresses

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>nodes-addresses</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains detailed information about physical addresses associated with offshore entities, intermediaries, and officers.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>nodes-addresses</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>8</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>402246</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>80449</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>0.9996</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>0</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-nodes-addresses-node_id"></a>**node_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id [<a href="#profile-nodes-addresses-node_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each address node.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column serves as the primary key for the addresses dataset. All values are unique, with no nulls. The values range from 67,276 to 240,492,574.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>250973</li><li>81046186</li><li>58098287</li><li>58104579</li><li>58064769</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>67302.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240492574.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-address"></a>**address**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>address [<a href="#profile-nodes-addresses-address">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The full physical address.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 4.97% of values are null. There are 76,171 unique addresses out of 76,452 non-null sampled records, indicating high uniqueness. The most frequent addresses are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>GLORIA, FL3, VJAL SIR PAUL BOFFA, PAOLA</li><li>No. 9 Building 14 Mingguangcun Residential Area Haidian District Beijing P.R.C.</li><li>Lenin Street 42 appart. 3; Izhevsk city; Russia</li><li>C/ZULOAGA 014, SEGUNDO A, 28222 MAJADAHONDA, MADRID, SPAIN</li><li>BEVANDE ALIMENTARI, TRIQ IL-LANDIER, MOSTAMST 4000, MALTA</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-name"></a>**name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>name [<a href="#profile-nodes-addresses-name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A name associated with the address, if applicable (e.g., building name, company name at address).</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 44.66% of values are null. There are 44,490 unique names out of 44,521 non-null sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>FLT 5, HYDE PARK TOWERS, BORG OLIVIER STREET, ST. JULIANS, MALTA</li><li>Eichlitz, Dennis, Wray & Westheimer Agency, Inc., 105 South St. Mary's Street, Suite 1800; San Antonio; Texas 78205-2881; United States of America</li><li>Allianz Risk Transfer (U.K.) Limited; Riverbank House; 2 Swan Lane; London EC4R 3UX; United Kingdom</li><li>CONNIE, GUZE D'AMATO STREET, TARXIENPLA 05, MALTA</li><li>PARADISE COURT, FLAT 3, TRIQ PAPA GWANNI XXIII BIRKIRKARA</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>186.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-countries"></a>**countries**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>countries [<a href="#profile-nodes-addresses-countries">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Full country names associated with the address.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 31.07% of values are null. The top 3 most frequent countries are China with 6,566 occurrences (8.16%), Hong Kong with 5,592 occurrences (6.95%), and United States with 4,888 occurrences (6.08%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Israel</li><li>Cyprus</li><li>Qatar</li><li>Russia</li><li>United States</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>33.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-country_codes"></a>**country_codes**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>country_codes [<a href="#profile-nodes-addresses-country_codes">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Abbreviated country codes associated with the address.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 31.07% of values are null. The top 3 most frequent country codes are CHN (China) with 6,566 occurrences (8.16%), HKG (Hong Kong) with 5,593 occurrences (6.95%), and USA (United States) with 4,893 occurrences (6.08%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>IND</li><li>CHN</li><li>IDN</li><li>BRA</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>3.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>55459</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-nodes-addresses-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the address record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent source IDs are Paradise Papers - Malta corporate registry with 24,621 occurrences (30.61%), Panama Papers with 18,676 occurrences (23.22%), and Paradise Papers - Appleby with 11,780 occurrences (14.64%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Panama Papers</li><li>Paradise Papers - Appleby</li><li>Paradise Papers - Malta corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>13.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>57.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>28571</td>
        <td>35.51%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>18719</td>
        <td>23.27%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>11911</td>
        <td>14.81%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>11408</td>
        <td>14.18%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>4205</td>
        <td>5.23%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXáX, XXXXXXX, XXXXXXX & XXX (XXXXXXX)</td>
        <td>2636</td>
        <td>3.28%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>579</td>
        <td>0.72%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXX XXXXXXXXXX</td>
        <td>510</td>
        <td>0.63%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXXX</td>
        <td>490</td>
        <td>0.61%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXX</td>
        <td>384</td>
        <td>0.48%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXX XXXXXXXXX XXXXXXXX</td>
        <td>369</td>
        <td>0.46%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXXXXX</td>
        <td>332</td>
        <td>0.41%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>121</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XX XXXX XXXXXXXXX XXXXXXXXXX XXXXXXX</td>
        <td>96</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>66</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXX XXXXXXX (XXX)</td>
        <td>49</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXX</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-valid_until"></a>**valid_until**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>valid_until [<a href="#profile-nodes-addresses-valid_until">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Indicates the period until which the data from the source is considered current.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.18% of values are null. The top 3 most frequent 'valid until' statements are 'Malta corporate registry data is current through 2016' with 24,621 occurrences (30.61%), 'The Panama Papers data is current through 2015' with 18,676 occurrences (23.22%), and 'Appleby data is current through 2014' with 11,780 occurrences (14.64%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>The Offshore Leaks data is current through 2010</li><li>The Panama Papers  data is current through 2015</li><li>Malta corporate registry data is current through 2016</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>36.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>58.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>28571</td>
        <td>35.59%</td>
    </tr>
    <tr>
        <td>XXX XXXXXX XXXXXX  XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>18719</td>
        <td>23.31%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>11911</td>
        <td>14.84%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>11408</td>
        <td>14.21%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>5274</td>
        <td>6.57%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>4205</td>
        <td>5.24%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX XXXXX 9999.</td>
        <td>121</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>66</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX XXX</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXXX - XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-addresses-note"></a>**note**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>note [<a href="#profile-nodes-addresses-note">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Additional notes or comments regarding the address record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 99.91% of values are null. There are 5 unique notes out of 76 non-null sampled records. The most frequent notes are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>On 8th of February 2024 ICIJ reclassified this address to improve the accuracy of the data</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XX 9XX XX XXXXXXXX 9999 XXXX XXXXXXXXXXXX XXXX XXXXXXX XX XXXXXXX XXX XXXXXXXX XX XXX XXXX</td>
        <td>82</td>
        <td>86.32%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX</td>
        <td>3</td>
        <td>3.16%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXXXXX XXXXXXXXX XXX XXXXX XXX XXXXXXXXX XX XXXXXXXX XX XXXXXX XXX XXXXX XX XXXX XXXXXXXXX XX XXX XXXXXXX XXXXXXXX XXXXXXXX. XXXX XXXXXXXXXXXX XXXXXXX XXXX XXXX XXXX XXX XXXXXXXXX, XXX XXXX XXX XXXXXX XXXXXXXX XXXX XXX XXXXXXXXXX XXXX XXX XXXXXXX. XXXX XXXXXXXXX XXXXXXX XXX XXXXXXXX' XXXXX XXX XXXXXXXXX XXXX XXX XXXXXXXX (9XX XXXX 9999)</td>
        <td>3</td>
        <td>3.16%</td>
    </tr>
    <tr>
        <td>XX 9XX XX XXXXXXXX 9999 XXXX XXXXX XXXX XXXXXXX XXXXX.</td>
        <td>2</td>
        <td>2.11%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXX'X XXXXXXX XXXX XXX XXXX XXXXX. (XXXX XXXXX XX XXXXXX 99XX, 9999)</td>
        <td>1</td>
        <td>1.05%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXX'X XXXXXXX XXXX XXX XXXX XXXXX. (XXXX XXXXX XX XXXX 99XX, 9999)</td>
        <td>1</td>
        <td>1.05%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXXXXX XXX XXXX XXXXXXXX. (XXXXXXX XX XXX 99XX , 9999)</td>
        <td>1</td>
        <td>1.05%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXX XXXXXXXXX XXXXXXXX XX XXXXXXXX 99XX, 9999.</td>
        <td>1</td>
        <td>1.05%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXX XXXXXXXXX XXXXXXXX XX XXXXXXXXX 9XX, 9999)</td>
        <td>1</td>
        <td>1.05%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-nodes-entities"></a>Dataset: nodes-entities

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>nodes-entities</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about offshore entities, including their names, jurisdictions, addresses, and operational dates.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>nodes-entities</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>21</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>814289</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>162857</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>0</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-nodes-entities-node_id"></a>**node_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id [<a href="#profile-nodes-entities-node_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each entity node.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column serves as the primary key for the entities dataset. All values are unique, with no nulls. The values range from 66,999 to 240,554,208.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>20081125</li><li>200504872</li><li>20073508</li><li>20040439</li><li>10153071</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>66979.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240554204.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-name"></a>**name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>name [<a href="#profile-nodes-entities-name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The current name of the offshore entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.003% of values are null. There are 161,473 unique names out of 162,857 sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>CONSTRUCTIVE CAPITAL INVESTMENTS LTD.</li><li>CEC ASIA SHIPPING CO. LTD.</li><li>GAUDI HOLDING LIMITED</li><li>KINFOLK INVESTMENTS COMPANY LIMITED</li><li>LOCROSS LIMITED</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>92.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-original_name"></a>**original_name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>original_name [<a href="#profile-nodes-entities-original_name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The original name of the offshore entity, if different from the current name.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 52.46% of values are null. There are 76,572 unique original names out of 77,424 non-null sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>PANIC HOLDINGS S.A.</li><li>QUEIN INVESTMENTS CORP.</li><li>Jacsam Ltd.</li><li>ASPARAGUS HOLDINGS LIMITED</li><li>ASHWORTH FOUNDATION</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>129.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-former_name"></a>**former_name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>former_name [<a href="#profile-nodes-entities-former_name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Any previous names used by the offshore entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 99.16% of values are null. There are 1,349 unique former names out of 1,359 non-null sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>ZABANAY REAL</li><li>WHITE  EAGLE GROUP INC.</li><li>UNIQUE CONTROL S.A.</li><li>GAINS PARK INVESTMENTS LIMITED</li><li>TERSINC TRADING LTD.</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>100.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-jurisdiction"></a>**jurisdiction**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>jurisdiction [<a href="#profile-nodes-entities-jurisdiction">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The abbreviated code for the jurisdiction where the entity is registered.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.96% of values are null. The top 3 most frequent jurisdictions are BAH (Bahamas) with 41,486 occurrences (25.47%), BVI (British Virgin Islands) with 33,480 occurrences (20.56%), and MLT (Malta) with 17,156 occurrences (10.53%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>BVI</li><li>BAH</li><li>NIUE</li><li>PMA</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-jurisdiction">REF-jurisdiction</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>5.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>143105</td>
        <td>88.69%</td>
    </tr>
    <tr>
        <td>XX</td>
        <td>15207</td>
        <td>9.42%</td>
    </tr>
    <tr>
        <td>XXXX</td>
        <td>2795</td>
        <td>1.73%</td>
    </tr>
    <tr>
        <td>XXXXX</td>
        <td>256</td>
        <td>0.16%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-jurisdiction_description"></a>**jurisdiction_description**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>jurisdiction_description [<a href="#profile-nodes-entities-jurisdiction_description">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The full name of the jurisdiction where the entity is registered.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.96% of values are null. The top 3 most frequent jurisdiction descriptions are Bahamas with 41,504 occurrences (25.48%), British Virgin Islands with 34,441 occurrences (21.15%), and Malta with 17,158 occurrences (10.54%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Saint Kitts and Nevis</li><li>Panama</li><li>Malta</li><li>Undetermined</li><li>Bahamas</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-jurisdiction_description">REF-jurisdiction_description</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>34.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-company_type"></a>**company_type**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>company_type [<a href="#profile-nodes-entities-company_type">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The type of company or legal structure of the entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 82.91% of values are null. The top 3 most frequent company types are Standard International Company with 8,021 occurrences (4.93%), Standard Company under IBC Act with 5,402 occurrences (3.32%), and Business Company Limited by Shares with 5,010 occurrences (3.08%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Client Sundry Account</li><li>Business Company Limited by Shares</li><li>Standard International Company</li><li>Standard Company under IBC Act</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-company_type">REF-company_type</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>46.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-address"></a>**address**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>address [<a href="#profile-nodes-entities-address">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The registered address of the offshore entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 63.21% of values are null. There are 7,560 unique addresses out of 59,920 non-null sampled records, indicating high uniqueness. The most frequent addresses are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>BANNING GROUP SERVICES LIMITED SUITE 13; FIRST FLOOR OLIAJI TRADE CENTRE FRANCIS RACHEL STREET VICTORIA; MAHE SEYCHELLES</li><li>HOEGH CAPITAL PARTNERS SERVICES (GUERNSEY) LIMITED SUITE 2 BOROUGH HOUSE RUE DU PRE ST. PETER PORT, GUERNSEY GY1 1EF CHANNEL ISLANDS UNITED KINGDOM</li><li>TROWERS & HAMLINS 3 BUNHILL ROW LONDON  DX 774 - EC1Y 8YZ,  UNITED KINGDOM</li><li>INVESTMENT & FINANCIAL CONSULTANTS GROUP 100 RUE DU RHONE CASE POSTALE 3334  1211 GENEVE 3,  SWITZERLAND</li><li>International Offshore Services Group 42 Chelmsford Road Dublin 6 Ireland RT BVI</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>254.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-internal_id"></a>**internal_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>internal_id [<a href="#profile-nodes-entities-internal_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An internal identifier used by the service provider for the entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 52.46% of values are null. There are 75,654 unique internal IDs out of 77,424 non-null sampled records, indicating high uniqueness. The values range from 1 to 10,500,005.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>32299</li><li>519411</li><li>22028</li><li>56854</li><li>2000603</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>10000017.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-incorporation_date"></a>**incorporation_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>incorporation_date [<a href="#profile-nodes-entities-incorporation_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the entity was incorporated.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 3.27% of values are null. The date format is DD-MMM-YYYY. There are 13,090 unique incorporation dates out of 157,524 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>02-JUN-2014</li><li>02-JUN-2008</li><li>25-OCT-2001</li><li>04-OCT-2011</li><li>24-MAR-1999</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td>DD-MMM-YYYY</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>157689</td>
        <td>100.00%</td>
    </tr>
    <tr>
        <td>XXX 99, 9999</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-inactivation_date"></a>**inactivation_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>inactivation_date [<a href="#profile-nodes-entities-inactivation_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the entity became inactive.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 82.25% of values are null. The date format is DD-MMM-YYYY. There are 4,975 unique inactivation dates out of 28,904 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>10-JUL-2006</li><li>06-NOV-2014</li><li>25-OCT-2013</li><li>16-JAN-2001</li><li>03-MAY-2005</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td>DD-MMM-YYYY</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>28868</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-struck_off_date"></a>**struck_off_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>struck_off_date [<a href="#profile-nodes-entities-struck_off_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the entity was officially struck off the registry.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 57.97% of values are null. The date format is DD-MMM-YYYY. There are 4,527 unique struck off dates out of 68,490 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>23-JUN-1985</li><li>01-JAN-1998</li><li>31-AUG-1978</li><li>01-FEB-2005</li><li>31-AUG-2002</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td>DD-MMM-YYYY</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>68645</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-dorm_date"></a>**dorm_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>dorm_date [<a href="#profile-nodes-entities-dorm_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the entity became dormant.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 97.49% of values are null. The date format is DD-MMM-YYYY. There are 118 unique dormant dates out of 4,065 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>01-NOV-2008</li><li>01-MAY-2006</li><li>01-MAY-2004</li><li>01-NOV-2009</li><li>01-NOV-2007</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td>DD-MMM-YYYY</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>4037</td>
        <td>100.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-status"></a>**status**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>status [<a href="#profile-nodes-entities-status">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The current operational status of the entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 56.01% of values are null. The top 3 most frequent statuses are Active with 23,253 occurrences (14.28%), Defaulted with 19,927 occurrences (12.24%), and Dissolved with 4,865 occurrences (2.99%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Bad debt account</li><li>In Dissolution</li><li>Active</li><li>Relocated in new jurisdiction</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-status">REF-status</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>41.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-service_provider"></a>**service_provider**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>service_provider [<a href="#profile-nodes-entities-service_provider">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The name of the service provider associated with the entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 57.73% of values are null. The top 3 most frequent service providers are Mossack Fonseca with 42,547 occurrences (26.13%), Portcullis Trustnet with 12,288 occurrences (7.55%), and Commonwealth Trust Limited with 9,047 occurrences (5.56%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Portcullis Trustnet</li><li>Mossack Fonseca</li><li>Commonwealth Trust Limited</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-service_provider">REF-service_provider</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>26.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXX</td>
        <td>42628</td>
        <td>62.07%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXX XXXXXXXX</td>
        <td>12151</td>
        <td>17.69%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXXXX XXXXX XXXXXXX</td>
        <td>8904</td>
        <td>12.97%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>4993</td>
        <td>7.27%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-ibcRUC"></a>**ibcRUC**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>ibcRUC [<a href="#profile-nodes-entities-ibcRUC">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An identifier related to International Business Companies (IBC) or other registration numbers.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 30.85% of values are null. There are 104,285 unique IBC/RUC values out of 112,610 non-null sampled records, indicating high uniqueness. The most frequent values are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>003954</li><li>45510</li><li>399156</li><li>15130B</li><li>80802B</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>19.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-country_codes"></a>**country_codes**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>country_codes [<a href="#profile-nodes-entities-country_codes">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Abbreviated country codes associated with the entity's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 37.84% of values are null. The top 3 most frequent country codes are MLT (Malta) with 17,249 occurrences (10.59%), VGB (British Virgin Islands) with 10,980 occurrences (6.74%), and HKG (Hong Kong) with 7,777 occurrences (4.77%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>RUS</li><li>LVA;VGB</li><li>ECU</li><li>VGB</li><li>HKG</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>15.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>89900</td>
        <td>89.18%</td>
    </tr>
    <tr>
        <td>XXX;XXX</td>
        <td>10841</td>
        <td>10.75%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX</td>
        <td>65</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-countries"></a>**countries**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>countries [<a href="#profile-nodes-entities-countries">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Full country names associated with the entity's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 37.84% of values are null. The top 3 most frequent countries are Malta with 17,249 occurrences (10.59%), British Virgin Islands with 10,980 occurrences (6.74%), and Hong Kong with 7,777 occurrences (4.77%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Cook Islands;Singapore</li><li>Cayman Islands</li><li>Hong Kong</li><li>Uruguay</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>47.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-nodes-entities-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the entity record (e.g., Panama Papers, Paradise Papers).</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent source IDs are Panama Papers with 42,547 occurrences (26.13%), Bahamas Leaks with 34,877 occurrences (21.42%), and Offshore Leaks with 21,335 occurrences (13.10%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Panama Papers</li><li>Offshore Leaks</li><li>Paradise Papers - Barbados corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>13.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>57.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>42628</td>
        <td>26.18%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>41216</td>
        <td>25.31%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>35188</td>
        <td>21.61%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>21055</td>
        <td>12.93%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>8176</td>
        <td>5.02%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>4993</td>
        <td>3.07%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>3579</td>
        <td>2.20%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXáX, XXXXXXX, XXXXXXX & XXX (XXXXXXX)</td>
        <td>3089</td>
        <td>1.90%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXX XXXXXXXXX XXXXXXXX</td>
        <td>591</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXX</td>
        <td>490</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXX XXXXXXXXXX</td>
        <td>413</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXXX</td>
        <td>368</td>
        <td>0.23%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>366</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXX XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>302</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXXXXX</td>
        <td>260</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXX XXXXXXX (XXX)</td>
        <td>59</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XX XXXX XXXXXXXXX XXXXXXXXXX XXXXXXX</td>
        <td>59</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXX</td>
        <td>25</td>
        <td>0.02%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-valid_until"></a>**valid_until**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>valid_until [<a href="#profile-nodes-entities-valid_until">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Indicates the period until which the data from the source is considered current.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.03% of values are null. The top 3 most frequent 'valid until' statements are 'The Panama Papers data is current through 2015' with 42,547 occurrences (26.13%), 'The Bahamas Leaks data is current through early 2016.' with 34,877 occurrences (21.42%), and 'The Offshore Leaks data is current through 2010' with 21,335 occurrences (13.10%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>The Bahamas Leaks data is current through early 2016.</li><li>Nevis corporate registry data is current through 2016</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>26.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>99.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX XXXXXX XXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>42628</td>
        <td>26.18%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>41216</td>
        <td>25.32%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX XXXXX 9999.</td>
        <td>35188</td>
        <td>21.61%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>21055</td>
        <td>12.93%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>8176</td>
        <td>5.02%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>5530</td>
        <td>3.40%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>4993</td>
        <td>3.07%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>3579</td>
        <td>2.20%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>302</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>XXXX XX XXXXXXX XXXXXXX 9999.</td>
        <td>108</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX XXX</td>
        <td>16</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXXX - XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXXXXXX 9999.</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX XXXX XX XXXXXXX XXXXXXX 9999.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX XX XXXXXXX XXXXXXX 9999.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999. XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-entities-note"></a>**note**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>note [<a href="#profile-nodes-entities-note">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Additional notes or comments regarding the entity record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 94.81% of values are null. There are 80 unique notes out of 8,451 non-null sampled records. The most frequent notes are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>This is not an offshore entity even though it was logged as such in original database ICIJ received. It isi an internal account created by the agent to record miscellaneous charges of an officer or intermediary</li><li>Closed date stands for Cancelled date.</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXX XXXX.</td>
        <td>5300</td>
        <td>63.70%</td>
    </tr>
    <tr>
        <td>XXXX XX XXX XX XXXXXXXX XXXXXX XXXX XXXXXX XX XXX XXXXXX XX XXXX XX XXXXXXXX XXXXXXXX XXXX XXXXXXXX. XX XXX XX XXXXXXXX XXXXXXX XXXXXXX XX XXX XXXXX XX XXXXXX XXXXXXXXXXXXX XXXXXXX XX XX XXXXXXX XX XXXXXXXXXXXX</td>
        <td>1795</td>
        <td>21.57%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXXX XXXX.</td>
        <td>714</td>
        <td>8.58%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXX XXXX</td>
        <td>302</td>
        <td>3.63%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXXXX XXXX.</td>
        <td>84</td>
        <td>1.01%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXXXXXXX: 99-XXX-9999</td>
        <td>55</td>
        <td>0.66%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXX XXXX.</td>
        <td>41</td>
        <td>0.49%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXXXX XXXX. XXXX XXXXXXXXXXXX: 99-XXX-9999</td>
        <td>20</td>
        <td>0.24%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXX XXXX. XXXX XXXXXXXXXXXX: 99-XXX-9999</td>
        <td>2</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>* XXXXX XX XXX XXXXXXXXX XXXXXXXX XX XXXX, XXXX XXXXXXX XXX XXXXXX XXX XX XXX 99XX, 9999 (XXXX XXXXX XX XXX 99XX, 9999)</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XX. XXXXXXX XXñX XXXXXX XXXX X&X XXXXXXXX XXXX XXXX XXXX XXX XXX XXXX XX XXXXXXXXXX XXX XXX XXXXXX XX XXXX XXXXXX XXX XXXXXXXXX XXXXXXXX XXXXXXXXXX XXX., XXXXXXXX XXXXXXXX XXXXXXX XXX XXXX XXXXXXXX XXX. XX XXXX XXXX XXXX XXXXX XXXXXX XXX XXXXXXXXXX XX XXXX XX XXX XX XXX XXXXXXX XXXXX XXXXX XX XXXX XXXX X XXXXXXXXX XXXX XXXXXX XXXXXXXXXXX XX XXXXX. 'XX X XXXXX XXXXX, XX XXXXXXXXXX XXX XXXXXX XXXX 9 XXXXXXXX XX XXXXXX (XXX XX XX XXXX XXXX XXXX), XXX XXXX XXXXXXX XXXX XX XXXXXXXXXXX XX XXXXXXXX XXXX XXXXXXXXX, XXXXXX XXX XXXX XXXXX XXX. XXXX XX XXX XX XXX XX XXXXXXX XXXX XXX XXXXXXX XXXXXXXX XXXX XX XXXX XXXX XXXXXXX.'   (XXXXXXX XX XXX. 99XX, 9999)</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>X XXXXXXXXXXXXXX XXXX XXX XXXX XXXX XXXX XXX XXX XXXXXX XX XXXXXXXX XXX XX XXXXXXXXXXX XXXX XXXXXXX XXXX XXXXXXXXXXX XX XXXXXXXXXX XXXXXXXXXXX XXXXXXXX XXX XXXX XX. XXXXX, XXX XX X XXXXXX XXXXXXXX XX XXX XXXXXXXXXX, XXX XXX XXXXXX XXXXXXXXX XX XXX XXXXXXXXX. “XX XXXX XXXXXX XXXX XX. XXXXX, XXX XXXXXXXXX XXXX XXX XXXXXXXXXXXX XXX XXXXXXX XXX, XXXXXXXXXX XXXXXXXXXX XXXXXXXX, XXX XXXXXXX XXXX XXXXXXXXXXX, XXX XXX XXX XXXXXX XX XXXXXXXX XXX XX XXXXXXXXXXX. XXX XXX XXXXXXX XXXXXXX XXXX XX XXXXXXX XXXX XXX XXX XXXXXXXXXXXXX XXXX XXXXX XXXXX XXXXXXXX,” XXX XXXXXXXXXXXXXX XXXXX. (XXXXXXX XX XXXXXX 99XX, 9999)</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXXXXX XXXXXXXX XXX XXX XXXXXXXXX XX XXXXXXX 99XX 9999, XXXXX XX XXXXXXXXX XXXXXXXX XX X XXXXXXXXXXXXXX XXX XXX XXXXXXX (XXXXXXX XX XXXXXXXX 99XX , 9999)</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX.</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXX XXXX. XXXX XXXXXXXXXXXX: 99-XXX-9999</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX XXXXX XXóX XXXX XXXX XXXX XX XX XXX XXX XXXXX XX XXX XXXXXXX. XX XXXXXXXX X XXXXXX XXXXXX XX X XXXXXXX XXXXXXX XXXXXXXXXXXXXX XXXX XXXXXX “XXXXXXXXX XX XXX XXXXXXX XXX XX XXX XXXXXXXXXXX XXXXXXXX XX XXX XXXXXX XXX XXXXXX, XXXXXX XXXXXX XXXXX XXóX XX XXX XXXXXXXXXXX XXX XXXXXXXXXX XXXXX XX XXXXXX XXXXXXXXX XXX.” (XXXXXXX XX XXXXXXXXX 99XX, 9999)</td>
        <td>1</td>
        <td>0.01%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-nodes-intermediaries"></a>Dataset: nodes-intermediaries

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>nodes-intermediaries</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about intermediaries, such as law firms or financial institutions, involved in setting up or managing offshore entities.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>nodes-intermediaries</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>10</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>26768</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>26768</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>0.9998</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>0</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-nodes-intermediaries-node_id"></a>**node_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id [<a href="#profile-nodes-intermediaries-node_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each intermediary node.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column serves as the primary key for the intermediaries dataset. All values are unique, with no nulls. The values range from 21,309 to 240,091,020.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>11007068</li><li>11005674</li><li>11007376</li><li>297582</li><li>11010466</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>27115.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240091021.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-name"></a>**name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>name [<a href="#profile-nodes-intermediaries-name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The name of the intermediary.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. There are 5,242 unique names out of 5,353 sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>SOBRI BIN ABU</li><li>IZACA S. A.</li><li>Han, Bang-Tsair</li><li>KHALIQ UZ ZAMAN KHAN LODHI</li><li>FIDUSYNERGIE S.A.</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>91.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-status"></a>**status**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>status [<a href="#profile-nodes-intermediaries-status">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The operational status of the intermediary.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 53.15% of values are null. The top 3 most frequent statuses are ACTIVE with 1,434 occurrences (26.79%), SUSPENDED with 918 occurrences (17.15%), and UNRECOVERABLE ACCOUNTS with 71 occurrences (1.33%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>INACTIVE</li><li>SUSPENDED</li><li>ACTIVE</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-status">REF-status</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>6.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>34.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>1427</td>
        <td>56.31%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>954</td>
        <td>37.65%</td>
    </tr>
    <tr>
        <td>XXXXXXXX</td>
        <td>72</td>
        <td>2.84%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXXXXX XXXXXXXX</td>
        <td>66</td>
        <td>2.60%</td>
    </tr>
    <tr>
        <td>XXXXXX XX XXXXXXXXXXXXXX XXXXXXXXX</td>
        <td>7</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXX</td>
        <td>3</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXX</td>
        <td>3</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX XXXXX</td>
        <td>2</td>
        <td>0.08%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-internal_id"></a>**internal_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>internal_id [<a href="#profile-nodes-intermediaries-internal_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>An internal identifier used by the service provider for the intermediary.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 45.23% of values are null. There are 2,915 unique internal IDs out of 2,932 non-null sampled records, indicating high uniqueness. The values range from 0 to 90,431.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>90427</li><li>33571</li><li>10901</li><li>3765</li><li>8548</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>6.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-address"></a>**address**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>address [<a href="#profile-nodes-intermediaries-address">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The registered address of the intermediary.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 68.18% of values are null. There are 1,703 unique addresses out of 1,703 non-null sampled records, indicating high uniqueness. The most frequent addresses are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>DUTCH CARIBBEAN TRUST CURACAO (DUCAT) VILLAPARK ROOI CATOOTJE 6 WILLEMSTAD NETHERLANDS ANTILLES</li><li>JUDY YEUNG YUK YING 300 LOCKHART ROAD KIM FU COMMERCIAL BUILDING 14/F; OFFICE B WANCHAI; HONG KONG</li><li>ROELAND PELS C/O BENELUX TRUST LUXEMBOURG 12, RUE LEON THYES L-2636 LUXEMBOURG</li><li>SMARTCOM SECRETARIES LIMITED SUITES 2302-3  CHINACHEM HOLLYWOOD CENTRE 1 HOLLYWOOD ROAD CENTRAL, HONG KONG</li><li>SIGNES SÀRL 68-70, BOULEVARD DE LA PÉTRUSSE L-2320 LUXEMBOURG</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>38.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>213.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-countries"></a>**countries**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>countries [<a href="#profile-nodes-intermediaries-countries">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Full country names associated with the intermediary's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 13.73% of values are null. The top 3 most frequent countries are Hong Kong with 965 occurrences (18.03%), United Kingdom with 303 occurrences (5.66%), and United States with 291 occurrences (5.44%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Hong Kong</li><li>Liechtenstein</li><li>Switzerland</li><li>United States</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-countries">REF-countries</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>40.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-country_codes"></a>**country_codes**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>country_codes [<a href="#profile-nodes-intermediaries-country_codes">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Abbreviated country codes associated with the intermediary's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 13.73% of values are null. The top 3 most frequent country codes are HKG (Hong Kong) with 965 occurrences (18.03%), GBR (United Kingdom) with 303 occurrences (5.66%), and USA (United States) with 291 occurrences (5.44%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>GBR</li><li>SGP</li><li>NZL</li><li>BRA</li><li>PAN</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>7.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>4498</td>
        <td>96.88%</td>
    </tr>
    <tr>
        <td>XXX;XXX</td>
        <td>145</td>
        <td>3.12%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-nodes-intermediaries-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the intermediary record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent source IDs are Panama Papers with 2,802 occurrences (52.34%), Offshore Leaks with 1,886 occurrences (35.23%), and Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal) with 215 occurrences (4.02%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Panama Papers</li><li>Offshore Leaks</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>13.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>57.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>2831</td>
        <td>52.89%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>1917</td>
        <td>35.81%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>204</td>
        <td>3.81%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXáX, XXXXXXX, XXXXXXX & XXX (XXXXXXX)</td>
        <td>190</td>
        <td>3.55%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>102</td>
        <td>1.91%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>43</td>
        <td>0.80%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>35</td>
        <td>0.65%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>31</td>
        <td>0.58%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-valid_until"></a>**valid_until**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>valid_until [<a href="#profile-nodes-intermediaries-valid_until">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Indicates the period until which the data from the source is considered current.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent 'valid until' statements are 'The Panama Papers data is current through 2015' with 2,802 occurrences (52.34%), 'The Offshore Leaks data is current through 2010' with 1,886 occurrences (35.23%), and 'Barbados corporate registry data is current through 2016' with 202 occurrences (3.77%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Provider data is current through 2017</li><li>The Offshore Leaks data is current through 2010</li><li>The Panama Papers  data is current through 2015</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>36.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>56.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX XXXXXX XXXXXX  XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>2831</td>
        <td>52.89%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>1917</td>
        <td>35.81%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>204</td>
        <td>3.81%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>190</td>
        <td>3.55%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX XXXXX 9999.</td>
        <td>102</td>
        <td>1.91%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>43</td>
        <td>0.80%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>35</td>
        <td>0.65%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>31</td>
        <td>0.58%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-intermediaries-note"></a>**note**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>note [<a href="#profile-nodes-intermediaries-note">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Additional notes or comments regarding the intermediary record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 99.97% of values are null. There are 6 unique notes out of 7 non-null sampled records. The most frequent notes are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>The name of this intermediary is displayed as it originally appeared in the leaked files ICIJ received.</li><li>Mr. Joseph Levy told ICIJ that Independent Financial Consulting, Inc. never had Mossack Fonseca as registered agent and that Carles-Barraza Abogados registered the company in 2007. Panama Papers documents show that Independent Financial Consulting was related to Mossack Fonseca through the rental of an office space. The company had an agreement with Mossfon Trust Corporation and paid regular fees for this service.  (Updated on Oct. 11th, 2016)</li><li>Mr. Ignacio Mañe lawyer from M&O Abogados told ICIJ that the law firm he represents did not create or help manage the companies Monmouth Associates Ltd., Harrison Overseas Limited and Orsa Equities Ltd. He also said that their client was introduced to them by one of the biggest Swiss banks to help with a potential real estate transaction in Spain. 'At a later stage, we discovered the client held 3 entities in Panama (set up by that same bank), and upon knowing that we recommended to dissolve such companies, paying any back taxes due. That is why we got in contact with the service provider just to have them disused.'   (Updated on Oct. 11th, 2016)</li><li>Not all beneficiaries are aware of offshore trusts in which they are named because the settlor may select beneficiaries without their knowledge.</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX XXXX XX XXXX XXXXXXXXXXXX XX XXXXXXXXX XX XX XXXXXXXXXX XXXXXXXX XX XXX XXXXXX XXXXX XXXX XXXXXXXX.</td>
        <td>2</td>
        <td>28.57%</td>
    </tr>
    <tr>
        <td>XX. XXXXXXX XXñX XXXXXX XXXX X&X XXXXXXXX XXXX XXXX XXXX XXX XXX XXXX XX XXXXXXXXXX XXX XXX XXXXXX XX XXXX XXXXXX XXX XXXXXXXXX XXXXXXXX XXXXXXXXXX XXX., XXXXXXXX XXXXXXXX XXXXXXX XXX XXXX XXXXXXXX XXX. XX XXXX XXXX XXXX XXXXX XXXXXX XXX XXXXXXXXXX XX XXXX XX XXX XX XXX XXXXXXX XXXXX XXXXX XX XXXX XXXX X XXXXXXXXX XXXX XXXXXX XXXXXXXXXXX XX XXXXX. 'XX X XXXXX XXXXX, XX XXXXXXXXXX XXX XXXXXX XXXX 9 XXXXXXXX XX XXXXXX (XXX XX XX XXXX XXXX XXXX), XXX XXXX XXXXXXX XXXX XX XXXXXXXXXXX XX XXXXXXXX XXXX XXXXXXXXX, XXXXXX XXX XXXX XXXXX XXX. XXXX XX XXX XX XXX XX XXXXXXX XXXX XXX XXXXXXX XXXXXXXX XXXX XX XXXX XXXX XXXXXXX.'   (XXXXXXX XX XXX. 99XX, 9999)</td>
        <td>1</td>
        <td>14.29%</td>
    </tr>
    <tr>
        <td>XX. XXXXXX XXXX XXXX XXXX XXXX XXXXXXXXXXX XXXXXXXXX XXXXXXXXXX, XXX. XXXXX XXX XXXXXXX XXXXXXX XX XXXXXXXXXX XXXXX XXX XXXX XXXXXX-XXXXXXX XXXXXXXX XXXXXXXXXX XXX XXXXXXX XX 9999. XXXXXX XXXXXX XXXXXXXXX XXXX XXXX XXXXXXXXXXX XXXXXXXXX XXXXXXXXXX XXX XXXXXXX XX XXXXXXX XXXXXXX XXXXXXX XXX XXXXXX XX XX XXXXXX XXXXX. XXX XXXXXXX XXX XX XXXXXXXXX XXXX XXXXXXX XXXXX XXXXXXXXXXX XXX XXXX XXXXXXX XXXX XXX XXXX XXXXXXX.  (XXXXXXX XX XXX. 99XX, 9999)</td>
        <td>1</td>
        <td>14.29%</td>
    </tr>
    <tr>
        <td>XX XXX XXXXXXX XXXXXXX XXXXXXXX XXXXXXXX XX XXXX, XXXXXXX XXXXXX XXX XXXXXX XXXXX XXXXXX XX XXXXXXXXXX XXXXXX XX XXXXXXXX XXXXXXX XXXXXXX. XXXXXXX XXXXXX XXXX XXXX XXXX XX XXX XXXXXX XXXXX XXX XXX XXXXXXXXXX XXXXXX XX XXX XXXXXXX. XX XXXX XXXX XXXX XXX XXXXXXXX XXXXX XXX XXXXXXXXX XXXXXXXX XXXXXXX, X XXXXXXXXX XXXXXXX XXXXXXXX XX XXXXXXXXX XXXX XXXXXXX XXXXXXXX. XXXXXX XXXXXXXX X XXXXXX XXXXXX XX X XXXXXXX XXXXXXX XXXXXXXXXXXXXX XXXX XXXXXX “XXXXXXXXX XX XXXXXXX XXXXXXX XX XXX XXXXXX XX XXXX 9, 9999 XXXXXXX XX. XXXXXXX XXXXXX XXX XXX. XXXXXX XXXXX XXX XXX XXXXXXXX XXXXXXXXXX XXXXX XX XXX XXXXXXX. XX. XXXXXX XXXXXXXX, XXXXXX XXXXXXX XXXX XXXXXXX: 99, X. XXXXXXX XXX. XXX 9, 9999, XXXXXXX, XXXXXXX XX XXX XXXXXXXX XXXXXXXXXX XXXXX XX XXX XXXXXXX.” (XXXX XXXXXXX XX XXXXXX 99XX XXX XXXXXXXX 99XX, 9999 XXX XXXXXXXXXXXXX XXXXXXX XX XXXXXXXX 9XX XXX 99XX, 9999).</td>
        <td>1</td>
        <td>14.29%</td>
    </tr>
    <tr>
        <td>X XXXXXXXXXXXXXX XXXX XXX XXXX XXXX XXXX XXX XXX XXXXXX XX XXXXXXXX XXX XX XXXXXXXXXXX XXXX XXXXXXX XXXX XXXXXXXXXXX XX XXXXXXXXXX XXXXXXXXXXX XXXXXXXX XXX XXXX XX. XXXXX, XXX XX X XXXXXX XXXXXXXX XX XXX XXXXXXXXXX, XXX XXX XXXXXX XXXXXXXXX XX XXX XXXXXXXXX. “XX XXXX XXXXXX XXXX XX. XXXXX, XXX XXXXXXXXX XXXX XXX XXXXXXXXXXXX XXX XXXXXXX XXX, XXXXXXXXXX XXXXXXXXXX XXXXXXXX, XXX XXXXXXX XXXX XXXXXXXXXXX, XXX XXX XXX XXXXXX XX XXXXXXXX XXX XX XXXXXXXXXXX. XXX XXX XXXXXXX XXXXXXX XXXX XX XXXXXXX XXXX XXX XXX XXXXXXXXXXXXX XXXX XXXXX XXXXX XXXXXXXX,” XXX XXXXXXXXXXXXXX XXXXX. (XXXXXXX XX XXXXXX 99XX, 9999)</td>
        <td>1</td>
        <td>14.29%</td>
    </tr>
    <tr>
        <td>XXX XXX XXXXXXXXXXXXX XXX XXXXX XX XXXXXXXX XXXXXX XX XXXXX XXXX XXX XXXXX XXXXXXX XXX XXXXXXX XXX XXXXXX XXXXXXXXXXXXX XXXXXXX XXXXX XXXXXXXXX.</td>
        <td>1</td>
        <td>14.29%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-nodes-officers"></a>Dataset: nodes-officers

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>nodes-officers</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about officers, such as directors, shareholders, or beneficiaries, associated with offshore entities.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>nodes-officers</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>7</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>771315</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>154263</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>0.9967</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>0</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-nodes-officers-node_id"></a>**node_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id [<a href="#profile-nodes-officers-node_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each officer node.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column serves as the primary key for the officers dataset. All values are unique, with no nulls. The values range from 5 to 240,556,391.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>80116664</li><li>56012870</li><li>80048374</li><li>12090047</li><li>40732</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240556383.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-name"></a>**name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>name [<a href="#profile-nodes-officers-name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The name of the officer.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.01% of values are null. There are 121,249 unique names out of 154,254 non-null sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>ANATOLY KOVALCHUK</li><li>BAOBAB TRUSTEES LTD. RE ZEBRA TRUST</li><li>SMALL ADRIAN DECOURSEY</li><li>HIRSCHFELD-BRIESUM, JENNIFER ROSE MARIE</li><li>GODDARD ENTERPRISES LTD.</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>200.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-countries"></a>**countries**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>countries [<a href="#profile-nodes-officers-countries">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Full country names associated with the officer's address or nationality.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 39.20% of values are null. The top 3 most frequent countries are Malta with 8,934 occurrences (5.79%), Not identified with 7,965 occurrences (5.16%), and China with 7,583 occurrences (4.92%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Malta</li><li>Hong Kong</li><li>Portugal</li><li>Guernsey</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>74.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-country_codes"></a>**country_codes**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>country_codes [<a href="#profile-nodes-officers-country_codes">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Abbreviated country codes associated with the officer's address or nationality.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 39.02% of values are null. The top 3 most frequent country codes are MLT (Malta) with 8,927 occurrences (5.79%), XXX (Not identified) with 7,965 occurrences (5.16%), and CHN (China) with 7,578 occurrences (4.91%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>GTM</li><li>ESP</li><li>CHE;LIE</li><li>TWN</li><li>CHN</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>27.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>86291</td>
        <td>91.46%</td>
    </tr>
    <tr>
        <td>XXX;XXX</td>
        <td>7228</td>
        <td>7.66%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX</td>
        <td>505</td>
        <td>0.54%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX</td>
        <td>289</td>
        <td>0.31%</td>
    </tr>
    <tr>
        <td>XXX; XXX;XXX</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX;XXX; XXX;XXX</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX;XXX</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX; XXX</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXX;XX</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX;XXX;XXX;XXX</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX;XXX; XXX</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX; XXX;XXX;XXX</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX;XXX;XXX</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-nodes-officers-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the officer record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent source IDs are Panama Papers with 47,749 occurrences (30.95%), Paradise Papers - Barbados corporate registry with 25,470 occurrences (16.51%), and Paradise Papers - Malta corporate registry with 21,341 occurrences (13.83%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Paradise Papers - Appleby</li><li>Paradise Papers - Barbados corporate registry</li><li>Paradise Papers - Malta corporate registry</li><li>Panama Papers</li><li>Paradise Papers - Aruba corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>13.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>57.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>47539</td>
        <td>30.82%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>28887</td>
        <td>18.73%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>25394</td>
        <td>16.46%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>21602</td>
        <td>14.00%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>15411</td>
        <td>9.99%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>5104</td>
        <td>3.31%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXáX, XXXXXXX, XXXXXXX & XXX (XXXXXXX)</td>
        <td>4862</td>
        <td>3.15%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXX XXXXXXXXX XXXXXXXX</td>
        <td>1707</td>
        <td>1.11%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXXX</td>
        <td>1071</td>
        <td>0.69%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXX</td>
        <td>814</td>
        <td>0.53%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>518</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXX XXXXXXXXXX</td>
        <td>518</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXXXXX</td>
        <td>430</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XX XXXX XXXXXXXXX XXXXXXXXXX XXXXXXX</td>
        <td>150</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXX XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>131</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXX XXXXXXX (XXX)</td>
        <td>79</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXX</td>
        <td>44</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-valid_until"></a>**valid_until**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>valid_until [<a href="#profile-nodes-officers-valid_until">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Indicates the period until which the data from the source is considered current.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.07% of values are null. The top 3 most frequent 'valid until' statements are 'The Panama Papers data is current through 2015' with 47,749 occurrences (30.95%), 'Barbados corporate registry data is current through 2016' with 25,470 occurrences (16.51%), and 'Malta corporate registry data is current through 2016' with 21,341 occurrences (13.83%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>The Panama Papers data is current through 2015</li><li>Appleby data is current through 2014</li><li>Malta corporate registry data is current through 2016</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>26.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>129.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX XXXXXX XXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>47539</td>
        <td>30.84%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>28887</td>
        <td>18.74%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>25394</td>
        <td>16.47%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>21602</td>
        <td>14.01%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>15411</td>
        <td>10.00%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>9428</td>
        <td>6.12%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXX XXXX XX XXXXXXX XXXXXXX XXXXX 9999.</td>
        <td>5104</td>
        <td>3.31%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>516</td>
        <td>0.33%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>131</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>XXXX XX XXXXXXX XXXXXXX 9999.</td>
        <td>114</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXX XXXXXX - XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>22</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXX XXXXXXX 9999.</td>
        <td>6</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX XXX</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999. XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX.</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX XX XXXXXXX XXXXXXX 9999.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXXX XX XXXXXXX XXXXXXX 9999. XXXX XX XXXXXXXáX XXñXXX'X XXXX XXXX XXXX 9999 XXX 9999 XXXXXXXX XXXXXXXXX XXXXXXXX XX XXXXX XXXXX.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-officers-note"></a>**note**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>note [<a href="#profile-nodes-officers-note">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Additional notes or comments regarding the officer record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 99.51% of values are null. There are 11 unique notes out of 752 non-null sampled records. The most frequent notes are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>Not all beneficiaries are aware of offshore trusts in which they are named because the settlor may select beneficiaries without their knowledge.</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX XXX XXXXXXXXXXXXX XXX XXXXX XX XXXXXXXX XXXXXX XX XXXXX XXXX XXX XXXXX XXXXXXX XXX XXXXXXX XXX XXXXXX XXXXXXXXXXXXX XXXXXXX XXXXX XXXXXXXXX.</td>
        <td>665</td>
        <td>89.26%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX</td>
        <td>27</td>
        <td>3.62%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXXXX XXX X XXXXX XX XXX XXXX XX XXX XXXXXXXXXXX XX XXX XXXX (XXX 9999). XXX XXX XXXXXXXXXXXXX XXX XXXXX XX XXXXXXXX XXXXXX XX XXXXX XXXX XXX XXXXX XXXXXXX XXX XXXXXXX XXX XXXXXX XXXXXXXXXXXXX XXXXXXX XXXXX XXXXXXXXX.</td>
        <td>24</td>
        <td>3.22%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XXX XXXXXXXXXX XXXX XXXXX XXXX XXXXXXX.</td>
        <td>11</td>
        <td>1.48%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXXXX XXX X XXXXX XX XXX XXXX XX XXX XXXXXXXXXXX XX XXX XXXX (XXX 9999).</td>
        <td>10</td>
        <td>1.34%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXXXX XXXXX XXXX XXXXXX XXXXXXXXX.</td>
        <td>3</td>
        <td>0.40%</td>
    </tr>
    <tr>
        <td>XXX XXXXXXXX XXXX'X XXXXXXX XXXX XXX XXXX XXXXX. (XXXX XXXXX XX XXXX 99XX, 9999)</td>
        <td>1</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX XXXXX XXóX XXXX XXXX XXXX XX XX XXX XXX XXXXX XX XXX XXXXXXX. XX XXXXXXXX X XXXXXX XXXXXX XX X XXXXXXX XXXXXXX XXXXXXXXXXXXXX XXXX XXXXXX “XXXXXXXXX XX XXX XXXXXXX XXX XX XXX XXXXXXXXXXX XXXXXXXX XX XXX XXXXXX XXX XXXXXX, XXXXXX XXXXXX XXXXX XXóX XX XXX XXXXXXXXXXX XXX XXXXXXXXXX XXXXX XX XXXXXX XXXXXXXXX XXX.” (XXXXXXX XX XXXXXXXXX 99XX, 9999)</td>
        <td>1</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXXXXX XXXXXXXXX XXX XXXXX XXX XXXXXXXXX XX XXXXXXXX XX XXXXXX XXX XXXXX XX XXXX XXXXXXXXX XX XXX XXXXXXX XXXXXXXX XXXXXXXX. XXXX XXXXXXXXXXXX XXXXXXX XXXX XXXX XXXX XXX XXXXXXXXX, XXX XXXX XXX XXXXXX XXXXXXXX XXXX XXX XXXXXXXXXX XXXX XXX XXXXXXX. XXXX XXXXXXXXX XXXXXXX XXX XXXXXXXX' XXXXX XXX XXXXXXXXX XXXX XXX XXXXXXXX (9XX XXXX 9999)</td>
        <td>1</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>XX. XXXXXXXXXXX XXXXXX XXXXX X XXXXXXXXXXX XXX XXXXXXX XX XXXXXX XXXXXXXXXX XXXXXXX XX XXX 99XX XX XXXXX 9999 XXXX XXX XXXXXXX XXX XXXXXXXXX, XXXXXXXXX XX XXXXXXXXXX XXXXXXXXXXX XXXXXXXX XX XXXX (XXXX XXXXX XX XXXXXXXX 99XX, 9999).</td>
        <td>1</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>XXX XXXX XXXXXXX XXXXXXX 9999. XXXX XX XXXXXXXáX XXñXXX'X XXXX XXXXX XXXX 9999 XXXXXXXX XXXXXXXXX XXXXXXXX XX XXXXX XXXXX XXX XXXXXXXóX XXXXXXíXXXXX XXXXX.</td>
        <td>1</td>
        <td>0.13%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-nodes-others"></a>Dataset: nodes-others

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>nodes-others</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset contains information about other types of entities or organizations not classified as offshore entities, intermediaries, officers, or addresses.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>nodes-others</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>13</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>2989</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>2989</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>1.0</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>0</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-nodes-others-node_id"></a>**node_id**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id [<a href="#profile-nodes-others-node_id">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A unique identifier for each 'other' node.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column serves as the primary key for the 'others' dataset. All values are unique, with no nulls. The values range from 80,000,012 to 240,558,070.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>85033671</li><li>85038383</li><li>80096619</li><li>80072625</li><li>80020720</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>80000012.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240558070.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-name"></a>**name**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>name [<a href="#profile-nodes-others-name">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The name of the 'other' entity or organization.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.03% of values are null. There are 2,975 unique names out of 2,988 non-null sampled records, indicating high uniqueness. The most frequent names are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>RPM PIZZA ARUBA N.V.</li><li>Peter Ronald Millson Settlement</li><li>SAVANETA HEALTH & BEAUTY SPA N.V.</li><li>Credit Suisse Securities (USA) LLC</li><li>Group - Treetop</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>155.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-type"></a>**type**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>type [<a href="#profile-nodes-others-type">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The type or category of the 'other' entity.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 70.30% of values are null. The top 3 most frequent types are LIMITED LIABILITY COMPANY with 881 occurrences (29.48%), SOLE OWNERSHIP with 4 occurrences (0.13%), and FOREIGN FORMED CORPORATION with 3 occurrences (0.10%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>LIMITED LIABILITY COMPANY</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-type">REF-type</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>14.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>26.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXXXXX XXXXXXX</td>
        <td>881</td>
        <td>99.21%</td>
    </tr>
    <tr>
        <td>XXXX XXXXXXXXX</td>
        <td>4</td>
        <td>0.45%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX XXXXXXXXXXX</td>
        <td>3</td>
        <td>0.34%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-incorporation_date"></a>**incorporation_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>incorporation_date [<a href="#profile-nodes-others-incorporation_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the 'other' entity was incorporated.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 70.30% of values are null. The date format is DD-MMM-YYYY. There are 834 unique incorporation dates out of 888 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>16-APR-1993</li><li>23-JUN-2009</li><li>10-AUG-2005</li><li>18-NOV-1996</li><li>03-FEB-2004</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-struck_off_date"></a>**struck_off_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>struck_off_date [<a href="#profile-nodes-others-struck_off_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the 'other' entity was officially struck off the registry.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 98.49% of values are null. The date format is DD-MMM-YYYY. There are 39 unique struck off dates out of 45 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>29-MAY-2006</li><li>31-DEC-1999</li><li>22-FEB-2005</li><li>31-JAN-1998</li><li>30-AUG-2001</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-closed_date"></a>**closed_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>closed_date [<a href="#profile-nodes-others-closed_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the 'other' entity was closed.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 96.08% of values are null. The date format is DD-MMM-YYYY. There are 112 unique closed dates out of 117 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>20-JAN-2011</li><li>16-AUG-2010</li><li>07-JUL-2010</li><li>18-MAY-2004</li><li>17-DEC-1997</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-jurisdiction"></a>**jurisdiction**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>jurisdiction [<a href="#profile-nodes-others-jurisdiction">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The abbreviated code for the jurisdiction where the 'other' entity is registered.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 67.95% of values are null. The top 3 most frequent jurisdictions are AW (Aruba) with 888 occurrences (29.71%), VGB (British Virgin Islands) with 62 occurrences (2.07%), and BLZ (Belize) with 3 occurrences (0.10%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>AW</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-jurisdiction">REF-jurisdiction</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>2.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>3.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XX</td>
        <td>888</td>
        <td>92.69%</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>70</td>
        <td>7.31%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-jurisdiction_description"></a>**jurisdiction_description**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>jurisdiction_description [<a href="#profile-nodes-others-jurisdiction_description">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The full name of the jurisdiction where the 'other' entity is registered.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 67.95% of values are null. The top 3 most frequent jurisdiction descriptions are Aruba with 888 occurrences (29.71%), British Virgin Islands with 62 occurrences (2.07%), and Belize with 3 occurrences (0.10%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>British Virgin Islands</li><li>Aruba</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-jurisdiction_description">REF-jurisdiction_description</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>5.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>22.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXX</td>
        <td>890</td>
        <td>92.90%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX XXXXXXX</td>
        <td>62</td>
        <td>6.47%</td>
    </tr>
    <tr>
        <td>XXXXXX</td>
        <td>5</td>
        <td>0.52%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXX</td>
        <td>1</td>
        <td>0.10%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-countries"></a>**countries**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>countries [<a href="#profile-nodes-others-countries">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Full country names associated with the 'other' entity's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 87.09% of values are null. The top 3 most frequent countries are Isle of Man with 105 occurrences (3.51%), Cayman Islands with 79 occurrences (2.64%), and United Kingdom with 26 occurrences (0.87%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Israel</li><li>Isle of Man</li><li>British Virgin Islands;Isle of Man</li><li>India</li><li>Australia</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-countries">REF-countries</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>4.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>41.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-country_codes"></a>**country_codes**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>country_codes [<a href="#profile-nodes-others-country_codes">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Abbreviated country codes associated with the 'other' entity's address or operations.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 87.09% of values are null. The top 3 most frequent country codes are IMN (Isle of Man) with 105 occurrences (3.51%), CYM (Cayman Islands) with 79 occurrences (2.64%), and GBR (United Kingdom) with 26 occurrences (0.87%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>IMN</li><li>IRL</li><li>MCO</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-country_codes">REF-country_codes</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>3.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>15.0</td>
    </tr></table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>separator</td>
        <td>;</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXX</td>
        <td>352</td>
        <td>91.19%</td>
    </tr>
    <tr>
        <td>XXX;XXX</td>
        <td>32</td>
        <td>8.29%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX</td>
        <td>1</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>XXX;XXX;XXX;XXX</td>
        <td>1</td>
        <td>0.26%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-nodes-others-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the 'other' entity record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent source IDs are Paradise Papers - Appleby with 2,031 occurrences (67.95%), Paradise Papers - Aruba corporate registry with 888 occurrences (29.71%), and Pandora Papers - Trident Trust with 49 occurrences (1.64%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Paradise Papers - Aruba corporate registry</li><li>Paradise Papers - Appleby</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>25.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>57.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>2031</td>
        <td>67.95%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>888</td>
        <td>29.71%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXX XXXXX</td>
        <td>49</td>
        <td>1.64%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXX XXXXXXX (XXX)</td>
        <td>11</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXáX, XXXXXXX, XXXXXXX & XXX (XXXXXXX)</td>
        <td>5</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXXXXXX</td>
        <td>3</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>2</td>
        <td>0.07%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-valid_until"></a>**valid_until**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>valid_until [<a href="#profile-nodes-others-valid_until">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Indicates the period until which the data from the source is considered current.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent 'valid until' statements are 'Appleby data is current through 2014' with 2,031 occurrences (67.95%), 'Aruba corporate registry data is current through 2016' with 888 occurrences (29.71%), and 'Provider data is current through 2017' with 35 occurrences (1.17%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Provider data is current through 2017</li><li>Appleby data is current through 2014</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-valid_until">REF-valid_until</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>36.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>53.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>2031</td>
        <td>67.95%</td>
    </tr>
    <tr>
        <td>XXXXX XXXXXXXXX XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>888</td>
        <td>29.71%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXX XX XXXXXXX XXXXXXX 9999</td>
        <td>70</td>
        <td>2.34%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-nodes-others-note"></a>**note**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>note [<a href="#profile-nodes-others-note">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>Additional notes or comments regarding the 'other' entity record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 96.08% of values are null. The top 2 most frequent notes are 'Closed date stands for Cancelled date.' with 90 occurrences (3.01%) and 'Closed date stands for Liquidation date.' with 27 occurrences (0.90%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>Closed date stands for Cancelled date.</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-note">REF-note</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>38.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>40.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXX XXXX.</td>
        <td>90</td>
        <td>76.92%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXX XXXXXX XXX XXXXXXXXXXX XXXX.</td>
        <td>27</td>
        <td>23.08%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### <a id="dataset-relationships"></a>Dataset: relationships

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>relationships</td>
        </tr>
    <tr>
        <td>Type</td>
        <td>csv</td>
        </tr>
    <tr>
        <td>Description</td>
        <td>This dataset describes the various relationships between different nodes (entities, intermediaries, officers, addresses) in the offshore data, including the type of relationship and its duration.</td>
        </tr>
    <tr>
        <td>Code</td>
        <td>relationships</td>
        </tr>
    <tr>
        <td>Column Count</td>
        <td>8</td>
        </tr>
    <tr>
        <td>Row Count</td>
        <td>3339267</td>
        </tr>
    <tr>
        <td>Samples Used</td>
        <td>667853</td>
        </tr>
    <tr>
        <td>Unique Row Ratio</td>
        <td>0.9976</td>
        </tr>
    <tr>
        <td>Row Has Null Ratio</td>
        <td>0.9617</td>
        </tr>
    <tr>
        <td>Duplicate Row Count</td>
        <td>8177</td>
        </tr>
    <tr>
        <td>Row Is Null Ratio</td>
        <td>0.0</td>
        </tr>
    <tr>
        </tr>
    </table>

### Columns:

<a id="column-relationships-node_id_start"></a>**node_id_start**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id_start [<a href="#profile-relationships-node_id_start">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The unique identifier of the starting node in a relationship.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-nodes-entities">nodes-entities</a>: <a href="#column-nodes-entities-node_id">node_id_start</a><br><a href="#dataset-nodes-intermediaries">nodes-intermediaries</a>: <a href="#column-nodes-intermediaries-node_id">node_id_start</a><br><a href="#dataset-nodes-others">nodes-others</a>: <a href="#column-nodes-others-node_id">node_id_start</a><br><a href="#dataset-nodes-addresses">nodes-addresses</a>: <a href="#column-nodes-addresses-node_id">node_id_start</a><br><a href="#dataset-nodes-officers">nodes-officers</a>: <a href="#column-nodes-officers-node_id">node_id_start</a><br></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column is part of the composite primary key for the relationships dataset. No null values. The values range from 3 to 240,558,062. Approximately 56.04% of values are unique.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>80005425</li><li>56017402</li><li>56062722</li><li>101728311</li><li>56068474</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>1.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240558065.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-node_id_end"></a>**node_id_end**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>node_id_end [<a href="#profile-relationships-node_id_end">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>int</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The unique identifier of the ending node in a relationship.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td><a href="#dataset-nodes-entities">nodes-entities</a>: <a href="#column-nodes-entities-node_id">node_id_end</a><br><a href="#dataset-nodes-intermediaries">nodes-intermediaries</a>: <a href="#column-nodes-intermediaries-node_id">node_id_end</a><br><a href="#dataset-nodes-others">nodes-others</a>: <a href="#column-nodes-others-node_id">node_id_end</a><br><a href="#dataset-nodes-addresses">nodes-addresses</a>: <a href="#column-nodes-addresses-node_id">node_id_end</a><br><a href="#dataset-nodes-officers">nodes-officers</a>: <a href="#column-nodes-officers-node_id">node_id_end</a></td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>This column is part of the composite primary key for the relationships dataset. No null values. The values range from 27 to 240,556,377. Approximately 65.52% of values are unique.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>240009676</li><li>55040548</li><li>82013014</li><li>14083199</li><li>10131969</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Value</td>
        <td>498.0</td>
    </tr><tr>
        <td>Max Value</td>
        <td>240558042.0</td>
    </tr></table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-rel_type"></a>**rel_type**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>rel_type [<a href="#profile-relationships-rel_type">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The general type of relationship between the two nodes.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>No null values. The top 3 most frequent relationship types are officer_of with 343,511 occurrences (51.44%), registered_address with 167,092 occurrences (25.02%), and intermediary_of with 119,847 occurrences (17.95%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>officer_of</li><li>registered_address</li><li>same_name_as</li><li>intermediary_of</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-rel_type">REF-rel_type</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>7.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>24.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXX_XX</td>
        <td>344665</td>
        <td>51.61%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXX_XXXXXXX</td>
        <td>166150</td>
        <td>24.88%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXXXX_XX</td>
        <td>119545</td>
        <td>17.90%</td>
    </tr>
    <tr>
        <td>XXXX_XXXX_XX</td>
        <td>20757</td>
        <td>3.11%</td>
    </tr>
    <tr>
        <td>XXXXXXX</td>
        <td>9423</td>
        <td>1.41%</td>
    </tr>
    <tr>
        <td>XXXX_XXXXXXX_XX</td>
        <td>3091</td>
        <td>0.46%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX_XX</td>
        <td>2400</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>XXXX_XX</td>
        <td>869</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>XXXX_XX_XX</td>
        <td>643</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>XXXXXXXXXX</td>
        <td>245</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>XXXXXXX_XXXXXXX_XX</td>
        <td>41</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XXXXXXXX_XXXX_XXXXXXX_XX</td>
        <td>24</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-link"></a>**link**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>link [<a href="#profile-relationships-link">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>text</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>A more specific description of the relationship, detailing the role or connection.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 0.01% of values are null. The top 3 most frequent links are shareholder of with 117,356 occurrences (17.57%), registered address with 113,501 occurrences (17.00%), and intermediary of with 102,788 occurrences (15.39%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>shareholder of</li><li>secretary of</li><li>registered address</li><li>director</li><li>intermediary of</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>

</table>



<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-status"></a>**status**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>status [<a href="#profile-relationships-status">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The status of the relationship (e.g., appointed, resigned).</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 94.76% of values are null. The top 2 most frequent statuses are Resigned with 26,208 occurrences (3.92%) and Appointed with 8,759 occurrences (1.31%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>Resigned</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-status">REF-status</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>8.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>9.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXX</td>
        <td>26197</td>
        <td>74.94%</td>
    </tr>
    <tr>
        <td>XXXXXXXXX</td>
        <td>8762</td>
        <td>25.06%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-start_date"></a>**start_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>start_date [<a href="#profile-relationships-start_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the relationship began.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 71.64% of values are null. The date formats are DD-MMM-YYYY and YYYY-MM-DD. There are 17,849 unique start dates out of 189,414 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>26-SEP-2008</li><li>26-APR-2007</li><li>25-MAY-1988</li><li>2004-09-08</li><li>2007-02-08</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td>DD-MMM-YYYY</td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>140917</td>
        <td>74.36%</td>
    </tr>
    <tr>
        <td>9999-99-99</td>
        <td>46153</td>
        <td>24.35%</td>
    </tr>
    <tr>
        <td>99/99/9999</td>
        <td>2003</td>
        <td>1.06%</td>
    </tr>
    <tr>
        <td>9/9/9999</td>
        <td>150</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>99/99/99</td>
        <td>102</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>9/99/9999</td>
        <td>93</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>99/9/9999</td>
        <td>60</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>99.99.9999</td>
        <td>20</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>99/9/99</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9/9/99</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9/99/99</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9999</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9.99.9999</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>99/99/999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>99999999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-end_date"></a>**end_date**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>end_date [<a href="#profile-relationships-end_date">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>date</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The date when the relationship ended.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 91.98% of values are null. The date formats are DD-MMM-YYYY and YYYY-MM-DD. There are 9,134 unique end dates out of 53,512 non-null sampled records, indicating high uniqueness. The most frequent dates are not provided in the sample statistics.</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>08-OCT-2008</li><li>2001-11-02</li><li>11-OCT-2001</li><li>14-SEP-2012</li><li>01-JAN-2012</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    </table>


#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>dateFormat</td>
        <td><ul><li>DD-MMM-YYYY</li><li>YYYY-MM-DD</li></ul></td>
    </tr>
    </table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>99-XXX-9999</td>
        <td>47722</td>
        <td>88.66%</td>
    </tr>
    <tr>
        <td>9999-99-99</td>
        <td>5995</td>
        <td>11.14%</td>
    </tr>
    <tr>
        <td>99/99/9999</td>
        <td>104</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>*</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX-9999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>99/99/99</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>9/99/9999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>99.99.9999</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


<a id="column-relationships-sourceID"></a>**sourceID**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>sourceID [<a href="#profile-relationships-sourceID">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>string</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>The source of the data for the relationship record.</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>Approximately 15.53% of values are null. The top 3 most frequent source IDs are Paradise Papers - Malta corporate registry with 154,904 occurrences (23.19%), Panama Papers with 134,884 occurrences (20.19%), and Offshore Leaks with 112,525 occurrences (16.85%).</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>False</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td><ul><li>Panama Papers</li><li>Offshore Leaks</li></ul></td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>None</td>
    </tr>
    <tr>
        <td>Null or Empty</td>
        <td>True</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td><a href="#ref-dataset-REF-sourceID">REF-sourceID</a></td>
    </tr>
    <tr>
        <td>Order</td>
        <td>random</td>
    </tr>
    <tr>
        <td>Min Length</td>
        <td>13.0</td>
    </tr><tr>
        <td>Max Length</td>
        <td>49.0</td>
    </tr></table>

</table>


#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXX XXXXXXXXX XXXXXXXX</td>
        <td>184516</td>
        <td>32.70%</td>
    </tr>
    <tr>
        <td>XXXXXX XXXXXX</td>
        <td>134911</td>
        <td>23.91%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXX</td>
        <td>112206</td>
        <td>19.89%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX</td>
        <td>78106</td>
        <td>13.84%</td>
    </tr>
    <tr>
        <td>XXXXXXX XXXXX</td>
        <td>49840</td>
        <td>8.83%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>3996</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXX XXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>660</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>XXXXXXXX XXXXXX - XXXXXXXX XXXXXXXXX XXXXXXXX</td>
        <td>9</td>
        <td>0.00%</td>
    </tr>
    </table>


<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------


-------------------------


### Data Profile:

### <a href="#dataset-nodes-addresses">Dataset: nodes-addresses</a>

<a id="profile-nodes-addresses-node_id"></a><a href="#column-nodes-addresses-node_id">**node_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>67302.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240492574.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>58130005.188</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>58096205.2234</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>4824885884532.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>59974466.8614</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>3499507918946235.5</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>59156638.8408</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.7334</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>3.146</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>67302.0</li><li>3149677.28205128</li><li>237410199.0</li><li>240492574.0</li></ul>bin_counts: <ul><li>11408.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>5448.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 14104765.88721: 58096205.22342: 80952547.2202
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0074</li><li>0.0078</li><li>0.0104</li><li>0.0001</li><li>0.0001</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-address"></a><a href="#column-nodes-addresses-address">**address**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>4011</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>210834</li><li>210836</li><li>210838</li><li>390985</li><li>390991</li><li>390992</li></ul>-----: <ul><li>88696</li></ul>-: <ul><li>86870</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>667.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>48.2175</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>48.9411</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>3933355.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>51.4581</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>567.2064</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>23.8161</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.8204</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>6.3336</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>3.45833333</li><li>665.54166667</li><li>667.0</li></ul>bin_counts: <ul><li>11.0</li><li>10.0</li><li>47.0</li><li>163.0</li><li>322.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 34.77141: 48.94112: 66.4592
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>臨</li><li>"</li><li>2</li><li>s</li><li>Ș</li><li>深</li><li>a</li><li>\</li><li>Œ</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>76169</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9965</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0232</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0068</li><li>0.0068</li><li>0.0111</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-name"></a><a href="#column-nodes-addresses-name">**name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>35697</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>5</li><li>6</li><li>9</li><li>12</li><li>402231</li><li>402237</li><li>402238</li><li>402245</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>186.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>36.0875</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>48.0957</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2330744.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>52.0813</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>435.8409</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>20.8768</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0686</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>1.559</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>7.0</li><li>8.51694915</li><li>184.48305085</li><li>186.0</li></ul>bin_counts: <ul><li>3.0</li><li>4.0</li><li>4.0</li><li>13.0</li><li>27.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 36.9141: 48.09572: 63.9755
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>U</li><li>臨</li><li>"</li><li>2</li><li>/</li><li>¤</li><li>E</li><li>a</li><li>\</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>44730</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9995</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0131</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0041</li><li>0.004</li><li>0.0069</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-countries"></a><a href="#column-nodes-addresses-countries">**countries**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>24990</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>2154</li><li>3137</li><li>5549</li><li>6687</li><li>401737</li><li>401747</li><li>401769</li><li>401822</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>33.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>4.995</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.9897</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9487</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9487</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>479712.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.6498</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>16.198</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.0247</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.7213</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>4.0459</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>3.20833333</li><li>32.79166667</li><li>33.0</li></ul>bin_counts: <ul><li>369.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>363.0</li><li>115.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.00381: 7.98972: 10.0073
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li>C</li><li> </li><li>K</li><li>E</li><li>G</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>China</li><li>Hong Kong</li><li>United States</li><li>ALB</li><li>NZL</li><li>SAU</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>284</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0051</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>55459</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0049</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.005</li><li>0.0049</li><li>0.0072</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>China</td>
        <td>6613</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>5643</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>4954</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>3880</td>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>3502</td>
    </tr>
    <tr>
        <td>Taiwan</td>
        <td>3272</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>2387</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>1491</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>1413</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>1156</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>1002</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>793</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>740</td>
    </tr>
    <tr>
        <td>Indonesia</td>
        <td>701</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>682</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>680</td>
    </tr>
    <tr>
        <td>Malaysia</td>
        <td>664</td>
    </tr>
    <tr>
        <td>Brazil</td>
        <td>653</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>645</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>634</td>
    </tr>
    <tr>
        <td>Macedonia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Benin</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Togo</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Palestine</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PHL</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BLR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CIV</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ALB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SAU</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-country_codes"></a><a href="#column-nodes-addresses-country_codes">**country_codes**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>24990</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>2154</li><li>3137</li><li>5549</li><li>6687</li><li>401737</li><li>401747</li><li>401769</li><li>401822</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9482</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9482</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>166377.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0002</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>55459</li></ul>bin_edges: <ul><li>3.0</li><li>3.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.01: 3.02: 3.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li>C</li><li>F</li><li>H</li><li>E</li><li>M</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>CHN</li><li>HKG</li><li>USA</li><li>BRB</li><li>BEN</li><li>TGO</li><li>PSE</li><li>TUV</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>197</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0036</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>55459</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0033</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.005</li><li>0.0051</li><li>0.0024</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>CHN</td>
        <td>6613</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>5645</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>4958</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>3880</td>
    </tr>
    <tr>
        <td>ABW</td>
        <td>3502</td>
    </tr>
    <tr>
        <td>TWN</td>
        <td>3275</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>2428</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>1699</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>1492</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>1179</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>1011</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>793</td>
    </tr>
    <tr>
        <td>BMU</td>
        <td>740</td>
    </tr>
    <tr>
        <td>IDN</td>
        <td>702</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>692</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>682</td>
    </tr>
    <tr>
        <td>MYS</td>
        <td>665</td>
    </tr>
    <tr>
        <td>BRA</td>
        <td>661</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>647</td>
    </tr>
    <tr>
        <td>CAN</td>
        <td>639</td>
    </tr>
    <tr>
        <td>ARG</td>
        <td>504</td>
    </tr>
    <tr>
        <td>IMN</td>
        <td>485</td>
    </tr>
    <tr>
        <td>AUS</td>
        <td>469</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>460</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>450</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>419</td>
    </tr>
    <tr>
        <td>ZAF</td>
        <td>419</td>
    </tr>
    <tr>
        <td>UKR</td>
        <td>359</td>
    </tr>
    <tr>
        <td>THA</td>
        <td>342</td>
    </tr>
    <tr>
        <td>FRA</td>
        <td>334</td>
    </tr>
    <tr>
        <td>JPN</td>
        <td>313</td>
    </tr>
    <tr>
        <td>ISR</td>
        <td>284</td>
    </tr>
    <tr>
        <td>IND</td>
        <td>268</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>264</td>
    </tr>
    <tr>
        <td>URY</td>
        <td>263</td>
    </tr>
    <tr>
        <td>ITA</td>
        <td>253</td>
    </tr>
    <tr>
        <td>PER</td>
        <td>247</td>
    </tr>
    <tr>
        <td>COL</td>
        <td>245</td>
    </tr>
    <tr>
        <td>VEN</td>
        <td>241</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>227</td>
    </tr>
    <tr>
        <td>ESP</td>
        <td>227</td>
    </tr>
    <tr>
        <td>LUX</td>
        <td>211</td>
    </tr>
    <tr>
        <td>DEU</td>
        <td>205</td>
    </tr>
    <tr>
        <td>SYC</td>
        <td>196</td>
    </tr>
    <tr>
        <td>NLD</td>
        <td>189</td>
    </tr>
    <tr>
        <td>PHL</td>
        <td>187</td>
    </tr>
    <tr>
        <td>IRL</td>
        <td>179</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>175</td>
    </tr>
    <tr>
        <td>KOR</td>
        <td>169</td>
    </tr>
    <tr>
        <td>LIE</td>
        <td>159</td>
    </tr>
    <tr>
        <td>ECU</td>
        <td>156</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>155</td>
    </tr>
    <tr>
        <td>LBN</td>
        <td>154</td>
    </tr>
    <tr>
        <td>GTM</td>
        <td>152</td>
    </tr>
    <tr>
        <td>TUR</td>
        <td>152</td>
    </tr>
    <tr>
        <td>SAU</td>
        <td>151</td>
    </tr>
    <tr>
        <td>MEX</td>
        <td>130</td>
    </tr>
    <tr>
        <td>GRC</td>
        <td>129</td>
    </tr>
    <tr>
        <td>CUW</td>
        <td>117</td>
    </tr>
    <tr>
        <td>GIB</td>
        <td>116</td>
    </tr>
    <tr>
        <td>NOR</td>
        <td>115</td>
    </tr>
    <tr>
        <td>BEL</td>
        <td>115</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>113</td>
    </tr>
    <tr>
        <td>CHL</td>
        <td>99</td>
    </tr>
    <tr>
        <td>PRT</td>
        <td>94</td>
    </tr>
    <tr>
        <td>MLT</td>
        <td>93</td>
    </tr>
    <tr>
        <td>KAZ</td>
        <td>87</td>
    </tr>
    <tr>
        <td>SWE</td>
        <td>81</td>
    </tr>
    <tr>
        <td>CRI</td>
        <td>80</td>
    </tr>
    <tr>
        <td>DOM</td>
        <td>76</td>
    </tr>
    <tr>
        <td>MAC</td>
        <td>74</td>
    </tr>
    <tr>
        <td>NGA</td>
        <td>74</td>
    </tr>
    <tr>
        <td>EGY</td>
        <td>73</td>
    </tr>
    <tr>
        <td>JOR</td>
        <td>72</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>70</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>64</td>
    </tr>
    <tr>
        <td>KEN</td>
        <td>63</td>
    </tr>
    <tr>
        <td>CZE</td>
        <td>62</td>
    </tr>
    <tr>
        <td>VNM</td>
        <td>53</td>
    </tr>
    <tr>
        <td>BGR</td>
        <td>51</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>51</td>
    </tr>
    <tr>
        <td>KWT</td>
        <td>48</td>
    </tr>
    <tr>
        <td>POL</td>
        <td>45</td>
    </tr>
    <tr>
        <td>PAK</td>
        <td>45</td>
    </tr>
    <tr>
        <td>HUN</td>
        <td>45</td>
    </tr>
    <tr>
        <td>AUT</td>
        <td>45</td>
    </tr>
    <tr>
        <td>ZWE</td>
        <td>44</td>
    </tr>
    <tr>
        <td>ROU</td>
        <td>43</td>
    </tr>
    <tr>
        <td>ISL</td>
        <td>41</td>
    </tr>
    <tr>
        <td>AIA</td>
        <td>40</td>
    </tr>
    <tr>
        <td>AZE</td>
        <td>39</td>
    </tr>
    <tr>
        <td>QAT</td>
        <td>37</td>
    </tr>
    <tr>
        <td>NIU</td>
        <td>35</td>
    </tr>
    <tr>
        <td>UZB</td>
        <td>34</td>
    </tr>
    <tr>
        <td>MDA</td>
        <td>33</td>
    </tr>
    <tr>
        <td>HTI</td>
        <td>33</td>
    </tr>
    <tr>
        <td>EST</td>
        <td>32</td>
    </tr>
    <tr>
        <td>SLV</td>
        <td>30</td>
    </tr>
    <tr>
        <td>SRB</td>
        <td>30</td>
    </tr>
    <tr>
        <td>FIN</td>
        <td>29</td>
    </tr>
    <tr>
        <td>BLR</td>
        <td>29</td>
    </tr>
    <tr>
        <td>COK</td>
        <td>29</td>
    </tr>
    <tr>
        <td>JAM</td>
        <td>26</td>
    </tr>
    <tr>
        <td>BHR</td>
        <td>26</td>
    </tr>
    <tr>
        <td>AGO</td>
        <td>26</td>
    </tr>
    <tr>
        <td>DNK</td>
        <td>26</td>
    </tr>
    <tr>
        <td>TCA</td>
        <td>25</td>
    </tr>
    <tr>
        <td>HND</td>
        <td>25</td>
    </tr>
    <tr>
        <td>TTO</td>
        <td>24</td>
    </tr>
    <tr>
        <td>LCA</td>
        <td>23</td>
    </tr>
    <tr>
        <td>VIR</td>
        <td>23</td>
    </tr>
    <tr>
        <td>LTU</td>
        <td>22</td>
    </tr>
    <tr>
        <td>MHL</td>
        <td>22</td>
    </tr>
    <tr>
        <td>DMA</td>
        <td>21</td>
    </tr>
    <tr>
        <td>AND</td>
        <td>20</td>
    </tr>
    <tr>
        <td>MAR</td>
        <td>19</td>
    </tr>
    <tr>
        <td>BWA</td>
        <td>18</td>
    </tr>
    <tr>
        <td>IRN</td>
        <td>18</td>
    </tr>
    <tr>
        <td>VUT</td>
        <td>18</td>
    </tr>
    <tr>
        <td>ARM</td>
        <td>17</td>
    </tr>
    <tr>
        <td>GEO</td>
        <td>17</td>
    </tr>
    <tr>
        <td>SVK</td>
        <td>16</td>
    </tr>
    <tr>
        <td>FJI</td>
        <td>16</td>
    </tr>
    <tr>
        <td>CIV</td>
        <td>16</td>
    </tr>
    <tr>
        <td>DZA</td>
        <td>16</td>
    </tr>
    <tr>
        <td>OMN</td>
        <td>15</td>
    </tr>
    <tr>
        <td>HRV</td>
        <td>14</td>
    </tr>
    <tr>
        <td>SVN</td>
        <td>14</td>
    </tr>
    <tr>
        <td>BGD</td>
        <td>13</td>
    </tr>
    <tr>
        <td>VCT</td>
        <td>13</td>
    </tr>
    <tr>
        <td>ATG</td>
        <td>13</td>
    </tr>
    <tr>
        <td>TZA</td>
        <td>13</td>
    </tr>
    <tr>
        <td>LBY</td>
        <td>13</td>
    </tr>
    <tr>
        <td>MNG</td>
        <td>13</td>
    </tr>
    <tr>
        <td>LKA</td>
        <td>13</td>
    </tr>
    <tr>
        <td>PRY</td>
        <td>12</td>
    </tr>
    <tr>
        <td>LBR</td>
        <td>12</td>
    </tr>
    <tr>
        <td>CAF</td>
        <td>12</td>
    </tr>
    <tr>
        <td>GHA</td>
        <td>12</td>
    </tr>
    <tr>
        <td>ZMB</td>
        <td>11</td>
    </tr>
    <tr>
        <td>GUF</td>
        <td>11</td>
    </tr>
    <tr>
        <td>BOL</td>
        <td>11</td>
    </tr>
    <tr>
        <td>TCD</td>
        <td>11</td>
    </tr>
    <tr>
        <td>NIC</td>
        <td>10</td>
    </tr>
    <tr>
        <td>GAB</td>
        <td>10</td>
    </tr>
    <tr>
        <td>MOZ</td>
        <td>10</td>
    </tr>
    <tr>
        <td>KHM</td>
        <td>10</td>
    </tr>
    <tr>
        <td>MMR</td>
        <td>9</td>
    </tr>
    <tr>
        <td>COD</td>
        <td>9</td>
    </tr>
    <tr>
        <td>LAO</td>
        <td>9</td>
    </tr>
    <tr>
        <td>MWI</td>
        <td>9</td>
    </tr>
    <tr>
        <td>SYR</td>
        <td>9</td>
    </tr>
    <tr>
        <td>SWZ</td>
        <td>8</td>
    </tr>
    <tr>
        <td>BRN</td>
        <td>8</td>
    </tr>
    <tr>
        <td>PRI</td>
        <td>7</td>
    </tr>
    <tr>
        <td>MDG</td>
        <td>7</td>
    </tr>
    <tr>
        <td>MNE</td>
        <td>7</td>
    </tr>
    <tr>
        <td>TUN</td>
        <td>7</td>
    </tr>
    <tr>
        <td>SXM</td>
        <td>6</td>
    </tr>
    <tr>
        <td>PNG</td>
        <td>6</td>
    </tr>
    <tr>
        <td>SEN</td>
        <td>6</td>
    </tr>
    <tr>
        <td>NPL</td>
        <td>6</td>
    </tr>
    <tr>
        <td>TJK</td>
        <td>5</td>
    </tr>
    <tr>
        <td>UGA</td>
        <td>5</td>
    </tr>
    <tr>
        <td>ALB</td>
        <td>5</td>
    </tr>
    <tr>
        <td>ASM</td>
        <td>5</td>
    </tr>
    <tr>
        <td>IRQ</td>
        <td>5</td>
    </tr>
    <tr>
        <td>CUB</td>
        <td>4</td>
    </tr>
    <tr>
        <td>PRK</td>
        <td>4</td>
    </tr>
    <tr>
        <td>COG</td>
        <td>4</td>
    </tr>
    <tr>
        <td>CMR</td>
        <td>4</td>
    </tr>
    <tr>
        <td>TKM</td>
        <td>4</td>
    </tr>
    <tr>
        <td>NAM</td>
        <td>4</td>
    </tr>
    <tr>
        <td>KGZ</td>
        <td>4</td>
    </tr>
    <tr>
        <td>SOM</td>
        <td>3</td>
    </tr>
    <tr>
        <td>SUR</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BES</td>
        <td>3</td>
    </tr>
    <tr>
        <td>MLI</td>
        <td>3</td>
    </tr>
    <tr>
        <td>TON</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BIH</td>
        <td>3</td>
    </tr>
    <tr>
        <td>PYF</td>
        <td>3</td>
    </tr>
    <tr>
        <td>GNQ</td>
        <td>2</td>
    </tr>
    <tr>
        <td>MDV</td>
        <td>2</td>
    </tr>
    <tr>
        <td>CPV</td>
        <td>2</td>
    </tr>
    <tr>
        <td>GIN</td>
        <td>2</td>
    </tr>
    <tr>
        <td>YEM</td>
        <td>2</td>
    </tr>
    <tr>
        <td>ETH</td>
        <td>2</td>
    </tr>
    <tr>
        <td>ANT</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SLB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BFA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DJI</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SLE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MKD</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BEN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TGO</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PSE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TUV</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-sourceID"></a><a href="#column-nodes-addresses-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>57.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>42.018</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>25.0049</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8044</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8044</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2349802.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>29.2086</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>197.1324</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>14.0404</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0729</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.5316</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>13.0</li><li>14.29411765</li><li>55.70588235</li><li>57.0</li></ul>bin_counts: <ul><li>30248.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>2636.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.97291: 25.00492: 42.0208
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>-</li><li> </li><li>C</li><li>n</li><li>s</li><li>G</li><li>a</li><li>&</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Paradise Papers - Malta corporate registry</li><li>Pandora Papers - Asiaciti Trust</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>20</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0002</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.014</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0072</li><li>0.0071</li><li>0.0095</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Paradise Papers - Malta corporate registry</td>
        <td>24595</td>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>18719</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>11911</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>11408</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>4205</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>3586</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>2636</td>
    </tr>
    <tr>
        <td>Pandora Papers - Fidelity Corporate Services</td>
        <td>579</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha Consulting</td>
        <td>510</td>
    </tr>
    <tr>
        <td>Pandora Papers - Trident Trust</td>
        <td>490</td>
    </tr>
    <tr>
        <td>Pandora Papers - Commence Overseas</td>
        <td>384</td>
    </tr>
    <tr>
        <td>Pandora Papers - SFM Corporate Services</td>
        <td>369</td>
    </tr>
    <tr>
        <td>Paradise Papers - Samoa corporate registry</td>
        <td>357</td>
    </tr>
    <tr>
        <td>Pandora Papers - CILTrust International</td>
        <td>332</td>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>121</td>
    </tr>
    <tr>
        <td>Pandora Papers - Il Shin Corporate Consulting Limited</td>
        <td>96</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>66</td>
    </tr>
    <tr>
        <td>Pandora Papers - Overseas Management Company (OMC)</td>
        <td>49</td>
    </tr>
    <tr>
        <td>Paradise Papers - Nevis corporate registry</td>
        <td>33</td>
    </tr>
    <tr>
        <td>Pandora Papers - Asiaciti Trust</td>
        <td>3</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-valid_until"></a><a href="#column-nodes-addresses-valid_until">**valid_until**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>161</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>391001</li><li>391003</li><li>391019</li><li>400173</li><li>400459</li><li>400575</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>36.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>58.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>47.011</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>47.0168</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.803</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.803</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>3800223.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>47.3324</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>41.5892</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>6.449</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.7046</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.7653</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>36.0</li><li>36.275</li><li>36.55</li><li>57.45</li><li>57.725</li><li>58.0</li></ul>bin_counts: <ul><li>11921.0</li><li>0.0</li><li>0.0</li><li>5274.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>3.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 47.00211: 47.01682: 52.9939
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>-</li><li> </li><li>n</li><li>s</li><li>5</li><li>M</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Malta corporate registry data is current through 2016</li><li>The Pandora Papers - Asiaciti data is current through 2018</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0003</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>80288</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0211</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0077</li><li>0.0077</li><li>0.0103</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Malta corporate registry data is current through 2016</td>
        <td>24595</td>
    </tr>
    <tr>
        <td>The Panama Papers  data is current through 2015</td>
        <td>18719</td>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>11911</td>
    </tr>
    <tr>
        <td>The Offshore Leaks data is current through 2010</td>
        <td>11408</td>
    </tr>
    <tr>
        <td>Barbados corporate registry data is current through 2016</td>
        <td>4205</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>3586</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>3160</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>1374</td>
    </tr>
    <tr>
        <td>Provider data is current through 2016</td>
        <td>376</td>
    </tr>
    <tr>
        <td>Samoa corporate registry data is current through 2016</td>
        <td>357</td>
    </tr>
    <tr>
        <td>The Bahamas Leaks data is current through early 2016.</td>
        <td>121</td>
    </tr>
    <tr>
        <td>Provider data is current through 2019</td>
        <td>108</td>
    </tr>
    <tr>
        <td>Bahamas corporate registry data is current through 2016</td>
        <td>66</td>
    </tr>
    <tr>
        <td>Provider data is current through 2012</td>
        <td>64</td>
    </tr>
    <tr>
        <td>Provider data is current through 2013</td>
        <td>54</td>
    </tr>
    <tr>
        <td>Provider data is current through 2015</td>
        <td>53</td>
    </tr>
    <tr>
        <td>Provider data is current through 2014</td>
        <td>44</td>
    </tr>
    <tr>
        <td>Nevis corporate registry data is current through 2016</td>
        <td>33</td>
    </tr>
    <tr>
        <td>Provider data is current through 2011</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Provider data is current through 2020</td>
        <td>19</td>
    </tr>
    <tr>
        <td>Provider data is current through nan</td>
        <td>10</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2018</td>
        <td>3</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-addresses-note"></a><a href="#column-nodes-addresses-note">**note**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>80449</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>80354</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>5</li><li>6</li><li>9</li><li>12</li><li>402231</li><li>402237</li><li>402238</li><li>402245</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>43.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>347.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>89.968</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>89.955</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.252</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.2546</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>9006.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>94.8</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>2210.0766</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>47.0115</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>4.9624</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>25.1502</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>43.0</li><li>81.0</li><li>119.0</li><li>157.0</li><li>233.0</li><li>271.0</li><li>309.0</li><li>347.0</li></ul>bin_counts: <ul><li>9.0</li><li>83.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>3.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 89.8671: 89.9552: 90.0431
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>U</li><li> </li><li>C</li><li>n</li><li>5</li><li>M</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>On 8th of February 2024 ICIJ reclassified this address to improve the accuracy of the data</li><li>This address was partially redacted on September 5th, 2023)</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0947</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>95</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-nodes-entities">Dataset: nodes-entities</a>

<a id="profile-nodes-entities-node_id"></a><a href="#column-nodes-entities-node_id">**node_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>66979.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240554204.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10047198.8375</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>20127743.2664</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8502298892919.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>52207144.261</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>4414443683857053.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>66441279.9685</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.6371</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>1.5248</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>66979.0</li><li>2680970.57608696</li><li>237940212.0</li><li>240554204.0</li></ul>bin_counts: <ul><li>21055.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>5720.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 10068824.64671: 20127743.26642: 81943920.606
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0007</li><li>0.0154</li><li>0.0154</li><li>0.0219</li><li>0.0001</li><li>0.0001</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-name"></a><a href="#column-nodes-entities-name">**name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>75258</li><li>725155</li><li>745442</li><li>749490</li><li>757195</li><li>758108</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>92.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>23.015</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>23.0535</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>3926290.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.1097</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>68.6812</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>8.2874</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.9008</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.1651</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>2.36585366</li><li>91.63414634</li><li>92.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>4.0</li><li>0.0</li><li>0.0</li><li>20.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 18.92871: 23.05352: 29.0065
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>倡</li><li>Ö</li><li>t</li><li>悦</li><li>再</li><li>球</li><li>來</li><li>鹿</li><li> </li><li>2</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>161469</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9915</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0266</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0148</li><li>0.0146</li><li>0.0215</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-original_name"></a><a href="#column-nodes-entities-original_name">**original_name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>85041</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>213916</li><li>213926</li><li>213927</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>129.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>23.042</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>23.0747</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1871205.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.0465</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>75.267</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>8.6757</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.6034</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>6.7964</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>5.42033898</li><li>128.57966102</li><li>129.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>4.0</li><li>0.0</li><li>54.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 18.90751: 23.07472: 27.997
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>q</li><li>i</li><li>&</li><li>,</li><li>è</li><li>F</li><li>f</li><li>J</li><li>a</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>76962</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.989</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0131</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0004</li><li>0.0071</li><li>0.007</li><li>0.011</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-former_name"></a><a href="#column-nodes-entities-former_name">**former_name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>161525</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>6</li><li>7</li><li>26</li><li>27</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>100.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>23.021</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>23.0032</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>31553.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>23.6884</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>87.1087</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>9.3332</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.2859</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>11.5503</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>3.63333333</li><li>98.36666667</li><li>100.0</li></ul>bin_counts: <ul><li>2.0</li><li>3.0</li><li>2.0</li><li>13.0</li><li>19.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 18.04351: 23.00322: 27.05
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>c</li><li>t</li><li>g</li><li>m</li><li>G</li><li>I</li><li>)</li><li>Q</li><li>E</li><li>2</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>1330</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9985</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0002</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0006</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-jurisdiction"></a><a href="#column-nodes-entities-jurisdiction">**jurisdiction**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>1494</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>699999</li><li>700000</li><li>700001</li><li>812492</li><li>813361</li><li>813381</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.0005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0004</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8558</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8558</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>472189.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>2.9263</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.1125</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.3354</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-1.0325</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>6.6259</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>2.15789474</li><li>4.84210526</li><li>5.0</li></ul>bin_counts: <ul><li>15207.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>256.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 2.99951: 3.00042: 3.0012
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>O</li><li>H</li><li>I</li><li>V</li><li>E</li><li>B</li><li>X</li><li>M</li><li>K</li><li>J</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>BAH</li><li>BVI</li><li>MLT</li><li>KNA</li><li>AN</li><li>LU</li><li>MT</li><li>NETH</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>81</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0005</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>161363</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0101</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0152</li><li>0.0152</li><li>0.0184</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>BAH</td>
        <td>41932</td>
    </tr>
    <tr>
        <td>BVI</td>
        <td>33273</td>
    </tr>
    <tr>
        <td>MLT</td>
        <td>16843</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>14216</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>10662</td>
    </tr>
    <tr>
        <td>AW</td>
        <td>9871</td>
    </tr>
    <tr>
        <td>PMA</td>
        <td>9710</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>8176</td>
    </tr>
    <tr>
        <td>SEY</td>
        <td>3150</td>
    </tr>
    <tr>
        <td>SAM</td>
        <td>2917</td>
    </tr>
    <tr>
        <td>NIUE</td>
        <td>1910</td>
    </tr>
    <tr>
        <td>BM</td>
        <td>1883</td>
    </tr>
    <tr>
        <td>KY</td>
        <td>1807</td>
    </tr>
    <tr>
        <td>COOK</td>
        <td>852</td>
    </tr>
    <tr>
        <td>ANG</td>
        <td>655</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>494</td>
    </tr>
    <tr>
        <td>VG</td>
        <td>445</td>
    </tr>
    <tr>
        <td>HK</td>
        <td>338</td>
    </tr>
    <tr>
        <td>IM</td>
        <td>262</td>
    </tr>
    <tr>
        <td>NEV</td>
        <td>257</td>
    </tr>
    <tr>
        <td>JE</td>
        <td>181</td>
    </tr>
    <tr>
        <td>SYC</td>
        <td>171</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>141</td>
    </tr>
    <tr>
        <td>CAYMN</td>
        <td>138</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>130</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>116</td>
    </tr>
    <tr>
        <td>XX</td>
        <td>102</td>
    </tr>
    <tr>
        <td>MU</td>
        <td>96</td>
    </tr>
    <tr>
        <td>LABUA</td>
        <td>82</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>74</td>
    </tr>
    <tr>
        <td>SC</td>
        <td>72</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>49</td>
    </tr>
    <tr>
        <td>UK</td>
        <td>33</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>32</td>
    </tr>
    <tr>
        <td>USDE</td>
        <td>31</td>
    </tr>
    <tr>
        <td>GG</td>
        <td>24</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>20</td>
    </tr>
    <tr>
        <td>MAURI</td>
        <td>16</td>
    </tr>
    <tr>
        <td>KN</td>
        <td>15</td>
    </tr>
    <tr>
        <td>MALAY</td>
        <td>14</td>
    </tr>
    <tr>
        <td>UY</td>
        <td>14</td>
    </tr>
    <tr>
        <td>CRI</td>
        <td>13</td>
    </tr>
    <tr>
        <td>BS</td>
        <td>12</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>10</td>
    </tr>
    <tr>
        <td>LR</td>
        <td>10</td>
    </tr>
    <tr>
        <td>JSY</td>
        <td>9</td>
    </tr>
    <tr>
        <td>WYO</td>
        <td>9</td>
    </tr>
    <tr>
        <td>AIA</td>
        <td>8</td>
    </tr>
    <tr>
        <td>COK</td>
        <td>7</td>
    </tr>
    <tr>
        <td>US</td>
        <td>7</td>
    </tr>
    <tr>
        <td>LI</td>
        <td>7</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>5</td>
    </tr>
    <tr>
        <td>VC</td>
        <td>4</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>4</td>
    </tr>
    <tr>
        <td>TC</td>
        <td>4</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>4</td>
    </tr>
    <tr>
        <td>CY</td>
        <td>4</td>
    </tr>
    <tr>
        <td>CK</td>
        <td>3</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BB</td>
        <td>3</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>3</td>
    </tr>
    <tr>
        <td>VCT</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BERMU</td>
        <td>2</td>
    </tr>
    <tr>
        <td>NL</td>
        <td>2</td>
    </tr>
    <tr>
        <td>IOM</td>
        <td>2</td>
    </tr>
    <tr>
        <td>AG</td>
        <td>2</td>
    </tr>
    <tr>
        <td>MARSH</td>
        <td>2</td>
    </tr>
    <tr>
        <td>PA</td>
        <td>2</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>2</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>2</td>
    </tr>
    <tr>
        <td>LCA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LIBER</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DUBAI</td>
        <td>1</td>
    </tr>
    <tr>
        <td>STLU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>AN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MT</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NETH</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-jurisdiction_description"></a><a href="#column-nodes-entities-jurisdiction_description">**jurisdiction_description**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>1493</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>699999</li><li>700000</li><li>700001</li><li>812492</li><li>813361</li><li>813381</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>34.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>7.015</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>7.0264</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8532</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8532</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1866223.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.5653</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>48.2337</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>6.945</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.6589</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.356</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.54545455</li><li>33.45454545</li><li>34.0</li></ul>bin_counts: <ul><li>1910.0</li><li>29640.0</li><li>0.0</li><li>10592.0</li><li>7.0</li><li>0.0</li><li>0.0</li><li>19.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.00491: 7.02642: 20.9972
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>.</li><li>l</li><li>i</li><li>f</li><li>K</li><li>U</li><li>F</li><li>B</li><li>a</li><li>L</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Bahamas</li><li>British Virgin Islands</li><li>Netherlands Antilles</li><li>Georgia</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>68</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0004</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>161364</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0164</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0152</li><li>0.015</li><li>0.0191</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>41946</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>34211</td>
    </tr>
    <tr>
        <td>Malta</td>
        <td>16844</td>
    </tr>
    <tr>
        <td>Saint Kitts and Nevis</td>
        <td>14228</td>
    </tr>
    <tr>
        <td>Undetermined</td>
        <td>10745</td>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>9871</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>9760</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>8179</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>3393</td>
    </tr>
    <tr>
        <td>Samoa</td>
        <td>2921</td>
    </tr>
    <tr>
        <td>Niue</td>
        <td>1910</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>1885</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>1807</td>
    </tr>
    <tr>
        <td>Cook Islands</td>
        <td>856</td>
    </tr>
    <tr>
        <td>British Anguilla</td>
        <td>655</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>454</td>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>262</td>
    </tr>
    <tr>
        <td>Nevada</td>
        <td>260</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>192</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>142</td>
    </tr>
    <tr>
        <td>Cayman</td>
        <td>139</td>
    </tr>
    <tr>
        <td>Belize</td>
        <td>130</td>
    </tr>
    <tr>
        <td>Mauritius</td>
        <td>116</td>
    </tr>
    <tr>
        <td>Labuan</td>
        <td>82</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>43</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>38</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>32</td>
    </tr>
    <tr>
        <td>State of Delaware</td>
        <td>31</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>26</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>24</td>
    </tr>
    <tr>
        <td>Recorded in leaked files as "fund"</td>
        <td>19</td>
    </tr>
    <tr>
        <td>Uruguay</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Malaysia</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Wyoming</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Costa Rica</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Liberia</td>
        <td>11</td>
    </tr>
    <tr>
        <td>South Dakota</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Anguilla</td>
        <td>8</td>
    </tr>
    <tr>
        <td>United States of America</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Saint Vincent and the Grenadines</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Liechtenstein</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Delaware</td>
        <td>6</td>
    </tr>
    <tr>
        <td>COOK ISLANDS</td>
        <td>5</td>
    </tr>
    <tr>
        <td>New Zealand</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Florida</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Turks and Caicos Islands</td>
        <td>4</td>
    </tr>
    <tr>
        <td>United States Of America</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Latvia</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Nevis</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Netherlands</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Isle Of Man</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Marshall Islands</td>
        <td>2</td>
    </tr>
    <tr>
        <td>New York</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Antigua and Barbuda</td>
        <td>2</td>
    </tr>
    <tr>
        <td>District of Columbia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Alaska</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Saint Lucia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Dubai</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GUERNSEY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Monaco</td>
        <td>1</td>
    </tr>
    <tr>
        <td>USA (South Dakota)</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Panama0x0a</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COOKISLANDS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>St. Lucia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BRITISH VIRGIN ISLANDS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Luxembourg</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Netherlands Antilles</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Georgia</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-company_type"></a><a href="#column-nodes-entities-company_type">**company_type**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>135265</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>6</li><li>7</li><li>26</li><li>27</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>46.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>29.9895</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>29.9838</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8151</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8152</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>770716.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>27.9326</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>26.8021</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.1771</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.5048</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.3751</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>5.46067416</li><li>45.53932584</li><li>46.0</li></ul>bin_counts: <ul><li>14.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>14.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 23.01511: 29.98382: 30.0054
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>c</li><li>k</li><li>t</li><li>F</li><li>g</li><li>.</li><li>z</li><li>)</li><li>E</li><li>2</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Standard International Company</li><li>Business Company Restricted Purposes</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>51</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0018</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>27592</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0055</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0026</li><li>0.0025</li><li>0.0037</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Standard International Company</td>
        <td>7868</td>
    </tr>
    <tr>
        <td>Standard Company under IBC Act</td>
        <td>5218</td>
    </tr>
    <tr>
        <td>Business Company Limited by Shares</td>
        <td>5120</td>
    </tr>
    <tr>
        <td>Regular (Local) Company</td>
        <td>3547</td>
    </tr>
    <tr>
        <td>Business Corporation</td>
        <td>3116</td>
    </tr>
    <tr>
        <td>Client Sundry Account</td>
        <td>1737</td>
    </tr>
    <tr>
        <td>International Trust</td>
        <td>202</td>
    </tr>
    <tr>
        <td>Cook Islands Asset Protection Trust</td>
        <td>105</td>
    </tr>
    <tr>
        <td>Domestic Company</td>
        <td>90</td>
    </tr>
    <tr>
        <td>Cook Islands Asset Protection Trust - 3520A</td>
        <td>90</td>
    </tr>
    <tr>
        <td>International Company</td>
        <td>84</td>
    </tr>
    <tr>
        <td>Sundry Account</td>
        <td>58</td>
    </tr>
    <tr>
        <td>Cook Islands Trust</td>
        <td>51</td>
    </tr>
    <tr>
        <td>The GRA group of Companies for express Co.</td>
        <td>36</td>
    </tr>
    <tr>
        <td>International Business Corporation</td>
        <td>32</td>
    </tr>
    <tr>
        <td>BVI Trust</td>
        <td>32</td>
    </tr>
    <tr>
        <td>Nominee Only Entity</td>
        <td>31</td>
    </tr>
    <tr>
        <td>Belize International Business Company</td>
        <td>23</td>
    </tr>
    <tr>
        <td>Mutual Fund Manager</td>
        <td>20</td>
    </tr>
    <tr>
        <td>Foreign Company Transfer</td>
        <td>16</td>
    </tr>
    <tr>
        <td>The Forbes Group of companies for Express Co..</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Mutual Fund</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Singapore Trust</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Bahamas IBC</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Trust</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Nevis - Limited Liability Company</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Turks</td>
        <td>7</td>
    </tr>
    <tr>
        <td>UK Register</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Mauritius - Hybrid</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Nevis Company</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Partnership</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Mauritius - International</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Limited Liability Company</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Audit Licence</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Professional Mutual Fund</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Private Company Limited By Shares</td>
        <td>2</td>
    </tr>
    <tr>
        <td>BVI Sundry Entities (one off transactions)</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Hong Kong Trust</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Busines Company Limited by Shares & Guarantee</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Business Vehicle</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Holding Company</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Private Mutual Fund</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Panama - IBC</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Panama - Foundation</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Mauritius - Offshore</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Business Company Limited by Guarantee</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Antigua</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Seminar / Workshop</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Business Company Restricted Purposes</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-address"></a><a href="#column-nodes-entities-address">**address**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>103141</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>2035</li><li>19690</li><li>22550</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>254.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>84.0575</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>96.8857</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9843</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9843</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>5987695.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>100.2695</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>753.8046</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>27.4555</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.4139</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.0568</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>6.83088235</li><li>252.16911765</li><li>254.0</li></ul>bin_counts: <ul><li>3.0</li><li>0.0</li><li>0.0</li><li>2.0</li><li>3.0</li><li>4.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 83.12031: 96.88572: 118.7963
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>Ò</li><li>o</li><li>p</li><li>F</li><li>Ö</li><li>y</li><li>é</li><li>s</li><li>Ý</li><li>|</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Portcullis TrustNet Chambers P.O. Box 3444 Road Town, Tortola BRITISH VIRGIN ISLANDS</li><li>John E. Deans 212 New London Turnpike Suite D Glastonbury, CT 06033 USA</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>7572</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.1268</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>59716</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0324</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0054</li><li>0.0053</li><li>0.0086</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Portcullis TrustNet Chambers P.O. Box 3444 Road Town, Tortola BRITISH VIRGIN ISLANDS</td>
        <td>6680</td>
    </tr>
    <tr>
        <td>ORION HOUSE SERVICES (HK) LIMITED ROOM 1401; 14/F.; WORLD COMMERCE  CENTRE; HARBOUR CITY; 7-11 CANTON ROAD; TSIM SHA TSUI; KOWLOON; HONG KONG</td>
        <td>1447</td>
    </tr>
    <tr>
        <td>Unitrust Corporate Services Ltd. John Humphries House, Room 304 4-10 Stockwell Street, Greenwich London SE10 9JN RT BVI</td>
        <td>1098</td>
    </tr>
    <tr>
        <td>MOSSACK FONSECA & CO. MOSSFON BUILDING CALLE 54 ESTE PANAMA, REPUBLICA DE PANAMA</td>
        <td>835</td>
    </tr>
    <tr>
        <td>MF ASSOCIATES INC. PASEO ROBERTO MOTTA CAPITAL PLAZA; FLOOR 8 COSTA DEL ESTE; PANAMÁ PANAMA REPUBLIC OF PANAMA *S.I.*</td>
        <td>808</td>
    </tr>
    <tr>
        <td>OFFSHORER BUSINESS SERVICES (HK) LTD. UNIT 826; 8/F OCEAN CENTRE; HARBOUR CITY; 5 CANTON ROAD; TST KOWLOON; HONG KONG</td>
        <td>805</td>
    </tr>
    <tr>
        <td>Sealight Incorporations Limited Room 1201, Connaught Commercial Building 185 Wanchai Road Wanchai, Hong Kong RT BVI</td>
        <td>801</td>
    </tr>
    <tr>
        <td>MOSSACK FONSECA & CO. (SINGAPORE) PTE LTD.  19 KEPPEL ROAD #03-05, 3RD STOREY JIT POH BUILDING SINGAPORE 089058 REPUBLIC OF SINGAPORE *S.I.*</td>
        <td>735</td>
    </tr>
    <tr>
        <td>CONSULCO INTERNATIONAL LIMITED RAS AL KHAIMAH FREE TRADE ZONE RAS AL KHAIMAH UNITED ARAB EMIRATES</td>
        <td>633</td>
    </tr>
    <tr>
        <td>MOSSACK FONSECA & CO. (GENEVA) S.A. 4, RUE MICHELI-DU-CREST 1205 GENEVA SWITZERLAND</td>
        <td>569</td>
    </tr>
    <tr>
        <td>Company Kit Limited Unit A, 6/F Shun On Comm Bldg. 112-114 Des Voeux Road C., Hong Kong  SAR RT BVI</td>
        <td>532</td>
    </tr>
    <tr>
        <td>MOSSACK FONSECA & CO. (U.K.) LIMITED INVISION HOUSE WILBURY WAY, HITCHIN HERTFORDSHIRE SG4 OTW UNITED KINGDOM</td>
        <td>494</td>
    </tr>
    <tr>
        <td>Panocean Secretarial Services Limited Room 1708 Kai Tak Commercial Building 317-321 Des Voeux Road C Hong Kong RT BVI</td>
        <td>447</td>
    </tr>
    <tr>
        <td>MOSSACK FONSECA & CO. (PERU) CORP. SAFFREY SQUARE SUITE 205; BANK LANE P. O. BOX N-8188 NASSAU; BAHAMAS **S.I.**</td>
        <td>440</td>
    </tr>
    <tr>
        <td>POWER POINT INTERNATIONAL CO. LTD. 6F; NO. 72; SEC 2; NANJIN EAST ROAD; TAIPEI CITY; R.O.C. TAIWAN (R.O.C.) *S.I.*</td>
        <td>426</td>
    </tr>
    <tr>
        <td>MOSSFON MANAGERS LTD. SAFFREY SQUARE; SUITE 205; BANK LANE P.O. BOX N-8188 NASSAU **S.I**; NEW PROVIDENCE ISLAND BAHAMAS</td>
        <td>400</td>
    </tr>
    <tr>
        <td>SERGEY SOBOLEV GRAFF INTERNATIONAL PARTNERS K/S DOBROLUYBOVA STREET; HOUSE 2; BUILDING 1 MOSCOW (MOSKVA) 127254; MOSCOVSKAYA OBLAST (MOSCOW) RUSSIA</td>
        <td>387</td>
    </tr>
    <tr>
        <td>Kuzniecky & Co. Banco General Building, 21st Floor Aquilino de la Guardia Street Panama City Republic of Panama P.O.Box 0831-01450  RT BVI</td>
        <td>355</td>
    </tr>
    <tr>
        <td>International Offshore Services Group 42 Chelmsford Road Dublin 6 Ireland RT BVI</td>
        <td>346</td>
    </tr>
    <tr>
        <td>EXPERTA CORPORATE & TRUST SERVICES 42, RUE DE LA VALLÉE L-2661 LUXEMBOURG CITY LUXEMBOURG</td>
        <td>327</td>
    </tr>
    <tr>
        <td>BONALBO BUSINESS SERVICES P. O. BOX 29000 CY-2084 NICOSIA CYPRUS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NATURAL TECH CORPORATE SERVICES LIMITED ROOM 1801; 18/F; MALAYSIA BUILDING; NO. 50 GLOUCESTER ROAD; WANCHAI HONG KONG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LINE MANAGEMENT SERVICES LIMITED 57/63 LINE WALL ROAD P.O. BOX 199 GIBRALTAR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NEW WORLD TRUST CORPORATION CASE POSTALE 3501 1211 GENEVA 3 SWITZERLAND</td>
        <td>1</td>
    </tr>
    <tr>
        <td>KOSTENBAUM & ASSOCIES COURS DE RIVE 10 1204, GENEVA SWITZERLAND</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GOLDWAY DEVELOPMENT LIMITED C/0 YUE XIU ENTERPRISES (HOLDINGS) LIMITED 24/F; YUE XIU BUILDING 160-174 LOCKHART ROAD WANCHAI; HONG KONG ATTN.: MS. NANCY TAU & MS. ZANONIA LI</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ZENNON COMMERCE & INDUSTRY LTD. 7TH FLOOR; BLOCK A; SUMMIT BUILDING 30 MAN YUE ST.; HUNG HOM KOWLOON; HONG KONG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LAWRENCE I. BROWN & ASSOCIATES LIMITED P.O.BOX 635 GREENWICH CONNECTICUT 06836 U.S.A.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>APPLETON COMPANY SVS LT [Ms Rachel Burgess] 186 Hammersmith Road London W6 7Dj E15 2BY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>John E. Deans 212 New London Turnpike Suite D Glastonbury, CT 06033 USA</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-internal_id"></a><a href="#column-nodes-entities-internal_id">**internal_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>85041</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>213916</li><li>213926</li><li>213927</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>10000017.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5002.0075</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>149700.543</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>53598242289.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>688781.771</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>2325165450581.073</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1524849.3206</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.1443</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>8.4315</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>22885.3295</li><li>9977133.67048055</li><li>10000017.0</li></ul>bin_counts: <ul><li>7954.0</li><li>7228.0</li><li>6693.0</li><li>5216.0</li><li>4533.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 60177.0991: 149700.5432: 548981.8944
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>76038</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9772</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0073</li><li>0.0072</li><li>0.0121</li><li>0.0001</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-incorporation_date"></a><a href="#column-nodes-entities-incorporation_date">**incorporation_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>5166</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>48189</li><li>133071</li><li>161203</li><li>814147</li><li>814173</li><li>814282</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>12.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0005</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9998</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9998</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1734603.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0036</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>280.7917</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>78842.9999</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>11.0</li><li>11.05263158</li><li>11.94736842</li><li>12.0</li></ul>bin_counts: <ul><li>157689.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.00031: 11.00052: 11.0008
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>l</li><li>9</li><li>c</li><li>t</li><li>F</li><li>3</li><li>C</li><li> </li><li>E</li><li>2</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>02-JAN-1998</li><li>04-JAN-1999</li><li>09-FEB-1951</li><li>18-Oct-2011</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>13092</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.083</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>157691</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0173</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0142</li><li>0.0141</li><li>0.0179</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-inactivation_date"></a><a href="#column-nodes-entities-inactivation_date">**inactivation_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>133989</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>34</li><li>78</li><li>80</li><li>82</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9972</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9973</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>317548.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0003</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>28868</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>O</li><li>0</li><li>V</li><li>E</li><li>T</li><li>8</li><li>M</li><li>2</li><li>4</li><li>J</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>02-NOV-2009</li><li>03-MAY-2010</li><li>14-FEB-2000</li><li>07-DEC-2017</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>4981</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.1725</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>28868</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0033</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0027</li><li>0.0026</li><li>0.0015</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-struck_off_date"></a><a href="#column-nodes-entities-struck_off_date">**struck_off_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>94212</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>34</li><li>78</li><li>80</li><li>82</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9881</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9881</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>755095.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0001</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>68645</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>7</li><li>E</li><li>3</li><li>O</li><li>G</li><li>B</li><li>C</li><li>5</li><li>R</li><li>L</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>31-AUG-2002</li><li>01-JAN-2000</li><li>13-DEC-1984</li><li>19-MAY-2017</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>4466</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0651</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>68645</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.007</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0063</li><li>0.0063</li><li>0.003</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-dorm_date"></a><a href="#column-nodes-entities-dorm_date">**dorm_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>158820</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>6</li><li>7</li><li>26</li><li>27</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.934</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9343</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>44407.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0022</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>4037</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>F</li><li>S</li><li>8</li><li>9</li><li>6</li><li>P</li><li>U</li><li>1</li><li>3</li><li>5</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>01-MAY-2009</li><li>01-NOV-2009</li><li>19-JUN-2009</li><li>17-MAR-2003</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>125</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.031</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>4037</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0004</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0005</li><li>0.0004</li><li>0.0004</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-status"></a><a href="#column-nodes-entities-status">**status**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>91450</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>35717</li><li>92451</li><li>93105</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>41.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>8.985</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.9776</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.7998</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.7998</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>703609.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>9.8535</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>38.8686</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>6.2345</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.4218</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>5.5967</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>3.19191919</li><li>40.80808081</li><li>41.0</li></ul>bin_counts: <ul><li>1.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>4619.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 5.98551: 8.97762: 9.9982
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>l</li><li>q</li><li>i</li><li>,</li><li>O</li><li>F</li><li>f</li><li>B</li><li>a</li><li>L</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Active</li><li>Defaulted</li><li>Resigned as agent of shelf company</li><li>LIQUIDATED</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>68</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.001</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>71407</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0067</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0068</li><li>0.0066</li><li>0.0093</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Active</td>
        <td>23157</td>
    </tr>
    <tr>
        <td>Defaulted</td>
        <td>19969</td>
    </tr>
    <tr>
        <td>Dissolved</td>
        <td>4782</td>
    </tr>
    <tr>
        <td>Dead</td>
        <td>4619</td>
    </tr>
    <tr>
        <td>Struck / Defunct / Deregistered</td>
        <td>3806</td>
    </tr>
    <tr>
        <td>Struck Off</td>
        <td>3303</td>
    </tr>
    <tr>
        <td>Changed agent</td>
        <td>3177</td>
    </tr>
    <tr>
        <td>Inactivated</td>
        <td>1512</td>
    </tr>
    <tr>
        <td>In Dissolution</td>
        <td>1394</td>
    </tr>
    <tr>
        <td>Resigned as agent</td>
        <td>639</td>
    </tr>
    <tr>
        <td>Struck Off as Defunct</td>
        <td>584</td>
    </tr>
    <tr>
        <td>Transferred OUT</td>
        <td>557</td>
    </tr>
    <tr>
        <td>Shelf company</td>
        <td>515</td>
    </tr>
    <tr>
        <td>Transferred Out</td>
        <td>371</td>
    </tr>
    <tr>
        <td>Dissolved shelf company</td>
        <td>300</td>
    </tr>
    <tr>
        <td>Struck Off Following Merger</td>
        <td>284</td>
    </tr>
    <tr>
        <td>Bad debt account</td>
        <td>267</td>
    </tr>
    <tr>
        <td>Registered</td>
        <td>217</td>
    </tr>
    <tr>
        <td>Inactive</td>
        <td>203</td>
    </tr>
    <tr>
        <td>Liquidated</td>
        <td>178</td>
    </tr>
    <tr>
        <td>Trash company</td>
        <td>175</td>
    </tr>
    <tr>
        <td>Company liquidated</td>
        <td>170</td>
    </tr>
    <tr>
        <td>In Penalty</td>
        <td>153</td>
    </tr>
    <tr>
        <td>In transition</td>
        <td>144</td>
    </tr>
    <tr>
        <td>Relocated in new jurisdiction</td>
        <td>137</td>
    </tr>
    <tr>
        <td>Not To Be Renewed / In Deregistration</td>
        <td>118</td>
    </tr>
    <tr>
        <td>Shelf</td>
        <td>106</td>
    </tr>
    <tr>
        <td>Discontinued</td>
        <td>95</td>
    </tr>
    <tr>
        <td>Deregistered</td>
        <td>84</td>
    </tr>
    <tr>
        <td>Continuation Out</td>
        <td>74</td>
    </tr>
    <tr>
        <td>Shelf company not possible to sell</td>
        <td>36</td>
    </tr>
    <tr>
        <td>We resigned as registered agent</td>
        <td>29</td>
    </tr>
    <tr>
        <td>Struck Off Following Division</td>
        <td>25</td>
    </tr>
    <tr>
        <td>Resigned</td>
        <td>24</td>
    </tr>
    <tr>
        <td>In Formation</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Pending</td>
        <td>19</td>
    </tr>
    <tr>
        <td>In Liquidation</td>
        <td>17</td>
    </tr>
    <tr>
        <td>Un Registered</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Removed</td>
        <td>15</td>
    </tr>
    <tr>
        <td>In liquidation</td>
        <td>14</td>
    </tr>
    <tr>
        <td>In Process of Converting</td>
        <td>12</td>
    </tr>
    <tr>
        <td>In Process of Merging</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Subject to UN/EU Sanctions</td>
        <td>11</td>
    </tr>
    <tr>
        <td>dissolved</td>
        <td>9</td>
    </tr>
    <tr>
        <td>active</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Redomiciled</td>
        <td>7</td>
    </tr>
    <tr>
        <td>struck off</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Vesting</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Change in administration pending</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Discontinuance</td>
        <td>3</td>
    </tr>
    <tr>
        <td>inactive</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Struck Off / Dissolved</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Sundry Account</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Struck off</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Struck off Dissolved</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Closed</td>
        <td>1</td>
    </tr>
    <tr>
        <td>de-registered, ceased business operations</td>
        <td>1</td>
    </tr>
    <tr>
        <td>closed for non-payment/non-communication</td>
        <td>1</td>
    </tr>
    <tr>
        <td>strike off</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Client Sundry Account</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Suspended</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IAC</td>
        <td>1</td>
    </tr>
    <tr>
        <td>to be liquidated</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Struck off - Non Pmt A/Fee</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Winding Up</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Active *</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Resigned as agent of shelf company</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LIQUIDATED</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-service_provider"></a><a href="#column-nodes-entities-service_provider">**service_provider**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>94181</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>92451</li><li>93105</li><li>93505</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>26.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>15.0085</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>15.0121</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.5613</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.5613</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1136744.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>16.5523</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>20.7626</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.5566</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.4888</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.8237</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>7.0</li><li>7.19387755</li><li>25.80612245</li><li>26.0</li></ul>bin_counts: <ul><li>4993.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>8904.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 15.00441: 15.01212: 18.9951
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>c</li><li>k</li><li>e</li><li>L</li><li>t</li><li>A</li><li>d</li><li>r</li><li>o</li><li>a</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Mossack Fonseca</li><li>Portcullis Trustnet</li><li>Commonwealth Trust Limited</li><li>Appleby</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0001</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>68676</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0086</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0065</li><li>0.0063</li><li>0.0075</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Mossack Fonseca</td>
        <td>42628</td>
    </tr>
    <tr>
        <td>Portcullis Trustnet</td>
        <td>12151</td>
    </tr>
    <tr>
        <td>Commonwealth Trust Limited</td>
        <td>8904</td>
    </tr>
    <tr>
        <td>Appleby</td>
        <td>4993</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-ibcRUC"></a><a href="#column-nodes-entities-ibcRUC">**ibcRUC**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>50466</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>259</li><li>281</li><li>308</li><li>342</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>None: <ul><li>517760</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>19.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.995</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>5.9971</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>672180.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>5.9807</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>2.0579</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.4346</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-1.0107</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>5.2924</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>1.04137931</li><li>18.95862069</li><li>19.0</li></ul>bin_counts: <ul><li>1353.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 5.98911: 5.99712: 6.9969
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>r</li><li>o</li><li>F</li><li> </li><li>l</li><li>w</li><li>J</li><li>+</li><li>s</li><li>3</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>104015</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9255</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0083</li><li>0.0001</li><li>0.0001</li><li>0.0</li><li>0.0003</li><li>0.0105</li><li>0.0106</li><li>0.0146</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-country_codes"></a><a href="#column-nodes-entities-country_codes">**country_codes**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>62050</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>2035</li><li>12840</li><li>13749</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>15.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.006</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0067</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9352</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9352</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>346317.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.4354</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.5738</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.2545</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.579</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>4.9475</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>3.66666667</li><li>14.33333333</li><li>15.0</li></ul>bin_counts: <ul><li>89900.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00341: 3.00672: 3.0101
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>O</li><li>H</li><li>I</li><li>V</li><li>E</li><li>B</li><li>X</li><li>M</li><li>K</li><li>J</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>MLT</li><li>VGB</li><li>HKG</li><li>ZWE</li><li>XXX;CRI</li><li>PAK</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>611</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0061</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>100807</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0067</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0097</li><li>0.0094</li><li>0.0121</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>MLT</td>
        <td>16922</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>10800</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>7786</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>7713</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>7538</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>4659</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>3111</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>3043</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>2259</td>
    </tr>
    <tr>
        <td>LUX</td>
        <td>2189</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>1958</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>1888</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>1681</td>
    </tr>
    <tr>
        <td>BMU</td>
        <td>1504</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>1492</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>1448</td>
    </tr>
    <tr>
        <td>IMN</td>
        <td>1226</td>
    </tr>
    <tr>
        <td>URY</td>
        <td>1000</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>913</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>829</td>
    </tr>
    <tr>
        <td>BMU;KOR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BMU;KAZ</td>
        <td>1</td>
    </tr>
    <tr>
        <td>VUT;VGB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BMU;CYP;RUS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BMU;LUX</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BHS;BMU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GUF</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ZWE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>XXX;CRI</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PAK</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-countries"></a><a href="#column-nodes-entities-countries">**countries**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>62050</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>2035</li><li>12840</li><li>13749</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>47.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.002</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.9903</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9352</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9352</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1197168.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.8758</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>64.7785</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>8.0485</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.382</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>1.0356</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>3.34375</li><li>3.6875</li><li>46.3125</li><li>46.65625</li><li>47.0</li></ul>bin_counts: <ul><li>286.0</li><li>0.0</li><li>81.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.01251: 8.99032: 14.0295
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>c</li><li>k</li><li>t</li><li>F</li><li>g</li><li>.</li><li>z</li><li>q</li><li>Q</li><li>E</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Malta</li><li>British Virgin Islands</li><li>Guernsey;Jersey</li><li>Pakistan</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>612</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0061</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>100807</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0113</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0095</li><li>0.0094</li><li>0.0134</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Malta</td>
        <td>16922</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>10800</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>7786</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>7713</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>7538</td>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>4659</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>3111</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>3043</td>
    </tr>
    <tr>
        <td>Not identified</td>
        <td>2259</td>
    </tr>
    <tr>
        <td>Luxembourg</td>
        <td>2189</td>
    </tr>
    <tr>
        <td>Samoa</td>
        <td>1958</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>1888</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>1681</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>1504</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>1492</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>1448</td>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>1226</td>
    </tr>
    <tr>
        <td>Uruguay</td>
        <td>1000</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>913</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>829</td>
    </tr>
    <tr>
        <td>British Virgin Islands;New Zealand</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Isle of Man;Singapore</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Canada;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Gibraltar;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Germany;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Belgium;Brazil;France;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Canada;Isle of Man;United States</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Isle of Man;South Africa</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Guernsey;Jersey</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pakistan</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-sourceID"></a><a href="#column-nodes-entities-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>57.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.022</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>13.9755</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8418</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8418</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>3976016.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.4142</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>208.5675</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>14.4419</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.6172</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.4102</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>13.0</li><li>14.04761905</li><li>55.95238095</li><li>57.0</li></ul>bin_counts: <ul><li>98871.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>3089.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.0231: 13.97552: 42.0132
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>r</li><li>p</li><li>o</li><li>F</li><li> </li><li>L</li><li>i</li><li>á</li><li>s</li><li>y</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Panama Papers</li><li>Pandora Papers - Asiaciti Trust</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>21</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0001</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0292</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0003</li><li>0.0151</li><li>0.0146</li><li>0.0178</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>42628</td>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>35188</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>21055</td>
    </tr>
    <tr>
        <td>Paradise Papers - Malta corporate registry</td>
        <td>16833</td>
    </tr>
    <tr>
        <td>Paradise Papers - Nevis corporate registry</td>
        <td>14213</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>9870</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>8176</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>4993</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>3579</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>3089</td>
    </tr>
    <tr>
        <td>Pandora Papers - SFM Corporate Services</td>
        <td>591</td>
    </tr>
    <tr>
        <td>Pandora Papers - Commence Overseas</td>
        <td>490</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha Consulting</td>
        <td>413</td>
    </tr>
    <tr>
        <td>Pandora Papers - Trident Trust</td>
        <td>368</td>
    </tr>
    <tr>
        <td>Pandora Papers - Fidelity Corporate Services</td>
        <td>366</td>
    </tr>
    <tr>
        <td>Paradise Papers - Cook Islands corporate registry</td>
        <td>302</td>
    </tr>
    <tr>
        <td>Paradise Papers - Samoa corporate registry</td>
        <td>300</td>
    </tr>
    <tr>
        <td>Pandora Papers - CILTrust International</td>
        <td>260</td>
    </tr>
    <tr>
        <td>Pandora Papers - Overseas Management Company (OMC)</td>
        <td>59</td>
    </tr>
    <tr>
        <td>Pandora Papers - Il Shin Corporate Consulting Limited</td>
        <td>59</td>
    </tr>
    <tr>
        <td>Pandora Papers - Asiaciti Trust</td>
        <td>25</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-valid_until"></a><a href="#column-nodes-entities-valid_until">**valid_until**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>45</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>805052</li><li>809348</li><li>809349</li><li>812376</li><li>812452</li><li>812530</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>26.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>99.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>52.9735</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>52.9438</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8416</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8416</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8061816.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>49.5161</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>23.9905</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.898</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-1.0394</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.947</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>26.0</li><li>26.25614035</li><li>98.74385965</li><li>99.0</li></ul>bin_counts: <ul><li>5.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 45.98051: 52.94382: 52.9826
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>.</li><li>7</li><li>l</li><li>i</li><li>f</li><li>m</li><li>B</li><li>a</li><li>5</li><li>L</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>The Panama Papers data is current through 2015</li><li>Data is current through 2008.</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>41</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0003</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>162812</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.044</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0149</li><li>0.0147</li><li>0.0189</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>The Panama Papers data is current through 2015</td>
        <td>42628</td>
    </tr>
    <tr>
        <td>The Bahamas Leaks data is current through early 2016.</td>
        <td>35188</td>
    </tr>
    <tr>
        <td>The Offshore Leaks data is current through 2010</td>
        <td>21055</td>
    </tr>
    <tr>
        <td>Malta corporate registry data is current through 2016</td>
        <td>16833</td>
    </tr>
    <tr>
        <td>Nevis corporate registry data is current through 2016</td>
        <td>14213</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>9870</td>
    </tr>
    <tr>
        <td>Barbados corporate registry data is current through 2016</td>
        <td>8176</td>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>4993</td>
    </tr>
    <tr>
        <td>Bahamas corporate registry data is current through 2016</td>
        <td>3579</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>3011</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>1576</td>
    </tr>
    <tr>
        <td>Provider data is current through 2016</td>
        <td>357</td>
    </tr>
    <tr>
        <td>Cook Islands corporate registry data is current through 2016</td>
        <td>302</td>
    </tr>
    <tr>
        <td>Samoa corporate registry data is current through 2016</td>
        <td>300</td>
    </tr>
    <tr>
        <td>Provider data is current through 2015</td>
        <td>132</td>
    </tr>
    <tr>
        <td>Provider data is current through 2019</td>
        <td>112</td>
    </tr>
    <tr>
        <td>Provider data is current through 2013</td>
        <td>90</td>
    </tr>
    <tr>
        <td>Provider data is current through 2014</td>
        <td>83</td>
    </tr>
    <tr>
        <td>Provider data is current through 2012</td>
        <td>79</td>
    </tr>
    <tr>
        <td>Provider data is current through 2011</td>
        <td>55</td>
    </tr>
    <tr>
        <td>Data is current through 2017.</td>
        <td>49</td>
    </tr>
    <tr>
        <td>Provider data is current through 2020</td>
        <td>26</td>
    </tr>
    <tr>
        <td>Data is current through 2015.</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Provider data is current through nan</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Data is current through 2016.</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Data is current through 2013.</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Data is current through 2018.</td>
        <td>11</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2018</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Provider data is current through 2010</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Data current through 2017.</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Data is current through 2007.</td>
        <td>3</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2016</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Provider data is current through 2008</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Data is current through 2009.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Data is current through 2014.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The data is current through 2017.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2017</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Dta is current through 2017.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2012</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alcogal data is current through 2011. Record manually added from leaked documents.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Data is current through 2008.</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-entities-note"></a><a href="#column-nodes-entities-note">**note**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>162857</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>154537</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>6</li><li>7</li><li>26</li><li>27</li><li>814278</li><li>814281</li><li>814282</li><li>814283</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>30.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>654.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>37.99240987</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>38.0353</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.7125</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.7126</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>627473.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>75.4174</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>5087.6811</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>71.328</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.4588</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.7207</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>55</li><li>0</li><li>0</li><li>0</li><li>0</li><li>1</li></ul>bin_edges: <ul><li>30.0</li><li>30.19734345</li><li>653.80265655</li><li>654.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 37.95791: 38.03532: 40.017
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>a</li><li>T</li><li>j</li><li>r</li><li>*</li><li>o</li><li>M</li><li>e</li><li>4</li><li>J</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Closed date stands for Cancelled date.</li><li>Date discontinued: 28-FEB-2013</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>73</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0088</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>8320</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0036</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0009</li><li>0.0008</li><li>0.0016</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-nodes-intermediaries">Dataset: nodes-intermediaries</a>

<a id="profile-nodes-intermediaries-node_id"></a><a href="#column-nodes-intermediaries-node_id">**node_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>27115.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240091021.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10950022.723</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>10894395.057</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>117429594120.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>21937155.6361</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>2630061370144079.5</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>51284123.958</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.4207</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>10.7765</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>27115.0</li><li>1251930.84693878</li><li>238866205.0</li><li>240091021.0</li></ul>bin_counts: <ul><li>1917.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>190.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 414246.16841: 10894395.0572: 11007876.3436
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0006</li><li>0.0005</li><li>0.0011</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-name"></a><a href="#column-nodes-intermediaries-name">**name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>91.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>14.044</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>20.0387</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>118181.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>22.0775</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>94.0106</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>9.6959</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.0721</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>1.6384</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>4.46666667</li><li>89.53333333</li><li>91.0</li></ul>bin_counts: <ul><li>6.0</li><li>3.0</li><li>43.0</li><li>40.0</li><li>227.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 14.97771: 20.03872: 27.9941
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>4</li><li>C</li><li>"</li><li>2</li><li>0</li><li>Ñ</li><li>E</li><li>a</li><li>Ó</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>5234</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9778</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0009</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0005</li><li>0.0005</li><li>0.0011</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-status"></a><a href="#column-nodes-intermediaries-status">**status**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2819</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>118</li><li>307</li><li>1139</li><li>26753</li><li>26756</li><li>26759</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>34.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>6.014</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>6.0249</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.5399</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.5401</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>19510.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>7.6993</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>9.5771</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.0947</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>4.2196</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>23.4493</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>6.0</li><li>6.4375</li><li>6.875</li><li>33.125</li><li>33.5625</li><li>34.0</li></ul>bin_counts: <ul><li>1427.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>72.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>7.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 6.01241: 6.02492: 9.0078
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li>C</li><li> </li><li>V</li><li>Y</li><li>E</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>ACTIVE</li><li>SUSPENDED</li><li>ACTIVE LEGAL</li><li>SUSPENDED LEGAL</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0036</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>2534</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0002</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0003</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>ACTIVE</td>
        <td>1427</td>
    </tr>
    <tr>
        <td>SUSPENDED</td>
        <td>954</td>
    </tr>
    <tr>
        <td>UNRECOVERABLE ACCOUNTS</td>
        <td>66</td>
    </tr>
    <tr>
        <td>INACTIVE</td>
        <td>58</td>
    </tr>
    <tr>
        <td>PROSPECT</td>
        <td>14</td>
    </tr>
    <tr>
        <td>CLIENT IN REPRESENTATIVE TERRITORY</td>
        <td>7</td>
    </tr>
    <tr>
        <td>DELINQUENT</td>
        <td>3</td>
    </tr>
    <tr>
        <td>ACTIVE LEGAL</td>
        <td>3</td>
    </tr>
    <tr>
        <td>SUSPENDED LEGAL</td>
        <td>2</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-internal_id"></a><a href="#column-nodes-intermediaries-internal_id">**internal_id**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2420</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>14111</li><li>14122</li><li>14125</li><li>26753</li><li>26756</li><li>26759</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>6.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.0025</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>5.0014</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>13511.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>4.6065</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.4256</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.6524</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-1.6228</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.3218</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>1.13888889</li><li>5.86111111</li><li>6.0</li></ul>bin_counts: <ul><li>3.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 4.00371: 5.00142: 5.0032
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>-</li><li>6</li><li>9</li><li>0</li><li>5</li><li>2</li><li>A</li><li>8</li><li>1</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2917</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9945</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0002</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0003</li><li>0.0006</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-address"></a><a href="#column-nodes-intermediaries-address">**address**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>3591</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>1</li><li>6</li><li>7</li><li>26753</li><li>26756</li><li>26759</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>38.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>213.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>104.9375</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>93.0343</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>166185.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>94.3161</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>605.218</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>24.6012</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.6147</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>0.7404</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>38.0</li><li>43.46875</li><li>48.9375</li><li>202.0625</li><li>207.53125</li><li>213.0</li></ul>bin_counts: <ul><li>3.0</li><li>11.0</li><li>25.0</li><li>64.0</li><li>101.0</li><li>2.0</li><li>1.0</li><li>0.0</li><li>1.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 76.04431: 93.03432: 109.959
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>4</li><li>C</li><li>"</li><li>2</li><li>0</li><li>Ñ</li><li>E</li><li>a</li><li>Ó</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>1762</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0002</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-countries"></a><a href="#column-nodes-intermediaries-countries">**countries**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>710</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>118</li><li>307</li><li>1139</li><li>1174</li><li>26747</li><li>26753</li><li>26756</li><li>26759</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>40.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>8.986</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.9849</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9259</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9261</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>44887.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>9.6677</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>13.9595</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.7362</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.6807</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>4.1405</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.47368421</li><li>39.52631579</li><li>40.0</li></ul>bin_counts: <ul><li>7.0</li><li>0.0</li><li>239.0</li><li>0.0</li><li>707.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 7.0071: 8.98492: 11.005
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li> </li><li>C</li><li>K</li><li>M</li><li>G</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Hong Kong</li><li>United States</li><li>Zambia</li><li>India;Switzerland</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>156</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0336</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>4643</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0004</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0005</li><li>0.0005</li><li>0.0012</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>1030</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>308</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>299</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>271</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>265</td>
    </tr>
    <tr>
        <td>Taiwan</td>
        <td>245</td>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>173</td>
    </tr>
    <tr>
        <td>China</td>
        <td>142</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>134</td>
    </tr>
    <tr>
        <td>Indonesia</td>
        <td>106</td>
    </tr>
    <tr>
        <td>Thailand</td>
        <td>83</td>
    </tr>
    <tr>
        <td>Not identified</td>
        <td>81</td>
    </tr>
    <tr>
        <td>Brazil</td>
        <td>80</td>
    </tr>
    <tr>
        <td>Guatemala</td>
        <td>73</td>
    </tr>
    <tr>
        <td>Luxembourg</td>
        <td>71</td>
    </tr>
    <tr>
        <td>Ecuador</td>
        <td>68</td>
    </tr>
    <tr>
        <td>Malaysia</td>
        <td>60</td>
    </tr>
    <tr>
        <td>Uruguay</td>
        <td>56</td>
    </tr>
    <tr>
        <td>Jersey;United Kingdom</td>
        <td>56</td>
    </tr>
    <tr>
        <td>Guernsey;United Kingdom</td>
        <td>47</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>46</td>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>46</td>
    </tr>
    <tr>
        <td>Colombia</td>
        <td>42</td>
    </tr>
    <tr>
        <td>Australia</td>
        <td>40</td>
    </tr>
    <tr>
        <td>Spain</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>33</td>
    </tr>
    <tr>
        <td>Monaco</td>
        <td>30</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>30</td>
    </tr>
    <tr>
        <td>Liechtenstein</td>
        <td>28</td>
    </tr>
    <tr>
        <td>Saint Kitts and Nevis</td>
        <td>26</td>
    </tr>
    <tr>
        <td>France</td>
        <td>26</td>
    </tr>
    <tr>
        <td>Israel</td>
        <td>25</td>
    </tr>
    <tr>
        <td>Venezuela</td>
        <td>25</td>
    </tr>
    <tr>
        <td>Costa Rica</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Argentina</td>
        <td>22</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>21</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>20</td>
    </tr>
    <tr>
        <td>New Zealand</td>
        <td>17</td>
    </tr>
    <tr>
        <td>Greece</td>
        <td>16</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Gibraltar</td>
        <td>14</td>
    </tr>
    <tr>
        <td>South Africa</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Netherlands</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Lebanon</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Philippines</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Japan</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>11</td>
    </tr>
    <tr>
        <td>India</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Chile</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Portugal</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Belgium</td>
        <td>9</td>
    </tr>
    <tr>
        <td>South Korea</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Dominican Republic</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Mauritius</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Mexico</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Malta</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Italy</td>
        <td>8</td>
    </tr>
    <tr>
        <td>Viet Nam</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Ireland</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Sweden</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Cook Islands</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Turkey</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Andorra</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Ukraine</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Jordan</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Saudi Arabia</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Latvia</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Panama;United States</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Estonia</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Peru</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Hungary</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Czech Republic</td>
        <td>4</td>
    </tr>
    <tr>
        <td>El Salvador</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Austria</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Poland</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Bahrain</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Belize</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Panama;Spain</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Bulgaria</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Macao</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Norway</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Panama;Brazil</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Turks and Caicos Islands</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Kazakhstan</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Kuwait</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Sri Lanka</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Egypt</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Macao;China</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Kenya</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Finland</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Vanuatu</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Bolivia</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Cuba</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Denmark</td>
        <td>2</td>
    </tr>
    <tr>
        <td>China;Hong Kong</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Qatar</td>
        <td>2</td>
    </tr>
    <tr>
        <td>U.S. Virgin Islands</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Spain;Uruguay</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Uruguay;Argentina</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Russia;Not identified</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Belarus</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Slovakia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>United States;Panama</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Not identified;India</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pakistan</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Switzerland;Monaco</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Indonesia;Not identified</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Singapore;United Arab Emirates</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Oman</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Not identified;Malaysia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Myanmar</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Romania</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bangladesh</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Azerbaijan</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Curaçao</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Syria</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Puerto Rico</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Botswana</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Macedonia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Colombia;El Salvador</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Netherlands;Luxembourg</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Slovenia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Uganda</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Luxembourg;Monaco</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Nigeria</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Singapore;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>United States;Dominican Republic</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Thailand;Hong Kong</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Nicaragua</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Lesotho</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Monaco;Brazil</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Hong Kong;China</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Mauritius;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Saint Vincent and the Grenadines;Hungary</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Switzerland;Israel</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Belgium;Canada</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Saint Vincent and the Grenadines</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Switzerland;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Tunisia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Costa Rica;Canada</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Honduras</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Seychelles;Czech Republic</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Montenegro;Serbia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Iceland</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Panama;Germany</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Paraguay</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Tanzania;Mauritius</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Isle of Man;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Zambia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>India;Switzerland</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-country_codes"></a><a href="#column-nodes-intermediaries-country_codes">**country_codes**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>710</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>118</li><li>307</li><li>1139</li><li>1174</li><li>26747</li><li>26753</li><li>26756</li><li>26759</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.002</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0021</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9259</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9261</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>14509.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.1249</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.4842</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.6958</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>5.3918</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>27.0834</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>3.28571429</li><li>6.71428571</li><li>7.0</li></ul>bin_counts: <ul><li>4498.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>145.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.0011: 3.00212: 3.0031
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li>C</li><li>F</li><li>H</li><li>E</li><li>M</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>HKG</li><li>USA</li><li>GBR</li><li>IMN;GBR</li><li>ZMB</li><li>IND;CHE</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>156</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0336</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>4643</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0003</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0005</li><li>0.0005</li><li>0.001</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>HKG</td>
        <td>1030</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>308</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>299</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>271</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>265</td>
    </tr>
    <tr>
        <td>TWN</td>
        <td>245</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>173</td>
    </tr>
    <tr>
        <td>CHN</td>
        <td>142</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>134</td>
    </tr>
    <tr>
        <td>IDN</td>
        <td>106</td>
    </tr>
    <tr>
        <td>THA</td>
        <td>83</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>81</td>
    </tr>
    <tr>
        <td>BRA</td>
        <td>80</td>
    </tr>
    <tr>
        <td>GTM</td>
        <td>73</td>
    </tr>
    <tr>
        <td>LUX</td>
        <td>71</td>
    </tr>
    <tr>
        <td>ECU</td>
        <td>68</td>
    </tr>
    <tr>
        <td>MYS</td>
        <td>60</td>
    </tr>
    <tr>
        <td>URY</td>
        <td>56</td>
    </tr>
    <tr>
        <td>JEY;GBR</td>
        <td>56</td>
    </tr>
    <tr>
        <td>GGY;GBR</td>
        <td>47</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>46</td>
    </tr>
    <tr>
        <td>IMN</td>
        <td>46</td>
    </tr>
    <tr>
        <td>COL</td>
        <td>42</td>
    </tr>
    <tr>
        <td>AUS</td>
        <td>40</td>
    </tr>
    <tr>
        <td>ESP</td>
        <td>39</td>
    </tr>
    <tr>
        <td>CAN</td>
        <td>39</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>33</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>30</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>30</td>
    </tr>
    <tr>
        <td>LIE</td>
        <td>28</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>26</td>
    </tr>
    <tr>
        <td>FRA</td>
        <td>26</td>
    </tr>
    <tr>
        <td>ISR</td>
        <td>25</td>
    </tr>
    <tr>
        <td>VEN</td>
        <td>25</td>
    </tr>
    <tr>
        <td>CRI</td>
        <td>22</td>
    </tr>
    <tr>
        <td>ARG</td>
        <td>22</td>
    </tr>
    <tr>
        <td>DEU</td>
        <td>21</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>20</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>17</td>
    </tr>
    <tr>
        <td>GRC</td>
        <td>16</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>14</td>
    </tr>
    <tr>
        <td>GIB</td>
        <td>14</td>
    </tr>
    <tr>
        <td>ZAF</td>
        <td>13</td>
    </tr>
    <tr>
        <td>NLD</td>
        <td>13</td>
    </tr>
    <tr>
        <td>LBN</td>
        <td>13</td>
    </tr>
    <tr>
        <td>PHL</td>
        <td>13</td>
    </tr>
    <tr>
        <td>JPN</td>
        <td>11</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>11</td>
    </tr>
    <tr>
        <td>IND</td>
        <td>10</td>
    </tr>
    <tr>
        <td>CHL</td>
        <td>10</td>
    </tr>
    <tr>
        <td>PRT</td>
        <td>9</td>
    </tr>
    <tr>
        <td>BEL</td>
        <td>9</td>
    </tr>
    <tr>
        <td>KOR</td>
        <td>9</td>
    </tr>
    <tr>
        <td>DOM</td>
        <td>9</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>8</td>
    </tr>
    <tr>
        <td>MEX</td>
        <td>8</td>
    </tr>
    <tr>
        <td>MLT</td>
        <td>8</td>
    </tr>
    <tr>
        <td>ITA</td>
        <td>8</td>
    </tr>
    <tr>
        <td>VNM</td>
        <td>7</td>
    </tr>
    <tr>
        <td>IRL</td>
        <td>7</td>
    </tr>
    <tr>
        <td>SWE</td>
        <td>7</td>
    </tr>
    <tr>
        <td>COK</td>
        <td>7</td>
    </tr>
    <tr>
        <td>TUR</td>
        <td>6</td>
    </tr>
    <tr>
        <td>BMU</td>
        <td>6</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>6</td>
    </tr>
    <tr>
        <td>AND</td>
        <td>5</td>
    </tr>
    <tr>
        <td>UKR</td>
        <td>5</td>
    </tr>
    <tr>
        <td>JOR</td>
        <td>5</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>5</td>
    </tr>
    <tr>
        <td>SAU</td>
        <td>5</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>5</td>
    </tr>
    <tr>
        <td>PAN;USA</td>
        <td>5</td>
    </tr>
    <tr>
        <td>EST</td>
        <td>5</td>
    </tr>
    <tr>
        <td>PER</td>
        <td>4</td>
    </tr>
    <tr>
        <td>SYC</td>
        <td>4</td>
    </tr>
    <tr>
        <td>HUN</td>
        <td>4</td>
    </tr>
    <tr>
        <td>CZE</td>
        <td>4</td>
    </tr>
    <tr>
        <td>SLV</td>
        <td>4</td>
    </tr>
    <tr>
        <td>AUT</td>
        <td>3</td>
    </tr>
    <tr>
        <td>POL</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BHR</td>
        <td>3</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>3</td>
    </tr>
    <tr>
        <td>PAN;ESP</td>
        <td>2</td>
    </tr>
    <tr>
        <td>BGR</td>
        <td>2</td>
    </tr>
    <tr>
        <td>MAC</td>
        <td>2</td>
    </tr>
    <tr>
        <td>NOR</td>
        <td>2</td>
    </tr>
    <tr>
        <td>PAN;BRA</td>
        <td>2</td>
    </tr>
    <tr>
        <td>TCA</td>
        <td>2</td>
    </tr>
    <tr>
        <td>KAZ</td>
        <td>2</td>
    </tr>
    <tr>
        <td>KWT</td>
        <td>2</td>
    </tr>
    <tr>
        <td>LKA</td>
        <td>2</td>
    </tr>
    <tr>
        <td>EGY</td>
        <td>2</td>
    </tr>
    <tr>
        <td>MAC;CHN</td>
        <td>2</td>
    </tr>
    <tr>
        <td>KEN</td>
        <td>2</td>
    </tr>
    <tr>
        <td>FIN</td>
        <td>2</td>
    </tr>
    <tr>
        <td>VUT</td>
        <td>2</td>
    </tr>
    <tr>
        <td>BOL</td>
        <td>2</td>
    </tr>
    <tr>
        <td>CUB</td>
        <td>2</td>
    </tr>
    <tr>
        <td>DNK</td>
        <td>2</td>
    </tr>
    <tr>
        <td>CHN;HKG</td>
        <td>2</td>
    </tr>
    <tr>
        <td>ABW</td>
        <td>2</td>
    </tr>
    <tr>
        <td>QAT</td>
        <td>2</td>
    </tr>
    <tr>
        <td>VIR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ESP;URY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>URY;ARG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>RUS;XXX</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BLR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SVK</td>
        <td>1</td>
    </tr>
    <tr>
        <td>USA;PAN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>XXX;IND</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PAK</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CHE;MCO</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IDN;XXX</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SGP;ARE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>OMN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>XXX;MYS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MMR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ROU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BGD</td>
        <td>1</td>
    </tr>
    <tr>
        <td>AZE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CUW</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SYR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PRI</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BWA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MKD</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COL;SLV</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NLD;LUX</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SVN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>UGA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LUX;MCO</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NGA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SGP;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>USA;DOM</td>
        <td>1</td>
    </tr>
    <tr>
        <td>THA;HKG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NIC</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LSO</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MCO;BRA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>HKG;CHN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MUS;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>VCT;HUN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CHE;ISR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BEL;CAN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>VCT</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CHE;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TUN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CRI;CAN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>HND</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SYC;CZE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MNE;SRB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ISL</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PAN;DEU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PRY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TZA;MUS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IMN;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ZMB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IND;CHE</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-sourceID"></a><a href="#column-nodes-intermediaries-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>57.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.022</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>13.0402</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.5889</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.589</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>89046.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>16.6348</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>108.4389</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>10.4134</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.043</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>7.723</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>13.0</li><li>13.11428571</li><li>56.88571429</li><li>57.0</li></ul>bin_counts: <ul><li>2933.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>190.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.02011: 13.04022: 13.9928
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>-</li><li> </li><li>C</li><li>n</li><li>s</li><li>G</li><li>a</li><li>&</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Panama Papers</li><li>Paradise Papers - Aruba corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0017</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0007</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0006</li><li>0.0005</li><li>0.0013</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>2831</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>1917</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>204</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>190</td>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>102</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>43</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>35</td>
    </tr>
    <tr>
        <td>Paradise Papers - Nevis corporate registry</td>
        <td>24</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>7</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-valid_until"></a><a href="#column-nodes-intermediaries-valid_until">**valid_until**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>36.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>56.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>47.01</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>47.0103</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.5893</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.5894</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>252284.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>47.1295</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>8.8209</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>2.97</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.3958</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>6.9112</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>36.0</li><li>37.42857143</li><li>54.57142857</li><li>56.0</li></ul>bin_counts: <ul><li>225.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>133.0</li><li>0.0</li><li>247.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 47.00471: 47.01032: 47.016
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li> </li><li>2</li><li>n</li><li>s</li><li>0</li><li>5</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>The Panama Papers  data is current through 2015</li><li>Aruba corporate registry data is current through 2016</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0019</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>5353</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0016</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0006</li><li>0.0009</li><li>0.0011</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>The Panama Papers  data is current through 2015</td>
        <td>2831</td>
    </tr>
    <tr>
        <td>The Offshore Leaks data is current through 2010</td>
        <td>1917</td>
    </tr>
    <tr>
        <td>Barbados corporate registry data is current through 2016</td>
        <td>204</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>141</td>
    </tr>
    <tr>
        <td>The Bahamas Leaks data is current through early 2016.</td>
        <td>102</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>49</td>
    </tr>
    <tr>
        <td>Bahamas corporate registry data is current through 2016</td>
        <td>43</td>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>35</td>
    </tr>
    <tr>
        <td>Nevis corporate registry data is current through 2016</td>
        <td>24</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>7</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-intermediaries-note"></a><a href="#column-nodes-intermediaries-note">**note**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>26768</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>26761</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>0</li><li>1</li><li>2</li><li>26765</li><li>26766</li><li>26767</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>103.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>865.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>103.381</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>447.043</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8163</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9524</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2924.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>417.7143</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>94328.5714</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>307.1296</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.2154</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.7451</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>103.0</li><li>293.5</li><li>484.0</li><li>674.5</li><li>865.0</li></ul>bin_counts: <ul><li>3.0</li><li>1.0</li><li>2.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 103.66681: 447.0432: 654.1165
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>4</li><li>C</li><li>2</li><li>s</li><li>B</li><li>T</li><li>0</li><li>E</li><li>a</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>The name of this intermediary is displayed as it originally appeared in the leaked files ICIJ received.</li><li>Not all beneficiaries are aware of offshore trusts in which they are named because the settlor may select beneficiaries without their knowledge.</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.8571</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-nodes-officers">Dataset: nodes-officers</a>

<a id="profile-nodes-officers-node_id"></a><a href="#column-nodes-officers-node_id">**node_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240556383.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>12148098.291</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>55875331.7541</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8998568819757.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>58332645.0267</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>3886899326426522.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>62345002.4174</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.5013</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.0822</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>2733596.25</li><li>237822788.0</li><li>240556383.0</li></ul>bin_counts: <ul><li>21601.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>10193.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 12097820.81641: 55875331.75412: 86003794.295
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0007</li><li>0.0147</li><li>0.0148</li><li>0.0214</li><li>0.0001</li><li>0.0001</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-name"></a><a href="#column-nodes-officers-name">**name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td> : <ul><li>273610</li></ul>"": <ul><li>246089</li><li>246126</li><li>269573</li><li>283354</li><li>292960</li><li>318877</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>200.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10.0545</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>17.0012</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2927975.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>18.9821</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>98.4689</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>9.9232</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.6297</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>28.8633</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>1.37265918</li><li>199.62734082</li><li>200.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>2.0</li><li>0.0</li><li>0.0</li><li>11.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 12.97391: 17.00122: 22.9127
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>;</li><li>恆</li><li>Č</li><li>玉</li><li>р</li><li>偉</li><li>i</li><li>盛</li><li>立</li><li>=</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>121479</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.7876</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0213</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0142</li><li>0.0139</li><li>0.0197</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-countries"></a><a href="#column-nodes-officers-countries">**countries**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>60185</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>21</li><li>56</li><li>76</li><li>77</li><li>771250</li><li>771279</li><li>771280</li><li>771290</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>74.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.015</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.9715</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9614</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9614</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>943972.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.0339</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>33.2541</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.7666</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.7824</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>4.8239</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.35175879</li><li>73.64824121</li><li>74.0</li></ul>bin_counts: <ul><li>512.0</li><li>0.0</li><li>21443.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 5.96691: 8.97152: 13.9409
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>J</li><li>F</li><li>B</li><li>y</li><li>T</li><li>I</li><li>,</li><li>s</li><li>C</li><li>d</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Malta</li><li>Mexico;Mexico; Colombia;Colombia</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>1781</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0189</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>94078</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0101</li><li>0.0001</li><li>0.0001</li><li>0.0</li><li>0.0005</li><li>0.0089</li><li>0.0085</li><li>0.0126</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Malta</td>
        <td>9005</td>
    </tr>
    <tr>
        <td>Not identified</td>
        <td>7986</td>
    </tr>
    <tr>
        <td>China</td>
        <td>7582</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>6068</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>5375</td>
    </tr>
    <tr>
        <td>Taiwan</td>
        <td>4191</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>3746</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>3350</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>1731</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>1640</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>1600</td>
    </tr>
    <tr>
        <td>Italy</td>
        <td>1596</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>1485</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>1401</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>1163</td>
    </tr>
    <tr>
        <td>Samoa</td>
        <td>1035</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>921</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>892</td>
    </tr>
    <tr>
        <td>Brazil</td>
        <td>840</td>
    </tr>
    <tr>
        <td>Argentina</td>
        <td>800</td>
    </tr>
    <tr>
        <td>Ireland;South Africa</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Barbados;Cayman Islands;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>South Africa;South Korea;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Malaysia;South Africa;South Korea</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Australia;Bahrain</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Poland;France</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Greece;Israel;United States</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Romania;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Uganda;Luxembourg;France</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Mexico;Mexico; Colombia;Colombia</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-country_codes"></a><a href="#column-nodes-officers-country_codes">**country_codes**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>59914</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>21</li><li>56</li><li>76</li><li>77</li><li>771250</li><li>771279</li><li>771280</li><li>771290</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>27.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.012</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0131</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9617</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9618</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>319918.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.3908</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.9241</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.3871</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>4.3729</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>24.8018</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>4.33333333</li><li>25.66666667</li><li>27.0</li></ul>bin_counts: <ul><li>86291.0</li><li>0.0</li><li>2.0</li><li>1.0</li><li>0.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00661: 3.01312: 3.0197
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>N</li><li>S</li><li>W</li><li>D</li><li>O</li><li>I</li><li>M</li><li>C</li><li>;</li><li>X</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>MLT</li><li>XXX</li><li>GBR;MCO;UGA</li><li>COL;MEX;MEX; COL</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2128</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0226</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>94349</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0061</li><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0089</li><li>0.0087</li><li>0.0115</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>MLT</td>
        <td>8996</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>7986</td>
    </tr>
    <tr>
        <td>CHN</td>
        <td>7580</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>6021</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>5350</td>
    </tr>
    <tr>
        <td>TWN</td>
        <td>4194</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>3748</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>3207</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>2239</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>1632</td>
    </tr>
    <tr>
        <td>ITA</td>
        <td>1606</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>1505</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>1475</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>1373</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>1129</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>1035</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>891</td>
    </tr>
    <tr>
        <td>BRA</td>
        <td>810</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>793</td>
    </tr>
    <tr>
        <td>IDN</td>
        <td>790</td>
    </tr>
    <tr>
        <td>CAN;DOM;MAR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DNK;LUX</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ARE;AUS;IND</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COG;EGY;ITA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GBR;MCO;NZL</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BRA;URY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COL;NLD</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COG;PRT</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GBR;MCO;UGA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>COL;MEX;MEX; COL</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-sourceID"></a><a href="#column-nodes-officers-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>57.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.022</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>24.9762</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8249</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8249</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>4207986.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>27.278</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>219.4643</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>14.8143</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.3355</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.5579</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>13.0</li><li>14.07317073</li><li>55.92682927</li><li>57.0</li></ul>bin_counts: <ul><li>74245.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>4862.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.03221: 24.97622: 42.0287
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>s</li><li>c</li><li>á</li><li>B</li><li>T</li><li>t</li><li>P</li><li>g</li><li>S</li><li>N</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Panama Papers</li><li>Paradise Papers - Bahamas corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>21</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0001</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.028</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.0144</li><li>0.014</li><li>0.0177</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>47539</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>25394</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>21602</td>
    </tr>
    <tr>
        <td>Paradise Papers - Malta corporate registry</td>
        <td>21523</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>15411</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>6141</td>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>5104</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>4862</td>
    </tr>
    <tr>
        <td>Pandora Papers - SFM Corporate Services</td>
        <td>1707</td>
    </tr>
    <tr>
        <td>Paradise Papers - Samoa corporate registry</td>
        <td>1181</td>
    </tr>
    <tr>
        <td>Pandora Papers - Trident Trust</td>
        <td>1071</td>
    </tr>
    <tr>
        <td>Pandora Papers - Commence Overseas</td>
        <td>814</td>
    </tr>
    <tr>
        <td>Pandora Papers - Fidelity Corporate Services</td>
        <td>518</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha Consulting</td>
        <td>518</td>
    </tr>
    <tr>
        <td>Pandora Papers - CILTrust International</td>
        <td>430</td>
    </tr>
    <tr>
        <td>Pandora Papers - Il Shin Corporate Consulting Limited</td>
        <td>150</td>
    </tr>
    <tr>
        <td>Paradise Papers - Cook Islands corporate registry</td>
        <td>131</td>
    </tr>
    <tr>
        <td>Pandora Papers - Overseas Management Company (OMC)</td>
        <td>79</td>
    </tr>
    <tr>
        <td>Pandora Papers - Asiaciti Trust</td>
        <td>44</td>
    </tr>
    <tr>
        <td>Paradise Papers - Nevis corporate registry</td>
        <td>42</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>2</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-valid_until"></a><a href="#column-nodes-officers-valid_until">**valid_until**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>99</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>750127</li><li>750666</li><li>751002</li><li>768544</li><li>768585</li><li>768844</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>26.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>129.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>46.0335</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>46.9308</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8247</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8247</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>7368830.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>47.7986</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>39.7182</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>6.3022</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.4776</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.3545</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>26.0</li><li>26.26075949</li><li>128.73924051</li><li>129.0</li></ul>bin_counts: <ul><li>6.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 46.01141: 46.93082: 53.0496
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>O</li><li>N</li><li>h</li><li>m</li><li>'</li><li>u</li><li>i</li><li>t</li><li>á</li><li>.</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>The Panama Papers data is current through 2015</li><li>The Pandora Papers - Asiaciti data is current through 2016</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>59</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0004</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>154164</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0411</li><li>0.0002</li><li>0.0001</li><li>0.0001</li><li>0.0004</li><li>0.014</li><li>0.0139</li><li>0.0173</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>The Panama Papers data is current through 2015</td>
        <td>47539</td>
    </tr>
    <tr>
        <td>Barbados corporate registry data is current through 2016</td>
        <td>25394</td>
    </tr>
    <tr>
        <td>The Offshore Leaks data is current through 2010</td>
        <td>21602</td>
    </tr>
    <tr>
        <td>Malta corporate registry data is current through 2016</td>
        <td>21523</td>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>15411</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>6141</td>
    </tr>
    <tr>
        <td>The Bahamas Leaks data is current through early 2016.</td>
        <td>5104</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>4735</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>2369</td>
    </tr>
    <tr>
        <td>Samoa corporate registry data is current through 2016</td>
        <td>1181</td>
    </tr>
    <tr>
        <td>Provider data is current through 2016</td>
        <td>1027</td>
    </tr>
    <tr>
        <td>Provider data is current through 2015</td>
        <td>299</td>
    </tr>
    <tr>
        <td>Provider data is current through 2013</td>
        <td>267</td>
    </tr>
    <tr>
        <td>Provider data is current through 2012</td>
        <td>251</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2017</td>
        <td>238</td>
    </tr>
    <tr>
        <td>Provider data is current through 2014</td>
        <td>191</td>
    </tr>
    <tr>
        <td>Provider data is current through 2011</td>
        <td>159</td>
    </tr>
    <tr>
        <td>Cook Islands corporate registry data is current through 2016</td>
        <td>131</td>
    </tr>
    <tr>
        <td>Provider data is current through 2019</td>
        <td>104</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2018</td>
        <td>99</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2019</td>
        <td>95</td>
    </tr>
    <tr>
        <td>Data is current through 2017.</td>
        <td>56</td>
    </tr>
    <tr>
        <td>Nevis corporate registry data is current through 2016</td>
        <td>42</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2016</td>
        <td>21</td>
    </tr>
    <tr>
        <td>Data is current through 2016.</td>
        <td>18</td>
    </tr>
    <tr>
        <td>Data is current through 2018.</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2020</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2013</td>
        <td>14</td>
    </tr>
    <tr>
        <td>Data is current through 2015.</td>
        <td>13</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2018</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2015</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2014</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Provider data is current through 2010</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Data is current through 2013.</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Provider data is current through 2020</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Data current through 2017.</td>
        <td>6</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2017</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2011</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Provider data is current through nan</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2010</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Provider data is current through 2008</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Provider data is current through 2009</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Bahamas corporate registry data is current through 2016</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Data is current through 2011.</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alcogal data is current through 2011. Record manually added from leaked documents.</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Provider data is current through 2007</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2008</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2019</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2009</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Dta is current through 2017.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Data is current through 2009.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2012</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2006</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2015</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Provider data is current through 1970</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2011</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Data is current through 2012.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Data is current through 2017. Data on Sebastián Piñera's role come from 2006 and 2015 external documents obtained by Ciper Chile.</td>
        <td>1</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2016</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-officers-note"></a><a href="#column-nodes-officers-note">**note**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>154263</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>153518</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>21</li><li>27</li><li>33</li><li>34</li><li>771292</li><li>771297</li><li>771301</li><li>771303</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>43.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>360.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>143.9645</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>143.9588</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.2005</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.2007</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>105032.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>140.9826</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>930.7322</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>30.5079</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-0.1671</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>11.0792</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>43.0</li><li>71.81818182</li><li>331.18181818</li><li>360.0</li></ul>bin_counts: <ul><li>41.0</li><li>11.0</li><li>0.0</li><li>666.0</li><li>0.0</li><li>25.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>2.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 143.871: 143.95882: 144.0476
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>J</li><li>F</li><li>y</li><li>B</li><li>T</li><li>,</li><li>s</li><li>C</li><li>d</li><li>á</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Not all beneficiaries are aware of offshore trusts in which they are named because the settlor may select beneficiaries without their knowledge.</li><li>The data current through 2017. Data on Sebastián Piñera's role comes from 2004 external documents obtained by Ciper Chile and Fundación Periodística LaBot.</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0148</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>745</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0007</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.0001</li><li>0.0005</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-nodes-others">Dataset: nodes-others</a>

<a id="profile-nodes-others-node_id"></a><a href="#column-nodes-others-node_id">**node_id**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>80000012.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240558070.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>80080291.029</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>80118157.7497</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>254951718578.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>85296660.6149</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>583367393506064.1</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>24152999.6793</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>6.2202</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>37.0814</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>80000012.0</li><li>80689102.3776824</li><li>239868980.0</li><li>240558070.0</li></ul>bin_counts: <ul><li>2031.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>70.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 80059084.87491: 80118157.74972: 85015417.2155
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0004</li><li>0.0003</li><li>0.0008</li><li>0.0</li><li>0.0</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-name"></a><a href="#column-nodes-others-name">**name**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>NONE: <ul><li>1719</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>155.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>12.9395</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>20.0197</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>69820.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>23.3668</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>223.2126</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>14.9403</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.5803</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>17.8001</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>3.66304348</li><li>153.33695652</li><li>155.0</li></ul>bin_counts: <ul><li>3.0</li><li>3.0</li><li>1.0</li><li>11.0</li><li>129.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 14.88081: 20.01972: 27.0036
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>4</li><li>C</li><li>元</li><li>2</li><li>/</li><li>0</li><li>E</li><li>團</li><li>a</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2975</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9956</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0005</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0003</li><li>0.0007</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-type"></a><a href="#column-nodes-others-type">**type**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2101</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>45</li><li>46</li><li>47</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>14.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>26.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>24.998</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>24.998</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.0157</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.0157</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>22159.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.9538</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.5469</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.7395</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-14.6775</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>215.533</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>14.0</li><li>15.09090909</li><li>24.90909091</li><li>26.0</li></ul>bin_counts: <ul><li>4.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>884.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 24.9951: 24.9982: 25.001
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>D</li><li> </li><li>C</li><li>F</li><li>H</li><li>E</li><li>M</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>LIMITED LIABILITY COMPANY</li><li>SOLE OWNERSHIP</li><li>FOREIGN FORMED CORPORATION</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0034</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>888</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>LIMITED LIABILITY COMPANY</td>
        <td>881</td>
    </tr>
    <tr>
        <td>SOLE OWNERSHIP</td>
        <td>4</td>
    </tr>
    <tr>
        <td>FOREIGN FORMED CORPORATION</td>
        <td>3</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-incorporation_date"></a><a href="#column-nodes-others-incorporation_date">**incorporation_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2101</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>45</li><li>46</li><li>47</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>9768.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0102</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>888</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>4</li><li>D</li><li>-</li><li>C</li><li>M</li><li>E</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>834</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9392</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0002</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-struck_off_date"></a><a href="#column-nodes-others-struck_off_date">**struck_off_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2944</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>0</li><li>2</li><li>4</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>495.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.2159</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>45</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>U</li><li>D</li><li>-</li><li>C</li><li>E</li><li>M</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>39</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.8667</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0</li><li>0.0002</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-closed_date"></a><a href="#column-nodes-others-closed_date">**closed_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2872</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>1</li><li>3</li><li>5</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1287.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-3.0792</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>117</li></ul>bin_edges: <ul><li>11.0</li><li>11.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 11.01: 11.02: 11.0
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>U</li><li>D</li><li>-</li><li>C</li><li>M</li><li>E</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>112</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.9573</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0002</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-jurisdiction"></a><a href="#column-nodes-others-jurisdiction">**jurisdiction**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2031</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>45</li><li>46</li><li>47</li><li>2073</li><li>2074</li><li>2075</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>2.0005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>2.0005</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.1366</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.1367</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1986.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>2.0731</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.0678</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.2604</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.2861</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>8.8167</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>2.0</li><li>2.09090909</li><li>2.90909091</li><li>3.0</li></ul>bin_counts: <ul><li>888.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>70.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 2.00031: 2.00052: 2.0008
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>L</li><li>U</li><li>B</li><li>N</li><li>Z</li><li>K</li><li>A</li><li>G</li><li>P</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>AW</li><li>VGB</li><li>BLZ</li><li>PAN</li><li>KNA</li><li>USA</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0063</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>958</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>AW</td>
        <td>888</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>62</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>3</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>2</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>2</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-jurisdiction_description"></a><a href="#column-nodes-others-jurisdiction_description">**jurisdiction_description**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2031</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>45</li><li>46</li><li>47</li><li>2073</li><li>2074</li><li>2075</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>5.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>22.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>5.0085</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>5.0091</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.1366</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.1367</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>5856.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>6.1127</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>17.54</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>4.1881</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>3.5294</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>10.4995</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>5.0</li><li>6.54545455</li><li>20.45454545</li><li>22.0</li></ul>bin_counts: <ul><li>895.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>62.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 5.00461: 5.00912: 5.0137
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>h</li><li>D</li><li> </li><li>i</li><li>v</li><li>k</li><li>m</li><li>a</li><li>l</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Aruba</li><li>British Virgin Islands</li><li>Nevis</li><li>South Dakota</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>6</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0063</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>958</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0001</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0004</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>888</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>62</td>
    </tr>
    <tr>
        <td>Belize</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Nevis</td>
        <td>2</td>
    </tr>
    <tr>
        <td>South Dakota</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-countries"></a><a href="#column-nodes-others-countries">**countries**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2603</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>0</li><li>1</li><li>2</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>41.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>11.0115</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>11.0236</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8692</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8714</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>4758.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>12.3264</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>32.688</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.7173</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.9257</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>5.3798</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>5.37037037</li><li>39.62962963</li><li>41.0</li></ul>bin_counts: <ul><li>21.0</li><li>31.0</li><li>36.0</li><li>14.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 9.01751: 11.02362: 14.0078
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li> </li><li>C</li><li>K</li><li>E</li><li>G</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Isle of Man</li><li>Cayman Islands</li><li>Peru</li><li>Turkey;United States</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>63</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.1632</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>386</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>105</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>79</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>26</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>24</td>
    </tr>
    <tr>
        <td>Ireland</td>
        <td>14</td>
    </tr>
    <tr>
        <td>China</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>12</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>10</td>
    </tr>
    <tr>
        <td>British Virgin Islands;Isle of Man</td>
        <td>9</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Mauritius</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Isle of Man;United Kingdom</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>4</td>
    </tr>
    <tr>
        <td>Monaco</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Greece</td>
        <td>3</td>
    </tr>
    <tr>
        <td>India</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Mexico</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Australia</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Israel</td>
        <td>2</td>
    </tr>
    <tr>
        <td>United Kingdom;United States</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Egypt</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Pakistan;United Arab Emirates</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Gibraltar</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Canada;Colombia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bermuda;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Nigeria;United States</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Qatar</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Turkey</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Germany;Switzerland</td>
        <td>1</td>
    </tr>
    <tr>
        <td>South Africa;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Malta;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>South Africa</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Dominican Republic;Mexico;Spain</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Jamaica</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Japan</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Germany;Netherlands</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Argentina;Bahamas</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bahamas;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bahrain</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Latvia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Isle of Man;Panama</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Isle of Man;Switzerland</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Ireland;Isle of Man</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Canada;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>France</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Bermuda;Germany;Switzerland;United States</td>
        <td>1</td>
    </tr>
    <tr>
        <td>French Guiana</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Saudi Arabia</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Lebanon</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Jersey;United Kingdom</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Kenya</td>
        <td>1</td>
    </tr>
    <tr>
        <td>China;Hong Kong</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Peru</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Turkey;United States</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-country_codes"></a><a href="#column-nodes-others-country_codes">**country_codes**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2603</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>0</li><li>1</li><li>2</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>3.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>15.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>3.006</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>3.0066</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8692</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8714</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>1306.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>3.3834</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>1.7227</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>1.3125</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>4.0453</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>21.0289</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>3.0</li><li>4.2</li><li>5.4</li><li>6.6</li><li>7.8</li><li>10.2</li><li>11.4</li><li>12.6</li><li>13.8</li><li>15.0</li></ul>bin_counts: <ul><li>352.0</li><li>0.0</li><li>0.0</li><li>32.0</li><li>0.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>0.0</li><li>1.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 3.00331: 3.00662: 3.0099
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>U</li><li>D</li><li>C</li><li>F</li><li>H</li><li>M</li><li>E</li><li>G</li><li>R</li><li>S</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>IMN</li><li>CYM</li><li>GBR</li><li>CHN;HKG</li><li>PER</li><li>TUR;USA</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>63</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.1632</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>386</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>IMN</td>
        <td>105</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>79</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>26</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>24</td>
    </tr>
    <tr>
        <td>IRL</td>
        <td>14</td>
    </tr>
    <tr>
        <td>CHN</td>
        <td>13</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>12</td>
    </tr>
    <tr>
        <td>BMU</td>
        <td>10</td>
    </tr>
    <tr>
        <td>VGB;IMN</td>
        <td>9</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>7</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>7</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>5</td>
    </tr>
    <tr>
        <td>IMN;GBR</td>
        <td>5</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>5</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>4</td>
    </tr>
    <tr>
        <td>CAN</td>
        <td>4</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>3</td>
    </tr>
    <tr>
        <td>GRC</td>
        <td>3</td>
    </tr>
    <tr>
        <td>IND</td>
        <td>3</td>
    </tr>
    <tr>
        <td>MEX</td>
        <td>2</td>
    </tr>
    <tr>
        <td>AUS</td>
        <td>2</td>
    </tr>
    <tr>
        <td>DEU</td>
        <td>2</td>
    </tr>
    <tr>
        <td>ISR</td>
        <td>2</td>
    </tr>
    <tr>
        <td>GBR;USA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>EGY</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PAK;ARE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GIB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CAN;COL</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BMU;IMN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>NGA;USA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>QAT</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TUR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DEU;CHE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ZAF;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>MLT;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ZAF</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DOM;MEX;ESP</td>
        <td>1</td>
    </tr>
    <tr>
        <td>JAM</td>
        <td>1</td>
    </tr>
    <tr>
        <td>JPN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>DEU;NLD</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ARG;BHS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BHS;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BHR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IMN;PAN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IMN;CHE</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>IRL;IMN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CAN;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>FRA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>BMU;DEU;CHE;USA</td>
        <td>1</td>
    </tr>
    <tr>
        <td>GUF</td>
        <td>1</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>1</td>
    </tr>
    <tr>
        <td>SAU</td>
        <td>1</td>
    </tr>
    <tr>
        <td>LBN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>JEY;GBR</td>
        <td>1</td>
    </tr>
    <tr>
        <td>KEN</td>
        <td>1</td>
    </tr>
    <tr>
        <td>CHN;HKG</td>
        <td>1</td>
    </tr>
    <tr>
        <td>PER</td>
        <td>1</td>
    </tr>
    <tr>
        <td>TUR;USA</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-sourceID"></a><a href="#column-nodes-others-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>25.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>57.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>25.016</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>25.0235</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.4497</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.4499</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>90581.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>30.3048</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>62.6002</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>7.912</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.8814</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.0773</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>25.0</li><li>27.28571429</li><li>54.71428571</li><li>57.0</li></ul>bin_counts: <ul><li>2031.0</li><li>0.0</li><li>49.0</li><li>0.0</li><li>11.0</li><li>0.0</li><li>0.0</li><li>5.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 25.01181: 25.02352: 41.9977
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>-</li><li> </li><li>C</li><li>n</li><li>s</li><li>M</li><li>G</li><li>a</li><li>&</li><li>l</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Paradise Papers - Appleby</li><li>Pandora Papers - Fidelity Corporate Services</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0023</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0005</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0003</li><li>0.0006</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>2031</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>888</td>
    </tr>
    <tr>
        <td>Pandora Papers - Trident Trust</td>
        <td>49</td>
    </tr>
    <tr>
        <td>Pandora Papers - Overseas Management Company (OMC)</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Pandora Papers - CILTrust International</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Pandora Papers - Fidelity Corporate Services</td>
        <td>2</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-valid_until"></a><a href="#column-nodes-others-valid_until">**valid_until**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>36.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>53.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>36.0085</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>36.0125</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.4499</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.45</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>122770.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>41.0739</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>60.1575</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>7.7561</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.8873</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.2119</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>36.0</li><li>37.30769231</li><li>51.69230769</li><li>53.0</li></ul>bin_counts: <ul><li>2101.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>888.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 36.00631: 36.01252: 52.9857
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>4</li><li>h</li><li> </li><li>i</li><li>v</li><li>g</li><li>5</li><li>a</li><li>p</li><li>l</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Appleby data is current through 2014</li><li>Provider data is current through 2012</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>10</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0033</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0007</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0003</li><li>0.0003</li><li>0.0005</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>2031</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>888</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>35</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Provider data is current through 2019</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Provider data is current through 2016</td>
        <td>7</td>
    </tr>
    <tr>
        <td>Provider data is current through 2013</td>
        <td>5</td>
    </tr>
    <tr>
        <td>Provider data is current through 2008</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Provider data is current through 2015</td>
        <td>1</td>
    </tr>
    <tr>
        <td>Provider data is current through 2012</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-nodes-others-note"></a><a href="#column-nodes-others-note">**note**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>2989</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>2872</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>1</li><li>3</li><li>5</li><li>2986</li><li>2987</li><li>2988</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>38.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>40.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>38.001</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>38.0013</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.355</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.3581</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>4500.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>38.4615</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.7162</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.8463</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.2947</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.3297</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>38.0</li><li>38.25</li><li>38.5</li><li>38.75</li><li>39.25</li><li>39.5</li><li>39.75</li><li>40.0</li></ul>bin_counts: <ul><li>90.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>27.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 38.00071: 38.00132: 38.002
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>C</li><li> </li><li>i</li><li>n</li><li>s</li><li>d</li><li>t</li><li>a</li><li>l</li><li>f</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Closed date stands for Cancelled date.</li><li>Closed date stands for Liquidation date.</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0171</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>117</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0001</li><li>0.0003</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Closed date stands for Cancelled date.</td>
        <td>90</td>
    </tr>
    <tr>
        <td>Closed date stands for Liquidation date.</td>
        <td>27</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


### <a href="#dataset-relationships">Dataset: relationships</a>

<a id="profile-relationships-node_id_start"></a><a href="#column-relationships-node_id_start">**node_id_start**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240558065.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>120280.032</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>55827578.162</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>36100570575341.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>54054665.5856</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>3468652906694516.5</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>58895270.6649</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.7986</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>3.288</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>1551988.51</li><li>239006077.0</li><li>240558065.0</li></ul>bin_counts: <ul><li>111968.0</li><li>846.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>29133.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 12034867.2521: 55827578.1622: 80011330.3331
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>373805</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.5597</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0004</li><li>0.0003</li><li>0.0002</li><li>0.0023</li><li>0.0659</li><li>0.066</li><li>0.0973</li><li>0.0007</li><li>0.0004</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-node_id_end"></a><a href="#column-relationships-node_id_end">**node_id_end**</a>

*inferredDataType:* int


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>498.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>240558042.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>54967896.804</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>54894467.3188</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>35431698104102.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>53053139.0951</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>3289981105692879.5</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>57358356.895</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.728</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>3.1342</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>498.0</li><li>1636943.88</li><li>238921596.0</li><li>240558042.0</li></ul>bin_counts: <ul><li>112596.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>29133.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 10130724.07861: 54894467.31882: 81812855.0602
        </td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>436618</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.6538</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0006</li><li>0.0003</li><li>0.0002</li><li>0.002</li><li>0.066</li><li>0.0647</li><li>0.1148</li><li>0.0005</li><li>0.0002</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-rel_type"></a><a href="#column-relationships-rel_type">**rel_type**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Min</td>
        <td>7.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>24.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10.0005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>10.0079</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.6385</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.6385</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>8637012.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>12.9325</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>12.2015</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>3.4931</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.4167</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.4862</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>7.0</li><li>7.11409396</li><li>23.88590604</li><li>24.0</li></ul>bin_counts: <ul><li>10292.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>24.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 9.99971: 10.00792: 15.0069
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>o</li><li>d</li><li>e</li><li>r</li><li>t</li><li>i</li><li>f</li><li>b</li><li>a</li><li>m</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>officer_of</li><li>registered_address</li><li>probably_same_officer_as</li><li>same_address_as</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>13</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0763</li><li>0.0003</li><li>0.0003</li><li>0.0002</li><li>0.0016</li><li>0.0617</li><li>0.06</li><li>0.0816</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>officer_of</td>
        <td>344665</td>
    </tr>
    <tr>
        <td>registered_address</td>
        <td>166150</td>
    </tr>
    <tr>
        <td>intermediary_of</td>
        <td>119545</td>
    </tr>
    <tr>
        <td>same_name_as</td>
        <td>20757</td>
    </tr>
    <tr>
        <td>similar</td>
        <td>9423</td>
    </tr>
    <tr>
        <td>same_company_as</td>
        <td>3089</td>
    </tr>
    <tr>
        <td>connected_to</td>
        <td>2400</td>
    </tr>
    <tr>
        <td>same_as</td>
        <td>869</td>
    </tr>
    <tr>
        <td>same_id_as</td>
        <td>643</td>
    </tr>
    <tr>
        <td>underlying</td>
        <td>245</td>
    </tr>
    <tr>
        <td>similar_company_as</td>
        <td>41</td>
    </tr>
    <tr>
        <td>probably_same_officer_as</td>
        <td>24</td>
    </tr>
    <tr>
        <td>same_address_as</td>
        <td>2</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-link"></a><a href="#column-relationships-link">**link**</a>

*inferredDataType:* text


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>80</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>1555392</li><li>1555394</li><li>1555422</li><li>3303741</li><li>3303899</li><li>3303947</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>2.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>281.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.95387454</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>14.9705</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.8894</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.8894</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>10711083.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>16.04</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>25.9466</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>5.0938</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>2.4771</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>23.1049</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_counts: <ul><li>1</li><li>0</li><li>0</li><li>0</li><li>0</li><li>1</li></ul>bin_edges: <ul><li>2.0</li><li>2.11439114</li><li>280.88560886</li><li>281.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.07291: 14.97052: 17.9567
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>-</li><li>m</li><li>b</li><li>.</li><li>E</li><li>W</li><li>e</li><li>I</li><li>Ê</li><li>Z</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>shareholder of</li><li>registered address</li><li>proxy b / department manager facilities of</li><li>c.e.o. / pres. / dir.</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>520</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0008</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>667773</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.082</li><li>0.0003</li><li>0.0003</li><li>0.0002</li><li>0.0016</li><li>0.0626</li><li>0.0607</li><li>0.0889</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-status"></a><a href="#column-relationships-status">**status**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>632894</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>10</li><li>14</li><li>27</li><li>28</li><li>3339254</li><li>3339260</li><li>3339262</li><li>3339264</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>8.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>9.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>8.0005</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>8.0007</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.3756</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.3756</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>288434.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>8.2506</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.1878</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.4334</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>1.1508</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-0.6756</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>8.0</li><li>8.05882353</li><li>8.94117647</li><li>9.0</li></ul>bin_counts: <ul><li>26197.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>8762.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 8.00031: 8.00072: 8.999
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>o</li><li>n</li><li>d</li><li>t</li><li>e</li><li>R</li><li>s</li><li>g</li><li>A</li><li>i</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Resigned</li><li>Appointed</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>2</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0001</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>34959</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0032</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0001</li><li>0.0034</li><li>0.0033</li><li>0.0046</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Resigned</td>
        <td>26197</td>
    </tr>
    <tr>
        <td>Appointed</td>
        <td>8762</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-start_date"></a><a href="#column-relationships-start_date">**start_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>478334</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>10</li><li>14</li><li>27</li><li>28</li><li>3339254</li><li>3339260</li><li>3339262</li><li>3339264</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>4.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10.9965</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>10.9953</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9999</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9999</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>2035383.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.7397</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.2038</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.4514</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-1.4172</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>2.0011</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>4.0</li><li>4.03465347</li><li>10.96534653</li><li>11.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>140917.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 10.00581: 10.99532: 10.9976
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>J</li><li>.</li><li>E</li><li>F</li><li>B</li><li>p</li><li>U</li><li>S</li><li>M</li><li>Y</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>31-DEC-1969</li><li>24-AUG-2010</li><li>4/7/2007</li><li>10-JUN-2019</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>17893</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0944</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>189519</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0193</li><li>0.0001</li><li>0.0001</li><li>0.0001</li><li>0.0005</li><li>0.0179</li><li>0.0178</li><li>0.0139</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-end_date"></a><a href="#column-relationships-end_date">**end_date**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>614025</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>10</li><li>14</li><li>27</li><li>28</li><li>3339254</li><li>3339260</li><li>3339262</li><li>3339264</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>1.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>11.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>10.995</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>10.9944</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.9984</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.9985</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>585973.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>10.886</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>0.1054</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>0.3246</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>-3.523</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>39.2893</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>1.0</li><li>1.58823529</li><li>10.41176471</li><li>11.0</li></ul>bin_counts: <ul><li>2.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>1.0</li><li>0.0</li><li>6100.0</li><li>47722.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 10.99151: 10.99442: 10.9972
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>o</li><li>-</li><li>2</li><li>4</li><li>8</li><li>R</li><li>.</li><li>C</li><li>a</li><li>6</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>30-SEP-2012</li><li>29-DEC-2009</li><li>1998-08-03</li><li>27-SEP-2017</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>9124</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.1695</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>53828</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0059</li><li>0.0</li><li>0.0</li><li>0.0</li><li>0.0002</li><li>0.005</li><li>0.005</li><li>0.0038</li></ul></td>
    </tr>
    </table>



-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


<a id="profile-relationships-sourceID"></a><a href="#column-relationships-sourceID">**sourceID**</a>

*inferredDataType:* string


#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Sample Size</td>
        <td>667853</td>
    </tr>
    <tr>
        <td>Null Count</td>
        <td>103609</td>
    </tr>
    <tr>
        <td>Null Types Index</td>
        <td>"": <ul><li>10</li><li>14</li><li>42</li><li>71</li><li>3339254</li><li>3339260</li><li>3339262</li><li>3339264</li></ul>
        </td>
    </tr>
    <tr>
        <td>Min</td>
        <td>13.0</td>
    </tr>
    <tr>
        <td>Max</td>
        <td>49.0</td>
    </tr>
    <tr>
        <td>Mode</td>
        <td>13.018</td>
    </tr>
    <tr>
        <td>Median</td>
        <td>14.0032</td>
    </tr>
    <tr>
        <td>Median Abs Deviation</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Gini Impurity</td>
        <td>0.7983</td>
    </tr>
    <tr>
        <td>Unalikeability</td>
        <td>0.7983</td>
    </tr>
    <tr>
        <td>Sum</td>
        <td>13883538.0</td>
    </tr>
    <tr>
        <td>Mean</td>
        <td>24.6056</td>
    </tr>
    <tr>
        <td>Variance</td>
        <td>168.8009</td>
    </tr>
    <tr>
        <td>Stddev</td>
        <td>12.9923</td>
    </tr>
    <tr>
        <td>Skewness</td>
        <td>0.4746</td>
    </tr>
    <tr>
        <td>Kurtosis</td>
        <td>-1.6028</td>
    </tr>
    <tr>
        <td>Num Zeros</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Num Negatives</td>
        <td>0</td>
    </tr>
    <tr>
        <td>Histogram</td>
        <td>bin_edges: <ul><li>13.0</li><li>13.69230769</li><li>48.30769231</li><li>49.0</li></ul>bin_counts: <ul><li>184751.0</li><li>112206.0</li><li>0.0</li><li>0.0</li><li>0.0</li><li>660.0</li></ul>
        </td>
    </tr>
    <tr>
        <td>Quantiles</td>
        <td>0: 13.02751: 14.00322: 41.9894
        </td>
    </tr>
    <tr>
        <td>Vocabulary</td>
        <td><ul><li>-</li><li>h</li><li>A</li><li>c</li><li>P</li><li>s</li><li>e</li><li>I</li><li>k</li><li>i</li></ul></td>
    </tr>
    <tr>
        <td>Categories</td>
        <td><ul><li>Paradise Papers - Malta corporate registry</li><li>Paradise Papers - Lebanon corporate registry</li></ul></td>
    </tr>
    <tr>
        <td>Unique Count</td>
        <td>11</td>
    </tr>
    <tr>
        <td>Unique Ratio</td>
        <td>0.0</td>
    </tr>
    <tr>
        <td>Un Like Ability</td>
        <td>564244</td>
    </tr>
    <tr>
        <td>Times</td>
        <td><ul><li>0.0913</li><li>0.0002</li><li>0.0002</li><li>0.0002</li><li>0.0014</li><li>0.0525</li><li>0.0508</li><li>0.068</li></ul></td>
    </tr>
    </table>


<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    <tr>
        <td>Paradise Papers - Malta corporate registry</td>
        <td>155405</td>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>134911</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>112206</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>78106</td>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>49840</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>26036</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>3995</td>
    </tr>
    <tr>
        <td>Paradise Papers - Samoa corporate registry</td>
        <td>3075</td>
    </tr>
    <tr>
        <td>Paradise Papers - Cook Islands corporate registry</td>
        <td>660</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>9</td>
    </tr>
    <tr>
        <td>Paradise Papers - Lebanon corporate registry</td>
        <td>1</td>
    </tr>
    </table>


-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>


-------------------------


## <a id="reference"></a>Reference Datasets



### <a id="ref-dataset-REF-jurisdiction"></a>Reference Data Code: REF-jurisdiction

Description: The abbreviated code for the jurisdiction where the 'other' entity is registered.

Values Count: 81

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>AG</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>AIA</td>
        <td>8</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>AN</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ANG</td>
        <td>655</td>
        <td>0.41%</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>32</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>AW</td>
        <td>9871</td>
        <td>6.12%</td>
    </tr>
    <tr>
        <td>BAH</td>
        <td>41932</td>
        <td>25.99%</td>
    </tr>
    <tr>
        <td>BB</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BERMU</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>130</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>BM</td>
        <td>1883</td>
        <td>1.17%</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>8176</td>
        <td>5.07%</td>
    </tr>
    <tr>
        <td>BS</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BVI</td>
        <td>33273</td>
        <td>20.62%</td>
    </tr>
    <tr>
        <td>CAYMN</td>
        <td>138</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>CK</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>COK</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>COOK</td>
        <td>852</td>
        <td>0.53%</td>
    </tr>
    <tr>
        <td>CRI</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>CY</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>20</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>DUBAI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>GG</td>
        <td>24</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>HK</td>
        <td>338</td>
        <td>0.21%</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>116</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>IM</td>
        <td>262</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>IOM</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>JE</td>
        <td>181</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>JSY</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KN</td>
        <td>15</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>14216</td>
        <td>8.81%</td>
    </tr>
    <tr>
        <td>KY</td>
        <td>1807</td>
        <td>1.12%</td>
    </tr>
    <tr>
        <td>LABUA</td>
        <td>82</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>LCA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>LI</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>LIBER</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>LR</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>LU</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MALAY</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>MARSH</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MAURI</td>
        <td>16</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MLT</td>
        <td>16843</td>
        <td>10.44%</td>
    </tr>
    <tr>
        <td>MT</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MU</td>
        <td>96</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NETH</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NEV</td>
        <td>257</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>NIUE</td>
        <td>1910</td>
        <td>1.18%</td>
    </tr>
    <tr>
        <td>NL</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PA</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>49</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>PMA</td>
        <td>9710</td>
        <td>6.02%</td>
    </tr>
    <tr>
        <td>SAM</td>
        <td>2917</td>
        <td>1.81%</td>
    </tr>
    <tr>
        <td>SC</td>
        <td>72</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>SEY</td>
        <td>3150</td>
        <td>1.95%</td>
    </tr>
    <tr>
        <td>SG</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>141</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>STLU</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SYC</td>
        <td>171</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>TC</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>UK</td>
        <td>33</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>US</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>74</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>USDE</td>
        <td>31</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>UY</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>VC</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>VCT</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>VG</td>
        <td>445</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>494</td>
        <td>0.31%</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>WYO</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>XX</td>
        <td>102</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>10662</td>
        <td>6.61%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-jurisdiction_description"></a>Reference Data Code: REF-jurisdiction_description

Description: The full name of the jurisdiction where the 'other' entity is registered.

Values Count: 68

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Alaska</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Anguilla</td>
        <td>8</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Antigua and Barbuda</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>9871</td>
        <td>6.12%</td>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>41946</td>
        <td>25.99%</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>8179</td>
        <td>5.07%</td>
    </tr>
    <tr>
        <td>Belize</td>
        <td>130</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>1885</td>
        <td>1.17%</td>
    </tr>
    <tr>
        <td>British Anguilla</td>
        <td>655</td>
        <td>0.41%</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>34211</td>
        <td>21.20%</td>
    </tr>
    <tr>
        <td>BRITISH VIRGIN ISLANDS</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Cayman</td>
        <td>139</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>1807</td>
        <td>1.12%</td>
    </tr>
    <tr>
        <td>Cook Islands</td>
        <td>856</td>
        <td>0.53%</td>
    </tr>
    <tr>
        <td>COOK ISLANDS</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>COOKISLANDS</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Costa Rica</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>24</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Delaware</td>
        <td>6</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>District of Columbia</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Dubai</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Florida</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Georgia</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>26</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>GUERNSEY</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>454</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>262</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>Isle Of Man</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>192</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>Labuan</td>
        <td>82</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>Latvia</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Liberia</td>
        <td>11</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Liechtenstein</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Luxembourg</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Malaysia</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Malta</td>
        <td>16844</td>
        <td>10.44%</td>
    </tr>
    <tr>
        <td>Marshall Islands</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Mauritius</td>
        <td>116</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>Monaco</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Netherlands</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Netherlands Antilles</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Nevada</td>
        <td>260</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>Nevis</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>New York</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>New Zealand</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Niue</td>
        <td>1910</td>
        <td>1.18%</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>9760</td>
        <td>6.05%</td>
    </tr>
    <tr>
        <td>Panama0x0a</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Recorded in leaked files as "fund"</td>
        <td>19</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Saint Kitts and Nevis</td>
        <td>14228</td>
        <td>8.82%</td>
    </tr>
    <tr>
        <td>Saint Lucia</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Saint Vincent and the Grenadines</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Samoa</td>
        <td>2921</td>
        <td>1.81%</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>3393</td>
        <td>2.10%</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>142</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>South Dakota</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>St. Lucia</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>State of Delaware</td>
        <td>31</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Turks and Caicos Islands</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Undetermined</td>
        <td>10745</td>
        <td>6.66%</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>32</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>43</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>38</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>United States of America</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>United States Of America</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Uruguay</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>USA (South Dakota)</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Wyoming</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-company_type"></a>Reference Data Code: REF-company_type

Description: The type of company or legal structure of the entity.

Values Count: 51

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Antigua</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Audit Licence</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Bahamas IBC</td>
        <td>8</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Belize International Business Company</td>
        <td>23</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>Busines Company Limited by Shares & Guarantee</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Business Company Limited by Guarantee</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Business Company Limited by Shares</td>
        <td>5120</td>
        <td>18.56%</td>
    </tr>
    <tr>
        <td>Business Company Restricted Purposes</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Business Corporation</td>
        <td>3116</td>
        <td>11.29%</td>
    </tr>
    <tr>
        <td>Business Vehicle</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BVI Sundry Entities (one off transactions)</td>
        <td>2</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BVI Trust</td>
        <td>32</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>Client Sundry Account</td>
        <td>1737</td>
        <td>6.30%</td>
    </tr>
    <tr>
        <td>Cook Islands Asset Protection Trust</td>
        <td>105</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>Cook Islands Asset Protection Trust - 3520A</td>
        <td>90</td>
        <td>0.33%</td>
    </tr>
    <tr>
        <td>Cook Islands Trust</td>
        <td>51</td>
        <td>0.18%</td>
    </tr>
    <tr>
        <td>Domestic Company</td>
        <td>90</td>
        <td>0.33%</td>
    </tr>
    <tr>
        <td>Foreign Company Transfer</td>
        <td>16</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Holding Company</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Hong Kong Trust</td>
        <td>2</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>International Business Corporation</td>
        <td>32</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>International Company</td>
        <td>84</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>International Trust</td>
        <td>202</td>
        <td>0.73%</td>
    </tr>
    <tr>
        <td>Limited Liability Company</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Mauritius - Hybrid</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Mauritius - International</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Mauritius - Offshore</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Mutual Fund</td>
        <td>13</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>Mutual Fund Manager</td>
        <td>20</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>Nevis - Limited Liability Company</td>
        <td>7</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Nevis Company</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Nominee Only Entity</td>
        <td>31</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Panama - Foundation</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Panama - IBC</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Partnership</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Private Company Limited By Shares</td>
        <td>2</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Private Mutual Fund</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Professional Mutual Fund</td>
        <td>2</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Regular (Local) Company</td>
        <td>3547</td>
        <td>12.86%</td>
    </tr>
    <tr>
        <td>Seminar / Workshop</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>2</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Singapore Trust</td>
        <td>12</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Standard Company under IBC Act</td>
        <td>5218</td>
        <td>18.91%</td>
    </tr>
    <tr>
        <td>Standard International Company</td>
        <td>7868</td>
        <td>28.52%</td>
    </tr>
    <tr>
        <td>Sundry Account</td>
        <td>58</td>
        <td>0.21%</td>
    </tr>
    <tr>
        <td>The Forbes Group of companies for Express Co..</td>
        <td>14</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>The GRA group of Companies for express Co.</td>
        <td>36</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>Trust</td>
        <td>7</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Turks</td>
        <td>7</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>UK Register</td>
        <td>6</td>
        <td>0.02%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-status"></a>Reference Data Code: REF-status

Description: The status of the relationship (e.g., appointed, resigned).

Values Count: 78

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Active</td>
        <td>23157</td>
        <td>32.43%</td>
    </tr>
    <tr>
        <td>active</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>ACTIVE</td>
        <td>1427</td>
        <td>56.31%</td>
    </tr>
    <tr>
        <td>Active *</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ACTIVE LEGAL</td>
        <td>3</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>Appointed</td>
        <td>8762</td>
        <td>25.06%</td>
    </tr>
    <tr>
        <td>Bad debt account</td>
        <td>267</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>Change in administration pending</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Changed agent</td>
        <td>3177</td>
        <td>4.45%</td>
    </tr>
    <tr>
        <td>CLIENT IN REPRESENTATIVE TERRITORY</td>
        <td>7</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>Client Sundry Account</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Closed</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>closed for non-payment/non-communication</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Company liquidated</td>
        <td>170</td>
        <td>0.24%</td>
    </tr>
    <tr>
        <td>Continuation Out</td>
        <td>74</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>de-registered, ceased business operations</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Dead</td>
        <td>4619</td>
        <td>6.47%</td>
    </tr>
    <tr>
        <td>Defaulted</td>
        <td>19969</td>
        <td>27.97%</td>
    </tr>
    <tr>
        <td>DELINQUENT</td>
        <td>3</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>Deregistered</td>
        <td>84</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>Discontinuance</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Discontinued</td>
        <td>95</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>Dissolved</td>
        <td>4782</td>
        <td>6.70%</td>
    </tr>
    <tr>
        <td>dissolved</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Dissolved shelf company</td>
        <td>300</td>
        <td>0.42%</td>
    </tr>
    <tr>
        <td>IAC</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>In Dissolution</td>
        <td>1394</td>
        <td>1.95%</td>
    </tr>
    <tr>
        <td>In Formation</td>
        <td>22</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>In Liquidation</td>
        <td>17</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>In liquidation</td>
        <td>14</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>In Penalty</td>
        <td>153</td>
        <td>0.21%</td>
    </tr>
    <tr>
        <td>In Process of Converting</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>In Process of Merging</td>
        <td>12</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>In transition</td>
        <td>144</td>
        <td>0.20%</td>
    </tr>
    <tr>
        <td>Inactivated</td>
        <td>1512</td>
        <td>2.12%</td>
    </tr>
    <tr>
        <td>Inactive</td>
        <td>203</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>inactive</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>INACTIVE</td>
        <td>58</td>
        <td>2.29%</td>
    </tr>
    <tr>
        <td>Liquidated</td>
        <td>178</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>LIQUIDATED</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Not To Be Renewed / In Deregistration</td>
        <td>118</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>Pending</td>
        <td>19</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>PROSPECT</td>
        <td>14</td>
        <td>0.55%</td>
    </tr>
    <tr>
        <td>Redomiciled</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Registered</td>
        <td>217</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>Relocated in new jurisdiction</td>
        <td>137</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>Removed</td>
        <td>15</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Resigned</td>
        <td>24</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Resigned as agent</td>
        <td>639</td>
        <td>0.89%</td>
    </tr>
    <tr>
        <td>Resigned as agent of shelf company</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Shelf</td>
        <td>106</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Shelf company</td>
        <td>515</td>
        <td>0.72%</td>
    </tr>
    <tr>
        <td>Shelf company not possible to sell</td>
        <td>36</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>strike off</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Struck / Defunct / Deregistered</td>
        <td>3806</td>
        <td>5.33%</td>
    </tr>
    <tr>
        <td>Struck Off</td>
        <td>3303</td>
        <td>4.63%</td>
    </tr>
    <tr>
        <td>struck off</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Struck off</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Struck off - Non Pmt A/Fee</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Struck Off / Dissolved</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Struck Off as Defunct</td>
        <td>584</td>
        <td>0.82%</td>
    </tr>
    <tr>
        <td>Struck off Dissolved</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Struck Off Following Division</td>
        <td>25</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Struck Off Following Merger</td>
        <td>284</td>
        <td>0.40%</td>
    </tr>
    <tr>
        <td>Subject to UN/EU Sanctions</td>
        <td>11</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Sundry Account</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Suspended</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SUSPENDED</td>
        <td>954</td>
        <td>37.65%</td>
    </tr>
    <tr>
        <td>SUSPENDED LEGAL</td>
        <td>2</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>to be liquidated</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Transferred OUT</td>
        <td>557</td>
        <td>0.78%</td>
    </tr>
    <tr>
        <td>Transferred Out</td>
        <td>371</td>
        <td>0.52%</td>
    </tr>
    <tr>
        <td>Trash company</td>
        <td>175</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Un Registered</td>
        <td>16</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>UNRECOVERABLE ACCOUNTS</td>
        <td>66</td>
        <td>2.60%</td>
    </tr>
    <tr>
        <td>Vesting</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>We resigned as registered agent</td>
        <td>29</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Winding Up</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-service_provider"></a>Reference Data Code: REF-service_provider

Description: The name of the service provider associated with the entity.

Values Count: 4

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Appleby</td>
        <td>4993</td>
        <td>7.27%</td>
    </tr>
    <tr>
        <td>Commonwealth Trust Limited</td>
        <td>8904</td>
        <td>12.97%</td>
    </tr>
    <tr>
        <td>Mossack Fonseca</td>
        <td>42628</td>
        <td>62.07%</td>
    </tr>
    <tr>
        <td>Portcullis Trustnet</td>
        <td>12151</td>
        <td>17.69%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-country_codes"></a>Reference Data Code: REF-country_codes

Description: Abbreviated country codes associated with the 'other' entity's address or operations.

Values Count: 224

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>ABW</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>AGO</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>AIA</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ALB</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>AND</td>
        <td>100</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>ANT</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ARE</td>
        <td>1584</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>ARG</td>
        <td>49</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>ARM</td>
        <td>17</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>ASM</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>ATG</td>
        <td>63</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>AUS</td>
        <td>33</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>AUT</td>
        <td>23</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>AZE</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BEL</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BEN</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BES</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BFA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BGD</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>BGR</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BHR</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BHS</td>
        <td>4675</td>
        <td>4.64%</td>
    </tr>
    <tr>
        <td>BIH</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BLM</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BLR</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BLZ</td>
        <td>338</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>BMU</td>
        <td>1931</td>
        <td>1.92%</td>
    </tr>
    <tr>
        <td>BOL</td>
        <td>21</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>BRA</td>
        <td>300</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>BRB</td>
        <td>8085</td>
        <td>8.02%</td>
    </tr>
    <tr>
        <td>BRN</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>BVI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BVT</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>BWA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CAF</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CAN</td>
        <td>245</td>
        <td>0.24%</td>
    </tr>
    <tr>
        <td>CHE</td>
        <td>7622</td>
        <td>7.56%</td>
    </tr>
    <tr>
        <td>CHL</td>
        <td>31</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>CHN</td>
        <td>951</td>
        <td>0.94%</td>
    </tr>
    <tr>
        <td>CIV</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CMR</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>COD</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>COG</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>COK</td>
        <td>410</td>
        <td>0.41%</td>
    </tr>
    <tr>
        <td>COL</td>
        <td>379</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>CPV</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CRI</td>
        <td>180</td>
        <td>0.18%</td>
    </tr>
    <tr>
        <td>CUB</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>CUW</td>
        <td>19</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>CYM</td>
        <td>2383</td>
        <td>2.36%</td>
    </tr>
    <tr>
        <td>CYP</td>
        <td>1306</td>
        <td>1.30%</td>
    </tr>
    <tr>
        <td>CZE</td>
        <td>35</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>DEU</td>
        <td>44</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>DJI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>DMA</td>
        <td>20</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>DNK</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>DOM</td>
        <td>100</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>DZA</td>
        <td>16</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>ECU</td>
        <td>380</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>EGY</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>ERI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ESP</td>
        <td>227</td>
        <td>0.23%</td>
    </tr>
    <tr>
        <td>EST</td>
        <td>170</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>ETH</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>FIN</td>
        <td>18</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>FJI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>FRA</td>
        <td>69</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>FRO</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GAB</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GBR</td>
        <td>3617</td>
        <td>3.59%</td>
    </tr>
    <tr>
        <td>GEO</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GGY</td>
        <td>1463</td>
        <td>1.45%</td>
    </tr>
    <tr>
        <td>GHA</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GIB</td>
        <td>383</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>GIN</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GMB</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GNB</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GNQ</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GRC</td>
        <td>50</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>GRD</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GTM</td>
        <td>255</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>GUF</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>GUM</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>GUY</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>HKG</td>
        <td>10467</td>
        <td>10.38%</td>
    </tr>
    <tr>
        <td>HND</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>HRV</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>HTI</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>HUN</td>
        <td>19</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>IDN</td>
        <td>15</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>IMN</td>
        <td>1277</td>
        <td>1.27%</td>
    </tr>
    <tr>
        <td>IND</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>IOT</td>
        <td>18</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>IRL</td>
        <td>434</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>IRN</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>IRQ</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ISL</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ISR</td>
        <td>133</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>ITA</td>
        <td>59</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>JAM</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>JEY</td>
        <td>3133</td>
        <td>3.11%</td>
    </tr>
    <tr>
        <td>JOR</td>
        <td>310</td>
        <td>0.31%</td>
    </tr>
    <tr>
        <td>JPN</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KAZ</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KEN</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KGZ</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>KHM</td>
        <td>10</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>KIR</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>KNA</td>
        <td>81</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>KOR</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>KWT</td>
        <td>17</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LAO</td>
        <td>9</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LBN</td>
        <td>124</td>
        <td>0.12%</td>
    </tr>
    <tr>
        <td>LBR</td>
        <td>20</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LBY</td>
        <td>13</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LCA</td>
        <td>25</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LIE</td>
        <td>385</td>
        <td>0.38%</td>
    </tr>
    <tr>
        <td>LKA</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>LSO</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>LTU</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>LUX</td>
        <td>2206</td>
        <td>2.19%</td>
    </tr>
    <tr>
        <td>LVA</td>
        <td>589</td>
        <td>0.58%</td>
    </tr>
    <tr>
        <td>MAC</td>
        <td>28</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>MAF</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MAR</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MCO</td>
        <td>663</td>
        <td>0.66%</td>
    </tr>
    <tr>
        <td>MDA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MDG</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>MDV</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MEX</td>
        <td>11</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>MHL</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MKD</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>MLI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MLT</td>
        <td>16952</td>
        <td>16.82%</td>
    </tr>
    <tr>
        <td>MMR</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>MNE</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MNG</td>
        <td>13</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>MOZ</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MRT</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MTQ</td>
        <td>5</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>MUS</td>
        <td>395</td>
        <td>0.39%</td>
    </tr>
    <tr>
        <td>MWI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>MYS</td>
        <td>108</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>NAM</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NER</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NFK</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NGA</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>NIC</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NIU</td>
        <td>66</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>NLD</td>
        <td>69</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>NOR</td>
        <td>13</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>NPL</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NRU</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>NZL</td>
        <td>15</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>OMN</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PAK</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PAN</td>
        <td>3612</td>
        <td>3.58%</td>
    </tr>
    <tr>
        <td>PER</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>PHL</td>
        <td>10</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>PNG</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>POL</td>
        <td>36</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>PRI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PRK</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>PRT</td>
        <td>45</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>PRY</td>
        <td>27</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>PSE</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>PYF</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>QAT</td>
        <td>7</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>REU</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ROU</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>RUS</td>
        <td>2286</td>
        <td>2.27%</td>
    </tr>
    <tr>
        <td>RWA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SAU</td>
        <td>26</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>SDN</td>
        <td>15</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>SEN</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>SGP</td>
        <td>1178</td>
        <td>1.17%</td>
    </tr>
    <tr>
        <td>SGS</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SLB</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SLE</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SLV</td>
        <td>49</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>SMR</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>SOM</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>SRB</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SUR</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SVK</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>SVN</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>SWE</td>
        <td>26</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>SWZ</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>SXM</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>SYC</td>
        <td>358</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>SYR</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>TCA</td>
        <td>23</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>TCD</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>TGO</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>THA</td>
        <td>199</td>
        <td>0.20%</td>
    </tr>
    <tr>
        <td>TJK</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>TKM</td>
        <td>4</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>TON</td>
        <td>3</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>TTO</td>
        <td>17</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>TUN</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>TUR</td>
        <td>26</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>TUV</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>TWN</td>
        <td>608</td>
        <td>0.60%</td>
    </tr>
    <tr>
        <td>TZA</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>UAE</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>UGA</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>UKR</td>
        <td>103</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>UMI</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>URY</td>
        <td>1000</td>
        <td>0.99%</td>
    </tr>
    <tr>
        <td>USA</td>
        <td>1627</td>
        <td>1.61%</td>
    </tr>
    <tr>
        <td>UZB</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>VCT</td>
        <td>6</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>VEN</td>
        <td>160</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>VGB</td>
        <td>17553</td>
        <td>17.41%</td>
    </tr>
    <tr>
        <td>VIR</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>VNM</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>VUT</td>
        <td>8</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>WSM</td>
        <td>2192</td>
        <td>2.17%</td>
    </tr>
    <tr>
        <td>XK</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>XXX</td>
        <td>5158</td>
        <td>5.12%</td>
    </tr>
    <tr>
        <td>YEM</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>ZAF</td>
        <td>25</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>ZMB</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>ZWE</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-sourceID"></a>Reference Data Code: REF-sourceID

Description: The source of the data for the relationship record.

Values Count: 22

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Bahamas Leaks</td>
        <td>35188</td>
        <td>21.61%</td>
    </tr>
    <tr>
        <td>Offshore Leaks</td>
        <td>21055</td>
        <td>12.93%</td>
    </tr>
    <tr>
        <td>Panama Papers</td>
        <td>42628</td>
        <td>26.18%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alemán, Cordero, Galindo & Lee (Alcogal)</td>
        <td>3089</td>
        <td>1.90%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha Consulting</td>
        <td>413</td>
        <td>0.25%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Asiaciti Trust</td>
        <td>25</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Pandora Papers - CILTrust International</td>
        <td>260</td>
        <td>0.16%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Commence Overseas</td>
        <td>490</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Fidelity Corporate Services</td>
        <td>366</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Il Shin Corporate Consulting Limited</td>
        <td>59</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Overseas Management Company (OMC)</td>
        <td>59</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Pandora Papers - SFM Corporate Services</td>
        <td>591</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Trident Trust</td>
        <td>368</td>
        <td>0.23%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Appleby</td>
        <td>4993</td>
        <td>3.07%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Aruba corporate registry</td>
        <td>9870</td>
        <td>6.06%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Bahamas corporate registry</td>
        <td>3579</td>
        <td>2.20%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Barbados corporate registry</td>
        <td>8176</td>
        <td>5.02%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Cook Islands corporate registry</td>
        <td>302</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Lebanon corporate registry</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Malta corporate registry</td>
        <td>16833</td>
        <td>10.34%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Nevis corporate registry</td>
        <td>14213</td>
        <td>8.73%</td>
    </tr>
    <tr>
        <td>Paradise Papers - Samoa corporate registry</td>
        <td>300</td>
        <td>0.18%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-valid_until"></a>Reference Data Code: REF-valid_until

Description: Indicates the period until which the data from the source is considered current.

Values Count: 65

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Appleby data is current through 2014</td>
        <td>4993</td>
        <td>3.07%</td>
    </tr>
    <tr>
        <td>Aruba corporate registry data is current through 2016</td>
        <td>9870</td>
        <td>6.06%</td>
    </tr>
    <tr>
        <td>Bahamas corporate registry data is current through 2016</td>
        <td>3579</td>
        <td>2.20%</td>
    </tr>
    <tr>
        <td>Barbados corporate registry data is current through 2016</td>
        <td>8176</td>
        <td>5.02%</td>
    </tr>
    <tr>
        <td>Cook Islands corporate registry data is current through 2016</td>
        <td>302</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>Data current through 2017.</td>
        <td>5</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2007.</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2008.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2009.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2011.</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2012.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2013.</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Data is current through 2014.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2015.</td>
        <td>16</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Data is current through 2016.</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Data is current through 2017.</td>
        <td>49</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Data is current through 2017. Data on Sebastián Piñera's role come from 2006 and 2015 external documents obtained by Ciper Chile.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Data is current through 2018.</td>
        <td>11</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Dta is current through 2017.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Malta corporate registry data is current through 2016</td>
        <td>16833</td>
        <td>10.34%</td>
    </tr>
    <tr>
        <td>Nevis corporate registry data is current through 2016</td>
        <td>14213</td>
        <td>8.73%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alcogal data is current through 2011. Record manually added from leaked documents.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2006</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2008</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2009</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2010</td>
        <td>3</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2011</td>
        <td>4</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2012</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2013</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2014</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2015</td>
        <td>12</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2016</td>
        <td>21</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2017</td>
        <td>238</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2018</td>
        <td>99</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2019</td>
        <td>95</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Pandora Papers - Alpha data is current through 2020</td>
        <td>14</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Provider data is current through 1970</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2007</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2008</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2009</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2010</td>
        <td>7</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2011</td>
        <td>55</td>
        <td>0.03%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2012</td>
        <td>79</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2013</td>
        <td>90</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2014</td>
        <td>83</td>
        <td>0.05%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2015</td>
        <td>132</td>
        <td>0.08%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2016</td>
        <td>357</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2017</td>
        <td>3011</td>
        <td>1.85%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2018</td>
        <td>1576</td>
        <td>0.97%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2019</td>
        <td>112</td>
        <td>0.07%</td>
    </tr>
    <tr>
        <td>Provider data is current through 2020</td>
        <td>26</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Provider data is current through nan</td>
        <td>16</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>Samoa corporate registry data is current through 2016</td>
        <td>300</td>
        <td>0.18%</td>
    </tr>
    <tr>
        <td>The Bahamas Leaks data is current through early 2016.</td>
        <td>35188</td>
        <td>21.61%</td>
    </tr>
    <tr>
        <td>The data is current through 2017.</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Offshore Leaks data is current through 2010</td>
        <td>21055</td>
        <td>12.93%</td>
    </tr>
    <tr>
        <td>The Panama Papers  data is current through 2015</td>
        <td>2831</td>
        <td>52.89%</td>
    </tr>
    <tr>
        <td>The Panama Papers data is current through 2015</td>
        <td>42628</td>
        <td>26.18%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2011</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2012</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2015</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2016</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2017</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2018</td>
        <td>9</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>The Pandora Papers - Asiaciti data is current through 2019</td>
        <td>1</td>
        <td>0.00%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-countries"></a>Reference Data Code: REF-countries

Description: Full country names associated with the 'other' entity's address or operations.

Values Count: 125

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Andorra</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Argentina</td>
        <td>23</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>Aruba</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Australia</td>
        <td>40</td>
        <td>0.86%</td>
    </tr>
    <tr>
        <td>Austria</td>
        <td>3</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Azerbaijan</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Bahamas</td>
        <td>173</td>
        <td>3.73%</td>
    </tr>
    <tr>
        <td>Bahrain</td>
        <td>3</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Bangladesh</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Barbados</td>
        <td>11</td>
        <td>0.24%</td>
    </tr>
    <tr>
        <td>Belarus</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Belgium</td>
        <td>10</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>Belize</td>
        <td>3</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Bermuda</td>
        <td>6</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>Bolivia</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Botswana</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Brazil</td>
        <td>83</td>
        <td>1.79%</td>
    </tr>
    <tr>
        <td>British Virgin Islands</td>
        <td>20</td>
        <td>0.43%</td>
    </tr>
    <tr>
        <td>Bulgaria</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Canada</td>
        <td>41</td>
        <td>0.88%</td>
    </tr>
    <tr>
        <td>Cayman Islands</td>
        <td>14</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>Chile</td>
        <td>10</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>China</td>
        <td>147</td>
        <td>3.17%</td>
    </tr>
    <tr>
        <td>Colombia</td>
        <td>43</td>
        <td>0.93%</td>
    </tr>
    <tr>
        <td>Cook Islands</td>
        <td>7</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Costa Rica</td>
        <td>23</td>
        <td>0.50%</td>
    </tr>
    <tr>
        <td>Cuba</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Curaçao</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Cyprus</td>
        <td>30</td>
        <td>0.65%</td>
    </tr>
    <tr>
        <td>Czech Republic</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Denmark</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Dominican Republic</td>
        <td>10</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>Ecuador</td>
        <td>68</td>
        <td>1.46%</td>
    </tr>
    <tr>
        <td>Egypt</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>El Salvador</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Estonia</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Finland</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>France</td>
        <td>26</td>
        <td>0.56%</td>
    </tr>
    <tr>
        <td>French Guiana</td>
        <td>1</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>Germany</td>
        <td>22</td>
        <td>0.47%</td>
    </tr>
    <tr>
        <td>Gibraltar</td>
        <td>14</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>Greece</td>
        <td>16</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>Guatemala</td>
        <td>73</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>Guernsey</td>
        <td>52</td>
        <td>1.12%</td>
    </tr>
    <tr>
        <td>Honduras</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Hong Kong</td>
        <td>1034</td>
        <td>22.27%</td>
    </tr>
    <tr>
        <td>Hungary</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Iceland</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>India</td>
        <td>12</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>Indonesia</td>
        <td>107</td>
        <td>2.30%</td>
    </tr>
    <tr>
        <td>Ireland</td>
        <td>7</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Isle of Man</td>
        <td>47</td>
        <td>1.01%</td>
    </tr>
    <tr>
        <td>Israel</td>
        <td>26</td>
        <td>0.56%</td>
    </tr>
    <tr>
        <td>Italy</td>
        <td>8</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>Jamaica</td>
        <td>1</td>
        <td>0.26%</td>
    </tr>
    <tr>
        <td>Japan</td>
        <td>11</td>
        <td>0.24%</td>
    </tr>
    <tr>
        <td>Jersey</td>
        <td>62</td>
        <td>1.34%</td>
    </tr>
    <tr>
        <td>Jordan</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Kazakhstan</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Kenya</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Kuwait</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Latvia</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Lebanon</td>
        <td>13</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>Lesotho</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Liechtenstein</td>
        <td>28</td>
        <td>0.60%</td>
    </tr>
    <tr>
        <td>Luxembourg</td>
        <td>73</td>
        <td>1.57%</td>
    </tr>
    <tr>
        <td>Macao</td>
        <td>4</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>Macedonia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Malaysia</td>
        <td>61</td>
        <td>1.31%</td>
    </tr>
    <tr>
        <td>Malta</td>
        <td>8</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>Mauritius</td>
        <td>10</td>
        <td>0.22%</td>
    </tr>
    <tr>
        <td>Mexico</td>
        <td>8</td>
        <td>0.17%</td>
    </tr>
    <tr>
        <td>Monaco</td>
        <td>33</td>
        <td>0.71%</td>
    </tr>
    <tr>
        <td>Montenegro</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Myanmar</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Netherlands</td>
        <td>14</td>
        <td>0.30%</td>
    </tr>
    <tr>
        <td>New Zealand</td>
        <td>17</td>
        <td>0.37%</td>
    </tr>
    <tr>
        <td>Nicaragua</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Nigeria</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Norway</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Not identified</td>
        <td>85</td>
        <td>1.83%</td>
    </tr>
    <tr>
        <td>Oman</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Pakistan</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Panama</td>
        <td>145</td>
        <td>3.12%</td>
    </tr>
    <tr>
        <td>Paraguay</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Peru</td>
        <td>4</td>
        <td>0.09%</td>
    </tr>
    <tr>
        <td>Philippines</td>
        <td>13</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>Poland</td>
        <td>3</td>
        <td>0.06%</td>
    </tr>
    <tr>
        <td>Portugal</td>
        <td>9</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>Puerto Rico</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Qatar</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Romania</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Russia</td>
        <td>34</td>
        <td>0.73%</td>
    </tr>
    <tr>
        <td>Saint Kitts and Nevis</td>
        <td>26</td>
        <td>0.56%</td>
    </tr>
    <tr>
        <td>Saint Vincent and the Grenadines</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Saudi Arabia</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Serbia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Seychelles</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>Singapore</td>
        <td>273</td>
        <td>5.88%</td>
    </tr>
    <tr>
        <td>Slovakia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Slovenia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>South Africa</td>
        <td>13</td>
        <td>0.28%</td>
    </tr>
    <tr>
        <td>South Korea</td>
        <td>9</td>
        <td>0.19%</td>
    </tr>
    <tr>
        <td>Spain</td>
        <td>42</td>
        <td>0.90%</td>
    </tr>
    <tr>
        <td>Sri Lanka</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Sweden</td>
        <td>7</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Switzerland</td>
        <td>269</td>
        <td>5.79%</td>
    </tr>
    <tr>
        <td>Syria</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Taiwan</td>
        <td>245</td>
        <td>5.28%</td>
    </tr>
    <tr>
        <td>Tanzania</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Thailand</td>
        <td>84</td>
        <td>1.81%</td>
    </tr>
    <tr>
        <td>Tunisia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Turkey</td>
        <td>6</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>Turks and Caicos Islands</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>U.S. Virgin Islands</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Uganda</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    <tr>
        <td>Ukraine</td>
        <td>5</td>
        <td>0.11%</td>
    </tr>
    <tr>
        <td>United Arab Emirates</td>
        <td>47</td>
        <td>1.01%</td>
    </tr>
    <tr>
        <td>United Kingdom</td>
        <td>406</td>
        <td>8.74%</td>
    </tr>
    <tr>
        <td>United States</td>
        <td>315</td>
        <td>6.78%</td>
    </tr>
    <tr>
        <td>Uruguay</td>
        <td>58</td>
        <td>1.25%</td>
    </tr>
    <tr>
        <td>Vanuatu</td>
        <td>2</td>
        <td>0.04%</td>
    </tr>
    <tr>
        <td>Venezuela</td>
        <td>25</td>
        <td>0.54%</td>
    </tr>
    <tr>
        <td>Viet Nam</td>
        <td>7</td>
        <td>0.15%</td>
    </tr>
    <tr>
        <td>Zambia</td>
        <td>1</td>
        <td>0.02%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-type"></a>Reference Data Code: REF-type

Description: The type or category of the 'other' entity.

Values Count: 3

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>FOREIGN FORMED CORPORATION</td>
        <td>3</td>
        <td>0.34%</td>
    </tr>
    <tr>
        <td>LIMITED LIABILITY COMPANY</td>
        <td>881</td>
        <td>99.21%</td>
    </tr>
    <tr>
        <td>SOLE OWNERSHIP</td>
        <td>4</td>
        <td>0.45%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-note"></a>Reference Data Code: REF-note

Description: Additional notes or comments regarding the 'other' entity record.

Values Count: 2

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>Closed date stands for Cancelled date.</td>
        <td>90</td>
        <td>76.92%</td>
    </tr>
    <tr>
        <td>Closed date stands for Liquidation date.</td>
        <td>27</td>
        <td>23.08%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>


### <a id="ref-dataset-REF-rel_type"></a>Reference Data Code: REF-rel_type

Description: The general type of relationship between the two nodes.

Values Count: 13

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    <tr>
        <td>connected_to</td>
        <td>2400</td>
        <td>0.36%</td>
    </tr>
    <tr>
        <td>intermediary_of</td>
        <td>119545</td>
        <td>17.90%</td>
    </tr>
    <tr>
        <td>officer_of</td>
        <td>344665</td>
        <td>51.61%</td>
    </tr>
    <tr>
        <td>probably_same_officer_as</td>
        <td>24</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>registered_address</td>
        <td>166150</td>
        <td>24.88%</td>
    </tr>
    <tr>
        <td>same_address_as</td>
        <td>2</td>
        <td>0.00%</td>
    </tr>
    <tr>
        <td>same_as</td>
        <td>869</td>
        <td>0.13%</td>
    </tr>
    <tr>
        <td>same_company_as</td>
        <td>3089</td>
        <td>0.46%</td>
    </tr>
    <tr>
        <td>same_id_as</td>
        <td>643</td>
        <td>0.10%</td>
    </tr>
    <tr>
        <td>same_name_as</td>
        <td>20757</td>
        <td>3.11%</td>
    </tr>
    <tr>
        <td>similar</td>
        <td>9423</td>
        <td>1.41%</td>
    </tr>
    <tr>
        <td>similar_company_as</td>
        <td>41</td>
        <td>0.01%</td>
    </tr>
    <tr>
        <td>underlying</td>
        <td>245</td>
        <td>0.04%</td>
    </tr>
    
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>
