# {{ dataspec.name }} Data Specification Report

{{ dataspec.description }}

<table>
    <tr>
        <th>Attribute</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>Licensing</td>
        <td>{{ dataspec.licensing }}</td>
    </tr>
    <tr>
        <td>Location Coverage</td>
        <td>{% for location in dataspec.locationCoverage %}{% if not loop.last %}{{location}}, {% else %}{{location}}{% endif %}{% endfor %}</td>
    </tr>
    <tr>
        <td>Format</td>
        <td>{{dataspec.format | replace("\"", "") | replace("[", "") | replace("\'", "") | replace("]", "")}}</td>
    </tr>
    <tr>
        <td>Encoding</td>
        <td>{{dataspec.encoding}}</td>
    </tr>
</table>

## Overview

```mermaid
erDiagram
    {%- for dataset in dataspec.datasets %}
    {{dataset.name}} {
        {% for col in dataset["columns"] -%}
        {{col.type}} {{col.name|replace(" ", "_")}}{% if col.primaryKey %} PK{% endif %}{% if col.foreignKey and col.primaryKey %},{% endif %}{% if col.foreignKey %} FK{% endif %}{% if col.alternateKey %} "AK"{% endif %}
        {% endfor -%}
    }
    {%- endfor %}

    {%- for dataset in dataspec.datasets %}
    {%- for rel in dataspec.relationships %}
    {%- if dataset.name == rel.source.datasetName %}
    {{dataset.name}}{% if rel.cardinality == "M:1" %} }|--|| {% elif rel.cardinality == "M:M" %} }|--|{ {% elif rel.cardinality == "1:M" %} ||--|{ {% elif rel.cardinality == "1:1" %} ||--|| {% elif rel.cardinality == "1:0..1" %} ||--o| {% elif rel.cardinality == "1:1..M" %} ||--|{ {% elif rel.cardinality == "1:0..M" %} ||--o{ {% elif rel.cardinality == "0..M:0..M" %} }o--o{ {% elif rel.cardinality == "1..M:1..M" %} }|--|{ {% else %} {% endif %}{{rel.target.datasetName}} : "{{rel.type}}"
    {%- endif %}
    {%- endfor %}
    {%- endfor %}
```

## <a id="table-of-contents"></a>Table of Contents

<table>
    <tr>
        <th>Datasets</th>
        <th>Column</th>
        <th>Type</th>
        <th>Description</th>
        <th>Reference Data</th>
    </tr>
    {% for dataset in dataspec.datasets -%}
    <tr>
        <td rowspan="{{dataset['columns'] | length + 1}}"><a href="#dataset-{{dataset.name}}">{{dataset.name}}</a></td>
        {% for column in dataset["columns"] -%}
            <tr>
                <td><a href="#column-{{dataset.name}}-{{column.name}}">{{column.name}}{% if column.primaryKey and not column.foreignKey %}[PK]{% elif column.foreignKey and not column.primaryKey %}[FK]{% elif column.primaryKey and column.foreignKey %}[PK,FK]{% elif column.alternateKey and column.foreignKey %}[AK,FK]{% elif column.alternateKey and not column.foreignKey %}[AK]{% endif %}</a></td>
                <td>{{column.type}}</td>
                <td>{{column.description}}</td>
                <td>{% if column.refDataCode -%}<a href="#ref-dataset-{{column.refDataCode}}">{{column.refDataCode}}</a>{% else %}None{% endif -%}</td>
            </tr>
        {% endfor -%}
    </tr>
    {% endfor %}
</table>

## Datasets

{%- for dataset in dataspec.datasets %}

### <a id="dataset-{{dataset.name}}"></a>Dataset: {{dataset.name}}

<table>
    <tr>
        <th>Items</th>
        <th>Values</th>
    </tr>
    {% for dataset_item, dataset_item_value in dataset.items() -%}
    <tr>
        {% if dataset_item == "statistics" -%}
        <td>{{dataset_item | camel_case_to_title_case}}</td>
        <td>
            <table>
                {% for stat, stat_value in dataset_item_value.items() -%}
                <tr>
                    <td>{{stat | camel_case_to_title_case}}</td>
                    <td>{{stat_value}}</td>
                </tr>
                {% endfor -%}
            </table>
        </td>
        {% elif dataset_item != "columns" -%}
        <td>{{dataset_item | camel_case_to_title_case}}</td>
        <td>{{dataset_item_value}}</td>
        {% endif -%}
    </tr>
    {% endfor -%}
</table>

### Columns:

{%- for column in dataset["columns"] %}

<a id="column-{{dataset.name}}-{{column.name}}"></a>**{{column.name}}**

<table>
    <tr>
        <th>Column Attributes</th>
        <th>Values</th>
    </tr>
    <tr>
        <td>Name</td>
        <td>{{column.name}} {% if column.primaryKey and not column.foreignKey %}[PK]{% elif column.foreignKey and not column.primaryKey %}[FK]{% elif column.primaryKey and column.foreignKey %}[PK,FK]{% elif column.alternateKey and column.foreignKey %}[AK,FK]{% elif column.alternateKey and not column.foreignKey %}[AK]{% endif %}[<a href="#profile-{{dataset.name}}-{{column.name}}">Profile</a>]</td>
    </tr>
    <tr>
        <td>Type</td>
        <td>{{column.type}}</td>
    </tr>
    <tr>
        <td>Data Classification</td>
        <td>{{column.dataClassification}}</td>
    </tr>
    <tr>
        <td>Description</td>
        <td>{{column.description}}</td>
    </tr>
    <tr>
        <td>Primary Key</td>
        <td>{{column.primaryKey}}</td>
    </tr>
    <tr>
        <td>Alternate Key</td>
        <td>{{column.alternateKey}}</td>
    </tr>
    <tr>
        <td>Foreign Key</td>
        <td>{% if column.foreignKey %}{% for rel in dataspec.relationships %}{% if dataset.name == rel.target.datasetName and column.name == rel.target.key %}<a href="#dataset-{{rel.source.datasetName}}">{{rel.source.datasetName}}</a>: <a href="#column-{{rel.source.datasetName}}-{{rel.source.key}}">{{column.name}}</a>{% if not loop.last %}<br>{% endif %}{% endif %}{% endfor %}{% else %}{{column.foreignKey}}{% endif %}</td>
    </tr>
    <tr>
        <td>Comment</td>
        <td>{{column.comment}}</td>
    </tr>
    <tr>
        <td>Required</td>
        <td>{{column.required}}</td>
    </tr>
    <tr>
        <td>Unique</td>
        <td>{{column.unique}}</td>
    </tr>
    <tr>
        <td>Samples</td>
        <td>{% if column["samples"] | length > 1 %}<ul>{% for sample in column["samples"] %}<li>{{sample}}</li>{% endfor %}</ul>{% else %}{{column["samples"][0]}}{% endif %}</td>
    </tr>
    <tr>
        <td>Data Element Mapping</td>
        <td>{{column.dataElementMapping}}</td>
    </tr>
    {% if column.dataDictionaryMatching.result == "New/Missing" -%}
    <tr>
        <td>Data Dictionary Matching</td>
        <td>{{column.dataDictionaryMatching.result}}</td>
    </tr>
    {% if column.dataDictionaryMatching.potentialElementMatch is defined -%}
    <tr>
        <td>Potential Data Dictionary Element Match</td>
        <td>{{column.dataDictionaryMatching.potentialElementMatch}}</td>
    </tr>
    {% endif -%}
    {% endif -%}
    <tr>
        <td>Null or Empty</td>
        <td>{{column.nullOrEmpty}}</td>
    </tr>
    <tr>
        <td>Reference Data Code</td>
        <td>{% if column.refDataCode is not none -%}<a href="#ref-dataset-{{column.refDataCode}}">{{column.refDataCode}}</a>{% else %}{{column.refDataCode}}{% endif %}</td>
    </tr>
    {% if column["dataProfile"]["order"] -%}
    <tr>
        <td>Order</td>
        <td>{{column["dataProfile"]["order"]}}</td>
    </tr>
    {% endif -%}
    {%- if column["dataProfile"]["statistics"]["min"] -%}
    {%- if column.type == "string" -%}
    <tr>
        <td>Min Length</td>
        <td>{{column["dataProfile"]["statistics"]["min"]}}</td>
    </tr>
    {%- elif column.type == "int" -%}
    <tr>
        <td>Min Value</td>
        <td>{{column["dataProfile"]["statistics"]["min"]}}</td>
    </tr>
    {%- endif -%}
    {%- endif -%}
    {%- if column["dataProfile"]["statistics"]["max"] -%}
    {%- if column.type == "string" -%}
    <tr>
        <td>Max Length</td>
        <td>{{column["dataProfile"]["statistics"]["max"]}}</td>
    </tr>
    {%- elif column.type == "int" -%}
    <tr>
        <td>Max Value</td>
        <td>{{column["dataProfile"]["statistics"]["max"]}}</td>
    </tr>
    {%- endif -%}
    {%- endif -%}
</table>

{% if column.format | length > 0 %}
#### Format:
<table>
    <tr>
        <th>Format</th>
        <th>Value</th>
    </tr>
    {% for format, value in column["format"].items() -%}
    <tr>
        <td>{{format}}</td>
        <td>{% if value is string %}{{value}}{% elif value is mapping and value | length > 1 %}<ul>{% for v in value %}<li>{{v}}</li>{% endfor %}</ul>{% else %}{{value|first}}{% endif %}</td>
    </tr>
    {% endfor -%}
{% endif -%}
</table>

{% if column["dataProfile"]["statistics"]["dataProfileShape"] | length > 0 %}
#### Data Profile Shape:

<table>
    <tr>
        <th>Data Profile Shape</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    {% for shape in column["dataProfile"]["statistics"]["dataProfileShape"] -%}
    <tr>
        <td>{{shape.value}}</td>
        <td>{{shape.statistics.sampleSize}}</td>
        <td>{{"%.2f"|format(shape.statistics.likelihood * 100)}}%</td>
    </tr>
    {% endfor -%}
</table>
{% endif %}

<a href="#table-of-contents">Back to Table of Contents</a>

-------------------------
{% endfor %}

-------------------------
{% endfor %}

### Data Profile:

{%- for dataset in dataspec.datasets %}

### <a href="#dataset-{{dataset.name}}">Dataset: {{dataset.name}}</a>
{%- for column in dataset["columns"] %}

<a id="profile-{{dataset.name}}-{{column.name}}"></a><a href="#column-{{dataset.name}}-{{column.name}}">**{{column.name}}**</a>{% if column.primaryKey and not column.foreignKey %}[PK]{% elif column.foreignKey and not column.primaryKey %}[FK]{% elif column.primaryKey and column.foreignKey %}[PK,FK]{% elif column.alternateKey and column.foreignKey %}[AK,FK]{% elif column.alternateKey and not column.foreignKey %}[AK]{% endif %}
{% for data_profile_item, value in column["dataProfile"].items() -%}
{% if data_profile_item != "order" -%}
{% if data_profile_item == "statistics" %}

#### *Statistics:*

<table>
    <tr>
        <th>Statistics Attribute</th>
        <th>Value</th>
    </tr>
    {% for statistic, statistic_value in value.items() -%}
    {% if statistic_value is not iterable -%}
    <tr>
        <td>{{statistic | camel_case_to_title_case }}</td>
        <td>{{statistic_value}}</td>
    </tr>
    {% elif statistic_value is not mapping and statistic_value is iterable and statistic_value | length > 0 and statistic not in ("dataProfileShape", "sampledCategories") -%}
    <tr>
        <td>{{statistic | camel_case_to_title_case }}</td>
        <td>{% if statistic_value | length > 1 %}<ul>{% for arr_v in statistic_value -%}<li>{{arr_v}}</li>{% endfor -%}</ul>{% else %}{{statistic_value[0]}}{% endif %}</td>
    </tr>
    {% elif statistic_value is mapping and statistic_value | length > 0 -%}
    <tr>
        <td>{{statistic | camel_case_to_title_case }}</td>
        <td>{% for sub_item, sub_value in statistic_value.items() %}{% if sub_value is iterable %}{% if sub_item == "" %}""{% else %}{{sub_item}}{% endif %}: <ul>{% for v in sub_value %}<li>{{v}}</li>{% endfor %}</ul>{% else %}{{sub_item}}: {{sub_value}}{% endif %}{% endfor %}
        </td>
    </tr>
    {% endif -%}
    {% endfor -%}
</table>

{% if value.sampledCategories | length > 0 %}
<u>Sampled Categories:</u>

<table>
    <tr>
        <th>Sampled Category</th>
        <th>Sample Size</th>
    </tr>
    {% for cat in value.sampledCategories -%}
    <tr>
        <td>{{cat.value}}</td>
        <td>{{cat.statistics.sampleSize}}</td>
    </tr>
    {% endfor -%}
</table>
{% endif -%}

{% else -%}
{% if value != "" and ((value is iterable or value is mapping) and value | length > 0) %}
*{{data_profile_item}}:* {{value}}
{% endif -%}
{% endif -%}
{% endif -%}
{% endfor %}

-------------------------
<a href="#table-of-contents">Back to Table of Contents</a>
{% endfor %}

-------------------------
{% endfor %}

## <a id="reference"></a>Reference Datasets

{% for ref_data in dataspec.referenceDatasets %}

### <a id="ref-dataset-{{ref_data.refDataCode}}"></a>Reference Data Code: {{ref_data.refDataCode}}

Description: {{ref_data.description}}

Values Count: {{ref_data["values"] | length }}

{%- if ref_data.dataMapping.dataMappingName %}Data Mapping: {{ref_data.dataMapping.dataMappingName}}{% endif %}

{%- if ref_data.dataMapping.referenceDataset %}Reference Dataset: {{ref_data.dataMapping.referenceDataset}}{% endif %}

### Values and their statistics

<table>
    <tr>
        <th>Value</th>
        <th>Sample Size</th>
        <th>Likelihood</th>
    </tr>
    {% for value in ref_data["values"] -%}
    <tr>
        <td>{{value.value}}</td>
        <td>{{value.statistics.sampleSize}}</td>
        <td>{{"%.2f"|format(value.statistics.likelihood * 100)}}%</td>
    </tr>
    {% endfor %}
</table>
<a href="#reference">Back to Top of Reference Datasets</a>

<a href="#table-of-contents">Back to Table of Contents</a>
{% endfor %}