from pathlib import Path

import pytest
from kyd_dataspec_gen.config import Config, get_config

curr_dir = Path(__file__).parent


@pytest.mark.parametrize(
    ("config_file", "expected_config"),
    [
        pytest.param(
            f"{curr_dir}/test_data/test_config.toml",
            Config(
                separator=",",
                address_column_keyword="address",
                identification_column_keyword="key",
                categorical_limit=100,
                data_profile_shapes_limit=10,
                published_ref_id_prefix="PREF-",
                ref_data_fuzzy_threshold=85,
                sample_values_limit=3,
            ),
            id="valid_config",
        ),
        pytest.param("non_existent_file.toml", Config(), id="non_existent_config"),
    ],
)
def test_get_config(config_file, expected_config):
    """Test the get_config function to ensure it loads the configuration correctly."""
    config = get_config(config_file)
    assert config == expected_config
