import pytest
from kyd_dataspec_gen.utils import string_array_to_list


@pytest.mark.parametrize(
    ("str_array", "expected_list"),
    [
        pytest.param([1, 2, 3], [1, 2, 3], id="passing array to function"),
        pytest.param(
            "['a', 'b', 'c']", ["a", "b", "c"], id="passing string array to function"
        ),
    ],
)
def test_string_array_to_list(str_array, expected_list):
    """Test the string_array_to_list function."""
    result = string_array_to_list(str_array)
    assert result == expected_list
