"""DocX constants"""

from enum import Enum

from lxml import etree

NUMBERING_XML_PATH = "word/numbering.xml"
STYLES_XML_PATH = "word/styles.xml"
FOOTNOTES_XML_PATH = "word/footnotes.xml"
DOCUMENT_XML_PATH = "word/document.xml"

MAX_DISPLAY_LEN = 5000

docx_namespaces = {
    "w": "http://schemas.openxmlformats.org/wordprocessingml/2006/main",
    "mc": "http://schemas.openxmlformats.org/markup-compatibility/2006",
    "r": "http://schemas.openxmlformats.org/officeDocument/2006/relationships",
    "wp": "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing",
    # Add other namespaces here if your documents use them extensively
    "a": "http://schemas.openxmlformats.org/drawingml/2006/main",
    "pic": "http://schemas.openxmlformats.org/drawingml/2006/picture",
    "w15": "http://schemas.microsoft.com/office/word/2012/wordml",
}

w_ns = "{http://schemas.openxmlformats.org/wordprocessingml/2006/main}"
w_r = "{http://schemas.openxmlformats.org/officeDocument/2006/relationships}"


class OutputEncodeType(Enum):
    """Represents the encoding types for text runs."""

    PLAIN = "plain"
    HTML = "html"
    MARKDOWN = "markdown"


global_config = {
    "parser": etree.XMLParser(recover=True),
    "export_images": True,
    "images": {},
}
