"""
Unit tests for the kyd_docx2md module.

This module contains test cases for the Docx2Md class, which converts .docx files
to markdown format. It includes tests for various features such as tables, images,
styles, hyperlinks, and text formatting.
"""

import logging
import unittest
from pathlib import Path

from dotenv import load_dotenv

from kyd_docx2md.docx_config import DocxConfig
from kyd_docx2md.docx_file import (
    DocxFile,
)

logger = logging.getLogger(__name__)

load_dotenv()  # take environment variables from .env.


test_data_dir = Path(__file__).parent / "test-data"

# Use temporary directory for test data


class TestDocXRaw(unittest.TestCase):
    """Unit tests for the DocxRaw class in the kyd_docx2md module."""

    def test_docx_raw(self) -> None:
        """Test that DocxRaw can read and parse a DOCX file."""
        config = DocxConfig()
        docx_raw = DocxFile(config, test_data_dir / "simple-docx.docx")
        assert docx_raw is not None
        assert isinstance(docx_raw, DocxFile)
        assert docx_raw.document_xml is not None
        assert docx_raw.config.runtime.numbering_parts is not None
        assert docx_raw.config.runtime.styles_parts is not None
        assert docx_raw.config.runtime.footnotes_xml is None
