"""
Unit tests for the kyd_docx2md module.

This module contains test cases for the Docx2Md class, which converts .docx files
to markdown format. It includes tests for various features such as tables, images,
styles, hyperlinks, and text formatting.
"""

import logging
import unittest
from pathlib import Path

from dotenv import load_dotenv
from lxml import etree  # pyright: ignore[reportAttributeAccessIssue]

from kyd_docx2md.docx_parts_numbering import (
    DocxAbstractNumbering,
    NumberingParts,
)

logger = logging.getLogger(__name__)

load_dotenv()  # take environment variables from .env.


test_data_dir = Path(__file__).parent / "test-data"

# Use temporary directory for test data


class TestDocXNumbering(unittest.TestCase):
    """Unit tests for numbering and list tracking in the kyd_docx2md module."""

    def test_NumberingParts(self) -> None:
        """Test that NumberingParts constants have the expected string values."""
        # Read the numbering.xml file and check the constants
        with open(test_data_dir / "numbering_multi_level.xml", "rb") as f:
            numbering_xml = etree.parse(f).getroot()

            numbering_parts = NumberingParts(numbering_xml)
            assert numbering_parts is not None
            assert isinstance(numbering_parts, NumberingParts)
            assert len(numbering_parts.abstract_num_dict) == 4  # noqa: PLR2004

            # Test the DocxAbstractNumbering
            first_number_def = numbering_parts.abstract_num_dict[0]
            assert first_number_def is not None
            # logger.warning(first_number_def)
            assert isinstance(first_number_def, DocxAbstractNumbering)
            assert first_number_def.abstract_num_id == 0

            # Test the DocxAbstractNumberingLevel
            level_0 = first_number_def.levels.get(0)
            assert level_0 is not None
            # logger.warning(level_0)
            assert level_0.num_level == 0
            # assert level_0.num_level == 4
            assert level_0.num_fmt == "decimal"
            assert level_0.level_text == "%1."
